/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium;

import java.net.InetSocketAddress;
import java.util.List;
import org.eclipse.californium.scandium.DTLSConnector;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionStore;
import org.eclipse.californium.scandium.dtls.Record;

public class DtlsBindingPreprocessingConnector
extends DTLSConnector {
    private static final DtlsBindingActionWithCallback defaultAction = new DtlsBindingActionWithCallback(){

        @Override
        public void run(ConnectionId cid, InetSocketAddress addr, Runnable callback) {
            callback.run();
        }
    };
    private DtlsBindingActionWithCallback beforeConnectionRetrievalAction = defaultAction;

    public DtlsBindingPreprocessingConnector(DtlsConnectorConfig configuration) {
        super(configuration);
    }

    public DtlsBindingPreprocessingConnector(DtlsConnectorConfig configuration, ConnectionStore connectionStore) {
        super(configuration, connectionStore);
    }

    public synchronized void setBeforeConnectionRetrievalAction(DtlsBindingActionWithCallback beforeConnectionRetrievalAction) {
        if (this.beforeConnectionRetrievalAction != beforeConnectionRetrievalAction) {
            if (this.isRunning()) {
                throw new IllegalStateException("cannot set action while connector is running");
            }
            this.beforeConnectionRetrievalAction = beforeConnectionRetrievalAction == null ? defaultAction : beforeConnectionRetrievalAction;
        }
    }

    @Override
    protected void processRecords(final List<Record> records, final InetSocketAddress peerAddress, final InetSocketAddress router) {
        ConnectionId connectionId = records.get(0).getConnectionId();
        this.beforeConnectionRetrievalAction.run(connectionId, peerAddress, new Runnable(){

            @Override
            public void run() {
                DtlsBindingPreprocessingConnector.this.processRecordsInternally(records, peerAddress, router);
            }
        });
    }

    private void processRecordsInternally(List<Record> records, InetSocketAddress peerAddress, InetSocketAddress router) {
        super.processRecords(records, peerAddress, router);
    }

    public static interface DtlsBindingActionWithCallback {
        public void run(ConnectionId var1, InetSocketAddress var2, Runnable var3);
    }
}

