/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CB06
extends TestClientAbstract {
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;
    public final int EXPECTED_BLOCK_SIZE = BlockOption.size2Szx(16);

    public CB06(String serverURI) {
        super(CB06.class.getSimpleName());
        Request request = Request.newGet();
        request.getOptions().setBlock2(this.EXPECTED_BLOCK_SIZE, false, 0);
        this.executeRequest(request, serverURI, "/large");
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = response.getOptions().hasBlock2();
        if (!success) {
            System.out.println("FAIL: no Block2 option");
        } else {
            int maxNUM = response.getOptions().getBlock2().getNum();
            success &= this.checkType(CoAP.Type.ACK, response.getType());
            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
            success &= this.checkOption(StandardOptionRegistry.BLOCK2.create(this.EXPECTED_BLOCK_SIZE, false, maxNUM), response.getOptions().getBlock2(), "Block2");
            success &= this.hasNonEmptyPayload(response);
            success &= this.hasContentType(response);
        }
        return success;
    }
}

