/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.californium.elements.util.VirtualThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    public static final ThreadGroup COAP_THREAD_GROUP = new ThreadGroup("Californium");
    public static final ThreadGroup SCANDIUM_THREAD_GROUP = new ThreadGroup("Scandium");
    public static final ThreadGroup TRANSPORT_THREAD_GROUP = new ThreadGroup("Transport");
    private final ThreadGroup group;
    private final AtomicLong index;
    private final String prefix;
    private final boolean daemon;

    public NamedThreadFactory(String threadPrefix) {
        this(threadPrefix, null, false);
    }

    public NamedThreadFactory(String threadPrefix, ThreadGroup threadGroup) {
        this(threadPrefix, threadGroup, false);
    }

    public NamedThreadFactory(String threadPrefix, ThreadGroup threadGroup, boolean daemon) {
        this(threadPrefix, threadGroup, daemon, 0L);
    }

    public NamedThreadFactory(String threadPrefix, ThreadGroup threadGroup, boolean daemon, Long start) {
        this.prefix = threadPrefix;
        this.group = null == threadGroup ? COAP_THREAD_GROUP : threadGroup;
        this.daemon = daemon;
        this.index = start != null ? new AtomicLong(start) : null;
    }

    @Override
    public final Thread newThread(Runnable runnable) {
        String name = this.prefix;
        if (this.index != null) {
            name = name + this.index.getAndIncrement();
        }
        Thread ret = new Thread(this.group, runnable, name, 0L);
        ret.setDaemon(this.createDaemonThreads());
        if (ret.getPriority() != 5) {
            ret.setPriority(5);
        }
        return ret;
    }

    protected boolean createDaemonThreads() {
        return this.daemon;
    }

    public static ThreadFactory create(String prefix, Long start, ThreadGroup group, Type type) {
        if (start != null) {
            prefix = prefix + "-";
        }
        switch (type) {
            default: {
                return new NamedThreadFactory(prefix, group, false, start);
            }
            case DAEMON: {
                return new NamedThreadFactory(prefix, group, true, start);
            }
            case VIRTUAL: 
        }
        if (VirtualThreadFactory.isAvailable()) {
            return VirtualThreadFactory.create(prefix, start);
        }
        return new NamedThreadFactory(prefix, group, true, start);
    }

    static {
        COAP_THREAD_GROUP.setDaemon(false);
        SCANDIUM_THREAD_GROUP.setDaemon(false);
    }

    public static enum Type {
        NORMAL,
        DAEMON,
        VIRTUAL;

    }
}

