/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.config.DefinitionUtils;
import org.eclipse.californium.elements.config.IntegerDefinition;
import org.eclipse.californium.elements.config.SystemConfig;

public final class UdpConfig {
    public static final String MODULE = "UDP.";
    public static final IntegerDefinition UDP_RECEIVER_THREAD_COUNT = new IntegerDefinition("UDP.RECEIVER_THREAD_COUNT", "Number of UDP receiver threads. -1 for 1 virtual thread, if supported by the JVM.", 1);
    public static final IntegerDefinition UDP_SENDER_THREAD_COUNT = new IntegerDefinition("UDP.SENDER_THREAD_COUNT", "Number of UDP sender threads. -1 for 1 virtual thread, if supported by the JVM.", 1);
    public static final IntegerDefinition UDP_DATAGRAM_SIZE = new IntegerDefinition("UDP.DATAGRAM_SIZE", "Maxium size of UDP datagram.", 2048, 64);
    public static final IntegerDefinition UDP_RECEIVE_BUFFER_SIZE = new IntegerDefinition("UDP.RECEIVE_BUFFER_SIZE", "UDP receive-buffer size. Empty or 0 to use the OS default.", null, 64);
    public static final IntegerDefinition UDP_SEND_BUFFER_SIZE = new IntegerDefinition("UDP.SEND_BUFFER_SIZE", "UDP send-buffer size. Empty or 0 to use the OS default.", null, 64);
    public static final IntegerDefinition UDP_CONNECTOR_OUT_CAPACITY = new IntegerDefinition("UDP.CONNECTOR_OUT_CAPACITY", "Maximum number of pending outgoing messages.", Integer.MAX_VALUE, 32);
    public static final Configuration.ModuleDefinitionsProvider DEFINITIONS = new Configuration.ModuleDefinitionsProvider(){

        @Override
        public String getModule() {
            return UdpConfig.MODULE;
        }

        @Override
        public void applyDefinitions(Configuration config) {
            int CORES = Runtime.getRuntime().availableProcessors();
            int THREADS = CORES > 3 ? 2 : 1;
            config.set(UDP_RECEIVER_THREAD_COUNT, THREADS);
            config.set(UDP_SENDER_THREAD_COUNT, THREADS);
            config.set(UDP_DATAGRAM_SIZE, 2048);
            config.set(UDP_RECEIVE_BUFFER_SIZE, null);
            config.set(UDP_SEND_BUFFER_SIZE, null);
            config.set(UDP_CONNECTOR_OUT_CAPACITY, Integer.MAX_VALUE);
            DefinitionUtils.verify(UdpConfig.class, config);
        }
    };

    public static void register() {
        SystemConfig.register();
    }

    static {
        Configuration.addDefaultModule(DEFINITIONS);
    }
}

