/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.StringUtil;

public class DtlsEndpointContext
extends MapBasedEndpointContext {
    public static final Definition<Bytes> KEY_SESSION_ID = new Definition<Bytes>("DTLS_SESSION_ID", Bytes.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Integer> KEY_EPOCH = new Definition<Integer>("DTLS_EPOCH", Integer.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> KEY_CIPHER = new Definition<String>("DTLS_CIPHER", String.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Long> KEY_HANDSHAKE_TIMESTAMP = new Definition<Long>("DTLS_HANDSHAKE_TIMESTAMP", Long.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Long> DTLS_READ_SEQUENCE_NUMBER = new Definition<Long>("*DTLS_READ_SEQUENCE_NUMBER", Long.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Bytes> KEY_READ_CONNECTION_ID = new Definition<Bytes>("DTLS_READ_CONNECTION_ID", Bytes.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Bytes> KEY_WRITE_CONNECTION_ID = new Definition<Bytes>("DTLS_WRITE_CONNECTION_ID", Bytes.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> KEY_VIA_ROUTER = new Definition<String>("*DTLS_VIA_ROUTER", String.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> KEY_HANDSHAKE_MODE = new Definition<String>("*DTLS_HANDSHAKE_MODE", String.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Integer> KEY_AUTO_HANDSHAKE_TIMEOUT = new Definition<Integer>("*DTLS_AUTO_HANDSHAKE_TIMEOUT", Integer.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Integer> KEY_MESSAGE_SIZE_LIMIT = new Definition<Integer>("*DTLS_MESSAGE_SIZE_LIMIT", Integer.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Boolean> KEY_EXTENDED_MASTER_SECRET = new Definition<Boolean>("*DTLS_EXTENDED_MASTER_SECRET", Boolean.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Boolean> KEY_NEWEST_RECORD = new Definition<Boolean>("*DTLS_NEWEST_RECORD", Boolean.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<InetSocketAddress> KEY_PREVIOUS_ADDRESS = new Definition<InetSocketAddress>("*DTLS_PREVIOUS_ADDRESS", InetSocketAddress.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Boolean> KEY_SECURE_RENEGOTIATION = new Definition<Boolean>("DTLS_SECURE_RENEGOTIATION", Boolean.class, ATTRIBUTE_DEFINITIONS);
    public static final String HANDSHAKE_MODE_FORCE_FULL = "full";
    public static final String HANDSHAKE_MODE_FORCE = "force";
    public static final String HANDSHAKE_MODE_AUTO = "auto";
    public static final String HANDSHAKE_MODE_NONE = "none";
    public static final MapBasedEndpointContext.Attributes ATTRIBUTE_HANDSHAKE_MODE_NONE = new MapBasedEndpointContext.Attributes().add(KEY_HANDSHAKE_MODE, "none").lock();
    public static final MapBasedEndpointContext.Attributes ATTRIBUTE_HANDSHAKE_MODE_AUTO = new MapBasedEndpointContext.Attributes().add(KEY_HANDSHAKE_MODE, "auto").lock();
    public static final MapBasedEndpointContext.Attributes ATTRIBUTE_HANDSHAKE_MODE_FORCE = new MapBasedEndpointContext.Attributes().add(KEY_HANDSHAKE_MODE, "force").lock();
    public static final MapBasedEndpointContext.Attributes ATTRIBUE_HANDSHAKE_MODE_FORCE_FULL = new MapBasedEndpointContext.Attributes().add(KEY_HANDSHAKE_MODE, "full").lock();

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Bytes sessionId, int epoch, String cipher, long timestamp) {
        super(peerAddress, virtualHost, peerIdentity, new MapBasedEndpointContext.Attributes().add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher).add(KEY_EPOCH, epoch).add(KEY_HANDSHAKE_TIMESTAMP, timestamp));
    }

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, Bytes sessionId, int epoch, String cipher, long timestamp, Bytes writeCid, Bytes readCid, String via) {
        super(peerAddress, virtualHost, peerIdentity, new MapBasedEndpointContext.Attributes().add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher).add(KEY_EPOCH, epoch).add(KEY_HANDSHAKE_TIMESTAMP, timestamp).add(KEY_WRITE_CONNECTION_ID, writeCid).add(KEY_READ_CONNECTION_ID, readCid).add(KEY_VIA_ROUTER, via));
    }

    public DtlsEndpointContext(InetSocketAddress peerAddress, String virtualHost, Principal peerIdentity, MapBasedEndpointContext.Attributes attributes) {
        super(peerAddress, virtualHost, peerIdentity, attributes);
    }

    public final Bytes getSessionId() {
        return this.get(KEY_SESSION_ID);
    }

    public final Number getEpoch() {
        return this.get(KEY_EPOCH);
    }

    public final String getCipher() {
        return this.get(KEY_CIPHER);
    }

    public final Number getHandshakeTimestamp() {
        return this.get(KEY_HANDSHAKE_TIMESTAMP);
    }

    @Override
    public String toString() {
        return String.format("DTLS(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getSessionId().getAsString(), 10));
    }
}

