/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.resumption;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionStore;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.ResumptionVerificationResult;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.resumption.ConnectionStoreResumptionVerifier;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncResumptionVerifier
extends ConnectionStoreResumptionVerifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncResumptionVerifier.class);
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncResumptionTimer#");
    private final ScheduledExecutorService executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private volatile int delayMillis = 1;
    private volatile HandshakeResultHandler resultHandler;

    public AsyncResumptionVerifier() {
    }

    public AsyncResumptionVerifier(ConnectionStore connectionStore) {
        super(connectionStore);
    }

    public AsyncResumptionVerifier setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            LOGGER.info("Asynchronous delayed resumption verifier {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            LOGGER.info("Synchronous delayed resumption verifier {}ms.", (Object)(-delayMillis));
        } else {
            LOGGER.info("Synchronous resumption verifier.");
        }
        return this;
    }

    public int getDelay() {
        return this.delayMillis;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public ResumptionVerificationResult verifyResumptionRequest(final ConnectionId cid, final ServerNames serverName, final SessionId sessionId) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.verifyResumptionRequest(cid, serverName, sessionId);
        }
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                ResumptionVerificationResult result = AsyncResumptionVerifier.super.verifyResumptionRequest(cid, serverName, sessionId);
                AsyncResumptionVerifier.this.resultHandler.apply(result);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
        if (this.resultHandler != null && resultHandler != null && this.resultHandler != resultHandler) {
            throw new IllegalStateException("handshake result handler already set!");
        }
        this.resultHandler = resultHandler;
    }
}

