/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CO08
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/obs";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_1 = CoAP.ResponseCode.CHANGED;
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE_2 = CoAP.ResponseCode.NOT_ACCEPTABLE;

    public CO08(String serverURI) {
        super(CO08.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        request.setObserve();
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        CO08.addContextObserver(request);
        request.setURI(uri);
        int observeLoop = 2;
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            long maxAge = 60L;
            this.startObserve(request);
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            response = request.waitForResponse(10000L);
            if (response != null) {
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                success &= this.checkType(CoAP.Type.ACK, response.getType());
                success &= this.hasContentType(response);
                success &= this.hasToken(response);
                success &= this.hasObserve(response);
                maxAge = response.getOptions().getMaxAge();
            }
            for (int l = 0; success && l < observeLoop; ++l) {
                response = this.waitForNotification(10000L);
                if (response == null) continue;
                System.out.println("Received notification " + l);
                if (this.verbose) {
                    System.out.println("Response received");
                    System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                    Utils.prettyPrint(response);
                }
                success &= this.checkResponse(request, response);
                maxAge = response.getOptions().getMaxAge();
                if (!this.hasObserve(response)) break;
            }
            System.out.println("+++++ Sending PUT +++++");
            Request asyncRequest = new Request(CoAP.Code.PUT, CoAP.Type.CON);
            CO08.addContextObserver(asyncRequest);
            asyncRequest.setURI(uri);
            asyncRequest.getOptions().setContentFormat((int)Math.random() * 65535 + 1);
            asyncRequest.setPayload("Random");
            asyncRequest.addMessageObserver(new MessageObserverAdapter(){

                @Override
                public void onResponse(Response response) {
                    if (response != null) {
                        CO08.this.checkCode(CO08.this.EXPECTED_RESPONSE_CODE_1, response.getCode());
                    }
                }
            });
            asyncRequest.send();
            response = this.waitForNotification(maxAge * 1000L + 1000L);
            System.out.println("received " + response);
            if (response != null) {
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE_2, response.getCode());
                success &= this.hasToken(response);
                success &= this.hasNoObserve(response);
            } else {
                System.out.println("FAIL: No " + (Object)((Object)this.EXPECTED_RESPONSE_CODE_2) + " received");
                success = false;
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
        finally {
            this.stopObservation();
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.CON, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkToken(request.getToken(), response.getToken());
        success &= this.hasContentType(response);
        success &= this.hasNonEmptyPayload(response);
        return success &= this.hasObserve(response);
    }
}

