/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.Utils;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageObserverAdapter;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CO04
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/obs";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CO04(String serverURI) {
        super(CO04.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        request.setObserve();
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void executeRequest(Request request, String serverURI, String resourceUri) {
        if (!serverURI.endsWith("/") && !resourceUri.startsWith("/")) {
            resourceUri = "/" + resourceUri;
        }
        URI uri = null;
        try {
            uri = new URI(serverURI + resourceUri);
            this.setUseTcp(uri.getScheme());
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("Invalid URI: " + use.getMessage());
        }
        request.setURI(uri);
        int observeLoop = 10;
        if (this.verbose) {
            System.out.println("Request for test " + this.testName + " sent");
            Utils.prettyPrint(request);
        }
        try {
            Response response = null;
            boolean success = true;
            long time = 5000L;
            boolean timedOut = false;
            this.startObserve(request);
            System.out.println();
            System.out.println("**** TEST: " + this.testName + " ****");
            System.out.println("**** BEGIN CHECK ****");
            response = request.waitForResponse(time);
            if (response != null) {
                success &= this.checkType(CoAP.Type.ACK, response.getType());
                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                success &= this.checkToken(request.getToken(), response.getToken());
                success &= this.hasContentType(response);
                success &= this.hasNonEmptyPayload(response);
                if (success &= this.hasObserve(response)) {
                    time = response.getOptions().getMaxAge() * 1000L;
                    System.out.println("+++++ Max-Age: " + time + " +++++");
                    if (time == 0L) {
                        time = 5000L;
                    }
                    for (int l = 0; success && l < observeLoop; ++l) {
                        response = this.waitForNotification(time + 1000L);
                        if (response != null) {
                            System.out.println("+++++++ Received notification " + l + " +++++++");
                            if (this.verbose) {
                                System.out.println("Response received");
                                System.out.println("Time elapsed (ms): " + TimeUnit.NANOSECONDS.toMillis(response.getApplicationRttNanos()));
                                Utils.prettyPrint(response);
                            }
                            success &= this.checkResponse(request, response);
                            time = response.getOptions().getMaxAge() * 1000L;
                            if (timedOut || l < 2) continue;
                            System.out.println("+++++++++++++++++++++++");
                            System.out.println("++++ REBOOT SERVER ++++");
                            System.out.println("+++++++++++++++++++++++");
                            System.out.println("++++ obs-reset PUT ++++");
                            Request asyncRequest = new Request(CoAP.Code.POST, CoAP.Type.CON);
                            asyncRequest.setPayload("sesame");
                            CO04.addContextObserver(asyncRequest);
                            asyncRequest.setURI(serverURI + "/obs-reset");
                            asyncRequest.addMessageObserver(new MessageObserverAdapter(){

                                @Override
                                public void onResponse(Response response) {
                                    if (response != null) {
                                        System.out.println("Received: " + (Object)((Object)response.getCode()));
                                        System.out.println("+++++++++++++++++++++++");
                                    }
                                }
                            });
                            asyncRequest.send();
                            continue;
                        }
                        if (!timedOut) {
                            timedOut = true;
                            l = observeLoop / 2;
                            System.out.println("PASS: Max-Age timed out");
                            System.out.println("+++++ Re-registering +++++");
                            Request reregister = Request.newGet();
                            CO04.addContextObserver(reregister);
                            reregister.setURI(uri);
                            reregister.setToken(request.getToken());
                            reregister.setObserve();
                            request = reregister;
                            this.startObserve(request);
                            response = request.waitForResponse(time);
                            if (response != null) {
                                success &= this.checkType(CoAP.Type.ACK, response.getType());
                                success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
                                success &= this.checkToken(request.getToken(), response.getToken());
                                success &= this.hasContentType(response);
                                success &= this.hasNonEmptyPayload(response);
                                success &= this.hasObserve(response);
                                continue;
                            }
                            System.out.println("FAIL: Re-registration failed");
                            success = false;
                            break;
                        }
                        System.out.println("+++++++++++++++++++++++");
                        System.out.println("++++ START SERVER +++++");
                        System.out.println("+++++++++++++++++++++++");
                    }
                    if (!timedOut) {
                        System.out.println("FAIL: Server not rebooted");
                        success = false;
                    }
                    if (response != null) {
                        System.out.println("+++++++ Canceling +++++++");
                        request.cancel();
                        Thread.sleep(time + time / 2L);
                        response = request.getResponse();
                        if (response != null) {
                            System.out.println("FAIL: Notification after canceling");
                            success = false;
                        } else {
                            System.out.println("+++++++ No notification +++++++");
                        }
                    } else {
                        System.out.println("FAIL: No notification after re-registration");
                        success = false;
                    }
                }
            } else {
                System.out.println("FAIL: No notification after registration");
                success = false;
            }
            if (success) {
                System.out.println("**** TEST PASSED ****");
                this.addSummaryEntry(this.testName + ": PASSED");
            } else {
                System.out.println("**** TEST FAILED ****");
                this.addSummaryEntry(this.testName + ": --FAILED--");
            }
            this.tickOffTest();
        }
        catch (InterruptedException e) {
            System.err.println("Interupted during receive: " + e.getMessage());
            System.exit(-1);
        }
        finally {
            this.stopObservation();
        }
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.CON, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkToken(request.getToken(), response.getToken());
        success &= this.hasContentType(response);
        success &= this.hasNonEmptyPayload(response);
        return success &= this.hasObserve(response);
    }
}

