/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import java.util.Arrays;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CC18
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/test";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CREATED;

    public CC18(String serverURI) {
        super(CC18.class.getSimpleName());
        Request request = new Request(CoAP.Code.POST, CoAP.Type.CON);
        request.setPayload("TD_COAP_CORE_18");
        request.getOptions().setContentFormat(0);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.ACK, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        if (success &= this.hasLocation(response)) {
            List<String> path = OptionSet.getValues(response.getOptions().getLocationPath());
            List<String> expc = Arrays.asList("location1", "location2", "location3");
            success &= this.checkOption(expc, path, "Location path");
        }
        return success;
    }
}

