/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class CB02
extends TestClientAbstract {
    public static final String RESOURCE_URI = "/large";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CONTENT;

    public CB02(String serverURI) {
        super(CB02.class.getSimpleName());
        Request request = new Request(CoAP.Code.GET, CoAP.Type.CON);
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = response.getOptions().hasBlock2();
        if (!success) {
            System.out.println("FAIL: no Block2 option");
        } else {
            success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
            success &= this.hasNonEmptyPayload(response);
            success &= this.hasContentType(response);
        }
        return success;
    }
}

