/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class FilteredLogger {
    private static final boolean ENABLE = !Boolean.FALSE.equals(StringUtil.getConfigurationBoolean("COAP_LOGGING_FILTER"));
    private final Logger logger;
    private final long nanosPerPeriod;
    private final long maxPerPeriod;
    private long counter;
    private long startNanos;

    public FilteredLogger(Logger logger, long maxPerPeriod, long nanosPerPeriod) {
        this(logger, maxPerPeriod, nanosPerPeriod, TimeUnit.NANOSECONDS);
    }

    public FilteredLogger(Logger logger, long maxPerPeriod, long period, TimeUnit unit) {
        this.logger = logger;
        this.maxPerPeriod = maxPerPeriod;
        this.nanosPerPeriod = unit.toNanos(period);
        this.startNanos = ClockUtil.nanoRealtime();
    }

    public void warn(String fmt, Object ... args) {
        if (this.logger.isWarnEnabled()) {
            this.log(Level.WARN, fmt, args);
        }
    }

    public void info(String fmt, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.log(Level.INFO, fmt, args);
        }
    }

    public void debug(String fmt, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.log(Level.DEBUG, fmt, args);
        }
    }

    public void trace(String fmt, Object ... args) {
        if (this.logger.isTraceEnabled()) {
            this.log(Level.TRACE, fmt, args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(Level level, String fmt, Object ... args) {
        boolean info;
        if (ENABLE) {
            info = false;
            long now = ClockUtil.nanoRealtime();
            long time = this.nanosPerPeriod + this.startNanos - now;
            FilteredLogger filteredLogger = this;
            synchronized (filteredLogger) {
                boolean bl = info = this.counter < this.maxPerPeriod;
                if (time > 0L) {
                    ++this.counter;
                } else {
                    this.startNanos = now;
                    if (!info) {
                        int length = args.length;
                        args = Arrays.copyOf(args, length + 1);
                        args[length] = this.counter;
                        fmt = fmt + " ({} additional errors.)";
                        info = true;
                    }
                    this.counter = 0L;
                }
            }
        } else {
            info = true;
        }
        if (info) {
            switch (level) {
                case ERROR: {
                    this.logger.error(fmt, args);
                    break;
                }
                case WARN: {
                    this.logger.warn(fmt, args);
                    break;
                }
                case INFO: {
                    this.logger.info(fmt, args);
                    break;
                }
                case DEBUG: {
                    this.logger.debug(fmt, args);
                    break;
                }
                case TRACE: {
                    this.logger.trace(fmt, args);
                }
            }
        }
    }
}

