/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests.tests;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.plugtests.OscoreTest;
import org.eclipse.californium.plugtests.TestClientAbstract;

public class OC03
extends TestClientAbstract
implements OscoreTest {
    public static final String RESOURCE_URI = "/oscore";
    public final CoAP.ResponseCode EXPECTED_RESPONSE_CODE = CoAP.ResponseCode.CHANGED;

    public OC03(String serverURI) {
        super(OC03.class.getSimpleName());
        Request request = Request.newPut();
        request.getOptions().setOscore(Bytes.EMPTY);
        request.getOptions().setContentFormat(0);
        request.setPayload("Hello, OSCORE!");
        this.executeRequest(request, serverURI, RESOURCE_URI);
    }

    @Override
    protected boolean checkResponse(Request request, Response response) {
        boolean success = true;
        success &= this.checkType(CoAP.Type.ACK, response.getType());
        success &= this.checkCode(this.EXPECTED_RESPONSE_CODE, response.getCode());
        success &= this.checkInt(request.getMID(), response.getMID(), "MID");
        return success &= this.hasOption(response, 9, false);
    }
}

