/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.Arrays;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;

public final class FragmentedHandshakeMessage
extends HandshakeMessage {
    private final byte[] fragmentedBytes;
    private final HandshakeType type;
    private final int messageLength;
    private final int fragmentOffset;

    public FragmentedHandshakeMessage(HandshakeType type, int messageLength, int messageSeq, int fragmentOffset, byte[] fragmentedBytes) {
        this.type = type;
        this.messageLength = messageLength;
        this.fragmentedBytes = Arrays.copyOf(fragmentedBytes, fragmentedBytes.length);
        this.fragmentOffset = fragmentOffset;
        this.setMessageSeq(messageSeq);
    }

    @Override
    public HandshakeType getMessageType() {
        return this.type;
    }

    @Override
    public int getMessageLength() {
        return this.messageLength;
    }

    @Override
    public int getFragmentOffset() {
        return this.fragmentOffset;
    }

    @Override
    public int getFragmentLength() {
        return this.fragmentedBytes.length;
    }

    @Override
    protected String getImplementationTypePrefix() {
        return "Fragmented ";
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        String indentation = StringUtil.indentation(indent);
        sb.append(indentation).append("Fragment Offset: ").append(this.getFragmentOffset()).append(StringUtil.lineSeparator());
        sb.append(indentation).append("Fragment Length: ").append(this.getFragmentLength()).append(" bytes").append(StringUtil.lineSeparator());
        return sb.toString();
    }

    @Override
    public byte[] fragmentToByteArray() {
        return this.fragmentedBytes;
    }
}

