/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.plugtests;

import java.util.Set;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.server.resources.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkParser {
    protected static final Logger LOG = LoggerFactory.getLogger(LinkParser.class);

    public static Resource parseTree(String linkFormat) {
        CoapResource root = new CoapResource("");
        if (linkFormat != null) {
            Set<WebLink> links = LinkFormat.parse(linkFormat);
            for (WebLink link : links) {
                String path = link.getURI();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                LOG.debug("Parsing link resource: {}", (Object)path);
                CoapResource resource = new CoapResource(path);
                for (String attrName : link.getAttributes().getAttributeKeySet()) {
                    for (String attrValue : link.getAttributes().getAttributeValues(attrName)) {
                        resource.getAttributes().addAttribute(attrName, attrValue);
                    }
                }
                root.add((Resource)resource);
            }
        }
        return root;
    }
}

