/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.util.nat;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.util.nat.NioNatUtil;

public class Nat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: :port destination:port [destination2:port2 ...] <other arguments>");
            System.out.println("  or : localinterface:port [localinterface2:port2 ...] -- destination:port [destination2:port2 ...] <other arguments>");
            System.out.println("       <other arguments> := [-r] [-x] [-tnat=<millis>] [-tln=<millis>] [-n=<maxNatEntries>]");
            System.out.println("                            [-d=<messageDropping%>|[-f=<messageDropping%>][-b=<messageDropping%>]]");
            System.out.println("                            [-s=<sizeLimit:probability%>]");
            System.out.println("       -r                                           : enable reverse destination address update");
            System.out.println("       -x                                           : enable DTLS filter.");
            System.out.println("       -tnat=<milliseconds>                         : timeout for nat entries. Default 30000[ms]");
            System.out.println("       -tlb=<milliseconds>                          : timeout for destination entries. Default 15000[ms]");
            System.out.println("       -n=<max-number-of-nat-entries>               : maximum number of NAT entries. Default 10000");
            System.out.println("       -d=<messageDropping%>                        : drops forward and backward messages with provided probability");
            System.out.println("       -f=<messageDropping%>                        : drops forward messages with provided probability");
            System.out.println("       -b=<messageDropping%>                        : drops backward messages with provided probability");
            System.out.println("       -s=<sizeLimit:probability%>                  : limit message size to provided value");
            System.out.println();
            System.out.println("       use -f and/or -b, if you want to test with different probabilities.");
            return;
        }
        NioNatUtil util = null;
        try {
            String line = null;
            int argsIndex = 0;
            ArrayList<InetSocketAddress> proxyAddresses = new ArrayList<InetSocketAddress>();
            if (args[argsIndex].startsWith(":")) {
                proxyAddresses.add(Nat.createAnyAddress(args[argsIndex++]));
            } else {
                InetSocketAddress bind = Nat.createAddress("in ", args[argsIndex++]);
                proxyAddresses.add(bind);
                while (argsIndex < args.length && !args[argsIndex].equals("--")) {
                    bind = Nat.createAddress("in ", args[argsIndex++]);
                    proxyAddresses.add(bind);
                }
                if (++argsIndex >= args.length) {
                    System.out.println("Missing destination!");
                    return;
                }
            }
            InetSocketAddress destination = Nat.createAddress("out", args[argsIndex++]);
            util = new NioNatUtil(proxyAddresses, destination);
            int droppingMode = 0;
            block23: while (argsIndex < args.length) {
                String arg;
                if ((arg = args[argsIndex++]).length() > 1 && arg.charAt(0) == '-') {
                    char option = arg.charAt(1);
                    switch (option) {
                        case 'r': {
                            System.out.println("enable NAT reverse update.");
                            util.setReverseNatUpdate(true);
                            break;
                        }
                        case 'x': {
                            System.out.println("enable DTLS filter.");
                            util.setDtlsFilter(true);
                            break;
                        }
                        case 'd': {
                            if (droppingMode != 0) {
                                System.out.println("dropping already provided!");
                                break;
                            }
                            droppingMode = option;
                            int value = Nat.parse(2, arg, new int[0])[0];
                            util.setMessageDropping(value);
                            System.out.println("dropping " + value + "% of messages.");
                            break;
                        }
                        case 'f': {
                            if (droppingMode == 100) {
                                System.out.println("dropping already provided!");
                                break;
                            }
                            droppingMode = option;
                            int value = Nat.parse(2, arg, new int[0])[0];
                            util.setForwardMessageDropping(value);
                            System.out.println("dropping " + value + "% of forward messages.");
                            break;
                        }
                        case 'b': {
                            if (droppingMode == 100) {
                                System.out.println("dropping already provided!");
                                break;
                            }
                            droppingMode = option;
                            int value = Nat.parse(2, arg, new int[0])[0];
                            util.setBackwardMessageDropping(value);
                            System.out.println("dropping " + value + "% of backwards messages.");
                            break;
                        }
                        case 's': {
                            int[] values = Nat.parse(2, arg, 0, 100);
                            util.setForwardMessageSizeLimit(values[1], values[0], true);
                            System.out.println("size limit " + values[0] + " bytes, " + values[1] + " %.");
                            break;
                        }
                        case 'n': {
                            int value = Nat.parse(2, arg, new int[0])[0];
                            util.setMaxiumNumberOfNatEntries(value);
                            System.out.println("NAT max. entires " + value);
                            break;
                        }
                        case 't': {
                            int value;
                            if (arg.startsWith("-tnat")) {
                                value = Nat.parse(5, arg, new int[0])[0];
                                util.setNatTimeoutMillis(value);
                                System.out.println("NAT timeout " + value + "[ms].");
                                break;
                            }
                            if (!arg.startsWith("-tlb")) continue block23;
                            value = Nat.parse(4, arg, new int[0])[0];
                            util.setLoadBalancerTimeoutMillis(value);
                            System.out.println("LoadBalancer timeout " + value + "[ms].");
                            break;
                        }
                        default: {
                            System.out.println("option '" + arg + "' unknown!");
                            break;
                        }
                    }
                    continue;
                }
                InetSocketAddress destinationAddress = Nat.createAddress("out", arg);
                util.addDestination(destinationAddress);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                if (line.equals("exit") || line.equals("quit")) {
                    System.out.println(">> " + line);
                    break;
                }
                if (line.equals("help") || line.equals("?")) {
                    System.out.println("help or ? - print this help");
                    System.out.println("info or <empty line> - list number of NAT entries and destinations");
                    System.out.println("exit or quit - stop and exit");
                    System.out.println("clear [n] - drop all NAT entries, or drop n NAT entries");
                    System.out.println("reassign - reassign incoming addresses");
                    System.out.println("rebalance - reassign outgoing addresses");
                    System.out.println("add <host:port> - add new destination to load balancer");
                    System.out.println("remove <host:port> - remove destination from load balancer");
                    System.out.println("reverse (on|off) - enable/disable reverse address updates.");
                    continue;
                }
                if (line.isEmpty() || line.equals("info")) {
                    Nat.printInfo(util);
                    continue;
                }
                if (line.equals("clear")) {
                    int num = util.stopAllNatEntries();
                    System.out.println(num + " - NAT entries dropped.");
                    continue;
                }
                if (line.startsWith("clear ")) {
                    try {
                        int num = Nat.parse("clear ", line);
                        num = util.stopNatEntries(num);
                        System.out.println(num + " - NAT entries dropped.");
                    }
                    catch (NumberFormatException num) {}
                    continue;
                }
                if (line.equals("reassign")) {
                    util.reassignNewLocalAddresses();
                    continue;
                }
                if (line.equals("rebalance")) {
                    util.addStaleDestinations();
                    int entries = util.getNumberOfEntries();
                    int count = util.reassignDestinationAddresses();
                    System.out.println("reassigned " + count + " destinations of " + entries + ".");
                    continue;
                }
                if (line.startsWith("remove ")) {
                    try {
                        InetSocketAddress dest = Nat.createDestinationAddress("remove ", line);
                        if (!util.removeDestination(dest)) continue;
                        System.out.println(dest + " removed");
                    }
                    catch (URISyntaxException e) {
                        System.err.println(line);
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (line.startsWith("add ")) {
                    try {
                        InetSocketAddress dest = Nat.createDestinationAddress("add ", line);
                        if (!util.addDestination(dest)) continue;
                        System.out.println(dest + " added");
                    }
                    catch (URISyntaxException e) {
                        System.err.println(line);
                        e.printStackTrace(System.err);
                    }
                    continue;
                }
                if (line.equals("reverse on")) {
                    util.setReverseNatUpdate(true);
                    Nat.printInfo(util);
                    continue;
                }
                if (!line.equals("reverse off")) continue;
                util.setReverseNatUpdate(false);
                Nat.printInfo(util);
            }
            while (line == null) {
                Thread.sleep(100000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != util) {
                util.stop();
            }
        }
    }

    private static void printInfo(NioNatUtil util) {
        System.out.println(util.getNumberOfEntries() + " NAT entries, reverse address update " + (util.useReverseNatUpdate() ? "enabled." : "disabled."));
        int stale = util.getNumberOfStaleDestinations();
        if (stale == 0) {
            System.out.println(util.getNumberOfDestinations() + " destinations.");
        } else {
            System.out.println(util.getNumberOfDestinations() + " destinations, " + stale + " stale destinations.");
        }
        List<NioNatUtil.NatAddress> destinations = util.getDestinations();
        for (NioNatUtil.NatAddress address : destinations) {
            System.out.println("Destination: " + address.name + ", usage: " + address.usageCounter());
        }
        destinations = util.getStaleDestinations();
        for (NioNatUtil.NatAddress address : destinations) {
            System.out.println("Stale      : " + address.name + ", usage: " + address.usageCounter() + ", last usage: " + address.lastUsage() + "[s] " + (Object)((Object)address.getState()));
        }
        destinations = util.getProbeDestinations();
        for (NioNatUtil.NatAddress address : destinations) {
            System.out.println("Probing    : " + address.name + ", usage: " + address.usageCounter() + ", last usage: " + address.lastUsage() + "[s] " + (Object)((Object)address.getState()));
        }
        destinations = util.getPendingDestinations();
        for (NioNatUtil.NatAddress address : destinations) {
            System.out.println("Pending    : " + address.name + ", usage: " + address.usageCounter() + ", last usage: " + address.lastUsage() + "[s] " + (Object)((Object)address.getState()));
        }
    }

    public static int parse(String head, String line) {
        return Integer.parseInt(line.substring(head.length()));
    }

    public static InetSocketAddress createDestinationAddress(String head, String line) throws URISyntaxException {
        return Nat.createAddress("out", line.substring(head.length()));
    }

    public static InetSocketAddress createAddress(String direction, String address) throws URISyntaxException {
        if (address.startsWith(":")) {
            throw new URISyntaxException(address, "<any>: not allowed!");
        }
        URI uri = new URI("proxy://" + address);
        String host = uri.getHost();
        int port = uri.getPort();
        System.out.println(direction + ": " + address + " => " + host + ":" + port);
        InetSocketAddress result = new InetSocketAddress(host, port);
        result.getAddress();
        if (result.isUnresolved()) {
            System.err.println("Address: " + address + " is unresolved!");
            return null;
        }
        return result;
    }

    public static InetSocketAddress createAnyAddress(String address) throws URISyntaxException {
        if (address.startsWith(":")) {
            int port = Integer.parseInt(address.substring(1));
            System.out.println("in : " + address + " => <any>:" + port);
            return new InetSocketAddress(port);
        }
        throw new IllegalArgumentException(address + ", <interface>:<port> not allowed!");
    }

    public static int[] parse(int pos, String arg, int ... defs) {
        int index = 0;
        try {
            if (arg.charAt(pos) == '=') {
                ++pos;
            }
            String value = pos == 0 ? arg : arg.substring(pos);
            String[] values = value.split(":");
            int len = Math.max(values.length, defs.length);
            int[] results = new int[len];
            while (index < len) {
                results[index] = index < values.length ? Integer.parseInt(values[index]) : defs[index];
                ++index;
            }
            return results;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(arg + "[" + index + "]: " + e.getMessage());
        }
    }

    static {
        String property = System.getProperty("logback.configurationFile");
        if (property == null) {
            System.setProperty("logback.configurationFile", "logback-nat-config.xml");
        }
    }
}

