/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;

public interface Layer {
    public void sendRequest(Exchange var1, Request var2);

    public void sendResponse(Exchange var1, Response var2);

    public void sendEmptyMessage(Exchange var1, EmptyMessage var2);

    public void receiveRequest(Exchange var1, Request var2);

    public void receiveResponse(Exchange var1, Response var2);

    public void receiveEmptyMessage(Exchange var1, EmptyMessage var2);

    public void setLowerLayer(Layer var1);

    public void setUpperLayer(Layer var1);

    public void setExecutor(ScheduledExecutorService var1);

    public static class BottomUpBuilder {
        private LinkedList<Layer> stack = new LinkedList();

        public BottomUpBuilder add(Layer layer) {
            this.stack.getLast().setUpperLayer(layer);
            return this;
        }

        public List<Layer> create() {
            return this.stack;
        }
    }

    public static class TopDownBuilder {
        private LinkedList<Layer> stack = new LinkedList();

        public TopDownBuilder add(Layer layer) {
            if (this.stack.size() > 0) {
                this.stack.getLast().setLowerLayer(layer);
            }
            this.stack.add(layer);
            return this;
        }

        public List<Layer> create() {
            return this.stack;
        }
    }
}

