/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.examples;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.californium.core.CoapClient;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.Utils;

public class GETClient {
    public static void main(String[] args) {
        URI uri = null;
        if (args.length > 0) {
            try {
                uri = new URI(args[0]);
            }
            catch (URISyntaxException e) {
                System.err.println("Invalid URI: " + e.getMessage());
                System.exit(-1);
            }
            CoapClient client = new CoapClient(uri);
            CoapResponse response = client.get();
            if (response != null) {
                System.out.println((Object)response.getCode());
                System.out.println(response.getOptions());
                System.out.println(response.getResponseText());
                System.out.println("\nADVANCED\n");
                System.out.println(Utils.prettyPrint(response.advanced()));
            } else {
                System.out.println("No response received.");
            }
        } else {
            System.out.println("Californium (Cf) GET Client");
            System.out.println("(c) 2014, Institute for Pervasive Computing, ETH Zurich");
            System.out.println();
            System.out.println("Usage: " + GETClient.class.getSimpleName() + " URI");
            System.out.println("  URI: The CoAP URI of the remote resource to GET");
        }
    }
}

