/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.californium.core.network.config.NetworkConfigDefaults;
import org.eclipse.californium.core.network.config.NetworkConfigObserver;

public class NetworkConfig {
    private static final Logger LOGGER = Logger.getLogger(NetworkConfig.class.getCanonicalName());
    public static final String DEFAULT = "Californium.properties";
    public static final String DEFAULT_HEADER = "Californium CoAP Properties file";
    private static NetworkConfig standard;
    private Properties properties;
    private List<NetworkConfigObserver> observers = new LinkedList<NetworkConfigObserver>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkConfig getStandard() {
        if (standard != null) return standard;
        Class<NetworkConfig> clazz = NetworkConfig.class;
        synchronized (NetworkConfig.class) {
            if (standard != null) return standard;
            NetworkConfig.createStandardWithFile(new File(DEFAULT));
            // ** MonitorExit[var0] (shouldn't be in output)
            return standard;
        }
    }

    public static void setStandard(NetworkConfig standard) {
        NetworkConfig.standard = standard;
    }

    public static NetworkConfig createStandardWithoutFile() {
        LOGGER.info("Creating standard network configuration properties without a file");
        standard = new NetworkConfig();
        return standard;
    }

    public static NetworkConfig createStandardWithFile(File file) {
        LOGGER.info("Create standard properties with file " + file);
        standard = new NetworkConfig();
        if (file.exists()) {
            try {
                standard.load(file);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error while loading properties from " + file.getAbsolutePath(), e);
            }
        } else {
            try {
                standard.store(file);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error while storing properties to " + file.getAbsolutePath(), e);
            }
        }
        return standard;
    }

    public NetworkConfig() {
        this.properties = new Properties();
        NetworkConfigDefaults.setDefaults(this);
    }

    public void load(File file) throws IOException {
        FileInputStream inStream = new FileInputStream(file);
        this.properties.load(inStream);
    }

    public void store(File file) throws IOException {
        this.store(file, DEFAULT_HEADER);
    }

    public void store(File file, String header) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        this.properties.store(new FileWriter(file), header);
    }

    public String getString(String key) {
        return this.properties.getProperty(key);
    }

    public int getInt(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to integer", e);
            }
        } else {
            LOGGER.warning("Property \"" + key + "\" is undefined");
        }
        return 0;
    }

    public long getLong(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to long", e);
                return 0L;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0L;
    }

    public float getFloat(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to float", e);
                return 0.0f;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0.0f;
    }

    public double getDouble(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to double", e);
                return 0.0;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return 0.0;
    }

    public boolean getBoolean(String key) {
        String value = this.properties.getProperty(key);
        if (value != null) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, "Could not convert property \"" + key + "\" with value \"" + value + "\" to boolean", e);
                return false;
            }
        }
        LOGGER.warning("Property \"" + key + "\" is undefined");
        return false;
    }

    public NetworkConfig set(String key, Object value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setString(String key, String value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setInt(String key, int value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setLong(String key, long value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setFloat(String key, float value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setDouble(String key, double value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig setBoolean(String key, boolean value) {
        this.properties.put(key, String.valueOf(value));
        for (NetworkConfigObserver obs : this.observers) {
            obs.changed(key, value);
        }
        return this;
    }

    public NetworkConfig addConfigObserver(NetworkConfigObserver observer) {
        this.observers.add(observer);
        return this;
    }

    public NetworkConfig removeConfigObserver(NetworkConfigObserver observer) {
        this.observers.remove(observer);
        return this;
    }
}

