/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.util.encrypt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class ToC {
    private static final Pattern BEGIN_PATTERN = Pattern.compile("^\\-+BEGIN\\s+([\\w\\s]+)\\-+$");
    private static final Pattern END_PATTERN = Pattern.compile("^\\-+END\\s+([\\w\\s]+)\\-+$");
    private static final String MARKER = "-----";
    private static final String BEGIN = "BEGIN ";
    private static final String END = "END ";
    private static final String PRIVATE_KEY = "PRIVATE KEY";
    private static final String PUBLIC_KEY = "PUBLIC KEY";
    private static final String CERTIFICATE = "CERTIFICATE";
    private static final Integer ZERO = 0;
    private static Map<String, Integer> counters = new HashMap<String, Integer>();
    private static List<String> names = new ArrayList<String>();

    private static void usage() {
        System.out.println("usage:  <file>.pem [<out>]");
        System.out.println("usage:  <file>.p12 [<out>] --alias <alias> --pass <password> [--keypass <key-password]");
        System.out.println("   <out>: <file> (for .pem)");
        System.out.println("   <out>: <alias> (for .p12)");
        System.out.println("   <out.files>: <out>_<pem-tag>.h");
    }

    public static void main(String[] args) {
        File file = null;
        String out = null;
        String alias = null;
        char[] pass = null;
        char[] keyPass = null;
        for (int index = 0; index < args.length; ++index) {
            if (args[index].equals("--alias")) {
                if (alias != null) {
                    throw new IllegalArgumentException("--alias already provided!");
                }
                if (++index < args.length) {
                    alias = args[index];
                    continue;
                }
                throw new IllegalArgumentException("--alias missing argument!");
            }
            if (args[index].equals("--pass")) {
                if (pass != null) {
                    throw new IllegalArgumentException("--pass already provided!");
                }
                if (++index < args.length) {
                    pass = args[index].toCharArray();
                    continue;
                }
                throw new IllegalArgumentException("--pass missing argument!");
            }
            if (args[index].equals("--keypass")) {
                if (keyPass != null) {
                    throw new IllegalArgumentException("--keypass already provided!");
                }
                if (++index < args.length) {
                    keyPass = args[index].toCharArray();
                    continue;
                }
                throw new IllegalArgumentException("--keypass missing argument!");
            }
            if (file == null) {
                file = new File(args[index]);
                continue;
            }
            if (out == null) {
                out = args[index];
                continue;
            }
            throw new IllegalArgumentException("too many arguments! " + args[index]);
        }
        if (file == null) {
            throw new IllegalArgumentException("file missing!");
        }
        String name = file.getName();
        if (name.endsWith(".pem")) {
            if (alias != null) {
                throw new IllegalArgumentException("--alias not supported for .pem!");
            }
            if (pass != null) {
                throw new IllegalArgumentException("--pass not supported for .pem!");
            }
            if (keyPass != null) {
                throw new IllegalArgumentException("--keypass not supported for .pem!");
            }
            if (out == null) {
                out = name.substring(0, name.length() - 4);
            }
            ToC.exportPEM(file, out);
        } else if (name.endsWith(".p12")) {
            if (alias == null) {
                throw new IllegalArgumentException("--alias missing!");
            }
            if (pass == null) {
                throw new IllegalArgumentException("--pass missing!");
            }
            if (out == null) {
                out = alias;
            }
            if (keyPass == null) {
                keyPass = pass;
            }
            ToC.exportP12(file, out, alias, pass, keyPass);
        } else {
            ToC.usage();
            System.exit(1);
        }
    }

    private static String getFilename(String out, String tag) {
        String name = out + "_" + tag.toLowerCase().replace(' ', '_');
        Integer cur = counters.putIfAbsent(tag.toLowerCase(), ZERO);
        if (cur != null) {
            cur = cur + 1;
            counters.putIfAbsent(tag.toLowerCase(), cur);
            name = name + "_" + cur;
        }
        name = name + ".h";
        names.add("'" + name + "'");
        return name;
    }

    public static void exportPEM(File file, String out) {
        try {
            String line = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
                String tag = null;
                block16: while ((line = reader.readLine()) != null) {
                    Matcher matcher;
                    if (tag == null && (matcher = BEGIN_PATTERN.matcher(line)).matches()) {
                        tag = matcher.group(1);
                    }
                    if (tag == null) continue;
                    String name = ToC.getFilename(out, tag);
                    System.out.println(tag + " => " + name);
                    try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), StandardCharsets.UTF_8));){
                        ToC.writeCLine(writer, line);
                        while ((line = reader.readLine()) != null) {
                            ToC.writeCLine(writer, line);
                            Matcher matcher2 = END_PATTERN.matcher(line);
                            if (!matcher2.matches()) continue;
                            String end = matcher2.group(1);
                            if (!end.equals(tag)) {
                                System.err.println("Stop? " + line);
                                System.err.println("   expected " + tag);
                            }
                            tag = null;
                            continue block16;
                        }
                    }
                }
            }
            System.out.println("Converted '" + file.getCanonicalPath() + "' to " + names);
            return;
        }
        catch (FileNotFoundException e) {
            System.err.println(e.getMessage());
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
        }
        System.err.println();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ToC.usage();
        System.exit(1);
    }

    public static void exportP12(File file, String out, String alias, char[] pass, char[] keyPass) {
        try {
            System.out.println("Extract alias '" + alias + "'");
            SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(file.getCanonicalPath(), alias, pass, keyPass);
            if (credentials.getPrivateKey() != null) {
                String name = ToC.getFilename(out, PRIVATE_KEY);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), StandardCharsets.UTF_8));){
                    ToC.writeCLine(writer, "-----BEGIN PRIVATE KEY-----");
                    ToC.writeCBase64(writer, credentials.getPrivateKey().getEncoded());
                    ToC.writeCLine(writer, "-----END PRIVATE KEY-----");
                }
            }
            if (credentials.getCertificateChain() != null) {
                BufferedWriter writer;
                String name;
                X509Certificate[] chain = credentials.getCertificateChain();
                for (int index = 0; index < chain.length; ++index) {
                    X509Certificate certificate = chain[index];
                    String tag = CERTIFICATE;
                    if (0 < index && index == chain.length - 1) {
                        tag = "CA CERTIFICATE";
                    }
                    String name2 = ToC.getFilename(out, tag);
                    try (BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name2), StandardCharsets.UTF_8));){
                        ToC.writeLine(writer2, "/* Certificate " + (index + 1) + " */");
                        ToC.writeCLine(writer2, "-----BEGIN CERTIFICATE-----");
                        ToC.writeCBase64(writer2, certificate.getEncoded());
                        ToC.writeCLine(writer2, "-----END CERTIFICATE-----");
                        continue;
                    }
                }
                if (chain.length > 1) {
                    X509Certificate certificate = chain[chain.length - 1];
                    name = out + "_ca_certificate.pem";
                    names.add("'" + name + "'");
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), StandardCharsets.UTF_8));
                    try {
                        ToC.writeLine(writer, "-----BEGIN CERTIFICATE-----");
                        ToC.writeBase64(writer, certificate.getEncoded());
                        ToC.writeLine(writer, "-----END CERTIFICATE-----");
                    }
                    finally {
                        writer.close();
                    }
                }
                X509Certificate certificate = chain[0];
                name = out + "_public_key.pem";
                names.add("'" + name + "'");
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name), StandardCharsets.UTF_8));
                try {
                    ToC.writeLine(writer, "-----BEGIN PUBLIC KEY-----");
                    ToC.writeBase64(writer, certificate.getPublicKey().getEncoded());
                    ToC.writeLine(writer, "-----END PUBLIC KEY-----");
                }
                finally {
                    writer.close();
                }
            }
            System.out.println("Converted '" + file.getCanonicalPath() + "' to " + names);
            return;
        }
        catch (IOException e) {
            String version;
            String[] split;
            System.err.println();
            System.err.println(e.getMessage());
            if (e.getMessage().contains("parseAlgParameters failed:") && (split = (version = System.getProperty("java.version")).split("\\.", 2))[0].length() < 2) {
                System.err.println("Please use at least java 11!");
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println();
            System.err.println(e.getMessage());
        }
        catch (GeneralSecurityException e) {
            System.err.println();
            System.err.println(e.getMessage());
        }
        System.err.println();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ToC.usage();
        System.exit(1);
    }

    private static void writeCBase64(BufferedWriter writer, byte[] data) throws IOException {
        String[] lines;
        for (String line : lines = ToC.base64(data)) {
            ToC.writeCLine(writer, line);
        }
    }

    private static void writeBase64(BufferedWriter writer, byte[] data) throws IOException {
        String[] lines;
        for (String line : lines = ToC.base64(data)) {
            ToC.writeLine(writer, line);
        }
    }

    private static void writeCLine(BufferedWriter writer, String line) throws IOException {
        writer.write("\"" + line + "\\n\"");
        writer.newLine();
    }

    private static void writeLine(BufferedWriter writer, String line) throws IOException {
        writer.write(line);
        writer.newLine();
    }

    private static String[] base64(byte[] data) throws IOException {
        Base64.Encoder mimeEncoder = Base64.getMimeEncoder(64, StringUtil.lineSeparator().getBytes(StandardCharsets.UTF_8));
        String base64 = mimeEncoder.encodeToString(data);
        return base64.split(StringUtil.lineSeparator());
    }
}

