/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import com.upokecenter.cbor.CBORObject;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public interface Formatter {
    public void add(String var1, String var2);

    public void add(String var1, Long var2);

    public void add(String var1, Boolean var2);

    public void addList(String var1, String ... var2);

    public void addMap(String var1, Map<String, String> var2);

    public byte[] getPayload();

    public static class Xml
    implements Formatter {
        private StringBuilder payload = new StringBuilder();

        public Xml(String element) {
            this.payload.append("<").append(element).append(" ");
        }

        @Override
        public void add(String name, String value) {
            this.payload.append(name).append("=\"").append(value).append("\" ");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append(name).append("=\"").append(value).append("\" ");
        }

        @Override
        public void add(String name, Boolean value) {
            this.payload.append(name).append("=\"").append(value).append("\" ");
        }

        @Override
        public void addList(String name, String ... values) {
            this.payload.append(name).append("=\"");
            for (String value : values) {
                this.payload.append(value).append(',');
            }
            this.payload.setLength(this.payload.length() - 1);
            this.payload.append("\" ");
        }

        @Override
        public void addMap(String name, Map<String, String> values) {
            this.payload.append(name).append(": ");
            for (Map.Entry<String, String> entry : values.entrySet()) {
                this.payload.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            this.payload.setLength(this.payload.length() - 1);
            this.payload.append("\n");
        }

        @Override
        public byte[] getPayload() {
            this.payload.append("/>");
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class Json
    implements Formatter {
        private StringBuilder payload = new StringBuilder("{\n");

        @Override
        public void add(String name, String value) {
            this.payload.append("  \"").append(name).append("\": \"").append(value).append("\",\n");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append("  \"").append(name).append("\": ").append(value).append(",\n");
        }

        @Override
        public void add(String name, Boolean value) {
            this.payload.append("  \"").append(name).append("\": ").append(value).append(",\n");
        }

        @Override
        public void addList(String name, String ... values) {
            this.payload.append("  \"").append(name).append("\": [");
            if (values != null && values.length > 0) {
                for (String value : values) {
                    this.payload.append('\"').append(value).append("\",");
                }
                this.payload.setLength(this.payload.length() - 1);
            }
            this.payload.append("],\n");
        }

        @Override
        public void addMap(String name, Map<String, String> values) {
            this.payload.append("  \"").append(name).append("\": {\n");
            if (values != null && !values.isEmpty()) {
                for (Map.Entry<String, String> entry : values.entrySet()) {
                    this.add(entry.getKey(), entry.getValue());
                }
                this.payload.setLength(this.payload.length() - 2);
                this.payload.append("\n");
            }
            this.payload.append("},\n");
        }

        @Override
        public byte[] getPayload() {
            if (this.payload.length() > 2) {
                this.payload.setLength(this.payload.length() - 2);
                this.payload.append("\n}");
            } else {
                this.payload.append("}");
            }
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }

    public static class Cbor
    implements Formatter {
        CBORObject map = CBORObject.NewMap();

        @Override
        public void add(String name, String value) {
            this.map.set(name, CBORObject.FromObject(value));
        }

        @Override
        public void add(String name, Long value) {
            this.map.set(name, CBORObject.FromObject(value));
        }

        @Override
        public void add(String name, Boolean value) {
            this.map.set(name, CBORObject.FromObject(value));
        }

        @Override
        public void addList(String name, String ... values) {
            CBORObject array = CBORObject.NewArray();
            for (String value : values) {
                array.Add(CBORObject.FromObject(value));
            }
            this.map.set(name, array);
        }

        @Override
        public void addMap(String name, Map<String, String> values) {
            CBORObject map = CBORObject.NewMap();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                map.set(entry.getKey(), CBORObject.FromObject(entry.getValue()));
            }
            this.map.set(name, map);
        }

        @Override
        public byte[] getPayload() {
            return this.map.EncodeToBytes();
        }
    }

    public static class Text
    implements Formatter {
        private StringBuilder payload = new StringBuilder();

        @Override
        public void add(String name, String value) {
            this.payload.append(name).append(": ").append(value).append("\n");
        }

        @Override
        public void add(String name, Long value) {
            this.payload.append(name).append(": ").append(value).append("\n");
        }

        @Override
        public void add(String name, Boolean value) {
            this.payload.append(name).append(": ").append(value).append("\n");
        }

        @Override
        public void addList(String name, String ... values) {
            this.payload.append(name).append(": ");
            for (String value : values) {
                this.payload.append(value).append(",");
            }
            this.payload.setLength(this.payload.length() - 1);
            this.payload.append("\n");
        }

        @Override
        public void addMap(String name, Map<String, String> values) {
            this.payload.append(name).append(": ");
            for (Map.Entry<String, String> entry : values.entrySet()) {
                this.payload.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
            }
            this.payload.setLength(this.payload.length() - 1);
            this.payload.append("\n");
        }

        @Override
        public byte[] getPayload() {
            return this.payload.toString().getBytes(StandardCharsets.UTF_8);
        }
    }
}

