/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.resources;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.cloud.resources.ProtectedCoapResource;
import org.eclipse.californium.cloud.util.Formatter;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.DtlsEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.TlsEndpointContext;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConfig;

public class MyContext
extends ProtectedCoapResource {
    public static final String RESOURCE_NAME = "mycontext";
    private final String version;

    public MyContext(String name, String version, boolean visible) {
        super(name, visible);
        this.getAttributes().setTitle("Communication Context");
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(60);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(41);
        this.version = version;
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        int accept = exchange.getRequestOptions().getAccept();
        if (accept == -1) {
            accept = 0;
        }
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        response.getOptions().setContentFormat(accept);
        byte[] payload = null;
        switch (accept) {
            case 0: {
                payload = this.handleGet(exchange, new Formatter.Text());
                break;
            }
            case 60: {
                payload = this.handleGet(exchange, new Formatter.Cbor());
                break;
            }
            case 50: {
                payload = this.handleGet(exchange, new Formatter.Json());
                break;
            }
            case 41: {
                payload = this.handleGet(exchange, new Formatter.Xml("context"));
                break;
            }
            default: {
                String ct = MediaTypeRegistry.toString(accept);
                exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE, "Type \"" + ct + "\" is not supported for this resource!", 0);
                return;
            }
        }
        response.setPayload(payload);
        exchange.respond(response);
    }

    private byte[] handleGet(CoapExchange coapExchange, Formatter formatter) {
        InetSocketAddress previous;
        Integer limit;
        Boolean newest;
        Boolean extendedMasterSecret;
        Boolean secureRenegotiation;
        String via;
        String cid;
        String sessionId;
        String cipherSuite;
        Principal peerIdentity;
        Configuration config;
        Integer nodeId;
        Exchange exchange = coapExchange.advanced();
        EndpointContext context = exchange.getRequest().getSourceContext();
        InetSocketAddress source = context.getPeerAddress();
        formatter.add("ip", StringUtil.toString(source.getAddress()));
        formatter.add("port", new Long(source.getPort()));
        Endpoint endpoint = exchange.getEndpoint();
        if (endpoint != null && (nodeId = (config = endpoint.getConfig()).get(DtlsConfig.DTLS_CONNECTION_ID_NODE_ID)) != null) {
            formatter.add("node-id", nodeId.toString());
        }
        if ((peerIdentity = context.getPeerIdentity()) != null) {
            formatter.add("peer", peerIdentity.getName());
        }
        if ((cipherSuite = context.getString(DtlsEndpointContext.KEY_CIPHER)) == null) {
            cipherSuite = context.getString(TlsEndpointContext.KEY_CIPHER);
        }
        if (cipherSuite != null) {
            formatter.add("cipher-suite", cipherSuite);
        }
        if ((sessionId = context.getString(DtlsEndpointContext.KEY_SESSION_ID)) == null) {
            sessionId = context.getString(TlsEndpointContext.KEY_SESSION_ID);
        }
        if (sessionId != null) {
            formatter.add("session-id", sessionId);
        }
        if ((cid = context.getString(DtlsEndpointContext.KEY_READ_CONNECTION_ID)) != null) {
            formatter.add("read-cid", cid);
        }
        if ((cid = context.getString(DtlsEndpointContext.KEY_WRITE_CONNECTION_ID)) != null) {
            formatter.add("write-cid", cid);
        }
        if ((via = context.getString(DtlsEndpointContext.KEY_VIA_ROUTER)) != null) {
            formatter.add("via", via);
        }
        if ((secureRenegotiation = context.get(DtlsEndpointContext.KEY_SECURE_RENEGOTIATION)) != null) {
            formatter.add("secure-renegotiation", secureRenegotiation);
        }
        if ((extendedMasterSecret = context.get(DtlsEndpointContext.KEY_EXTENDED_MASTER_SECRET)) != null) {
            formatter.add("ext-master-secret", extendedMasterSecret);
        }
        if ((newest = context.get(DtlsEndpointContext.KEY_NEWEST_RECORD)) != null) {
            formatter.add("newest-record", newest);
        }
        if ((limit = context.get(DtlsEndpointContext.KEY_MESSAGE_SIZE_LIMIT)) != null) {
            formatter.add("message-size-limit", new Long(limit.intValue()));
        }
        if ((previous = context.get(DtlsEndpointContext.KEY_PREVIOUS_ADDRESS)) != null) {
            formatter.add("prev-ip", StringUtil.toString(previous.getAddress()));
            formatter.add("prev-port", new Long(previous.getPort()));
        }
        if (this.version != null) {
            formatter.add("server", "Cf " + this.version);
        }
        return formatter.getPayload();
    }
}

