/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.option.IntegerOption;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.elements.util.DatagramReader;

public final class NoResponseOption
extends IntegerOption {
    public static final int SUPPRESS_SUCCESS = 2;
    public static final int SUPPRESS_CLIENT_ERROR = 8;
    public static final int SUPPRESS_SERVER_ERROR = 16;
    public static final int SUPPRESS_ALL = 26;

    public NoResponseOption(int mask) {
        super(StandardOptionRegistry.NO_RESPONSE, mask);
    }

    public int getMask() {
        return this.getIntegerValue();
    }

    public boolean suppress(int code) {
        int bit = 1 << CoAP.getCodeClass(code) - 1;
        return (this.getIntegerValue() & bit) != 0;
    }

    public boolean suppress(CoAP.ResponseCode code) {
        int bit = 1 << code.codeClass - 1;
        return (this.getIntegerValue() & bit) != 0;
    }

    @Override
    public String toValueString() {
        int mask = this.getIntegerValue();
        if ((mask & 0x1A) != 0) {
            StringBuilder text = new StringBuilder("\"NO ");
            if ((mask & 2) != 0) {
                text.append("SUCCESS,");
            }
            if ((mask & 8) != 0) {
                text.append("CLIENT_ERROR,");
            }
            if ((mask & 0x10) != 0) {
                text.append("SERVER_ERROR,");
            }
            text.setLength(text.length() - 1);
            text.append('\"');
            return text.toString();
        }
        return "\"ALL\"";
    }

    public static class Definition
    extends IntegerOption.Definition {
        public Definition() {
            super(258, "No-Response", true, 0, 1);
        }

        @Override
        public NoResponseOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            if (length != 0 && length != 1) {
                throw new IllegalArgumentException("Option " + this.getName() + " value must be empty or 1 byte.");
            }
            int mask = 0;
            if (length == 1) {
                mask = reader.readNextByte() & 0xFF;
            }
            return new NoResponseOption(mask);
        }

        public NoResponseOption create(int mask) {
            return new NoResponseOption(mask);
        }
    }
}

