/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap.option;

import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionNumberRegistry;
import org.eclipse.californium.core.coap.option.BaseOptionDefinition;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;

public class EmptyOption
extends Option {
    private EmptyOption(Definition definition) {
        super(definition);
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public void writeTo(DatagramWriter writer) {
    }

    @Override
    public String toValueString() {
        return "";
    }

    public static class Definition
    extends BaseOptionDefinition {
        private static final int[] LENGTHS = new int[]{0, 0};
        private final EmptyOption option = new EmptyOption(this);

        public Definition(int number, String name) {
            super(number, name, true, LENGTHS);
        }

        @Override
        public OptionNumberRegistry.OptionFormat getFormat() {
            return OptionNumberRegistry.OptionFormat.EMPTY;
        }

        @Override
        public EmptyOption create(DatagramReader reader, int length) {
            if (reader == null) {
                throw new NullPointerException("Option " + this.getName() + " reader must not be null.");
            }
            if (length != 0) {
                throw new IllegalArgumentException("Option " + this.getName() + " value must be empty.");
            }
            return this.option;
        }

        public EmptyOption create() {
            return this.option;
        }
    }
}

