/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.security.Principal;
import org.eclipse.californium.cloud.util.ApplicationAnonymous;
import org.eclipse.californium.cloud.util.PrincipalInfoProvider;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;

public class PrincipalInfo {
    public static final String INFO_PROVIDER = "provider";
    public static final String INFO_NAME = "name";
    public final String name;
    public final String group;
    public final Type type;

    public PrincipalInfo(String group, String name, Type type) {
        if (group == null) {
            throw new NullPointerException("group must not be null!");
        }
        if (name == null) {
            throw new NullPointerException("name must not be null!");
        }
        if (type == null) {
            throw new NullPointerException("type must not be null!");
        }
        this.name = name;
        this.group = group;
        this.type = type;
    }

    public String toString() {
        return this.name + " (" + this.group + "," + this.type.getShortName() + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.group.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrincipalInfo other = (PrincipalInfo)obj;
        if (!this.group.equals(other.group)) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public static PrincipalInfo getPrincipalInfo(Principal principal) {
        ExtensiblePrincipal extensiblePrincipal;
        PrincipalInfoProvider provider;
        if (principal == null) {
            return ApplicationAnonymous.ANONYMOUS_INFO;
        }
        if (principal instanceof ExtensiblePrincipal && (provider = (extensiblePrincipal = (ExtensiblePrincipal)principal).getExtendedInfo().get(INFO_PROVIDER, PrincipalInfoProvider.class)) != null) {
            return provider.getPrincipalInfo(principal);
        }
        return null;
    }

    public static String getName(Principal principal) {
        if (principal instanceof ExtensiblePrincipal) {
            ExtensiblePrincipal extensiblePrincipal = (ExtensiblePrincipal)principal;
            return extensiblePrincipal.getExtendedInfo().get(INFO_NAME, String.class);
        }
        return null;
    }

    public static enum Type {
        ANONYMOUS_DEVICE("anon"),
        APPL_AUTH_DEVICE("appl_auth"),
        DEVICE("dev"),
        PROVISIONING("prov"),
        CA("ca"),
        WEB("web");

        private final String shortName;

        private Type(String shortName) {
            this.shortName = shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public static Type valueOfShortName(String shortName) {
            for (Type type : Type.values()) {
                if (!shortName.equalsIgnoreCase(type.getShortName())) continue;
                return type;
            }
            return null;
        }
    }
}

