/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.concurrent.Semaphore;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.cloud.util.AppendingResourceParser;
import org.eclipse.californium.cloud.util.ResourceChangedHandler;
import org.eclipse.californium.cloud.util.ResourceParser;
import org.eclipse.californium.cloud.util.ResultConsumer;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStore<T extends ResourceParser<T>>
implements Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceStore.class);
    private final T factory;
    protected final Semaphore semaphore = new Semaphore(1);
    protected final EncryptedStreamUtil encryptionUtility = new EncryptedStreamUtil();
    private volatile Observer<T> observer;
    protected volatile SystemResourceMonitors.SystemResourceMonitor monitor;
    private volatile String tag = "";
    private volatile T currentResource;
    private volatile boolean destroyed;
    private byte[] seed;

    public ResourceStore(T factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null!");
        }
        this.factory = factory;
        this.currentResource = factory.create();
    }

    public String getWriteCipher() {
        return this.encryptionUtility.getWriteCipher();
    }

    public String getReadCipher() {
        return this.encryptionUtility.getReadCipher();
    }

    public ResourceStore<T> setDefaultWriteCipher() {
        this.encryptionUtility.setDefaultWriteCipher();
        return this;
    }

    public ResourceStore<T> setWriteCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setWriteCipher(cipherAlgorithm, keySizeBits);
        return this;
    }

    public ResourceStore<T> setWriteCipher(String spec) {
        this.encryptionUtility.setWriteCipher(spec);
        return this;
    }

    public ResourceStore<T> setTag(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag must not be null!");
        }
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public ResourceStore<T> setObserver(Observer<T> observer) {
        this.observer = observer;
        return this;
    }

    public SystemResourceMonitors.SystemResourceMonitor createMonitor(String file, SecretKey password) {
        this.monitor = file != null ? new AppendFileMonitor(file, password) : null;
        return this.monitor;
    }

    public SystemResourceMonitors.SystemResourceMonitor getMonitor() {
        return this.monitor;
    }

    public void clearSeed() {
        if (this.seed != null) {
            Bytes.clear(this.seed);
            this.seed = null;
        }
    }

    public ResourceStore<T> load(String file) {
        try (FileInputStream in = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            this.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("{}read {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> load(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            this.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("{}read:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> load(String file, SecretKey password) {
        try (FileInputStream in = new FileInputStream(file);){
            this.load(in, password);
        }
        catch (IOException e) {
            LOGGER.warn("{}read encrypted {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> load(InputStream in, SecretKey password) {
        byte[] seed = this.encryptionUtility.readSeed(in);
        if (this.seed == null || !Arrays.equals(this.seed, seed)) {
            try (InputStream inEncrypted = this.encryptionUtility.prepare(seed, in, password);){
                this.load(inEncrypted);
                this.seed = seed;
            }
            catch (IOException e) {
                LOGGER.warn("{}read encrypted:", (Object)this.tag, (Object)e);
            }
        } else {
            LOGGER.debug("{}encrypted not changed, (same seed).", (Object)this.tag);
        }
        return this;
    }

    public ResourceStore<T> load(Reader reader) throws IOException {
        Object newConfigurations = this.factory.create();
        newConfigurations.load(reader);
        if (newConfigurations.isDestroyed()) {
            if (this.currentResource.isDestroyed()) {
                this.destroyed = true;
            }
        } else {
            Observer observer;
            if (newConfigurations instanceof AppendingResourceParser) {
                ((AppendingResourceParser)newConfigurations).clearNewEntries();
            }
            if ((observer = this.observer) != null) {
                observer.update(newConfigurations);
            }
            this.currentResource = newConfigurations;
            this.seed = null;
        }
        return this;
    }

    public ResourceStore<T> save(String file) {
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            this.save(writer);
        }
        catch (IOException e) {
            LOGGER.warn("{}write {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> save(OutputStream out) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.save(writer);
        }
        catch (IOException e) {
            LOGGER.warn("{}write:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> save(String file, SecretKey password) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(out, password);
        }
        catch (IOException e) {
            LOGGER.warn("{}write encrypted {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> save(OutputStream out, SecretKey password) {
        try (OutputStream outEncrypted = this.encryptionUtility.prepare(this.seed, out, password);){
            this.save(outEncrypted);
        }
        catch (IOException e) {
            LOGGER.warn("{}write encrypted:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> save(Writer writer) throws IOException {
        this.currentResource.save(writer);
        return this;
    }

    public T loadAndCreateMonitor(String name, String password64, boolean createMonitor) {
        if (password64 != null) {
            byte[] secret = StringUtil.base64ToByteArray(password64);
            SecretKey key = SecretUtil.create(secret, "PW");
            Bytes.clear(secret);
            this.load(name, key);
            if (createMonitor) {
                this.createMonitor(name, key);
            }
            SecretUtil.destroy(key);
            LOGGER.info("{}loaded encrypted store {}", (Object)this.getTag(), (Object)name);
        } else {
            this.load(name);
            if (createMonitor) {
                this.createMonitor(name, null);
            }
            LOGGER.info("{}loaded store {}", (Object)this.getTag(), (Object)name);
        }
        return this.currentResource;
    }

    public T getResource() {
        return this.currentResource;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.currentResource.destroy();
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public Semaphore getSemaphore() {
        return this.semaphore;
    }

    protected static int appendNewEntries(AppendingResourceParser<?> resource, InputStream in, OutputStream out) throws IOException {
        int len;
        int result = resource.sizeNewEntries();
        byte[] buffer = new byte[8192];
        while ((len = in.read(buffer)) >= 0) {
            if (len <= 0) continue;
            out.write(buffer, 0, len);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            resource.saveNewEntries(writer);
        }
        return result;
    }

    public static interface Observer<T extends ResourceParser<T>> {
        public void update(T var1);
    }

    public class AppendFileMonitor
    extends SystemResourceMonitors.FileMonitor
    implements ResourceChangedHandler {
        private final String file;
        private final SecretKey password;

        public AppendFileMonitor(String file, SecretKey password) {
            super(file);
            this.file = file;
            this.password = SecretUtil.create(password);
        }

        @Override
        public void checkForUpdate(SystemResourceMonitors.SystemResourceCheckReady ready) {
            if (ResourceStore.this.semaphore.tryAcquire()) {
                try {
                    super.checkForUpdate(ready);
                }
                finally {
                    ResourceStore.this.semaphore.release();
                }
            } else {
                ready.ready(false);
            }
        }

        @Override
        protected void update(SystemResourceMonitors.FileMonitor.MonitoredValues values, SystemResourceMonitors.SystemResourceCheckReady ready) {
            if (this.password != null) {
                ResourceStore.this.load(this.file, this.password);
            } else {
                ResourceStore.this.load(this.file);
            }
            this.ready(values);
            ready.ready(false);
        }

        @Override
        public void changed(ResultConsumer response) {
            if (!(ResourceStore.this.currentResource instanceof AppendingResourceParser)) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "no AppendResourceParser.");
                return;
            }
            AppendingResourceParser resource = (AppendingResourceParser)ResourceStore.this.currentResource;
            try {
                File temp;
                int result;
                block43: {
                    FileInputStream in;
                    result = 0;
                    temp = File.createTempFile(this.file, null);
                    if (this.password != null) {
                        try {
                            in = new FileInputStream(this.file);
                            try {
                                byte[] seed = ResourceStore.this.encryptionUtility.readSeed(in);
                                try (InputStream inEncrypted = ResourceStore.this.encryptionUtility.prepare(seed, in, this.password);
                                     FileOutputStream out = new FileOutputStream(temp);
                                     OutputStream outEncrypted = ResourceStore.this.encryptionUtility.prepare(seed, out, this.password);){
                                    result = ResourceStore.appendNewEntries(resource, inEncrypted, outEncrypted);
                                    break block43;
                                }
                            }
                            finally {
                                ((InputStream)in).close();
                            }
                        }
                        catch (IOException e) {
                            LOGGER.warn("{}append encrypted {}:", ResourceStore.this.tag, this.file, e);
                            throw e;
                        }
                    }
                    try {
                        in = new FileInputStream(this.file);
                        try (FileOutputStream out = new FileOutputStream(temp);){
                            result = ResourceStore.appendNewEntries(resource, in, out);
                        }
                        finally {
                            ((InputStream)in).close();
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warn("{}append {}:", ResourceStore.this.tag, this.file, e);
                        throw e;
                    }
                }
                if (result > 0) {
                    SystemResourceMonitors.FileMonitor.MonitoredValues values = this.checkMonitoredValues();
                    File currentFile = this.getFile();
                    currentFile.delete();
                    temp.renameTo(currentFile);
                    if (values == null) {
                        values = this.checkMonitoredValues();
                        this.ready(values);
                    }
                    resource.clearNewEntries();
                    response.results(ResultConsumer.ResultCode.SUCCESS, "successfully added " + result + " new entries.");
                } else {
                    temp.delete();
                    response.results(ResultConsumer.ResultCode.SERVER_ERROR, "failed to append new entries.");
                }
            }
            catch (IOException e) {
                LOGGER.warn("{}append {}:", ResourceStore.this.tag, this.file, e);
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "failed to save new entries. " + e.getMessage());
            }
        }
    }
}

