/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.resources;

import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.californium.cloud.option.TimeOption;
import org.eclipse.californium.cloud.util.DeviceManager;
import org.eclipse.californium.cloud.util.DeviceProvisioningConsumer;
import org.eclipse.californium.cloud.util.ResultConsumer;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Provisioning
extends CoapResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(Provisioning.class);
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    public static final String RESOURCE_NAME = "prov";
    private final int[] CONTENT_TYPES = new int[]{0};
    private final DeviceProvisioningConsumer devices;
    private final AtomicBoolean busy = new AtomicBoolean();

    public Provisioning(DeviceProvisioningConsumer devices) {
        super(RESOURCE_NAME);
        Arrays.sort(this.CONTENT_TYPES);
        this.getAttributes().setTitle("Device provisioning resource.");
        this.getAttributes().addContentTypes(this.CONTENT_TYPES);
        this.devices = devices;
    }

    @Override
    public void handlePOST(final CoapExchange exchange) {
        Request request = exchange.advanced().getRequest();
        if (request == null) {
            throw new NullPointerException("request must not be null!");
        }
        int format = request.getOptions().getContentFormat();
        if (format != -1 && Arrays.binarySearch(this.CONTENT_TYPES, format) < 0) {
            exchange.respond(CoAP.ResponseCode.NOT_ACCEPTABLE);
            return;
        }
        Principal principal = request.getSourceContext().getPeerIdentity();
        DeviceManager.DeviceInfo info = DeviceManager.getDeviceInfo(principal);
        if (info != null && info.provisioning) {
            String payload = request.getPayloadString();
            if (payload.isEmpty()) {
                exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Missing provisioning payload.");
            } else if (this.busy.compareAndSet(false, true)) {
                try {
                    final TimeOption timeOption = TimeOption.getMessageTime(request);
                    long time = timeOption.getLongValue();
                    payload = "# added " + Provisioning.format(time) + " by " + info.name + StringUtil.lineSeparator() + payload;
                    this.devices.add(info, time, payload, new ResultConsumer(){
                        private final AtomicBoolean done = new AtomicBoolean();

                        @Override
                        public void results(ResultConsumer.ResultCode code, String message) {
                            if (this.done.compareAndSet(false, true)) {
                                CoAP.ResponseCode responseCode = CoAP.ResponseCode.INTERNAL_SERVER_ERROR;
                                switch (code) {
                                    case SUCCESS: {
                                        responseCode = CoAP.ResponseCode.CHANGED;
                                        break;
                                    }
                                    case PROVISIONING_ERROR: {
                                        responseCode = CoAP.ResponseCode.CONFLICT;
                                        break;
                                    }
                                }
                                Response response = new Response(responseCode);
                                response.setPayload(message);
                                response.getOptions().setContentFormat(0);
                                TimeOption responseTimeOption = timeOption.adjust();
                                if (responseTimeOption != null) {
                                    response.getOptions().addOtherOption(responseTimeOption);
                                }
                                exchange.respond(response);
                                Provisioning.this.busy.set(false);
                                LOGGER.info("{}", (Object)response);
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "Provisioning failed, " + t.getMessage());
                    this.busy.set(false);
                }
            } else {
                LOGGER.info("Provisioing busy.");
                exchange.respond(CoAP.ResponseCode.TOO_MANY_REQUESTS, "Provisioning already pending.");
            }
        } else {
            LOGGER.info("No permission to added device credentials.");
            exchange.respond(CoAP.ResponseCode.FORBIDDEN, "No provisioning permission.");
        }
    }

    private static String format(long millis) {
        return ISO_DATE_FORMAT.format(new Date(millis));
    }
}

