/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.http;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.eclipse.californium.cloud.http.EtagGenerator;
import org.eclipse.californium.cloud.http.HtmlGenerator;
import org.eclipse.californium.cloud.util.CredentialsStore;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpService.class);
    private static final Logger LOGGER_BAN = LoggerFactory.getLogger("org.eclipse.californium.ban");
    private static final String TLS = "TLS";
    private static final String TLS_1_2 = "TLSv1.2";
    private static final String TLS_1_3 = "TLSv1.3";
    private static final String[] TLS_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2"};
    private static final String[] TLS_PROTOCOLS_1_2_ONLY = new String[]{"TLSv1.2"};
    private static final String HTTPS_PRIVATE_KEY = "privkey.pem";
    private static final String HTTPS_FULL_CHAIN = "fullchain.pem";
    public static final String ATTRIBUTE_PRINCIPAL = "principal";
    private static volatile HttpService httpService;
    private final InetSocketAddress localSecureAddress;
    private final String[] protocols;
    private final String sslContextAlgorithm;
    private final CredentialsStore credentialsStore;
    private SSLContext context;
    private X509Certificate node;
    private volatile ExecutorService executor;
    private HttpsServer secureServer;
    private volatile boolean started;
    private final Map<String, HttpHandler> handlers = new ConcurrentHashMap<String, HttpHandler>();

    public HttpService(InetSocketAddress localSecureAddress, CredentialsStore credentialsStore, String sslContextAlgorithm, String[] protocols) {
        this.localSecureAddress = localSecureAddress;
        this.sslContextAlgorithm = sslContextAlgorithm;
        this.protocols = protocols == null ? null : (String[])protocols.clone();
        this.credentialsStore = credentialsStore;
        this.applyCredentials(credentialsStore.getCredentials());
        this.credentialsStore.setObserver(new CredentialsStore.Observer(){

            @Override
            public void update(SslContextUtil.Credentials newCredentials) {
                if (newCredentials != null) {
                    HttpService.this.applyCredentials(newCredentials);
                }
            }
        });
    }

    public Executor getExecutor() {
        return new Executor(){

            @Override
            public void execute(Runnable command) {
                ExecutorService serverExecutor = HttpService.this.executor;
                if (serverExecutor == null) {
                    throw new RejectedExecutionException("Target executor missing!");
                }
                serverExecutor.execute(command);
            }
        };
    }

    public void setHttpsConfigurator(SSLContext sslContext) {
        if (this.secureServer != null && sslContext != null) {
            this.secureServer.setHttpsConfigurator(new HttpsConfigurator(sslContext){

                @Override
                public void configure(HttpsParameters parameters) {
                    parameters.setWantClientAuth(false);
                    if (HttpService.this.protocols != null) {
                        try {
                            boolean useTlsProtocols = false;
                            String[] clientProtocols = parameters.getProtocols();
                            if (clientProtocols == null || clientProtocols.length == 0) {
                                LOGGER.trace("TLS: protocol info not available!");
                                useTlsProtocols = true;
                            } else {
                                for (String protocol : clientProtocols) {
                                    LOGGER.trace("TLS: {}", (Object)protocol);
                                    if (!protocol.equals(HttpService.TLS_1_2)) continue;
                                    useTlsProtocols = true;
                                }
                            }
                            if (useTlsProtocols) {
                                parameters.setProtocols(HttpService.this.protocols);
                                for (String protocol : HttpService.this.protocols) {
                                    LOGGER.trace("TLS: set {}", (Object)protocol);
                                }
                            }
                        }
                        catch (Throwable t) {
                            LOGGER.error("TLS:", t);
                        }
                    }
                }
            });
        } else {
            if (this.secureServer == null) {
                LOGGER.warn("missing https server!");
            }
            if (sslContext == null) {
                LOGGER.warn("missing TLS context!");
            }
        }
    }

    public void createContext(String name, HttpHandler handler) {
        String url = name;
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.handlers.put(url, handler);
        if (this.secureServer != null) {
            this.secureServer.createContext(url, handler);
        }
    }

    public void createFileHandler(String resource, String contentType, boolean reload) {
        if (!resource.startsWith("http")) {
            this.createContext(resource, new FileHandler(resource, contentType, reload));
        }
    }

    public void start() {
        this.executor = Executors.newCachedThreadPool();
        if (this.localSecureAddress != null && this.context != null) {
            try {
                this.secureServer = HttpsServer.create(this.localSecureAddress, 10);
                this.setHttpsConfigurator(this.context);
                this.secureServer.createContext("/favicon.ico", new FileHandler(null, "image/x-icon", false));
                for (Map.Entry<String, HttpHandler> context : this.handlers.entrySet()) {
                    this.secureServer.createContext(context.getKey(), context.getValue());
                }
                this.secureServer.setExecutor(this.executor);
                this.secureServer.start();
                this.started = true;
                LOGGER.info("starting {} succeeded!", (Object)this.localSecureAddress);
            }
            catch (IOException ex) {
                LOGGER.warn("starting {} failed!", (Object)this.localSecureAddress, (Object)ex);
            }
        } else {
            if (this.localSecureAddress == null) {
                LOGGER.warn("missing local address!");
            }
            if (this.context == null) {
                LOGGER.warn("missing TLS context!");
            }
        }
    }

    public void stop() {
        this.started = false;
        if (this.secureServer != null) {
            this.secureServer.stop(2);
            this.secureServer = null;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    private void applyCredentials(SslContextUtil.Credentials newCredentials) {
        X509Certificate[] certificateChain = newCredentials.getCertificateChain();
        if (certificateChain != null && certificateChain.length > 0) {
            if (this.node == null || !this.node.equals(certificateChain[0])) {
                PrivateKey privateKey = newCredentials.getPrivateKey();
                if (privateKey != null) {
                    try {
                        KeyManager[] keyManager = SslContextUtil.createKeyManager("server", privateKey, certificateChain);
                        TrustManager[] trustManager = SslContextUtil.createTrustAllManager();
                        SSLContext sslContext = SSLContext.getInstance(this.sslContextAlgorithm);
                        sslContext.init(keyManager, trustManager, null);
                        this.context = sslContext;
                        this.node = certificateChain[0];
                        if (this.started) {
                            LOGGER.info("restart - certificates reloaded.");
                            this.stop();
                            this.start();
                        }
                    }
                    catch (GeneralSecurityException ex) {
                        LOGGER.warn("creating SSLcontext failed", ex);
                    }
                } else {
                    LOGGER.debug("private key missing.");
                }
            } else {
                LOGGER.debug("certificates not changed.");
            }
        } else {
            LOGGER.warn("missing certificates.");
        }
    }

    public SystemResourceMonitors.SystemResourceMonitor getFileMonitor() {
        return this.credentialsStore.getMonitor();
    }

    public static void logHeaders(String title, Headers headers) {
        for (String key : headers.keySet()) {
            LOGGER.debug("{}: {} {}", title, key, headers.getFirst(key));
        }
    }

    public static void respond(HttpExchange httpExchange, int httpCode, String contentType, byte[] payload) throws IOException {
        block23: {
            try {
                long length;
                if (payload == null) {
                    switch (httpCode) {
                        case 401: {
                            payload = "<h1>401 - Unauthorized!</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        case 403: {
                            payload = "<h1>403 - Forbidden!</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        case 404: {
                            payload = "<h1>404 - Not found!</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        case 405: {
                            payload = "<h1>405 - Method not allowed!</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        case 413: {
                            payload = "<h1>413 - Payload too large!</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                        case 500: {
                            payload = "<h1>500 - Internal Server Error</h1>".getBytes(StandardCharsets.UTF_8);
                            break;
                        }
                    }
                    if (payload != null) {
                        contentType = "text/html; charset=utf-8";
                    }
                }
                long l = length = payload != null && payload.length > 0 ? (long)payload.length : -1L;
                if (contentType != null) {
                    httpExchange.getResponseHeaders().set("Content-Type", contentType);
                }
                if (httpExchange.getRequestMethod().equals("HEAD")) {
                    httpExchange.getResponseHeaders().set("content-length", Long.toString(length));
                    httpExchange.getResponseHeaders().set("connection", "close");
                    length = -1L;
                }
                httpExchange.sendResponseHeaders(httpCode, length);
                HttpService.logHeaders("response", httpExchange.getResponseHeaders());
                if (length > 0L) {
                    try (OutputStream out = httpExchange.getResponseBody();){
                        out.write(payload);
                    }
                    LOGGER.info("respond {} {} {} bytes", httpExchange.getRequestMethod(), httpCode, length);
                    break block23;
                }
                LOGGER.info("respond {} {}", (Object)httpExchange.getRequestMethod(), (Object)httpCode);
            }
            catch (IOException e) {
                LOGGER.warn("writing response to {} failed!", (Object)httpExchange.getRemoteAddress(), (Object)e);
            }
            catch (Throwable e) {
                LOGGER.warn("respond to {} failed!", (Object)httpExchange.getRemoteAddress(), (Object)e);
            }
        }
    }

    public static void ban(HttpExchange httpExchange, String topic) {
        if (LOGGER_BAN.isInfoEnabled()) {
            String address = httpExchange.getRemoteAddress().getAddress().getHostAddress();
            String protocol = httpExchange.getProtocol();
            String method = httpExchange.getRequestMethod();
            String uri = httpExchange.getRequestURI().toString();
            LOGGER_BAN.info("https: {} {} {} {} Ban: {}", method, uri, protocol, topic, address);
        }
    }

    public static boolean strictPathCheck(HttpExchange httpExchange) {
        URI uri = httpExchange.getRequestURI();
        String path = httpExchange.getHttpContext().getPath();
        return path.equals(uri.getPath());
    }

    public static CredentialsStore loadCredentials(String credentialsPath, String password64) throws IOException, GeneralSecurityException {
        if (credentialsPath.endsWith("/")) {
            credentialsPath = credentialsPath.substring(0, credentialsPath.length() - 1);
        }
        String privateKey = credentialsPath + "/" + HTTPS_PRIVATE_KEY;
        String fullChain = credentialsPath + "/" + HTTPS_FULL_CHAIN;
        File directory = new File(credentialsPath);
        if (!directory.exists()) {
            LOGGER.error("Missing directory {} for https credentials!", (Object)credentialsPath);
        } else {
            File file = new File(fullChain);
            if (!file.exists()) {
                LOGGER.error("Missing https full-chain {}!", (Object)fullChain);
            } else if (!file.canRead()) {
                LOGGER.error("Missing read permission for https full-chain {}!", (Object)fullChain);
            }
            file = new File(privateKey);
            if (!file.exists()) {
                LOGGER.error("Missing https private-key {}!", (Object)privateKey);
            } else if (!file.canRead()) {
                LOGGER.error("Missing read permission for https private-key {}!", (Object)privateKey);
            }
        }
        CredentialsStore credentialsStore = new CredentialsStore(){

            @Override
            protected boolean complete(SslContextUtil.Credentials newCredentials) {
                return super.complete(newCredentials) && newCredentials.getCertificateChain() != null;
            }
        };
        credentialsStore.setTag("https ");
        credentialsStore.loadAndCreateMonitor(fullChain, privateKey, password64, true);
        return credentialsStore;
    }

    public static HttpService getHttpService() {
        return httpService;
    }

    public static boolean createHttpService(int httpsPort, String credentialsPath, String password64, boolean tls12Only) {
        try {
            HttpService service;
            CredentialsStore credentials = HttpService.loadCredentials(credentialsPath, password64);
            httpService = service = new HttpService(new InetSocketAddress(httpsPort), credentials, tls12Only ? TLS_1_2 : TLS, tls12Only ? TLS_PROTOCOLS_1_2_ONLY : TLS_PROTOCOLS);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("I/O error", e);
        }
        catch (GeneralSecurityException e) {
            LOGGER.error("Crypto error", e);
        }
        return false;
    }

    public static boolean startHttpService() {
        HttpService service = httpService;
        if (service != null) {
            service.start();
            return true;
        }
        LOGGER.error("HTTP service missing!");
        return false;
    }

    public static boolean stopHttpService() {
        HttpService service = httpService;
        if (service != null) {
            service.stop();
            return true;
        }
        LOGGER.error("HTTP service missing!");
        return false;
    }

    public static class FileHandler
    implements HttpHandler {
        private final String file;
        private final String path;
        private final String contentType;
        private final boolean classpath;
        private final boolean reload;
        private byte[] data;

        public FileHandler(String file, String contentType, boolean reload) {
            this.contentType = contentType;
            String path = null;
            boolean classpath = false;
            if (file != null) {
                classpath = file.startsWith("classpath://");
                if (classpath) {
                    file = file.substring("classpath://".length());
                } else {
                    path = "src/main/resources/";
                    File f = new File(path + file);
                    if (!f.isFile() || !f.canRead()) {
                        InputStream in;
                        path = "";
                        f = new File(file);
                        if (!(f.isFile() && f.canRead() || (in = Thread.currentThread().getContextClassLoader().getResourceAsStream(file)) == null)) {
                            classpath = true;
                            try {
                                in.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            this.classpath = classpath;
            this.file = file;
            this.path = path;
            this.reload = this.classpath ? false : reload;
            this.load();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load() {
            byte[] data;
            block15: {
                data = Bytes.EMPTY;
                if (this.file != null && !this.file.isEmpty()) {
                    try {
                        InputStream inStream = this.classpath ? Thread.currentThread().getContextClassLoader().getResourceAsStream(this.file) : new FileInputStream(this.path + this.file);
                        if (inStream == null) break block15;
                        try {
                            int length;
                            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
                            byte[] temp = new byte[4096];
                            while ((length = inStream.read(temp)) > 0) {
                                out.write(temp, 0, length);
                            }
                            data = out.toByteArray();
                        }
                        catch (IOException ex) {
                            LOGGER.info("Failure loading file {}", (Object)this.file, (Object)ex);
                        }
                        finally {
                            try {
                                inStream.close();
                            }
                            catch (IOException ex) {}
                        }
                    }
                    catch (FileNotFoundException e1) {
                        LOGGER.info("Failure loading file {}", (Object)this.file, (Object)e1);
                    }
                }
            }
            this.data = data;
            LOGGER.info("{} file {} bytes", (Object)this.contentType, (Object)data.length);
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            URI uri = httpExchange.getRequestURI();
            LOGGER.info("file-request: {} {}", (Object)httpExchange.getRequestMethod(), (Object)uri);
            String contentType = null;
            byte[] payload = null;
            int httpCode = 404;
            if (HttpService.strictPathCheck(httpExchange)) {
                String method = httpExchange.getRequestMethod();
                if (method.equals("GET")) {
                    if (this.reload) {
                        this.load();
                    }
                    if (EtagGenerator.setEtag(httpExchange, this.data)) {
                        httpCode = 304;
                    } else {
                        httpCode = 200;
                        payload = this.data;
                    }
                    contentType = this.contentType;
                    if (this.reload) {
                        httpExchange.getResponseHeaders().add("Cache-Control", "no-cache");
                    }
                } else if (method.equals("HEAD")) {
                    contentType = this.contentType;
                    payload = this.data;
                    httpCode = 200;
                    if (this.reload) {
                        httpExchange.getResponseHeaders().add("Cache-Control", "no-cache");
                    }
                } else {
                    httpCode = 405;
                }
            }
            HttpService.respond(httpExchange, httpCode, contentType, payload);
        }
    }

    public static class CoapProxyHandler
    implements HttpHandler {
        private final MessageDeliverer messageDeliverer;
        private final Executor executor;
        private final String[] prefix;

        public CoapProxyHandler(MessageDeliverer messageDeliverer, Executor executor, String ... prefix) {
            this.messageDeliverer = messageDeliverer;
            this.executor = executor;
            this.prefix = prefix;
        }

        public void fillUri(OptionSet options, String uri) {
            String[] prefix = this.prefix;
            String[] path = uri.split("/");
            int index = 0;
            for (index = 0; index < path.length - 1; ++index) {
                String element = path[index + 1];
                if (prefix != null && index < prefix.length) {
                    String pre = prefix[index];
                    if (pre.equals(element)) continue;
                    prefix = null;
                }
                options.addUriPath(element);
            }
        }

        public boolean checkResourcePath(String path) {
            return true;
        }

        @Override
        public void handle(final HttpExchange httpExchange) throws IOException {
            URI uri = httpExchange.getRequestURI();
            String method = httpExchange.getRequestMethod();
            Headers headers = httpExchange.getRequestHeaders();
            Request request = null;
            Principal principal = httpExchange.getPrincipal();
            Object attribute = httpExchange.getAttribute(HttpService.ATTRIBUTE_PRINCIPAL);
            if (attribute instanceof Principal) {
                principal = (Principal)attribute;
            }
            LOGGER.info("http-request: {} {}", (Object)method, (Object)uri);
            HttpService.logHeaders("request", headers);
            if (method.equals("GET") || method.equals("HEAD")) {
                request = Request.newGet();
                AddressEndpointContext context = new AddressEndpointContext(httpExchange.getRemoteAddress(), principal);
                request.setSourceContext(context);
            } else {
                request = Request.newPing();
            }
            this.fillUri(request.getOptions(), uri.getPath());
            String coapPath = "/" + request.getOptions().getUriPathString();
            if (this.checkResourcePath(coapPath)) {
                Exchange coapExchange = new Exchange(request, httpExchange.getRemoteAddress(), Exchange.Origin.REMOTE, this.executor){

                    @Override
                    public void sendAccept() {
                    }

                    @Override
                    public void sendReject() {
                        Response response = Response.createResponse(this.getRequest(), CoAP.ResponseCode.INTERNAL_SERVER_ERROR);
                        this.sendResponse(response);
                    }

                    @Override
                    public void sendResponse(Response response) {
                        Request request = this.getRequest();
                        if (response.getType() == null) {
                            CoAP.Type reqType = request.getType();
                            if (request.acknowledge()) {
                                response.setType(CoAP.Type.ACK);
                            } else {
                                response.setType(reqType);
                            }
                        }
                        request.setResponse(response);
                        CoapProxyHandler.this.respond(httpExchange, response);
                    }
                };
                this.messageDeliverer.deliverRequest(coapExchange);
            } else {
                int httpCode = 404;
                this.respond(httpExchange, httpCode, null, null);
                this.updateBan(httpExchange);
            }
        }

        public boolean respond(HttpExchange httpExchange, Response response) {
            LOGGER.info("CoAP response: {}", (Object)response);
            URI uri = httpExchange.getRequestURI();
            String contentType = null;
            byte[] payload = response.getPayload();
            int httpCode = 200;
            if (response.isSuccess()) {
                if (response.getOptions().getContentFormat() == 40) {
                    String path;
                    Set<WebLink> links = LinkFormat.parse(response.getPayloadString());
                    String title = path = uri.getPath();
                    int index = path.lastIndexOf(47);
                    if (index >= 0) {
                        title = path.substring(index + 1);
                        path = path.substring(0, index + 1);
                    }
                    String page = HtmlGenerator.createListPage(path, "", title, links, null, "time");
                    payload = page.getBytes(StandardCharsets.UTF_8);
                    contentType = "text/html; charset=utf-8";
                } else {
                    contentType = "text/plain; charset=utf-8";
                }
                List<byte[]> tags = response.getOptions().getETags();
                if (!tags.isEmpty()) {
                    byte[] etag = tags.get(0);
                    httpExchange.getResponseHeaders().set("ETag", StringUtil.byteArray2Hex(etag));
                }
            } else {
                payload = null;
                switch (response.getCode()) {
                    case NOT_FOUND: {
                        httpCode = 404;
                        break;
                    }
                    case METHOD_NOT_ALLOWED: {
                        httpCode = 405;
                        break;
                    }
                    default: {
                        httpCode = 500;
                    }
                }
            }
            try {
                this.respond(httpExchange, httpCode, contentType, payload);
                LOGGER.info("HTTP returned {}", (Object)response);
            }
            catch (IOException e) {
                LOGGER.warn("write response to {} failed!", (Object)httpExchange.getRemoteAddress(), (Object)e);
            }
            this.updateBan(httpExchange);
            return true;
        }

        public void respond(HttpExchange httpExchange, int httpCode, String contentType, byte[] payload) throws IOException {
            HttpService.respond(httpExchange, httpCode, contentType, payload);
        }

        public boolean updateBan(HttpExchange httpExchange) {
            return true;
        }
    }

    public static class ForwardHandler
    implements HttpHandler {
        private final String forwardLink;
        private final String forwardTitle;

        public ForwardHandler(String link, String title) {
            this.forwardLink = link;
            this.forwardTitle = title;
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            URI uri = httpExchange.getRequestURI();
            LOGGER.info("/request: {} {}", (Object)httpExchange.getRequestMethod(), (Object)uri);
            String method = httpExchange.getRequestMethod();
            String contentType = "text/html; charset=utf-8";
            byte[] payload = null;
            int httpCode = 405;
            if (method.equals("GET")) {
                String page = HtmlGenerator.createForwardPage(this.forwardLink, this.forwardTitle);
                httpCode = 200;
                payload = page.toString().getBytes(StandardCharsets.UTF_8);
            } else if (method.equals("HEAD")) {
                String page = HtmlGenerator.createForwardPage(this.forwardLink, this.forwardTitle);
                httpCode = 200;
                payload = page.toString().getBytes(StandardCharsets.UTF_8);
            }
            HttpService.respond(httpExchange, httpCode, contentType, payload);
        }
    }
}

