/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ManagementStatistic {
    private static final long MEGA = 0x100000L;
    private final Logger logger;
    private final boolean warnMemoryUsage;

    public ManagementStatistic(Logger logger) {
        this.logger = logger;
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        if (mxBean.isThreadCpuTimeSupported() && !mxBean.isThreadCpuTimeEnabled()) {
            mxBean.setThreadCpuTimeEnabled(true);
        }
        Boolean zgc = null;
        ArrayList<String> gcNames = new ArrayList<String>();
        for (GarbageCollectorMXBean gcMxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            String name = gcMxBean.getName();
            if (gcNames.contains(name)) continue;
            gcNames.add(name);
            if (zgc != null && !zgc.booleanValue()) continue;
            zgc = name.startsWith("ZGC");
        }
        this.warnMemoryUsage = zgc == null || zgc == false;
        logger.info("GC: {}", (Object)gcNames);
    }

    public boolean useWarningMemoryUsage() {
        return this.warnMemoryUsage;
    }

    public long getCollectionCount() {
        long gcCount = 0L;
        for (GarbageCollectorMXBean gcMxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = gcMxBean.getCollectionCount();
            if (0L < count) {
                gcCount += count;
            }
            this.logger.debug("{}: {} calls.", (Object)gcMxBean.getName(), (Object)count);
        }
        this.logger.debug("Overall {} calls.", (Object)gcCount);
        return gcCount;
    }

    public void printManagementStatistic() {
        long time;
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        int processors = osMxBean.getAvailableProcessors();
        this.logger.info("{} processors", (Object)processors);
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        if (threadMxBean.isThreadCpuTimeSupported() && threadMxBean.isThreadCpuTimeEnabled()) {
            long[] ids;
            long alltime = 0L;
            for (long id : ids = threadMxBean.getAllThreadIds()) {
                time = threadMxBean.getThreadCpuTime(id);
                if (0L >= time) continue;
                alltime += time;
            }
            long pTime = alltime / (long)processors;
            this.logger.info("cpu-time: {} ms (per-processor: {} ms)", (Object)TimeUnit.NANOSECONDS.toMillis(alltime), (Object)TimeUnit.NANOSECONDS.toMillis(pTime));
        }
        long gcCount = 0L;
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcMxBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long count = gcMxBean.getCollectionCount();
            if (0L < count) {
                gcCount += count;
            }
            if (0L < (time = gcMxBean.getCollectionTime())) {
                gcTime += time;
            }
            this.logger.info("{}: {} ms, {} calls.", gcMxBean.getName(), time, count);
        }
        this.logger.info("gc: {} ms, {} calls.", (Object)gcTime, (Object)gcCount);
        MemoryMXBean memoryMxBean = ManagementFactory.getMemoryMXBean();
        ManagementStatistic.printMemoryUsage(this.logger, "heap", memoryMxBean.getHeapMemoryUsage());
        ManagementStatistic.printMemoryUsage(this.logger, "non-heap", memoryMxBean.getNonHeapMemoryUsage());
        double loadAverage = osMxBean.getSystemLoadAverage();
        if (!(loadAverage < 0.0)) {
            this.logger.info("average load: {}", (Object)String.format("%.2f", loadAverage));
        }
    }

    public static void printMemoryUsage(Logger logger, String title, MemoryUsage memoryUsage) {
        long max = memoryUsage.getMax();
        if (max > 0L) {
            if (max > 0x100000L) {
                logger.info("{}: {} m-bytes used of {}/{}.", title, memoryUsage.getUsed() / 0x100000L, memoryUsage.getCommitted() / 0x100000L, max / 0x100000L);
            } else {
                logger.info("{}: {} bytes used of {}/{}.", title, memoryUsage.getUsed(), memoryUsage.getCommitted(), max);
            }
            return;
        }
        max = memoryUsage.getCommitted();
        if (max > 0x100000L) {
            logger.info("{}: {} m-bytes used of {}.", title, memoryUsage.getUsed() / 0x100000L, max / 0x100000L);
        } else {
            logger.info("{}: {} bytes used of {}.", title, memoryUsage.getUsed(), max);
        }
    }
}

