/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import org.eclipse.californium.cloud.util.DeviceGredentialsProvider;
import org.eclipse.californium.cloud.util.DeviceParser;
import org.eclipse.californium.cloud.util.DeviceProvisioningConsumer;
import org.eclipse.californium.cloud.util.ResourceChangedHandler;
import org.eclipse.californium.cloud.util.ResourceStore;
import org.eclipse.californium.cloud.util.ResultConsumer;
import org.eclipse.californium.elements.auth.AdditionalInfo;
import org.eclipse.californium.elements.auth.ExtensiblePrincipal;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.auth.ApplicationLevelInfoSupplier;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateIdentityResult;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.dtls.x509.CertificateProvider;
import org.eclipse.californium.scandium.dtls.x509.NewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceManager
implements DeviceGredentialsProvider,
DeviceProvisioningConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceManager.class);
    public static final String INFO_NAME = "name";
    public static final String INFO_MANAGER = "manager";
    private static volatile DeviceInfoProvider provider;
    private final ResourceStore<DeviceParser> devices;
    protected final PrivateKey privateKey;
    protected final PublicKey publicKey;
    protected AdvancedPskStore pskStore;
    protected NewAdvancedCertificateVerifier certificateVerifier;
    protected CertificateProvider certificateProvider;
    protected ApplicationLevelInfoSupplier infoSupplier;

    public DeviceManager(ResourceStore<DeviceParser> devices, PrivateKey privateKey, PublicKey publicKey) {
        this.devices = devices;
        this.privateKey = privateKey;
        this.publicKey = publicKey;
    }

    protected ApplicationLevelInfoSupplier createInfoSupplier() {
        return new ApplicationLevelInfoSupplier(){

            @Override
            public AdditionalInfo getInfo(Principal clientIdentity, Object customArgument) {
                if (customArgument instanceof AdditionalInfo) {
                    return (AdditionalInfo)customArgument;
                }
                return DeviceManager.this.createAdditionalInfo(clientIdentity);
            }
        };
    }

    @Override
    public void add(DeviceInfo info, long time, String data, ResultConsumer response) {
        this.add(this.devices, info, time, data, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(final ResourceStore<DeviceParser> devices, DeviceInfo info, long time, String data, final ResultConsumer response) {
        block20: {
            if (devices == null) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "no credentials available.");
                return;
            }
            SystemResourceMonitors.SystemResourceMonitor monitor = devices.getMonitor();
            if (!(monitor instanceof ResourceChangedHandler)) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "no ResourceChangedHandler.");
                return;
            }
            Semaphore semaphore = devices.getSemaphore();
            try {
                if (semaphore.tryAcquire(15000L, TimeUnit.MILLISECONDS)) {
                    try (StringReader reader = new StringReader(data);){
                        int result = devices.getResource().load(reader);
                        if (result > 0) {
                            ((ResourceChangedHandler)((Object)monitor)).changed(new ResultConsumer(){

                                @Override
                                public void results(ResultConsumer.ResultCode code, String message) {
                                    try {
                                        response.results(code, message);
                                    }
                                    finally {
                                        devices.getSemaphore().release();
                                    }
                                }
                            });
                            semaphore = null;
                        } else {
                            LOGGER.info("no credentials added!");
                            response.results(ResultConsumer.ResultCode.PROVISIONING_ERROR, "no credentials added.");
                        }
                        break block20;
                    }
                    catch (IllegalArgumentException e) {
                        response.results(ResultConsumer.ResultCode.PROVISIONING_ERROR, e.getMessage());
                        break block20;
                    }
                    catch (IOException e) {
                        response.results(ResultConsumer.ResultCode.SERVER_ERROR, "failed to read new credentials. " + e.getMessage());
                        break block20;
                    }
                    finally {
                        if (semaphore != null) {
                            semaphore.release();
                        }
                    }
                }
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "Too busy.");
            }
            catch (InterruptedException e) {
                response.results(ResultConsumer.ResultCode.SERVER_ERROR, "Shutdown.");
            }
        }
    }

    @Override
    public AdvancedPskStore getPskStore() {
        if (this.devices == null) {
            return null;
        }
        if (this.pskStore == null) {
            this.pskStore = new DevicePskStore();
        }
        return this.pskStore;
    }

    @Override
    public NewAdvancedCertificateVerifier getCertificateVerifier() {
        if (this.devices == null || this.publicKey == null || this.privateKey == null) {
            return null;
        }
        if (this.certificateVerifier == null) {
            this.certificateVerifier = new DeviceCertificateVerifier();
        }
        return this.certificateVerifier;
    }

    @Override
    public CertificateProvider getCertificateProvider() {
        if (this.devices == null || this.publicKey == null || this.privateKey == null) {
            return null;
        }
        if (this.certificateProvider == null) {
            this.certificateProvider = new ServerCertificateProvider();
        }
        return this.certificateProvider;
    }

    @Override
    public ApplicationLevelInfoSupplier getInfoSupplier() {
        if (this.infoSupplier == null) {
            this.infoSupplier = new ApplicationLevelInfoSupplier(){

                @Override
                public AdditionalInfo getInfo(Principal clientIdentity, Object customArgument) {
                    if (customArgument instanceof AdditionalInfo) {
                        return (AdditionalInfo)customArgument;
                    }
                    return DeviceManager.this.createAdditionalInfo(clientIdentity);
                }
            };
        }
        return this.infoSupplier;
    }

    public AdditionalInfo createAdditionalInfo(Principal clientIdentity) {
        if (this.devices == null) {
            return null;
        }
        return this.createAdditionalInfo(this.devices.getResource().getByPrincipal(clientIdentity));
    }

    public AdditionalInfo createAdditionalInfo(DeviceParser.Device device) {
        if (device != null) {
            HashMap<String, Object> info = new HashMap<String, Object>();
            info.put(INFO_NAME, device.name);
            info.put(INFO_MANAGER, this);
            return AdditionalInfo.from(info);
        }
        return null;
    }

    public static DeviceInfo getDeviceInfo(Principal principal) {
        DeviceInfoProvider provider = DeviceManager.provider;
        if (provider != null) {
            return provider.getDeviceInfo(principal);
        }
        if (principal instanceof ExtensiblePrincipal) {
            DeviceParser.Device device;
            ExtensiblePrincipal extensiblePrincipal = (ExtensiblePrincipal)principal;
            String name = extensiblePrincipal.getExtendedInfo().get(INFO_NAME, String.class);
            DeviceManager manager = extensiblePrincipal.getExtendedInfo().get(INFO_MANAGER, DeviceManager.class);
            if (manager != null && name != null && !name.contains("/") && (device = manager.devices.getResource().get(name)) != null) {
                return new DeviceInfo(device.group, name, device.provisioning);
            }
        }
        return null;
    }

    public static void setDeviceInfoProvider(DeviceInfoProvider provider) {
        DeviceManager.provider = provider;
    }

    public static class DeviceInfo {
        public final String name;
        public final String group;
        public final boolean provisioning;

        protected DeviceInfo(String group, String name, boolean provisioning) {
            this.name = name;
            this.group = group;
            this.provisioning = provisioning;
        }

        public String toString() {
            return this.name + " (" + this.group + (this.provisioning ? ",prov)" : ")");
        }
    }

    private class DevicePskStore
    implements AdvancedPskStore {
        private final PskPublicInformation dummy = new PskPublicInformation("dummy");

        private DevicePskStore() {
        }

        @Override
        public boolean hasEcdhePskSupported() {
            return true;
        }

        @Override
        public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
            DeviceParser.Device device = ((DeviceParser)DeviceManager.this.devices.getResource()).getByPreSharedKeyIdentity(identity.getPublicInfoAsString());
            if (device != null) {
                return new PskSecretResult(cid, identity, SecretUtil.create(device.pskSecret, "PSK"), DeviceManager.this.createAdditionalInfo(device));
            }
            return new PskSecretResult(cid, identity, null);
        }

        @Override
        public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
            return this.dummy;
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }

    private class DeviceCertificateVerifier
    implements NewAdvancedCertificateVerifier {
        private final List<CertificateType> supportedCertificateTypes = Arrays.asList(CertificateType.RAW_PUBLIC_KEY);

        private DeviceCertificateVerifier() {
        }

        @Override
        public List<CertificateType> getSupportedCertificateTypes() {
            return this.supportedCertificateTypes;
        }

        @Override
        public CertificateVerificationResult verifyCertificate(ConnectionId cid, ServerNames serverName, InetSocketAddress remotePeer, boolean clientUsage, boolean verifySubject, boolean truncateCertificatePath, CertificateMessage message) {
            PublicKey publicKey = message.getPublicKey();
            DeviceParser.Device device = ((DeviceParser)DeviceManager.this.devices.getResource()).getByRawPublicKey(publicKey);
            if (device != null) {
                return new CertificateVerificationResult(cid, publicKey, (Object)DeviceManager.this.createAdditionalInfo(device));
            }
            LOGGER.warn("Certificate validation failed: Raw public key is not trusted");
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            return new CertificateVerificationResult(cid, new HandshakeException("Raw public key is not trusted!", alert), null);
        }

        @Override
        public List<X500Principal> getAcceptedIssuers() {
            return Collections.emptyList();
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }

    protected class ServerCertificateProvider
    implements CertificateProvider {
        private List<CertificateType> supportedCertificateTypes = Collections.unmodifiableList(Arrays.asList(CertificateType.RAW_PUBLIC_KEY));
        private List<CipherSuite.CertificateKeyAlgorithm> supportedCertificateKeyAlgorithms;

        public ServerCertificateProvider() {
            this.supportedCertificateKeyAlgorithms = Collections.unmodifiableList(Arrays.asList(CipherSuite.CertificateKeyAlgorithm.getAlgorithm(DeviceManager.this.publicKey)));
        }

        @Override
        public List<CipherSuite.CertificateKeyAlgorithm> getSupportedCertificateKeyAlgorithms() {
            return this.supportedCertificateKeyAlgorithms;
        }

        @Override
        public List<CertificateType> getSupportedCertificateTypes() {
            return this.supportedCertificateTypes;
        }

        @Override
        public CertificateIdentityResult requestCertificateIdentity(ConnectionId cid, boolean client, List<X500Principal> issuers, ServerNames serverNames, List<CipherSuite.CertificateKeyAlgorithm> certificateKeyAlgorithms, List<SignatureAndHashAlgorithm> signatureAndHashAlgorithms, List<XECDHECryptography.SupportedGroup> curves) {
            return new CertificateIdentityResult(cid, DeviceManager.this.privateKey, DeviceManager.this.publicKey);
        }

        @Override
        public void setResultHandler(HandshakeResultHandler resultHandler) {
        }
    }

    public static interface DeviceInfoProvider {
        public DeviceInfo getDeviceInfo(Principal var1);
    }
}

