/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.http;

import com.sun.net.httpserver.HttpExchange;
import java.security.MessageDigest;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.cipher.ThreadLocalMessageDigest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtagGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(EtagGenerator.class);
    private static final String ETAG_HEADER = "ETag";
    private static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    private static final String ETAG_ALGORITHM = "MD5";
    private static final ThreadLocalMessageDigest ETAG = new ThreadLocalMessageDigest("MD5");

    public static boolean setEtag(HttpExchange exchange, byte[] payload) {
        MessageDigest md = (MessageDigest)ETAG.current();
        md.reset();
        String etag = StringUtil.byteArray2Hex(md.digest(payload)).toLowerCase();
        exchange.getResponseHeaders().set(ETAG_HEADER, etag);
        Object etags = exchange.getRequestHeaders().get(IF_NONE_MATCH_HEADER);
        if (etags != null) {
            if (etags.contains(etag)) {
                LOGGER.info("ETAG matching");
                return true;
            }
            LOGGER.info("ETAG not matching");
        } else {
            LOGGER.info("ETAG not provided");
        }
        return false;
    }
}

