/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.util;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.cloud.util.ResourceParser;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.EncryptedStreamUtil;
import org.eclipse.californium.elements.util.StandardCharsets;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.elements.util.SystemResourceMonitors;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStore<T extends ResourceParser<T>>
implements Destroyable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceStore.class);
    private final T factory;
    private final EncryptedStreamUtil encryptionUtility = new EncryptedStreamUtil();
    private volatile Observer<T> observer;
    protected volatile SystemResourceMonitors.SystemResourceMonitor monitor;
    private volatile String tag = "";
    private volatile T currentResource;
    private volatile boolean destroyed;
    private byte[] seed;

    public ResourceStore(T factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null!");
        }
        this.factory = factory;
        this.currentResource = factory.create();
    }

    public String getWriteCipher() {
        return this.encryptionUtility.getWriteCipher();
    }

    public String getReadCipher() {
        return this.encryptionUtility.getReadCipher();
    }

    public ResourceStore<T> setDefaultWriteCipher() {
        this.encryptionUtility.setDefaultWriteCipher();
        return this;
    }

    public ResourceStore<T> setWriteCipher(String cipherAlgorithm, int keySizeBits) {
        this.encryptionUtility.setWriteCipher(cipherAlgorithm, keySizeBits);
        return this;
    }

    public ResourceStore<T> setWriteCipher(String spec) {
        this.encryptionUtility.setWriteCipher(spec);
        return this;
    }

    public ResourceStore<T> setTag(String tag) {
        if (tag == null) {
            throw new NullPointerException("tag must not be null!");
        }
        this.tag = tag;
        return this;
    }

    public String getTag() {
        return this.tag;
    }

    public ResourceStore<T> setObserver(Observer<T> observer) {
        this.observer = observer;
        return this;
    }

    public SystemResourceMonitors.SystemResourceMonitor createMonitor(final String file, final SecretKey password) {
        this.monitor = file != null ? new SystemResourceMonitors.FileMonitor(file){
            private SecretKey monitorPassword;
            {
                super(arg0);
                this.monitorPassword = SecretUtil.create(password);
            }

            @Override
            protected void update(SystemResourceMonitors.FileMonitor.MonitoredValues values, SystemResourceMonitors.SystemResourceCheckReady ready) {
                if (this.monitorPassword != null) {
                    ResourceStore.this.load(file, this.monitorPassword);
                } else {
                    ResourceStore.this.load(file);
                }
                this.ready(values);
                ready.ready(false);
            }
        } : null;
        return this.monitor;
    }

    public SystemResourceMonitors.SystemResourceMonitor getMonitor() {
        return this.monitor;
    }

    public void clearSeed() {
        if (this.seed != null) {
            Bytes.clear(this.seed);
            this.seed = null;
        }
    }

    public ResourceStore<T> load(String file) {
        try (FileInputStream in = new FileInputStream(file);
             InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
            this.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("{}read {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> load(InputStream in) {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            this.load(reader);
        }
        catch (IOException e) {
            LOGGER.warn("{}read:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> load(String file, SecretKey password) {
        try (FileInputStream in = new FileInputStream(file);){
            this.load(in, password);
        }
        catch (IOException e) {
            LOGGER.warn("{}read encrypted {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> load(InputStream in, SecretKey password) {
        byte[] seed = this.encryptionUtility.readSeed(in);
        if (this.seed == null || !Arrays.equals(this.seed, seed)) {
            try (InputStream inEncrypted = this.encryptionUtility.prepare(seed, in, password);){
                this.load(inEncrypted);
                this.seed = seed;
            }
            catch (IOException e) {
                LOGGER.warn("{}read encrypted:", (Object)this.tag, (Object)e);
            }
        } else {
            LOGGER.debug("{}encrypted not changed, (same seed).", (Object)this.tag);
        }
        return this;
    }

    public ResourceStore<T> load(Reader reader) throws IOException {
        Object newConfigurations = this.factory.create();
        newConfigurations.load(reader);
        if (newConfigurations.isDestroyed()) {
            if (this.currentResource.isDestroyed()) {
                this.destroyed = true;
            }
        } else {
            Observer observer = this.observer;
            if (observer != null) {
                observer.update(newConfigurations);
            }
            this.currentResource = newConfigurations;
            this.seed = null;
        }
        return this;
    }

    public ResourceStore<T> save(String file) {
        try (FileOutputStream out = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);){
            this.save(writer);
        }
        catch (IOException e) {
            LOGGER.warn("{}write {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> save(OutputStream out) {
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            this.save(writer);
        }
        catch (IOException e) {
            LOGGER.warn("{}write:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> save(String file, SecretKey password) {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(out, password);
        }
        catch (IOException e) {
            LOGGER.warn("{}write encrypted {}:", this.tag, file, e);
        }
        return this;
    }

    public ResourceStore<T> save(OutputStream out, SecretKey password) {
        try (OutputStream outEncrypted = this.encryptionUtility.prepare(this.seed, out, password);){
            this.save(outEncrypted);
        }
        catch (IOException e) {
            LOGGER.warn("{}write encrypted:", (Object)this.tag, (Object)e);
        }
        return this;
    }

    public ResourceStore<T> save(Writer writer) throws IOException {
        this.currentResource.save(writer);
        return this;
    }

    public T loadAndCreateMonitor(String name, String password64, boolean createMonitor) {
        if (password64 != null) {
            byte[] secret = StringUtil.base64ToByteArray(password64);
            SecretKey key = SecretUtil.create(secret, "PW");
            Bytes.clear(secret);
            this.load(name, key);
            if (createMonitor) {
                this.createMonitor(name, key);
            }
            SecretUtil.destroy(key);
            LOGGER.info("{}loaded encrypted store {}", (Object)this.getTag(), (Object)name);
        } else {
            this.load(name);
            if (createMonitor) {
                this.createMonitor(name, null);
            }
            LOGGER.info("{}loaded store {}", (Object)this.getTag(), (Object)name);
        }
        return this.currentResource;
    }

    public T getResource() {
        return this.currentResource;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        this.currentResource.destroy();
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    public static interface Observer<T extends ResourceParser<T>> {
        public void update(T var1);
    }
}

