/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.upokecenter.cbor.CBORObject;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.cloud.EndpointNetSocketObserver;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.WebLink;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.LinkFormat;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.interceptors.MessageInterceptor;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.config.DtlsConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Diagnose
extends CoapResource {
    public static final String RESOURCE_NAME = "diagnose";
    private static final Logger LOGGER = LoggerFactory.getLogger(Diagnose.class);
    private static final SimpleDateFormat ISO = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSSXXX");
    private static final String START_TIME = ISO.format(new Date());
    private final List<ServerInterface> serverList = new ArrayList<ServerInterface>();
    private final ConcurrentMap<InetSocketAddress, List<CounterStatisticManager>> endpointsHealth;
    private final List<CounterStatisticManager> endpointHealth;
    private final Endpoint endpoint;

    public Diagnose(ServerInterface server) {
        this(RESOURCE_NAME, "Resource for diagnose statistics", server);
    }

    public Diagnose(String name, String title, ServerInterface server) {
        super(name);
        this.init(title);
        if (server != null) {
            this.serverList.add(server);
        }
        this.endpointsHealth = new ConcurrentHashMap<InetSocketAddress, List<CounterStatisticManager>>();
        this.endpointHealth = null;
        this.endpoint = null;
    }

    public Diagnose(String name, String title, Endpoint endpoint, List<CounterStatisticManager> endpointHealth) {
        super(name);
        this.init(title);
        this.endpointsHealth = null;
        this.endpointHealth = endpointHealth;
        this.endpoint = endpoint;
    }

    private void init(String title) {
        this.getAttributes().setTitle(title);
        this.getAttributes().addContentType(0);
        this.getAttributes().addContentType(50);
        this.getAttributes().addContentType(60);
    }

    public void add(ServerInterface server) {
        if (server != null) {
            this.serverList.add(server);
        }
    }

    public void update(List<CounterStatisticManager> serverHealth) {
        this.endpointsHealth.clear();
        for (Resource child : this.getChildren()) {
            this.delete(child);
        }
        for (ServerInterface server : this.serverList) {
            for (Endpoint ep : server.getEndpoints()) {
                String scheme = ep.getUri().getScheme();
                if (!CoAP.isUdpScheme(scheme)) continue;
                this.addHealth(ep, serverHealth);
            }
        }
    }

    public void addHealth(Endpoint endpoint, List<CounterStatisticManager> serverHealth) {
        ArrayList<CounterStatisticManager> health = new ArrayList<CounterStatisticManager>(serverHealth);
        String protocol = CoAP.getProtocolForScheme(endpoint.getUri().getScheme());
        InetSocketAddress local = endpoint.getAddress();
        String key = protocol + ":" + StringUtil.toString(local);
        CounterStatisticManager statistic = EndpointNetSocketObserver.getDtlsStatisticManager(endpoint);
        if (statistic != null) {
            health.add(statistic);
        }
        for (MessageInterceptor interceptor : endpoint.getInterceptors()) {
            if (!(interceptor instanceof CounterStatisticManager)) continue;
            health.add((CounterStatisticManager)((Object)interceptor));
        }
        for (MessageInterceptor interceptor : endpoint.getPostProcessInterceptors()) {
            if (!(interceptor instanceof CounterStatisticManager)) continue;
            health.add((CounterStatisticManager)((Object)interceptor));
        }
        if (!health.isEmpty()) {
            this.endpointsHealth.put(local, health);
            Diagnose child = new Diagnose(key, "Resource for diagnose statistic of " + key, endpoint, health);
            this.add((CoapResource)child);
            LOGGER.debug("added {} diagnose for {}", (Object)health.size(), (Object)key);
        }
    }

    @Override
    public void handleGET(CoapExchange exchange) {
        Response response = new Response(CoAP.ResponseCode.CONTENT);
        Integer maxConnections = null;
        Integer nodeId = null;
        List healths = this.endpointHealth;
        Endpoint endpoint = this.endpoint;
        if (endpoint == null) {
            endpoint = exchange.advanced().getEndpoint();
        }
        if (endpoint != null) {
            String scheme = endpoint.getUri().getScheme();
            if ("coaps".equalsIgnoreCase(scheme)) {
                Configuration config = endpoint.getConfig();
                maxConnections = config.get(DtlsConfig.DTLS_MAX_CONNECTIONS);
                nodeId = config.get(DtlsConfig.DTLS_CONNECTION_ID_NODE_ID);
                LOGGER.info("coaps: max {}, node-id {}", (Object)maxConnections, (Object)nodeId);
            } else {
                LOGGER.info("{}", (Object)scheme);
            }
            if (this.endpointsHealth != null) {
                healths = (List)this.endpointsHealth.get(endpoint.getAddress());
            }
        } else if (healths == null) {
            List<String> query = exchange.getRequestOptions().getUriQuery();
            if (query.size() > 1) {
                exchange.respond(CoAP.ResponseCode.BAD_OPTION, "only one search query is supported!", 0);
                return;
            }
            Set<WebLink> subTree = LinkFormat.getSubTree(this, query);
            response.setPayload(LinkFormat.serialize(subTree));
            response.getOptions().setContentFormat(40);
            exchange.respond(response);
            return;
        }
        switch (exchange.getRequestOptions().getAccept()) {
            case -1: 
            case 0: {
                response.getOptions().setContentFormat(0);
                response.setPayload(this.toText(maxConnections, nodeId, healths));
                break;
            }
            case 50: {
                response.getOptions().setContentFormat(50);
                response.setPayload(this.toJson(maxConnections, nodeId, healths));
                break;
            }
            case 60: {
                response.getOptions().setContentFormat(60);
                response.setPayload(this.toCbor(maxConnections, nodeId, healths));
                break;
            }
            default: {
                response = new Response(CoAP.ResponseCode.NOT_ACCEPTABLE);
            }
        }
        exchange.respond(response);
    }

    public String toText(Integer maxConnections, Integer nodeId, List<CounterStatisticManager> healths) {
        String eol = System.lineSeparator();
        StringBuilder builder = new StringBuilder();
        builder.append("systemstart: ").append(START_TIME).append(eol);
        if (nodeId != null) {
            builder.append("node-id: ").append(nodeId).append(eol);
        }
        if (maxConnections != null) {
            builder.append("max. connnections: ").append(maxConnections).append(eol);
        }
        if (healths != null && !healths.isEmpty()) {
            CounterStatisticManager first = healths.get(0);
            long lastTransfer = ClockUtil.nanoRealtime() - first.getLastTransferTime();
            builder.append("since: ").append(TimeUnit.NANOSECONDS.toSeconds(lastTransfer)).append("s").append(eol);
            int counter = 0;
            for (CounterStatisticManager manager : healths) {
                String tag = manager.getTag();
                if (tag != null && !tag.isEmpty()) {
                    builder.append(tag).append(eol);
                } else {
                    builder.append(++counter).append(eol);
                }
                String head = "   ";
                for (String key : manager.getKeys()) {
                    SimpleCounterStatistic statistic = manager.getByKey(key);
                    if (statistic == null) continue;
                    long[] pair = statistic.getCountersPair();
                    builder.append(head).append(key).append(",").append(pair[0]).append(",").append(pair[1]).append(eol);
                }
            }
        }
        return builder.toString();
    }

    public String toJson(Integer maxConnections, Integer nodeId, List<CounterStatisticManager> healths) {
        JsonObject element = new JsonObject();
        element.addProperty("systemstart", START_TIME);
        if (nodeId != null) {
            element.addProperty("node-id", nodeId);
        }
        if (maxConnections != null) {
            element.addProperty("max-connections", maxConnections);
        }
        if (healths != null && !healths.isEmpty()) {
            CounterStatisticManager first = healths.get(0);
            long lastTransfer = ClockUtil.nanoRealtime() - first.getLastTransferTime();
            element.addProperty("since", TimeUnit.NANOSECONDS.toSeconds(lastTransfer) + "s");
            int counter = 0;
            for (CounterStatisticManager manager : healths) {
                JsonObject group = new JsonObject();
                for (String key : manager.getKeys()) {
                    SimpleCounterStatistic statistic = manager.getByKey(key);
                    if (statistic == null) continue;
                    long[] pair = statistic.getCountersPair();
                    JsonObject info = new JsonObject();
                    info.addProperty("cur", pair[0]);
                    info.addProperty("all", pair[1]);
                    group.add(key, info);
                }
                String tag = manager.getTag();
                if (tag != null && !tag.isEmpty()) {
                    element.add(tag, group);
                    continue;
                }
                element.add(Integer.toString(++counter), group);
            }
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        return gson.toJson(element);
    }

    public byte[] toCbor(Integer maxConnections, Integer nodeId, List<CounterStatisticManager> healths) {
        CBORObject map = CBORObject.NewOrderedMap();
        map.set("systemstart", CBORObject.FromObject(START_TIME));
        if (nodeId != null) {
            map.set("node-id", CBORObject.FromObject(nodeId));
        }
        if (maxConnections != null) {
            map.set("max-connections", CBORObject.FromObject(maxConnections));
        }
        if (healths != null && !healths.isEmpty()) {
            CounterStatisticManager first = healths.get(0);
            long lastTransfer = ClockUtil.nanoRealtime() - first.getLastTransferTime();
            map.set("since", CBORObject.FromObject(TimeUnit.NANOSECONDS.toSeconds(lastTransfer) + "s"));
            int counter = 0;
            for (CounterStatisticManager manager : healths) {
                CBORObject group = CBORObject.NewOrderedMap();
                for (String key : manager.getKeys()) {
                    SimpleCounterStatistic statistic = manager.getByKey(key);
                    if (statistic == null) continue;
                    long[] pair = statistic.getCountersPair();
                    CBORObject info = CBORObject.NewOrderedMap();
                    info.set("cur", CBORObject.FromObject(pair[0]));
                    info.set("all", CBORObject.FromObject(pair[1]));
                    group.set(key, info);
                }
                String tag = manager.getTag();
                if (tag != null && !tag.isEmpty()) {
                    map.set(tag, group);
                    continue;
                }
                map.set(Integer.toString(++counter), group);
            }
        }
        return map.EncodeToBytes();
    }
}

