/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.option;

import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.elements.util.ClockUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeOption
extends Option {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeOption.class);
    public static final int COAP_OPTION_TIME = 65000;
    public static final long MAX_MILLISECONDS_DELTA = 5000L;
    public static final IntegerOptionDefinition DEFINITION = new IntegerOptionDefinition(65000, "Time", true){

        @Override
        public Option create(byte[] value) {
            return new TimeOption(value);
        }
    };
    private boolean adjustTime;
    private static final int DEPRECATED_COAP_OPTION_TIME = 65340;
    public static final IntegerOptionDefinition DEPRECATED_DEFINITION = new IntegerOptionDefinition(65340, "_Time", true){

        @Override
        public Option create(byte[] value) {
            return new TimeOption(DEPRECATED_DEFINITION, value);
        }
    };

    public TimeOption() {
        this(System.currentTimeMillis());
    }

    public TimeOption(long time) {
        super(DEFINITION, time);
    }

    public TimeOption(byte[] value) {
        super((OptionDefinition)DEFINITION, value);
    }

    public TimeOption adjust() {
        return this.adjustTime ? new TimeOption((IntegerOptionDefinition)this.getDefinition()) : null;
    }

    public static TimeOption getMessageTime(Message message) {
        long delta = ClockUtil.delta(message.getNanoTimestamp(), TimeUnit.MILLISECONDS);
        long receiveTime = System.currentTimeMillis() - delta;
        Option option = message.getOptions().getOtherOption(DEFINITION);
        if (option == null) {
            option = message.getOptions().getOtherOption(DEPRECATED_DEFINITION);
        }
        if (option != null) {
            TimeOption time;
            IntegerOptionDefinition definition = (IntegerOptionDefinition)option.getDefinition();
            long value = option.getLongValue();
            if (value == 0L) {
                time = new TimeOption(definition, receiveTime);
                time.adjustTime = true;
                LOGGER.info("Time: send initial time");
            } else {
                time = (TimeOption)option;
                delta = value - receiveTime;
                if (Math.abs(delta) > 5000L) {
                    time.adjustTime = true;
                    LOGGER.info("Time: {}ms delta => send fix", (Object)delta);
                } else {
                    LOGGER.debug("Time: {}ms delta", (Object)delta);
                }
            }
            return time;
        }
        LOGGER.debug("Time: localtime");
        return new TimeOption(receiveTime);
    }

    private TimeOption(IntegerOptionDefinition definition) {
        super(definition, System.currentTimeMillis());
    }

    private TimeOption(IntegerOptionDefinition definition, long value) {
        super(definition, value);
    }

    private TimeOption(IntegerOptionDefinition definition, byte[] value) {
        super((OptionDefinition)definition, value);
    }
}

