/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cloud.option;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.option.IntegerOptionDefinition;
import org.eclipse.californium.core.coap.option.OptionDefinition;

public class ReadResponseOption
extends Option {
    public static final int COAP_OPTION_READ_RESPONSE = 65008;
    public static final IntegerOptionDefinition DEFINITION = new IntegerOptionDefinition(65008, "Read_ResponseCode", true, new int[]{1, 1}){

        @Override
        public Option create(byte[] value) {
            return new ReadResponseOption(value);
        }

        @Override
        public void assertValue(byte[] value) {
            int code = value[0] & 0xFF;
            try {
                CoAP.ResponseCode.valueOf(code);
            }
            catch (MessageFormatException ex) {
                throw new IllegalArgumentException(ex.getMessage() + " Value " + value);
            }
        }
    };

    public ReadResponseOption(int code) {
        super(DEFINITION, code);
    }

    public ReadResponseOption(CoAP.ResponseCode code) {
        this(code.value);
    }

    public ReadResponseOption(byte[] value) {
        super((OptionDefinition)DEFINITION, value);
    }
}

