/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.cli;

import java.net.InetSocketAddress;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.eclipse.californium.cli.ConnectorConfig;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.eclipse.californium.elements.util.StringUtil;
import picocli.CommandLine;

public class ClientBaseConfig
extends ConnectorConfig {
    public static final String LABEL_URI = "URI";
    public static final String DEFAULT_URI = "californium.eclipseprojects.io";
    public String defaultUri = "californium.eclipseprojects.io";
    private String defaultIdentity;
    private String defaultSecret;
    @CommandLine.Option(names={"--proxy"}, description={"use proxy. <address>:<port>[:<scheme>]. Default env-value of COAP_PROXY."})
    public ProxyConfiguration proxy;
    @CommandLine.Option(names={"--local-port"}, description={"local porty. Default ephemeral port."})
    public Integer localPort;
    @CommandLine.Option(names={"--dtls-auto-handshake"}, description={"enable dtls auto-handshake with provided timeout. Value in format time[unit], e.g. the recommended value of \"30[s]\". Or time|unit, e.g. 30s. Default disabled."})
    public String dtlsAutoHandshake;
    @CommandLine.Option(names={"--no-subject-verification"}, negatable=true, description={"enable/disable verification of server certificate's subject."})
    public Boolean noCertificatesSubjectVerification;
    @CommandLine.Option(names={"--no-sni"}, negatable=true, description={"enable/disable server-name indication."})
    public Boolean noServerNameIndication;
    @CommandLine.Parameters(index="0", paramLabel="URI", arity="0..1", description={"destination URI. Default ${DEFAULT-VALUE}"})
    public String uri;
    public boolean secure;
    public boolean tcp;
    private static CommandLine.ITypeConverter<ProxyConfiguration> proxyReader = new CommandLine.ITypeConverter<ProxyConfiguration>(){

        public ProxyConfiguration convert(String value) throws Exception {
            String host;
            int index;
            String config = value;
            if (config.startsWith("[")) {
                index = config.indexOf("]:");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index + 1);
                config = config.substring(index + 2);
            } else {
                index = config.indexOf(":");
                if (index < 0) {
                    throw new IllegalArgumentException(value + " invalid proxy configuration!");
                }
                host = config.substring(0, index);
                config = config.substring(index + 1);
            }
            String scheme = null;
            index = config.indexOf(":");
            if (index > 0) {
                scheme = config.substring(index + 1);
                config = config.substring(0, index);
            }
            try {
                InetSocketAddress destination = new InetSocketAddress(host, Integer.parseInt(config));
                return new ProxyConfiguration(scheme, destination);
            }
            catch (Throwable ex) {
                throw new IllegalArgumentException(value + " invalid proxy configuration!", ex);
            }
        }
    };

    @Override
    public void register(CommandLine cmd) {
        super.register(cmd);
        cmd.registerConverter(ProxyConfiguration.class, proxyReader);
        final CommandLine.IDefaultValueProvider defaultValueProvider = cmd.getDefaultValueProvider();
        CommandLine.IDefaultValueProvider newDefaultValueProvider = new CommandLine.IDefaultValueProvider(){

            public String defaultValue(CommandLine.Model.ArgSpec argSpec) throws Exception {
                CommandLine.Model.PositionalParamSpec spec;
                if (argSpec instanceof CommandLine.Model.PositionalParamSpec && ClientBaseConfig.LABEL_URI.contentEquals((spec = (CommandLine.Model.PositionalParamSpec)argSpec).paramLabel())) {
                    return ClientBaseConfig.this.defaultUri;
                }
                return defaultValueProvider != null ? defaultValueProvider.defaultValue(argSpec) : null;
            }
        };
        cmd.setDefaultValueProvider(newDefaultValueProvider);
    }

    @Override
    public void defaults() {
        String proxySpec;
        String scheme = CoAP.getSchemeFromUri((String)this.uri);
        if (scheme == null) {
            if (this.authenticationModes == null || this.authenticationModes.isEmpty()) {
                this.uri = "coap://" + this.uri;
            } else {
                this.uri = "coaps://" + this.uri;
                this.secure = true;
            }
        } else {
            this.secure = CoAP.isSecureScheme((String)scheme);
            this.tcp = CoAP.isTcpScheme((String)scheme);
        }
        super.defaults();
        if (this.proxy == null && (proxySpec = StringUtil.getConfiguration((String)"COAP_PROXY")) != null && !proxySpec.isEmpty()) {
            try {
                this.proxy = (ProxyConfiguration)proxyReader.convert(proxySpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.uri.endsWith("/")) {
            this.uri = this.uri.substring(this.uri.length() - 1);
        }
        if (this.secure && !this.tcp && (this.authenticationModes.isEmpty() || this.authenticationModes.contains((Object)ConnectorConfig.AuthenticationMode.PSK) || this.authenticationModes.contains((Object)ConnectorConfig.AuthenticationMode.ECDHE_PSK)) && this.identity == null && this.secret == null) {
            this.identity = this.defaultIdentity;
            this.secret = new ConnectorConfig.Secret();
            this.secret.text = this.defaultSecret;
            if (this.authenticationModes.isEmpty()) {
                this.authenticationModes.add(ConnectorConfig.AuthenticationMode.PSK);
            }
        }
    }

    @Override
    protected void defaultAuthenticationModes() {
        if (this.tcp) {
            this.authenticationModes.add(ConnectorConfig.AuthenticationMode.X509);
        } else {
            super.defaultAuthenticationModes();
        }
    }

    public ClientBaseConfig create() {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            if (this.authentication != null) {
                clone.authentication = new ConnectorConfig.Authentication();
                clone.authentication.anonymous = this.authentication.anonymous;
                if (this.authentication.credentials != null) {
                    clone.authentication.credentials = this.authentication.credentials;
                }
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public ClientBaseConfig create(String id, byte[] secret) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.identity = id;
            clone.secretKey = secret;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public ClientBaseConfig create(PrivateKey privateKey, PublicKey publicKey) {
        ClientBaseConfig clone = null;
        try {
            clone = (ClientBaseConfig)this.clone();
            clone.authentication = new ConnectorConfig.Authentication();
            clone.authentication.credentials = new SslContextUtil.Credentials(privateKey, publicKey, null);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public void setDefaultPskCredentials(String identity, String secret) {
        this.defaultIdentity = identity;
        this.defaultSecret = secret;
    }

    public void setDefaultPskCredentials(String identity) {
        this.defaultIdentity = "cali." + identity;
        this.defaultSecret = null;
    }

    public static class ProxyConfiguration {
        public final String scheme;
        public final InetSocketAddress destination;

        public ProxyConfiguration(String scheme, InetSocketAddress destination) {
            if (destination == null) {
                throw new NullPointerException("proxy destination must not be null!");
            }
            this.scheme = scheme;
            this.destination = destination;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(StringUtil.toString((InetSocketAddress)this.destination));
            if (this.scheme != null) {
                builder.append(" using ").append(this.scheme);
            }
            return builder.toString();
        }
    }
}

