/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.service.api.OutputOptions;
import org.eclipse.birt.report.service.api.ReportServiceException;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.Page;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateContent;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public abstract class AbstractGetPageActionHandler
extends AbstractBaseActionHandler {
    protected ViewerAttributeBean __bean;
    protected String __docName;
    protected long __pageNumber;
    protected long __totalPageNumber;
    protected boolean __isCompleted = true;
    protected boolean __useBookmark = false;
    protected String __bookmark;
    protected boolean __svgFlag;
    protected ByteArrayOutputStream __page = null;
    protected ArrayList __activeIds = null;

    protected abstract String __getReportDocument();

    protected abstract void __checkDocumentExists() throws Exception;

    public AbstractGetPageActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void __execute() throws Exception {
        this.prepareParameters();
        this.doExecution();
        this.prepareResponse();
    }

    protected void prepareParameters() throws Exception, RemoteException {
        this.__bean = (ViewerAttributeBean)this.context.getBean();
        this.__docName = this.__getReportDocument();
        this.__checkDocumentExists();
        if (ParameterAccessor.isGetReportlet(this.context.getRequest())) {
            this.__totalPageNumber = 1L;
        } else {
            InputOptions getPageCountOptions = new InputOptions();
            getPageCountOptions.setOption("locale", this.__bean.getLocale());
            getPageCountOptions.setOption("timeZone", this.__bean.getTimeZone());
            getPageCountOptions.setOption("request", this.context.getRequest());
            OutputOptions outputOptions = new OutputOptions();
            this.__totalPageNumber = this.getReportService().getPageCount(this.__docName, getPageCountOptions, outputOptions);
            Boolean isCompleted = (Boolean)outputOptions.getOption("completed");
            if (isCompleted != null) {
                this.__isCompleted = isCompleted;
            }
        }
        this.__pageNumber = this.getPageNumber(this.context.getRequest(), this.operation.getOprand(), this.__docName);
        if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
            this.__bookmark = this.getBookmark(this.operation.getOprand(), this.__bean);
            if (this.__bookmark != null && this.__bookmark.length() > 0) {
                InputOptions options = new InputOptions();
                options.setOption("request", this.context.getRequest());
                options.setOption("locale", this.__bean.getLocale());
                if (this.isToc(this.operation.getOprand(), this.__bean)) {
                    this.__bookmark = this.getReportService().findTocByName(this.__docName, this.__bookmark, options);
                }
                this.__pageNumber = this.getReportService().getPageNumberByBookmark(this.__docName, this.__bookmark, options);
                if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
                    AxisFault fault = new AxisFault();
                    fault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.INVALID_BOOKMARK", new String[]{this.getBookmark(this.operation.getOprand(), this.__bean)}));
                    throw fault;
                }
                this.__useBookmark = true;
            }
        }
        if (!this.isValidPageNumber(this.context.getRequest(), this.__pageNumber, this.__docName)) {
            AxisFault fault = new AxisFault();
            fault.setFaultReason(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER", new Object[]{this.__pageNumber, this.__totalPageNumber}));
            throw fault;
        }
        this.__svgFlag = this.getSVGFlag(this.operation.getOprand());
    }

    protected void doExecution() throws ReportServiceException, RemoteException {
        InputOptions options = this.createInputOptions(this.__bean, this.__svgFlag);
        String docName = null;
        this.__activeIds = new ArrayList();
        if (ParameterAccessor.isGetReportlet(this.context.getRequest())) {
            ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
            assert (attrBean != null);
            docName = attrBean.getReportDocumentName();
            String __reportletId = attrBean.getReportletId();
            this.__page = this.getReportService().getReportlet(docName, __reportletId, options, this.__activeIds);
        } else {
            docName = this.__docName;
            this.__page = this.getReportService().getPage(docName, String.valueOf(this.__pageNumber), options, this.__activeIds);
        }
    }

    protected void prepareResponse() throws ReportServiceException, RemoteException {
        UpdateContent content = new UpdateContent();
        content.setContent(DataUtil.toUTF8(this.__page.toByteArray()));
        content.setTarget("Document");
        content.setInitializationId(this.parseReportId(this.__activeIds));
        if (this.__useBookmark) {
            content.setBookmark(this.__bookmark);
        }
        Update updateDocument = new Update();
        updateDocument.setUpdateContent(content);
        UpdateData updateData = new UpdateData();
        updateData.setTarget("navigationBar");
        Page pageObj = new Page();
        pageObj.setPageNumber(String.valueOf(this.__pageNumber));
        pageObj.setTotalPage(String.valueOf(this.__totalPageNumber));
        pageObj.setRtl(this.__bean.isReportRtl());
        Data pageData = new Data();
        pageData.setPage(pageObj);
        updateData.setData(pageData);
        Update updateNavbar = new Update();
        updateNavbar.setUpdateData(updateData);
        UpdateData updateDocumentData = new UpdateData();
        updateDocumentData.setTarget("birtReportDocument");
        updateDocumentData.setData(pageData);
        updateDocument.setUpdateData(updateDocumentData);
        this.response.setUpdate(new Update[]{updateDocument, updateNavbar});
    }

    @Override
    protected boolean isValidPageNumber(HttpServletRequest request, long pageNumber, String documentName) throws RemoteException, ReportServiceException {
        InputOptions options = new InputOptions();
        options.setOption("request", request);
        return pageNumber > 0L && pageNumber <= this.__totalPageNumber;
    }

    @Override
    protected long getPageNumber(HttpServletRequest request, Oprand[] params, String documentName) throws RemoteException, ReportServiceException {
        long pageNumber = -1L;
        if (params != null && params.length > 0) {
            int i = 0;
            while (i < params.length) {
                if ("__page".equalsIgnoreCase(params[i].getName())) {
                    try {
                        pageNumber = Integer.parseInt(params[i].getValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        AxisFault fault = new AxisFault();
                        fault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                        fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.PAGE_NUMBER_PARSE_ERROR", new Object[]{params[i].getValue()}));
                        throw fault;
                    }
                    if (pageNumber > 0L && pageNumber <= this.__totalPageNumber) break;
                    AxisFault fault = new AxisFault();
                    fault.setFaultCode(new QName("DocumentProcessor.getPageNumber( )"));
                    fault.setFaultString(BirtResources.getMessage("birt.viewer.actionException.INVALID_PAGE_NUMBER", new Object[]{pageNumber, this.__totalPageNumber}));
                    throw fault;
                }
                ++i;
            }
        }
        return pageNumber;
    }
}

