/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.context.BaseAttributeBean;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.engine.api.DataExtractionFormatInfo;
import org.eclipse.birt.report.engine.api.EmitterInfo;
import org.eclipse.birt.report.exception.ViewerException;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.session.IViewingSession;
import org.eclipse.birt.report.session.ViewingCache;
import org.eclipse.birt.report.session.ViewingSessionConfig;
import org.eclipse.birt.report.session.ViewingSessionUtil;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.filename.DefaultFilenameGenerator;
import org.eclipse.birt.report.utility.filename.IFilenameGenerator;
import org.eclipse.birt.report.utility.filename.IFilenameGeneratorFactory;

public class ParameterAccessor {
    public static final String PARAM_ID = "__id";
    public static final String PARAM_TITLE = "__title";
    public static final String PARAM_SHOW_TITLE = "__showtitle";
    public static final String PARAM_TOOLBAR = "__toolbar";
    public static final String PARAM_NAVIGATIONBAR = "__navigationbar";
    public static final String PARAM_PARAMETER_PAGE = "__parameterpage";
    public static final String PARAM_REPORT = "__report";
    public static final String PARAM_REPORT_DOCUMENT = "__document";
    public static final String PARAM_OUTPUT_DOCUMENT_NAME = "__outputDocName";
    public static final String PARAM_FORMAT = "__format";
    public static final String PARAM_EMITTER_ID = "__emitterid";
    public static final String PARAM_FORMAT_HTM = "htm";
    public static final String PARAM_FORMAT_HTML = "html";
    public static final String PARAM_FORMAT_PDF = "pdf";
    public static final String PARAM_LOCALE = "__locale";
    public static final String PARAM_TIMEZONE = "__timezone";
    public static final String PARAM_SVG = "__svg";
    public static final String PARAM_PAGE = "__page";
    public static final String PARAM_PAGE_RANGE = "__pagerange";
    public static final String PARAM_ISNULL = "__isnull";
    public static final String PARAM_ISNULLLIST = "__isnulllist";
    public static final String PARAM_ISLOCALE = "__islocale";
    public static final String PARAM_MASTERPAGE = "__masterpage";
    public static final String PARAM_DESIGNER = "__designer";
    public static final String PARAM_OVERWRITE = "__overwrite";
    public static final String PARAM_IMAGEID = "__imageid";
    public static final String PARAM_BOOKMARK = "__bookmark";
    public static final String PARAM_ISTOC = "__istoc";
    public static final String PARAM_RTL = "__rtl";
    public static final String PARAM_MAXROWS = "__maxrows";
    public static final String PARAM_CUBEMEMSIZE = "__cubememsize";
    public static final String PARAM_INSTANCEID = "__instanceid";
    public static final String PARAM_ISREPORTLET = "__isreportlet";
    public static final String PARAM_EXPORT_ENCODING = "__exportencoding";
    public static final String PARAM_PAGE_OVERFLOW = "__pageoverflow";
    public static final String PARAM_PAGEBREAK_ONLY = "__pagebreakonly";
    public static final String PREFIX_DISPLAY_TEXT = "__isdisplay__";
    public static final String PREFIX_ISLOCALE = "__islocale__";
    public static final String PARAM_RESOURCE_FOLDER = "__resourceFolder";
    public static final String PARAM_SERVLET_PATTERN = "__pattern";
    public static final String PARAM_TARGET = "__target";
    public static final String PARAM_NOCACHE_PARAMETER = "__nocache";
    public static final String PARAM_AS_ATTACHMENT = "__asattachment";
    public static final String PARAM_ACTION = "__action";
    public static final String PARAM_DPI = "__dpi";
    public static final String PARAM_AGENTSTYLE_ENGINE = "__agentstyle";
    public static final String HEADER_REQUEST_TYPE = "request-type";
    public static final String HEADER_REQUEST_TYPE_SOAP = "soap";
    public static final String PARAM_IID = "iid";
    public static final String PARAM_CLOSEWIN = "__closewin";
    public static final String PARAM_RESULTSETNAME = "__resultsetname";
    public static final String PARAM_SELECTEDCOLUMNNUMBER = "__selectedcolumnnumber";
    public static final String PARAM_SELECTEDCOLUMN = "__selectedcolumn";
    public static final String PARAM_APPCONTEXTNAME = "__appcontextname";
    public static final String PARAM_DATA_EXTRACT_FORMAT = "__extractformat";
    public static final String PARAM_DATA_EXTRACT_EXTENSION = "__extractextension";
    public static final String PARAM_ENCODED_PATHS = "__encodedPaths";
    public static final String INIT_PARAM_LOCALE = "BIRT_VIEWER_LOCALE";
    public static final String INIT_PARAM_TIMEZONE = "BIRT_VIEWER_TIMEZONE";
    public static final String INIT_PARAM_WORKING_DIR = "BIRT_VIEWER_WORKING_FOLDER";
    public static final String INIT_PARAM_IMAGE_DIR = "BIRT_VIEWER_IMAGE_DIR";
    public static final String INIT_PARAM_LOG_DIR = "BIRT_VIEWER_LOG_DIR";
    public static final String INIT_PARAM_LOG_LEVEL = "BIRT_VIEWER_LOG_LEVEL";
    public static final String INIT_PARAM_SCRIPTLIB_DIR = "BIRT_VIEWER_SCRIPTLIB_DIR";
    public static final String INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY = "WORKING_FOLDER_ACCESS_ONLY";
    public static final String INIT_PARAM_URL_REPORT_PATH_POLICY = "URL_REPORT_PATH_POLICY";
    public static final String INIT_PARAM_DOCUMENT_FOLDER = "BIRT_VIEWER_DOCUMENT_FOLDER";
    public static final String INIT_PARAM_BIRT_RESOURCE_PATH = "BIRT_RESOURCE_PATH";
    public static final String INIT_PARAM_VIEWER_MAXROWS = "BIRT_VIEWER_MAX_ROWS";
    public static final String INIT_PARAM_VIEWER_MAXCUBE_ROWLEVELS = "BIRT_VIEWER_MAX_CUBE_ROWLEVELS";
    public static final String INIT_PARAM_VIEWER_MAXCUBE_COLUMNLEVELS = "BIRT_VIEWER_MAX_CUBE_COLUMNLEVELS";
    public static final String INIT_PARAM_VIEWER_CUBEMEMSIZE = "BIRT_VIEWER_CUBE_MEMORY_SIZE";
    public static final String INIT_PARAM_OVERWRITE_DOCUMENT = "BIRT_OVERWRITE_DOCUMENT";
    public static final String INIT_PARAM_CONFIG_FILE = "BIRT_VIEWER_CONFIG_FILE";
    public static final String INIT_PARAM_PRINT_SERVERSIDE = "BIRT_VIEWER_PRINT_SERVERSIDE";
    public static final String INIT_PARAM_AGENTSTYLE_ENGINE = "HTML_ENABLE_AGENTSTYLE_ENGINE";
    public static final String INIT_PARAM_FILENAME_GENERATOR_CLASS = "BIRT_FILENAME_GENERATOR_CLASS";
    public static final String UTF_8_ENCODE = "UTF-8";
    public static final String ISO_8859_1_ENCODE = "ISO-8859-1";
    public static final String PARAMETER_SEPARATOR = "&";
    public static final String QUERY_CHAR = "?";
    public static final String EQUALS_OPERATOR = "=";
    public static String workingFolder = null;
    public static String logFolder = null;
    public static String logLevel = null;
    public static String scriptLibDir = null;
    public static int maxRows;
    public static int maxCubeRowLevels;
    public static int maxCubeColumnLevels;
    public static int cubeMemorySize;
    public static Locale webAppLocale;
    public static TimeZone webAppTimeZone;
    public static boolean isWorkingFolderAccessOnly;
    public static String birtResourceFolder;
    protected static boolean isInitContext;
    public static boolean isOverWrite;
    public static final String POLICY_ALL = "all";
    public static final String POLICY_DOMAIN = "domain";
    public static final String POLICY_NONE = "none";
    public static String urlReportPathPolicy;
    public static final String ATTR_APPCONTEXT_KEY = "AppContextKey";
    public static final String ATTR_APPCONTEXT_VALUE = "AppContextValue";
    public static final String ATTR_VIEWING_SESSION = "ViewingSession";
    public static Map initProps;
    public static Map loggers;
    public static final String PROP_BASE_URL = "base_url";
    public static final String PARAM_VIEWING_SESSION_ID = "__sessionId";
    public static String[] supportedFormats;
    public static DataExtractionFormatInfo[] supportedDataExtractions;
    public static Map supportedEmitters;
    public static boolean isSupportedPrintOnServer;
    public static boolean isAgentStyle;
    public static boolean isDesigner;
    public static IFilenameGenerator exportFilenameGenerator;

    public static String getBookmark(HttpServletRequest request) {
        int page = ParameterAccessor.getParameterAsInt(request, PARAM_PAGE);
        return page < 1 ? ParameterAccessor.getReportParameter(request, PARAM_BOOKMARK, null) : null;
    }

    public static boolean isToc(HttpServletRequest request) {
        boolean flag = false;
        String isToc = ParameterAccessor.getParameter(request, PARAM_ISTOC);
        if ("true".equalsIgnoreCase(isToc)) {
            flag = true;
        }
        return flag;
    }

    public static String getQueryParameterString(String paramName, String value) {
        StringBuffer b = new StringBuffer();
        b.append(PARAMETER_SEPARATOR);
        b.append(paramName);
        b.append(EQUALS_OPERATOR);
        b.append(value);
        return b.toString();
    }

    public static String getTitle(HttpServletRequest request) {
        String title = ParameterAccessor.getParameter(request, PARAM_TITLE);
        if (title == null) {
            title = BirtResources.getMessage("birt.viewer.title");
        }
        return ParameterAccessor.htmlEncode(title);
    }

    public static String getFormat(HttpServletRequest request) {
        String emitterId;
        boolean formatSpecified = false;
        String format = ParameterAccessor.getParameter(request, PARAM_FORMAT);
        if (format != null && format.length() > 0) {
            formatSpecified = true;
            if (PARAM_FORMAT_HTM.equalsIgnoreCase(format)) {
                format = PARAM_FORMAT_HTML;
            }
        } else {
            format = PARAM_FORMAT_HTML;
        }
        if ((emitterId = ParameterAccessor.getEmitterId(request)) != null && emitterId.length() > 0) {
            String emitterFormat = ParameterAccessor.getEmitterFormat(emitterId);
            if (emitterFormat != null) {
                format = emitterFormat;
            } else if (!formatSpecified) {
                format = null;
            }
        }
        return format;
    }

    public static String getEmitterId(HttpServletRequest request) {
        String emitterId = ParameterAccessor.getParameter(request, PARAM_EMITTER_ID);
        if (emitterId != null && emitterId.length() > 0) {
            return emitterId;
        }
        return null;
    }

    public static int getMaxRows(HttpServletRequest request) {
        return ParameterAccessor.getParameterAsInt(request, PARAM_MAXROWS);
    }

    public static int getCubeMemorySize(HttpServletRequest request) {
        int curMaxMemSize = ParameterAccessor.getParameterAsInt(request, PARAM_CUBEMEMSIZE);
        if (curMaxMemSize <= 0) {
            curMaxMemSize = cubeMemorySize;
        }
        return curMaxMemSize;
    }

    public static String getInstanceId(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_INSTANCEID);
    }

    public static TimeZone getTimeZone(HttpServletRequest request) {
        TimeZone timeZone = ParameterAccessor.getTimeZoneFromString(ParameterAccessor.getParameter(request, PARAM_TIMEZONE));
        if (timeZone == null) {
            timeZone = webAppTimeZone;
        }
        return timeZone;
    }

    public static TimeZone getTimeZoneFromString(String timeZoneString) {
        if (timeZoneString != null && !"".equals(timeZoneString = timeZoneString.trim())) {
            return TimeZone.getTimeZone(timeZoneString);
        }
        return null;
    }

    public static Locale getLocale(HttpServletRequest request) {
        Locale locale = null;
        locale = ParameterAccessor.getLocaleFromString(ParameterAccessor.getParameter(request, PARAM_LOCALE));
        if (locale == null) {
            locale = request.getLocale();
        }
        if (locale == null) {
            locale = webAppLocale;
        }
        return locale;
    }

    public static boolean isRtl(HttpServletRequest request) {
        boolean isRtl = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_RTL))) {
            isRtl = true;
        }
        return isRtl;
    }

    public static Locale getLocaleFromString(String locale) {
        if (locale == null || locale.length() <= 0) {
            return null;
        }
        int len = locale.length();
        if (len != 2 && len != 5 && len < 7) {
            return null;
        }
        char ch0 = locale.charAt(0);
        char ch1 = locale.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            return null;
        }
        if (len == 2) {
            return new Locale(locale, "");
        }
        if (locale.charAt(2) != '_') {
            return null;
        }
        char ch3 = locale.charAt(3);
        if (ch3 == '_') {
            return new Locale(locale.substring(0, 2), "", locale.substring(4));
        }
        char ch4 = locale.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            return null;
        }
        if (len == 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        if (locale.charAt(5) != '_') {
            return null;
        }
        return new Locale(locale.substring(0, 2), locale.substring(3, 5), locale.substring(6));
    }

    public static String getLocaleString(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_LOCALE);
    }

    public static int getPage(HttpServletRequest request) {
        int page = ParameterAccessor.getParameterAsInt(request, PARAM_PAGE);
        if (page > 0) {
            return page;
        }
        String servletPath = request.getServletPath();
        page = "/frameset".equalsIgnoreCase(servletPath) && PARAM_FORMAT_HTML.equalsIgnoreCase(ParameterAccessor.getFormat(request)) ? 1 : 0;
        return page;
    }

    public static String getPageRange(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_PAGE_RANGE);
    }

    public static String getReportletId(HttpServletRequest request) {
        if (ParameterAccessor.isIidReportlet(request)) {
            return ParameterAccessor.getParameter(request, PARAM_INSTANCEID);
        }
        if (ParameterAccessor.isBookmarkReportlet(request)) {
            return ParameterAccessor.getParameter(request, PARAM_BOOKMARK);
        }
        return null;
    }

    public static String getReport(HttpServletRequest request, String filePath) {
        if (filePath == null) {
            filePath = DataUtil.trimString(ParameterAccessor.getParameter(request, PARAM_REPORT));
        }
        filePath = ParameterAccessor.decodeFilePath(request, filePath);
        return ParameterAccessor.getRealPathOnWorkingFolder(filePath, request);
    }

    public static String getReportDocument(HttpServletRequest request, String filePath, boolean isCreate) throws ViewerException {
        if (filePath == null) {
            filePath = DataUtil.trimString(ParameterAccessor.getParameter(request, PARAM_REPORT_DOCUMENT));
        }
        if ((filePath = ParameterAccessor.decodeFilePath(request, filePath)).length() <= 0 && !isCreate) {
            return null;
        }
        if (filePath.length() <= 0) {
            IViewingSession session = ViewingSessionUtil.getSession(request);
            if (session == null) {
                throw new ViewerException(BirtResources.getMessage("birt.viewer.error.noviewingsession"));
            }
            return session.getCachedReportDocument(ParameterAccessor.getReport(request, null), null);
        }
        filePath = ParameterAccessor.getRealPathOnWorkingFolder(filePath, request);
        return filePath;
    }

    public static String getRealPathOnWorkingFolder(String filePath, HttpServletRequest request) {
        if (filePath == null || filePath.length() == 0) {
            return filePath;
        }
        if (ParameterAccessor.isUniversalPath(filePath)) {
            return filePath;
        }
        filePath = !ParameterAccessor.isUniversalPath(workingFolder) ? ParameterAccessor.getRealPath(workingFolder + "/" + filePath, request.getSession().getServletContext()) : workingFolder + "/" + filePath;
        return filePath;
    }

    public static String getReportParameter(HttpServletRequest request, String name, String defaultValue) {
        Set nullParams;
        Map paramMap;
        assert (request != null && name != null);
        String value = ParameterAccessor.getParameter(request, name);
        if (value == null || value.length() <= 0) {
            value = "";
        }
        if ((paramMap = request.getParameterMap()) == null || !paramMap.containsKey(name)) {
            value = defaultValue;
        }
        if ((nullParams = ParameterAccessor.getParameterValues(request, PARAM_ISNULL)) != null && nullParams.contains(name)) {
            value = null;
        }
        return value;
    }

    public static List getReportParameters(HttpServletRequest request, String paramName) {
        Set nullParams;
        assert (request != null && paramName != null);
        ArrayList<String> paramList = new ArrayList<String>();
        Set params = ParameterAccessor.getParameterValues(request, paramName);
        if (params != null) {
            for (String value : params) {
                if (value == null) continue;
                paramList.add(value);
            }
        }
        if ((nullParams = ParameterAccessor.getParameterValues(request, PARAM_ISNULL)) != null && nullParams.contains(paramName)) {
            paramList.add(null);
        }
        return paramList;
    }

    public static String getResultSetName(HttpServletRequest request) {
        return ParameterAccessor.getReportParameter(request, PARAM_RESULTSETNAME, null);
    }

    public static Collection getSelectedColumns(HttpServletRequest request) {
        ArrayList<String> columns = new ArrayList<String>();
        int columnCount = ParameterAccessor.getParameterAsInt(request, PARAM_SELECTEDCOLUMNNUMBER);
        for (int i = 0; i < columnCount; ++i) {
            String paramName = PARAM_SELECTEDCOLUMN + String.valueOf(i);
            String columnName = ParameterAccessor.getParameter(request, paramName);
            if (columnName == null || "".equals(columnName)) continue;
            columns.add(columnName);
        }
        return columns;
    }

    public static boolean getSVGFlag(HttpServletRequest request) {
        boolean svg = false;
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_SVG))) {
            svg = true;
        }
        return svg;
    }

    public static Locale getWebAppLocale() {
        return webAppLocale;
    }

    public static TimeZone getWebAppTimeZone() {
        return webAppTimeZone;
    }

    public static final String htmlHeaderValueEncode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("\\s", " ");
        return s;
    }

    public static final String htmlEncode(String s) {
        String sHtmlEncoded = "";
        if (s == null) {
            return null;
        }
        StringBuffer sbHtmlEncoded = new StringBuffer();
        char[] chrarry = s.toCharArray();
        int length = chrarry.length;
        block14: for (int i = 0; i < length; ++i) {
            char c = chrarry[i];
            switch (c) {
                case '\t': {
                    sbHtmlEncoded.append("&#09;");
                    continue block14;
                }
                case '\n': {
                    sbHtmlEncoded.append("<br>");
                    continue block14;
                }
                case '\r': {
                    sbHtmlEncoded.append("&#13;");
                    continue block14;
                }
                case ' ': {
                    sbHtmlEncoded.append("&#32;");
                    continue block14;
                }
                case '\"': {
                    sbHtmlEncoded.append("&#34;");
                    continue block14;
                }
                case '\'': {
                    sbHtmlEncoded.append("&#39;");
                    continue block14;
                }
                case '<': {
                    sbHtmlEncoded.append("&#60;");
                    continue block14;
                }
                case '>': {
                    sbHtmlEncoded.append("&#62;");
                    continue block14;
                }
                case '`': {
                    sbHtmlEncoded.append("&#96;");
                    continue block14;
                }
                case '&': {
                    sbHtmlEncoded.append("&#38;");
                    continue block14;
                }
                case '\\': {
                    sbHtmlEncoded.append("&#92;");
                    continue block14;
                }
                case '/': {
                    sbHtmlEncoded.append("&#47;");
                    continue block14;
                }
                default: {
                    if (c > '\ud7ff' && c < '\udc00' && i + 1 < length) {
                        char nc;
                        if ((nc = chrarry[++i]) > '\udbff' && nc < '\ue000') {
                            int rc = c - 55232 << 10 | nc & 0x3FF;
                            sbHtmlEncoded.append("&#").append(rc).append(';');
                            continue block14;
                        }
                        sbHtmlEncoded.append(c);
                        sbHtmlEncoded.append(nc);
                        continue block14;
                    }
                    sbHtmlEncoded.append(c);
                }
            }
        }
        sHtmlEncoded = sbHtmlEncoded.toString();
        return sHtmlEncoded;
    }

    public static final String htmlDecode(String s) {
        if (s == null) {
            return null;
        }
        String sHtmlDecoded = s.replaceAll("&#09;", "\t");
        sHtmlDecoded = sHtmlDecoded.replaceAll("<br>", "\n");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#13;", "\r");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#32;", " ");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#34;", "\"");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#39;", "'");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#60;", "<");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#62;", ">");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#96;", "`");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#38;", PARAMETER_SEPARATOR);
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#92;", "\\\\");
        sHtmlDecoded = sHtmlDecoded.replaceAll("&#47;", "/");
        return sHtmlDecoded;
    }

    public static synchronized void initParameters(ServletConfig config) {
        if (!isInitContext) {
            ParameterAccessor.initParameters(config.getServletContext());
        }
    }

    public static synchronized void initParameters(ServletContext context) {
        String exportFilenameGeneratorClassName;
        String s_overwrite;
        if (isInitContext) {
            return;
        }
        if ("true".equalsIgnoreCase(System.getProperty("birt.designer"))) {
            isDesigner = true;
        }
        String workingPath = "${birt.viewer.working.path}/";
        workingFolder = ParameterAccessor.processWorkingFolder(context, context.getInitParameter(INIT_PARAM_WORKING_DIR));
        String initDocumentFolder = context.getInitParameter(INIT_PARAM_DOCUMENT_FOLDER);
        if (isDesigner && initDocumentFolder == null) {
            initDocumentFolder = workingPath + "documents";
        }
        String documentFolder = ParameterAccessor.processRealPath(context, initDocumentFolder, "documents", true);
        String initImageFolder = context.getInitParameter(INIT_PARAM_IMAGE_DIR);
        if (isDesigner && initImageFolder == null) {
            initImageFolder = workingPath + "report/images";
        }
        String imageFolder = ParameterAccessor.processRealPath(context, initImageFolder, "report/images", true);
        String initLogFolder = context.getInitParameter(INIT_PARAM_LOG_DIR);
        if (isDesigner && initLogFolder == null) {
            initLogFolder = workingPath + "logs";
        }
        logFolder = ParameterAccessor.processRealPath(context, initLogFolder, "logs", true);
        logLevel = context.getInitParameter(INIT_PARAM_LOG_LEVEL);
        if (logLevel == null) {
            logLevel = "WARNING";
        }
        String rootPath = "${birt.viewer.root.path}/";
        String initScriptlibFolder = context.getInitParameter(INIT_PARAM_SCRIPTLIB_DIR);
        if (isDesigner && initScriptlibFolder == null) {
            initScriptlibFolder = rootPath + "scriptlib";
        }
        scriptLibDir = ParameterAccessor.processRealPath(context, initScriptlibFolder, "scriptlib", false);
        webAppLocale = ParameterAccessor.getLocaleFromString(context.getInitParameter(INIT_PARAM_LOCALE));
        if (webAppLocale == null) {
            webAppLocale = Locale.getDefault();
        }
        webAppTimeZone = ParameterAccessor.getTimeZoneFromString(context.getInitParameter(INIT_PARAM_TIMEZONE));
        isWorkingFolderAccessOnly = Boolean.valueOf(context.getInitParameter(INIT_PARAM_WORKING_FOLDER_ACCESS_ONLY));
        urlReportPathPolicy = context.getInitParameter(INIT_PARAM_URL_REPORT_PATH_POLICY);
        String s_maxRows = context.getInitParameter(INIT_PARAM_VIEWER_MAXROWS);
        try {
            maxRows = Integer.valueOf(s_maxRows);
        }
        catch (NumberFormatException e) {
            maxRows = -1;
        }
        String s_maxRowLevels = context.getInitParameter(INIT_PARAM_VIEWER_MAXCUBE_ROWLEVELS);
        try {
            maxCubeRowLevels = Integer.valueOf(s_maxRowLevels);
        }
        catch (NumberFormatException e) {
            maxCubeRowLevels = -1;
        }
        String s_maxColumnLevels = context.getInitParameter(INIT_PARAM_VIEWER_MAXCUBE_COLUMNLEVELS);
        try {
            maxCubeColumnLevels = Integer.valueOf(s_maxColumnLevels);
        }
        catch (NumberFormatException e) {
            maxCubeColumnLevels = -1;
        }
        String s_cubeMemSize = context.getInitParameter(INIT_PARAM_VIEWER_CUBEMEMSIZE);
        try {
            cubeMemorySize = Integer.valueOf(s_cubeMemSize);
        }
        catch (NumberFormatException e) {
            cubeMemorySize = 0;
        }
        String initResourceFolder = context.getInitParameter(INIT_PARAM_BIRT_RESOURCE_PATH);
        if (isDesigner && initResourceFolder == null) {
            initResourceFolder = "${birt.viewer.resource.path}";
        }
        birtResourceFolder = ParameterAccessor.processRealPath(context, initResourceFolder, null, false);
        isOverWrite = isDesigner ? true : "true".equalsIgnoreCase(s_overwrite = DataUtil.trimString(context.getInitParameter(INIT_PARAM_OVERWRITE_DOCUMENT)));
        initProps = ParameterAccessor.initViewerProps(context, initProps);
        if (loggers == null) {
            loggers = new HashMap();
        }
        Iterator i = initProps.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!name.startsWith("logger.")) continue;
            String loggerName = name.replaceFirst("logger.", "");
            String levelName = (String)initProps.get(name);
            loggers.put(loggerName, levelName);
            i.remove();
        }
        String flag = DataUtil.trimString(context.getInitParameter(INIT_PARAM_PRINT_SERVERSIDE));
        if ("ON".equalsIgnoreCase(flag)) {
            isSupportedPrintOnServer = true;
        } else if ("OFF".equalsIgnoreCase(flag)) {
            isSupportedPrintOnServer = false;
        }
        String s_agentstyle = context.getInitParameter(INIT_PARAM_AGENTSTYLE_ENGINE);
        if ("false".equalsIgnoreCase(s_agentstyle)) {
            isAgentStyle = false;
        }
        if ((exportFilenameGeneratorClassName = context.getInitParameter(INIT_PARAM_FILENAME_GENERATOR_CLASS)) != null) {
            Object generatorInstance = null;
            try {
                Class<?> generatorClass = Class.forName(exportFilenameGeneratorClassName);
                generatorInstance = generatorClass.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (generatorInstance != null) {
                if (generatorInstance instanceof IFilenameGeneratorFactory) {
                    exportFilenameGenerator = ((IFilenameGeneratorFactory)generatorInstance).createFilenameGenerator(context);
                } else if (generatorInstance instanceof IFilenameGenerator) {
                    exportFilenameGenerator = generatorInstance;
                }
            }
        }
        if (exportFilenameGenerator == null) {
            exportFilenameGenerator = new DefaultFilenameGenerator();
        }
        ParameterAccessor.initViewingSessionConfig(documentFolder, imageFolder);
        isInitContext = true;
    }

    private static void initViewingSessionConfig(String documentFolder, String imageFolder) {
        int maximumSessionCount;
        int minimumSessionCountThreshold;
        ViewingSessionUtil.viewingCache = new ViewingCache(documentFolder, imageFolder);
        ViewingSessionUtil.defaultConfig = new ViewingSessionConfig();
        long sessionTimeout = ParameterAccessor.getLongInitProp("viewer.session.timeout");
        if (sessionTimeout <= 0L) {
            sessionTimeout = 0L;
        }
        ViewingSessionUtil.defaultConfig.setSessionTimeout(sessionTimeout);
        float sessionCountThresholdFactor = ParameterAccessor.getFloatInitProp("viewer.session.loadFactor");
        if (sessionCountThresholdFactor >= 0.1f) {
            ViewingSessionUtil.defaultConfig.setSessionCountThresholdFactor(sessionCountThresholdFactor);
        }
        if ((minimumSessionCountThreshold = ParameterAccessor.getIntegerInitProp("viewer.session.minimumThreshold")) > 0) {
            ViewingSessionUtil.defaultConfig.setMinimumSessionCountThreshold(minimumSessionCountThreshold);
        }
        if ((maximumSessionCount = ParameterAccessor.getIntegerInitProp("viewer.session.maximumSessionCount")) >= 0) {
            ViewingSessionUtil.defaultConfig.setMaximumSessionCount(maximumSessionCount);
        }
        int maximumSessionCountPolicy = ParameterAccessor.getIntegerInitProp("viewer.session.maximumSessionCountPolicy");
        switch (maximumSessionCountPolicy) {
            case 0: {
                ViewingSessionUtil.defaultConfig.setMaxSessionCountPolicy(ViewingSessionConfig.ViewingSessionPolicy.SESSION_POLICY_DISCARD_NEW);
                break;
            }
            case 1: {
                ViewingSessionUtil.defaultConfig.setMaxSessionCountPolicy(ViewingSessionConfig.ViewingSessionPolicy.SESSION_POLICY_DISCARD_OLDEST);
            }
        }
    }

    public static boolean isDesigner() {
        return isDesigner;
    }

    public static boolean isGetImageOperator(HttpServletRequest request) {
        String imageName = ParameterAccessor.getParameter(request, PARAM_IMAGEID);
        return imageName != null && imageName.length() > 0;
    }

    public static boolean isServlet(HttpServletRequest request, String servlet) {
        return servlet.equalsIgnoreCase(request.getServletPath());
    }

    public static boolean isGetReportlet(HttpServletRequest request) {
        return ParameterAccessor.isBookmarkReportlet(request) || ParameterAccessor.isIidReportlet(request);
    }

    public static boolean isBookmarkReportlet(HttpServletRequest request) {
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_ISREPORTLET))) {
            String bookmark = ParameterAccessor.getParameter(request, PARAM_BOOKMARK);
            return bookmark != null && bookmark.length() > 0;
        }
        return false;
    }

    public static boolean isIidReportlet(HttpServletRequest request) {
        String instanceId = ParameterAccessor.getParameter(request, PARAM_INSTANCEID);
        return instanceId != null && instanceId.length() > 0;
    }

    public static boolean isMasterPageContent(HttpServletRequest request) {
        boolean isMasterPageContent = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_MASTERPAGE))) {
            isMasterPageContent = false;
        }
        return isMasterPageContent;
    }

    public static boolean isOverwrite(HttpServletRequest request) {
        boolean overwrite = isOverWrite;
        String urlParam = ParameterAccessor.getParameter(request, PARAM_OVERWRITE);
        if ("true".equalsIgnoreCase(urlParam)) {
            overwrite = true;
        } else if ("false".equalsIgnoreCase(urlParam)) {
            overwrite = false;
        }
        return overwrite;
    }

    public static boolean isRelativePath(String fileName) {
        if (fileName == null) {
            return false;
        }
        return !new File(fileName).isAbsolute();
    }

    public static boolean isUniversalPath(String fileName) {
        if (fileName == null) {
            return false;
        }
        File f = new File(fileName);
        if (f.isAbsolute()) {
            return true;
        }
        try {
            new URL(fileName);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }

    public static boolean isReportParameterExist(HttpServletRequest request, String name) {
        Set nullParams;
        assert (request != null && name != null);
        boolean isExist = false;
        Map paramMap = request.getParameterMap();
        if (paramMap != null) {
            isExist = paramMap.containsKey(name);
        }
        if ((nullParams = ParameterAccessor.getParameterValues(request, PARAM_ISNULL)) != null && nullParams.contains(name)) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isValidFilePath(HttpServletRequest request, String filePath) {
        block10: {
            File f;
            if (filePath == null) {
                return false;
            }
            if (!POLICY_ALL.equalsIgnoreCase(urlReportPathPolicy) && !(f = new File(filePath)).isAbsolute()) {
                try {
                    URL url = new URL(filePath);
                    if (POLICY_DOMAIN.equalsIgnoreCase(urlReportPathPolicy)) {
                        String dm = request.getServerName();
                        if (!dm.equals(url.getHost())) {
                            return false;
                        }
                        break block10;
                    }
                    return false;
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
        }
        if (isWorkingFolderAccessOnly) {
            File docFile = new File(filePath);
            if (!docFile.isAbsolute()) {
                return filePath.indexOf("..") == -1;
            }
            File docFolder = new File(workingFolder);
            if (docFolder.isAbsolute()) {
                String absolutePath = docFile.getAbsolutePath();
                String docFolderPath = docFolder.getAbsolutePath();
                if (ParameterAccessor.isWindowsPlatform()) {
                    absolutePath = absolutePath.toLowerCase();
                    docFolderPath = docFolderPath.toLowerCase();
                }
                return absolutePath.startsWith(docFolderPath);
            }
            return false;
        }
        return true;
    }

    public static String getParameter(HttpServletRequest request, String parameterName) {
        if (request.getCharacterEncoding() == null) {
            try {
                request.setCharacterEncoding(UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return request.getParameter(parameterName);
    }

    protected static int getParameterAsInt(HttpServletRequest request, String parameterName) {
        int iValue = -1;
        String value = ParameterAccessor.getParameter(request, parameterName);
        if (value != null && value.length() > 0) {
            try {
                iValue = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                iValue = -1;
            }
        }
        return iValue;
    }

    public static Set getParameterValues(HttpServletRequest request, String parameterName) {
        LinkedHashSet<String> parameterValues = null;
        String[] parameterValuesArray = request.getParameterValues(parameterName);
        if (parameterValuesArray != null) {
            parameterValues = new LinkedHashSet<String>();
            for (int i = 0; i < parameterValuesArray.length; ++i) {
                parameterValues.add(parameterValuesArray[i]);
            }
        }
        return parameterValues;
    }

    public static String urlEncode(String s, String format) {
        String encodedString = s;
        if (s != null) {
            try {
                encodedString = URLEncoder.encode(s, format);
            }
            catch (UnsupportedEncodingException e) {
                encodedString = s;
            }
        }
        return encodedString;
    }

    public static String encodeBase64(String fileName) {
        if (fileName != null) {
            try {
                byte[] decodedBytes = fileName.getBytes(UTF_8_ENCODE);
                byte[] encodedBytes = Base64.encodeBase64((byte[])decodedBytes);
                return new String(encodedBytes, UTF_8_ENCODE);
            }
            catch (UnsupportedEncodingException e) {
                return fileName;
            }
        }
        return null;
    }

    public static String decodeBase64(String string) {
        try {
            byte[] encodedBytes = string.getBytes(UTF_8_ENCODE);
            byte[] decodedBytes = Base64.decodeBase64((byte[])encodedBytes);
            return new String(decodedBytes, UTF_8_ENCODE);
        }
        catch (UnsupportedEncodingException e) {
            return string;
        }
    }

    public static String decodeFilePath(HttpServletRequest request, String filePath) {
        if (filePath == null) {
            return null;
        }
        if (ParameterAccessor.isEncodedPaths(request)) {
            return ParameterAccessor.decodeBase64(filePath);
        }
        return filePath;
    }

    public static String getConfigFileName(String reportDesignName) {
        if (reportDesignName == null) {
            return null;
        }
        String[] result = reportDesignName.split("\\.");
        String extensionName = result[result.length - 1];
        String configFileName = reportDesignName.substring(0, reportDesignName.length() - extensionName.length()) + "rptconfig";
        return configFileName;
    }

    public static String getFormat(HttpServletRequest request, String paramName) {
        if (request == null || paramName == null) {
            return null;
        }
        return ParameterAccessor.getParameter(request, paramName + "_format");
    }

    public static boolean isWorkingFolderAccessOnly() {
        return isWorkingFolderAccessOnly;
    }

    public static String getUrlReportPathPolicy() {
        return urlReportPathPolicy;
    }

    public static String isDisplayText(String paramName) {
        if (paramName == null) {
            return null;
        }
        if (paramName.startsWith(PREFIX_DISPLAY_TEXT)) {
            return paramName.replaceFirst(PREFIX_DISPLAY_TEXT, "");
        }
        return null;
    }

    public static IFilenameGenerator getFilenameGenerator() {
        return exportFilenameGenerator;
    }

    public static void reset() {
        isInitContext = false;
    }

    public static boolean isWindowsPlatform() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    }

    public static String getResourceFolder(HttpServletRequest request) {
        String resourceFolder = ParameterAccessor.getParameter(request, PARAM_RESOURCE_FOLDER);
        if ((resourceFolder = ParameterAccessor.decodeFilePath(request, resourceFolder)) == null || resourceFolder.trim().length() <= 0) {
            resourceFolder = birtResourceFolder;
        }
        return resourceFolder;
    }

    public static Map pushAppContext(Map map, HttpServletRequest request) {
        String appContextKey;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if ((appContextKey = (String)request.getAttribute(ATTR_APPCONTEXT_KEY)) != null) {
            map.put(appContextKey, request.getAttribute(ATTR_APPCONTEXT_VALUE));
        } else {
            HttpSession session = request.getSession(false);
            if (session != null && (appContextKey = (String)session.getAttribute(ATTR_APPCONTEXT_KEY)) != null) {
                map.put(appContextKey, session.getAttribute(ATTR_APPCONTEXT_VALUE));
            }
        }
        return map;
    }

    public static String getExportEncoding(HttpServletRequest request) {
        String encoding = ParameterAccessor.getParameter(request, PARAM_EXPORT_ENCODING);
        if (encoding == null) {
            encoding = UTF_8_ENCODE;
        }
        return encoding;
    }

    public static boolean isShowTitle(HttpServletRequest request) {
        boolean isTitle = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_SHOW_TITLE))) {
            isTitle = false;
        }
        return isTitle;
    }

    public static boolean isShowToolbar(HttpServletRequest request) {
        boolean isToolbar = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_TOOLBAR))) {
            isToolbar = false;
        }
        return isToolbar;
    }

    public static boolean isShowNavigationbar(HttpServletRequest request) {
        boolean isNavigationbar = true;
        if ("false".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_NAVIGATIONBAR))) {
            isNavigationbar = false;
        }
        return isNavigationbar;
    }

    public static String getShowParameterPage(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_PARAMETER_PAGE);
    }

    public static synchronized Map initViewerProps(ServletContext context, Map props) {
        String file;
        if (props == null) {
            props = new HashMap<String, String>();
        }
        if ((file = context.getInitParameter(INIT_PARAM_CONFIG_FILE)) == null || file.trim().length() <= 0) {
            file = "WEB-INF/viewer.properties";
        }
        try {
            InputStream is = null;
            if (ParameterAccessor.isRelativePath(file)) {
                if (!file.startsWith("/")) {
                    file = "/" + file;
                }
                is = context.getResourceAsStream(file);
            } else {
                is = new FileInputStream(file);
            }
            PropertyResourceBundle bundle = new PropertyResourceBundle(is);
            if (bundle != null) {
                Enumeration<String> keys = bundle.getKeys();
                while (keys != null && keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    String value = (String)bundle.getObject(key);
                    if (key == null || value == null) continue;
                    props.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public static String getInitProp(String key) {
        if (initProps == null || key == null) {
            return null;
        }
        return (String)initProps.get(key);
    }

    public static int getIntegerInitProp(String key) {
        String value = ParameterAccessor.getInitProp(key);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long getLongInitProp(String key) {
        String value = ParameterAccessor.getInitProp(key);
        if (value == null) {
            return 0L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float getFloatInitProp(String key) {
        String value = ParameterAccessor.getInitProp(key);
        if (value == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static String getExtensionName(String format) {
        if (format == null) {
            return null;
        }
        String key = "viewer.extension." + format.replaceAll(" ", "_");
        return DataUtil.trimString(ParameterAccessor.getInitProp(key));
    }

    public static String getOutputFormatLabel(String format) {
        if (format == null) {
            return null;
        }
        String key = "viewer.label." + format.replaceAll(" ", "_");
        String label = DataUtil.trimString(ParameterAccessor.getInitProp(key));
        if (label.length() <= 0) {
            label = format;
        }
        return label;
    }

    public static String getBaseURL() {
        String baseURL = ParameterAccessor.getInitProp(PROP_BASE_URL);
        if (baseURL != null && baseURL.length() > 0 && baseURL.endsWith("/")) {
            baseURL = baseURL.substring(0, baseURL.length() - 1);
        }
        return baseURL;
    }

    protected static String convertSystemPath(String path) {
        if (path == null) {
            return path;
        }
        Pattern p = Pattern.compile("\\$\\s*\\{([^\\}]*)\\}\\s*(.*)", 2);
        Matcher m = p.matcher(path);
        if (m.find()) {
            String sysPath = DataUtil.trimSepEnd(System.getProperty(m.group(1).trim()));
            if (sysPath.length() <= 0) {
                return DataUtil.trimSepFirst(m.group(2).trim());
            }
            return sysPath + m.group(2).trim();
        }
        return path;
    }

    public static String processWorkingFolder(ServletContext context, String path) {
        path = ParameterAccessor.convertSystemPath(DataUtil.trimString(path));
        String realPath = null;
        realPath = ParameterAccessor.isRelativePath(path) ? ParameterAccessor.getRealPath(path, context) : path;
        ParameterAccessor.makeDir(realPath);
        return DataUtil.trimSepEnd(realPath);
    }

    private static String processRealPath(ServletContext context, String path, String defaultPath, boolean canWrite) {
        String realPath = null;
        boolean isRelative = false;
        if ((path = ParameterAccessor.convertSystemPath(path)) == null || path.trim().length() <= 0) {
            path = DataUtil.trimString(defaultPath);
        }
        if (ParameterAccessor.isRelativePath(path)) {
            isRelative = true;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            realPath = DataUtil.trimSepEnd(ParameterAccessor.getRealPath(path, context));
        } else {
            realPath = DataUtil.trimSepEnd(path);
        }
        boolean flag = ParameterAccessor.makeDir(realPath);
        if (!canWrite) {
            return realPath;
        }
        if (flag) {
            try {
                if (canWrite && new File(realPath).canWrite()) {
                    return realPath;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isRelative) {
            realPath = DataUtil.trimSepEnd(System.getProperty("java.io.tmpdir")) + path;
        } else if (defaultPath != null) {
            realPath = DataUtil.trimSepEnd(System.getProperty("java.io.tmpdir")) + File.separator + defaultPath;
        }
        ParameterAccessor.makeDir(realPath);
        return realPath;
    }

    private static String getRealPath(String path, ServletContext context) {
        assert (path != null);
        String realPath = null;
        try {
            String orginalPath = path;
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if ((realPath = context.getRealPath(path)) == null) {
                String rootPath = System.getProperty("birt.viewer.root.path");
                if (rootPath != null && ParameterAccessor.isUniversalPath(rootPath)) {
                    path = path.substring(1);
                    realPath = DataUtil.trimSepEnd(rootPath) + "/" + path;
                } else {
                    URL url = context.getResource("/");
                    if (url != null) {
                        String urlRoot = null;
                        urlRoot = "file".equalsIgnoreCase(url.getProtocol()) ? DataUtil.trimString(url.getPath()) : DataUtil.trimString(url.toExternalForm());
                        realPath = orginalPath.startsWith(urlRoot) ? orginalPath : (urlRoot.endsWith("/") || orginalPath.startsWith("/") ? urlRoot + orginalPath : urlRoot + "/" + orginalPath);
                    }
                }
            }
        }
        catch (Exception e) {
            realPath = path;
        }
        return realPath;
    }

    private static boolean makeDir(String path) {
        assert (path != null);
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static int getPageOverflow(HttpServletRequest request) {
        int pageOverflow = ParameterAccessor.getParameterAsInt(request, PARAM_PAGE_OVERFLOW);
        if (pageOverflow < 0) {
            pageOverflow = 0;
        }
        return pageOverflow;
    }

    public static boolean isPagebreakOnly(HttpServletRequest request) {
        String pagebreakOnly = ParameterAccessor.getParameter(request, PARAM_PAGEBREAK_ONLY);
        return !"false".equalsIgnoreCase(pagebreakOnly);
    }

    public static String getOpenType(HttpServletRequest request) {
        if ("true".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_AS_ATTACHMENT))) {
            return "attachment";
        }
        return "inline";
    }

    public static boolean isOpenAsAttachment(HttpServletRequest request) {
        return "true".equalsIgnoreCase(ParameterAccessor.getParameter(request, PARAM_AS_ATTACHMENT));
    }

    public static String getAction(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_ACTION);
    }

    public static Number getDpi(HttpServletRequest request) {
        String dpi = ParameterAccessor.getParameter(request, PARAM_DPI);
        if (dpi == null || dpi.trim().length() <= 0) {
            return null;
        }
        return Integer.valueOf(dpi);
    }

    public static boolean isAgentStyle(HttpServletRequest request) {
        boolean flag = isAgentStyle;
        String urlParam = ParameterAccessor.getParameter(request, PARAM_AGENTSTYLE_ENGINE);
        if ("true".equalsIgnoreCase(urlParam)) {
            flag = true;
        } else if ("false".equalsIgnoreCase(urlParam)) {
            flag = false;
        }
        return flag;
    }

    public static boolean isPDFLayout(String format) {
        if (format == null) {
            return false;
        }
        return PARAM_FORMAT_PDF.equalsIgnoreCase(format) || "postscript".equalsIgnoreCase(format) || "ppt".equalsIgnoreCase(format);
    }

    public static boolean isCloseWindow(HttpServletRequest request) {
        String isCloseWin = ParameterAccessor.getParameter(request, PARAM_CLOSEWIN);
        return "true".equalsIgnoreCase(isCloseWin);
    }

    public static boolean isEncodedPaths(HttpServletRequest request) {
        String encodedPaths = ParameterAccessor.getParameter(request, PARAM_ENCODED_PATHS);
        return "true".equalsIgnoreCase(encodedPaths);
    }

    public static String getAppContextName(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_APPCONTEXTNAME);
    }

    public static String getExtractFormat(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_DATA_EXTRACT_FORMAT);
    }

    public static String getExtractExtension(HttpServletRequest request) {
        return ParameterAccessor.getParameter(request, PARAM_DATA_EXTRACT_EXTENSION);
    }

    public static Map<String, String> getParameterAsMap(HttpServletRequest request) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = ParameterAccessor.getParameter(request, name);
            map.put(name, value);
        }
        if (ParameterAccessor.isEncodedPaths(request)) {
            if (map.containsKey(PARAM_RESOURCE_FOLDER)) {
                map.put(PARAM_RESOURCE_FOLDER, ParameterAccessor.decodeBase64((String)map.get(PARAM_RESOURCE_FOLDER)));
            }
            if (map.containsKey(PARAM_REPORT)) {
                map.put(PARAM_REPORT, ParameterAccessor.decodeBase64((String)map.get(PARAM_REPORT)));
            }
            if (map.containsKey(PARAM_REPORT_DOCUMENT)) {
                map.put(PARAM_REPORT_DOCUMENT, ParameterAccessor.decodeBase64((String)map.get(PARAM_REPORT_DOCUMENT)));
            }
        }
        return map;
    }

    public static String getEmitterMimeType(String emitterId) {
        EmitterInfo emitterInfo;
        if (emitterId != null && (emitterInfo = ParameterAccessor.getEmitterInfo(emitterId)) != null) {
            return emitterInfo.getMimeType();
        }
        return null;
    }

    public static EmitterInfo getEmitterInfo(String emitterId) {
        return (EmitterInfo)supportedEmitters.get(emitterId);
    }

    public static String getEmitterFormat(String emitterId) {
        EmitterInfo emitterInfo = ParameterAccessor.getEmitterInfo(emitterId);
        if (emitterInfo != null) {
            return emitterInfo.getFormat();
        }
        return null;
    }

    public static String getExtractionMIMEType(String extractFormat, String extractExtension) {
        String mimeType;
        block3: {
            block4: {
                if (supportedDataExtractions.length <= 0) {
                    return null;
                }
                mimeType = null;
                if (extractExtension == null) break block4;
                for (int i = 0; i < supportedDataExtractions.length; ++i) {
                    DataExtractionFormatInfo info = supportedDataExtractions[i];
                    if (info == null || !extractExtension.equals(info.getId())) continue;
                    mimeType = info.getMimeType();
                    break block3;
                }
                break block3;
            }
            if (extractFormat == null) break block3;
            for (int i = 0; i < supportedDataExtractions.length; ++i) {
                DataExtractionFormatInfo info = supportedDataExtractions[i];
                if (info == null || !extractFormat.equals(info.getFormat())) continue;
                mimeType = info.getMimeType();
                break;
            }
        }
        return mimeType;
    }

    public static String getExtractFormat(String extractExtension) {
        if (supportedDataExtractions.length <= 0) {
            return null;
        }
        String extractFormat = null;
        for (int i = 0; i < supportedDataExtractions.length; ++i) {
            DataExtractionFormatInfo info = supportedDataExtractions[i];
            if (info == null || !extractExtension.equals(info.getId())) continue;
            extractFormat = info.getFormat();
            break;
        }
        return extractFormat;
    }

    public static boolean validateExtractFormat(String extractFormat) {
        if (supportedDataExtractions.length <= 0 || extractFormat == null) {
            return false;
        }
        for (int i = 0; i < supportedDataExtractions.length; ++i) {
            DataExtractionFormatInfo info = supportedDataExtractions[i];
            if (info == null || !extractFormat.equals(info.getFormat())) continue;
            return true;
        }
        return false;
    }

    public static boolean validateExtractExtension(String extractExtension) {
        if (supportedDataExtractions.length <= 0 || extractExtension == null) {
            return false;
        }
        for (int i = 0; i < supportedDataExtractions.length; ++i) {
            DataExtractionFormatInfo info = supportedDataExtractions[i];
            if (info == null || !extractExtension.equals(info.getId())) continue;
            return true;
        }
        return false;
    }

    public static Map makeFilenameGeneratorOptions(IContext context) {
        HttpServletRequest request = context.getRequest();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("servletContext", request.getSession().getServletContext());
        options.put("httpRequest", request);
        BaseAttributeBean attrBean = context.getBean();
        options.put("viewerAttributesBean", attrBean);
        if (attrBean != null) {
            String reportDesignName = attrBean.getReportDesignName();
            String reportDocumentName = attrBean.getReportDocumentName();
            if (reportDesignName != null) {
                File reportDesign = new File(reportDesignName);
                options.put("reportDesign", reportDesign.getName());
            }
            if (reportDocumentName != null) {
                File reportDocument = new File(reportDocumentName);
                options.put("reportDocument", reportDocument.getName());
            }
        }
        return options;
    }

    public static String getExportFilename(IContext context, String format, String emitterId) {
        String baseName;
        String extensionName;
        EmitterInfo emitterInfo;
        IFilenameGenerator gen = ParameterAccessor.getFilenameGenerator();
        Map options = ParameterAccessor.makeFilenameGeneratorOptions(context);
        if (emitterId != null && (emitterInfo = ParameterAccessor.getEmitterInfo(emitterId)) != null) {
            options.put("emitterInfo", emitterInfo);
        }
        if ((extensionName = ParameterAccessor.getExtensionName(format)) != null) {
            options.put("targetFileExtension", extensionName);
        }
        if ((baseName = (String)options.get("reportDesign")) == null || baseName.length() == 0) {
            baseName = (String)options.get("reportDocument");
        }
        baseName = ParameterAccessor.stripFileExtension(baseName);
        return gen.getFilename(baseName, extensionName, "export", options);
    }

    public static String getExtractionFilename(IContext context, String extractExtension, String extractFormat) {
        IFilenameGenerator gen = ParameterAccessor.getFilenameGenerator();
        Map options = ParameterAccessor.makeFilenameGeneratorOptions(context);
        if (extractFormat != null) {
            options.put("targetFileExtension", extractFormat);
        }
        if (extractExtension != null) {
            options.put("extractionExtension", extractExtension);
        }
        String baseName = ParameterAccessor.stripFileExtension((String)options.get("reportDocument"));
        return gen.getFilename(baseName, extractFormat, "dataExtraction", options);
    }

    public static String getGeneratedReportDocumentName(IContext context) {
        IFilenameGenerator gen = ParameterAccessor.getFilenameGenerator();
        Map options = ParameterAccessor.makeFilenameGeneratorOptions(context);
        String baseName = ParameterAccessor.stripFileExtension((String)options.get("reportDesign"));
        return gen.getFilename(baseName, "rptdocument", "reportDocument", options);
    }

    public static String stripFileExtension(String baseName) {
        String fileName = baseName;
        if (baseName == null || baseName.trim().length() <= 0) {
            return fileName;
        }
        int dotIndex = baseName.lastIndexOf(46);
        if (dotIndex > 0) {
            fileName = baseName.substring(0, dotIndex);
        }
        return fileName;
    }

    public static String[] sortSupportedFormatsByDisplayName(String[] values) {
        Arrays.sort(values, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (ParameterAccessor.getOutputFormatLabel(o1) != null) {
                    return ParameterAccessor.getOutputFormatLabel(o1).compareToIgnoreCase(ParameterAccessor.getOutputFormatLabel(o2));
                }
                return o1.compareToIgnoreCase(o2);
            }
        });
        return values;
    }

    static {
        webAppLocale = null;
        webAppTimeZone = null;
        isWorkingFolderAccessOnly = false;
        birtResourceFolder = null;
        isInitContext = false;
        urlReportPathPolicy = POLICY_DOMAIN;
        supportedFormats = new String[]{PARAM_FORMAT_HTML, PARAM_FORMAT_PDF};
        supportedDataExtractions = new DataExtractionFormatInfo[0];
        supportedEmitters = null;
        isSupportedPrintOnServer = true;
        isAgentStyle = true;
        isDesigner = false;
        exportFilenameGenerator = null;
    }
}

