/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.service.actionhandler;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.service.ParameterDataTypeConverter;
import org.eclipse.birt.report.service.actionhandler.AbstractBaseActionHandler;
import org.eclipse.birt.report.service.api.IViewerReportService;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.soapengine.api.Data;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.api.Oprand;
import org.eclipse.birt.report.soapengine.api.Update;
import org.eclipse.birt.report.soapengine.api.UpdateData;
import org.eclipse.birt.report.utility.DataUtil;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class BirtCacheParameterActionHandler
extends AbstractBaseActionHandler {
    private int index = 0;
    private Map map = new HashMap();

    public BirtCacheParameterActionHandler(IContext context, Operation operation, GetUpdatedObjectsResponse response) {
        super(context, operation, response);
    }

    @Override
    protected void __execute() throws Exception {
        ParameterDefinition parameter;
        String paramName;
        ViewerAttributeBean attrBean = (ViewerAttributeBean)this.context.getBean();
        assert (attrBean != null);
        String reportDesignName = attrBean.getReportDesignName();
        String configFileName = ParameterAccessor.getConfigFileName(reportDesignName);
        if (configFileName == null) {
            this.handleUpdate();
            return;
        }
        SessionHandle sessionHandle = new DesignEngine(null).newSessionHandle(ULocale.US);
        File configFile = new File(configFileName);
        if (configFile != null && configFile.exists() && configFile.isFile()) {
            configFile.delete();
        }
        ModuleOption options = new ModuleOption();
        options.setProperty("blankCreation", (Object)Boolean.TRUE);
        ReportDesignHandle handle = sessionHandle.createDesign(configFileName, options);
        String displayTextParam = null;
        ArrayList<String> locs = new ArrayList<String>();
        HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
        Oprand[] op = this.operation.getOprand();
        if (op != null) {
            for (int i = 0; i < op.length; ++i) {
                ConfigVariable configVar = new ConfigVariable();
                paramName = op[i].getName();
                String paramValue = op[i].getValue();
                if (paramName == null || paramValue == null) continue;
                if (paramName.equalsIgnoreCase("__islocale")) {
                    locs.add(paramValue);
                    continue;
                }
                if (paramName.equalsIgnoreCase("__isnull")) {
                    parameter = attrBean.findParameterDefinition(paramValue);
                    if (parameter == null) continue;
                    configVar.setName(this.getConfigName("__isnull_" + parameter.getId()));
                    configVar.setValue(paramValue + "_" + parameter.getId());
                    handle.addConfigVariable(configVar);
                    this.updateParameterInfo(handle, parameter);
                    continue;
                }
                displayTextParam = ParameterAccessor.isDisplayText(paramName);
                if (displayTextParam != null) {
                    parameter = attrBean.findParameterDefinition(displayTextParam);
                    if (parameter == null) continue;
                    configVar.setName(this.getConfigName(paramName + "_" + parameter.getId()));
                    configVar.setValue(paramValue);
                    handle.addConfigVariable(configVar);
                    continue;
                }
                ArrayList<String> list = (ArrayList<String>)params.get(paramName);
                if (list == null) {
                    list = new ArrayList<String>();
                    params.put(paramName, list);
                }
                list.add(paramValue);
            }
        }
        for (Map.Entry entry : params.entrySet()) {
            paramName = (String)entry.getKey();
            List paramValues = (List)entry.getValue();
            parameter = attrBean.findParameterDefinition(paramName);
            if (parameter == null) continue;
            String pattern = parameter.getPattern();
            String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
            boolean isLocale = locs.contains(paramName);
            if (parameter.isMultiValue()) {
                for (int i = 0; i < paramValues.size(); ++i) {
                    String paramValue = null;
                    try {
                        Object paramValueObj = DataUtil.validate(dataType, pattern, (String)paramValues.get(i), attrBean.getLocale(), attrBean.getTimeZone(), isLocale);
                        paramValue = DataUtil.getDisplayValue(paramValueObj, attrBean.getTimeZone());
                    }
                    catch (Exception err) {
                        paramValue = (String)paramValues.get(i);
                    }
                    if (paramValue == null) continue;
                    ConfigVariable configVar = new ConfigVariable();
                    configVar.setName(this.getConfigName(paramName + "_" + parameter.getId()));
                    configVar.setValue(paramValue);
                    handle.addConfigVariable(configVar);
                }
            } else {
                String paramValue = null;
                try {
                    Object paramValueObj = DataUtil.validate(dataType, pattern, (String)paramValues.get(0), attrBean.getLocale(), attrBean.getTimeZone(), isLocale);
                    paramValue = DataUtil.getDisplayValue(paramValueObj, attrBean.getTimeZone());
                }
                catch (Exception err) {
                    paramValue = (String)paramValues.get(0);
                }
                if (paramValue != null) {
                    ConfigVariable configVar = new ConfigVariable();
                    configVar.setName(this.getConfigName(paramName + "_" + parameter.getId()));
                    configVar.setValue(paramValue);
                    handle.addConfigVariable(configVar);
                }
            }
            this.updateParameterInfo(handle, parameter);
        }
        handle.save();
        handle.close();
        this.handleUpdate();
    }

    private void updateParameterInfo(ReportDesignHandle handle, ParameterDefinition parameter) throws Exception {
        assert (handle != null);
        assert (parameter != null);
        String paramName = parameter.getName();
        if (this.map.containsKey(paramName)) {
            return;
        }
        String dataType = ParameterDataTypeConverter.convertDataType(parameter.getDataType());
        ConfigVariable typeVar = new ConfigVariable();
        typeVar.setName(paramName + "_" + parameter.getId() + "_" + "type" + "_");
        typeVar.setValue(dataType);
        handle.addConfigVariable(typeVar);
        if (parameter.getValueExpr() != null) {
            ConfigVariable exprVar = new ConfigVariable();
            exprVar.setName(paramName + "_" + parameter.getId() + "_" + "expr" + "_");
            exprVar.setValue(parameter.getValueExpr());
            handle.addConfigVariable(exprVar);
        }
        this.map.put(paramName, true);
    }

    protected void handleUpdate() {
        Data data = new Data();
        data.setConfirmation("Parameter value saved.");
        UpdateData updateData = new UpdateData();
        updateData.setTarget("birtParameterDialog");
        updateData.setData(data);
        Update update = new Update();
        update.setUpdateData(updateData);
        this.response.setUpdate(new Update[]{update});
    }

    protected String getConfigName(String name) {
        return name + "_" + this.index++;
    }

    @Override
    protected IViewerReportService getReportService() {
        return null;
    }
}

