/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.presentation.aggregation.parameter;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.report.context.ParameterGroupBean;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.BirtBaseFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.CheckboxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ComboBoxParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.HiddenParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.RadioButtonParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.ScalarParameterFragment;
import org.eclipse.birt.report.presentation.aggregation.parameter.TextBoxParameterFragment;
import org.eclipse.birt.report.service.api.ParameterDefinition;
import org.eclipse.birt.report.service.api.ParameterGroupDefinition;
import org.eclipse.birt.report.utility.ParameterAccessor;

public class ParameterGroupFragment
extends BirtBaseFragment {
    protected ParameterGroupDefinition parameterGroup = null;

    public ParameterGroupFragment(ParameterGroupDefinition parameterGroup) {
        this.parameterGroup = parameterGroup;
    }

    @Override
    protected void doService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ViewerAttributeBean attrBean = (ViewerAttributeBean)request.getAttribute("attributeBean");
        assert (attrBean != null);
        assert (this.parameterGroup != null);
        ParameterGroupBean parameterGroupBean = new ParameterGroupBean(this.parameterGroup);
        attrBean.setParameterBean(parameterGroupBean);
        String displayName = this.parameterGroup.getPromptText();
        displayName = displayName == null || displayName.length() <= 0 ? this.parameterGroup.getDisplayName() : displayName;
        displayName = ParameterAccessor.htmlEncode(displayName);
        parameterGroupBean.setDisplayName(displayName);
        ArrayList<HiddenParameterFragment> fragments = new ArrayList<HiddenParameterFragment>();
        ScalarParameterFragment fragment = null;
        for (Object obj : this.parameterGroup.getParameters()) {
            if (!(obj instanceof ParameterDefinition)) continue;
            ParameterDefinition scalarParameter = (ParameterDefinition)obj;
            if (!scalarParameter.isHidden()) {
                switch (scalarParameter.getControlType()) {
                    case 0: {
                        fragment = new TextBoxParameterFragment(scalarParameter);
                        break;
                    }
                    case 1: {
                        fragment = new ComboBoxParameterFragment(scalarParameter);
                        break;
                    }
                    case 2: {
                        fragment = new RadioButtonParameterFragment(scalarParameter);
                        break;
                    }
                    case 3: {
                        fragment = new CheckboxParameterFragment(scalarParameter);
                    }
                }
            } else {
                fragment = new HiddenParameterFragment(scalarParameter);
            }
            if (fragment == null) continue;
            fragment.setJSPRootPath(this.JSPRootPath);
            fragments.add((HiddenParameterFragment)fragment);
        }
        request.setAttribute("fragments", fragments);
    }

    @Override
    protected String doPostService(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String className = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        return this.JSPRootPath + "/pages/parameter/" + className + ".jsp";
    }
}

