/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import com.ibm.icu.text.Bidi;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLEmitterConfig;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IAction;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.IHTMLImageHandler;
import org.eclipse.birt.report.engine.api.IImage;
import org.eclipse.birt.report.engine.api.IMetadataFilter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.impl.Action;
import org.eclipse.birt.report.engine.api.impl.Image;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IElement;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.IHyperlinkAction;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLPerformanceOptimize;
import org.eclipse.birt.report.engine.emitter.html.HTMLVisionOptimize;
import org.eclipse.birt.report.engine.emitter.html.IDGenerator;
import org.eclipse.birt.report.engine.emitter.html.MetadataEmitter;
import org.eclipse.birt.report.engine.emitter.html.MetadataFilter;
import org.eclipse.birt.report.engine.emitter.html.TableLayout;
import org.eclipse.birt.report.engine.emitter.html.util.DiagonalLineImage;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.css.HTMLProcessor;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.parser.TextParser;
import org.eclipse.birt.report.engine.presentation.ContentEmitterVisitor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSValue;

public class HTMLReportEmitter
extends ContentEmitterAdapter {
    public static final String BIRT_ROOT = "__BIRT_ROOT";
    protected boolean hasCsslinks = false;
    public static final String OUTPUT_FORMAT_HTML = "html";
    public static final String REPORT_FILE = "report.html";
    public static final String IMAGE_FOLDER = "image";
    public static final String EXTENSION_HTML_CLIENT_SCRIPTS = "html.clientScripts";
    protected OutputStream out = null;
    protected IReportContent report;
    protected IReportRunnable runnable;
    protected IRenderOption renderOption;
    protected boolean outputMasterPageContent = true;
    protected boolean isEmbeddable = false;
    protected String urlEncoding = null;
    protected boolean htmlRtLFlag = false;
    protected boolean pageFooterFloatFlag = true;
    protected boolean enableMetadata = false;
    protected List ouputInstanceIDs = null;
    protected int pageNo = 0;
    protected HTMLWriter writer;
    protected IReportContext reportContext;
    protected Stack stack = new Stack();
    HashMap<Long, String> diagonalCellImageMap = new HashMap();
    protected static Logger logger = Logger.getLogger(HTMLReportEmitter.class.getName());
    protected IHTMLImageHandler imageHandler;
    protected IHTMLActionHandler actionHandler;
    protected IEmitterServices services;
    protected static final int DISPLAY_BLOCK = 1;
    protected static final int DISPLAY_INLINE = 2;
    protected static final int DISPLAY_INLINE_BLOCK = 4;
    protected static final int DISPLAY_NONE = 8;
    protected static final int DISPLAY_FLAG_ALL = 65535;
    protected ContentEmitterVisitor contentVisitor;
    protected MetadataEmitter metadataEmitter;
    protected IDGenerator idGenerator = new IDGenerator();
    private String layoutPreference;
    private boolean fixedReport = false;
    private boolean enableAgentStyleEngine;
    private boolean outputMasterPageMargins;
    private IMetadataFilter metadataFilter = null;
    private boolean needOutputBackgroundSize = false;
    private boolean enableInlineStyle = false;
    protected String htmlIDNamespace;
    protected int browserVersion;
    protected boolean browserSupportsInlineBlock = true;
    protected int imageDpi = -1;
    protected HTMLEmitter htmlEmitter;
    protected Stack tableDIVWrapedFlagStack = new Stack();
    protected Stack<DimensionType> fixedRowHeightStack = new Stack();
    private Set outputtedStyles = new HashSet();
    protected boolean needFixTransparentPNG = false;
    private ITableContent cachedStartTable = null;
    protected TableLayout tableLayout = new TableLayout(this);
    protected Stack startedGroups = new Stack();

    public HTMLReportEmitter() {
        this.contentVisitor = new ContentEmitterVisitor(this);
    }

    @Override
    public void initialize(IEmitterServices services) throws EngineException {
        Object ac;
        Object im;
        this.services = services;
        this.out = EmitterUtil.getOuputStream(services, REPORT_FILE);
        Object emitterConfig = services.getEmitterConfig().get(OUTPUT_FORMAT_HTML);
        if (emitterConfig != null && emitterConfig instanceof HTMLEmitterConfig) {
            this.imageHandler = ((HTMLEmitterConfig)emitterConfig).getImageHandler();
            this.actionHandler = ((HTMLEmitterConfig)emitterConfig).getActionHandler();
        }
        if ((im = services.getOption("imageHandler")) != null && im instanceof IHTMLImageHandler) {
            this.imageHandler = (IHTMLImageHandler)im;
        }
        if ((ac = services.getOption("actionHandler")) != null && ac instanceof IHTMLActionHandler) {
            this.actionHandler = (IHTMLActionHandler)ac;
        }
        this.reportContext = services.getReportContext();
        this.renderOption = services.getRenderOption();
        this.runnable = services.getReportRunnable();
        this.writer = this.creatWriter();
        if (this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            this.isEmbeddable = htmlOption.getEmbeddable();
            Map options = this.renderOption.getOutputSetting();
            if (options != null) {
                this.urlEncoding = (String)options.get("url-encoding");
            }
            this.outputMasterPageContent = htmlOption.getMasterPageContent();
            IHTMLActionHandler actHandler = htmlOption.getActionHandle();
            if (ac != null) {
                this.actionHandler = actHandler;
            }
            this.pageFooterFloatFlag = htmlOption.getPageFooterFloatFlag();
            this.enableMetadata = htmlOption.getEnableMetadata();
            if (this.enableMetadata) {
                this.metadataFilter = htmlOption.getMetadataFilter();
                if (this.metadataFilter == null) {
                    this.metadataFilter = new MetadataFilter();
                }
            }
            this.writer.setEnableCompactMode(htmlOption.isEnableCompactMode());
            this.ouputInstanceIDs = htmlOption.getInstanceIDs();
            this.metadataEmitter = this.creatMetadataEmitter(this.writer, htmlOption);
            this.layoutPreference = htmlOption.getLayoutPreference();
            this.enableAgentStyleEngine = htmlOption.getEnableAgentStyleEngine();
            this.outputMasterPageMargins = htmlOption.getOutputMasterPageMargins();
            this.htmlIDNamespace = htmlOption.getHTMLIDNamespace();
            if (this.htmlIDNamespace != null) {
                if (this.htmlIDNamespace.length() > 0) {
                    this.htmlIDNamespace = String.valueOf(this.htmlIDNamespace) + "_";
                    this.metadataEmitter.setHTMLIDNamespace(this.htmlIDNamespace);
                } else {
                    this.htmlIDNamespace = null;
                }
            }
            this.writer.setIndent(htmlOption.getHTMLIndent());
            if (this.isEmbeddable) {
                this.enableInlineStyle = htmlOption.getEnableInlineStyle();
            }
            this.browserVersion = HTMLEmitterUtil.getBrowserVersion(htmlOption.getUserAgent());
            if (this.browserVersion == HTMLEmitterUtil.BROWSER_IE5 || this.browserVersion == HTMLEmitterUtil.BROWSER_IE6) {
                this.needFixTransparentPNG = true;
                this.browserSupportsInlineBlock = false;
            } else if (this.browserVersion == HTMLEmitterUtil.BROWSER_IE7 || this.browserVersion == HTMLEmitterUtil.BROWSER_FIREFOX1 || this.browserVersion == HTMLEmitterUtil.BROWSER_FIREFOX2) {
                this.browserSupportsInlineBlock = false;
            }
        }
    }

    protected HTMLWriter creatWriter() {
        return new HTMLWriter();
    }

    protected MetadataEmitter creatMetadataEmitter(HTMLWriter writer, HTMLRenderOption htmlOption) {
        return new MetadataEmitter(writer, htmlOption, null, this.idGenerator, this);
    }

    public IReportContent getReport() {
        return this.report;
    }

    @Override
    public String getOutputFormat() {
        return OUTPUT_FORMAT_HTML;
    }

    protected void fixTransparentPNG() {
        this.writer.writeCode("<!--[if (gte IE 5.5000)&(lt IE 7)]>");
        this.writer.writeCode("   <script  type=\"text/javascript\">");
        this.writer.writeCode("    //<![CDATA");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("      var ie55up = true;");
        } else {
            this.writer.writeCode("      var " + this.htmlIDNamespace + "ie55up = true;");
        }
        this.writer.writeCode("    //]]>");
        this.writer.writeCode("   </script>");
        this.writer.writeCode("<![endif]-->");
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("   function fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or IE 6.");
            this.writer.writeCode("      {");
            this.writer.writeCode("       if ( window.ie55up )");
        } else {
            this.writer.writeCode("   function " + this.htmlIDNamespace + "fixPNG(myImage) // correctly handle PNG transparency in Win IE 5.5 or higher.");
            this.writer.writeCode("      {");
            this.writer.writeCode("       if ( window." + this.htmlIDNamespace + "ie55up )");
        }
        this.writer.writeCode("          {");
        this.writer.writeCode("           var imgID = (myImage.id) ? \"id='\" + myImage.id + \"' \" : \"\";");
        this.writer.writeCode("           var imgClass = (myImage.className) ? \"class='\" + myImage.className + \"' \" : \"\";");
        this.writer.writeCode("           var imgTitle = (myImage.title) ? \"title='\" + myImage.title + \"' \" : \"title='\" + myImage.alt + \"' \";");
        this.writer.writeCode("           var imgStyle = \"display:inline-block;\" + myImage.style.cssText;");
        this.writer.writeCode("           var strNewHTML = \"<span \" + imgID + imgClass + imgTitle;");
        this.writer.writeCode("           strNewHTML += \" style=\\\"\" + \"width:\" + myImage.width + \"px; height:\" + myImage.height + \"px;\" + imgStyle + \";\";");
        this.writer.writeCode("           strNewHTML += \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\";");
        this.writer.writeCode("           strNewHTML += \"(src=\\'\" + myImage.src + \"\\', sizingMethod='scale');\\\"></span>\";");
        this.writer.writeCode("           myImage.outerHTML = strNewHTML;");
        this.writer.writeCode("          }");
        this.writer.writeCode("      }");
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    protected void fixRedirect() {
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        if (this.htmlIDNamespace == null) {
            this.writer.writeCode("   function redirect(target, url){");
        } else {
            this.writer.writeCode("   function " + this.htmlIDNamespace + "redirect(target, url){");
        }
        this.writer.writeCode("       if (target =='_blank'){");
        this.writer.writeCode("           open(url);");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_top'){");
        this.writer.writeCode("           window.top.location.href=url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_parent'){");
        this.writer.writeCode("           location.href=url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else if (target == '_self'){");
        this.writer.writeCode("           location.href =url;");
        this.writer.writeCode("       }");
        this.writer.writeCode("       else{");
        this.writer.writeCode("           open(url);");
        this.writer.writeCode("       }");
        this.writer.writeCode("      }");
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    private void loadBirtJs(String birtJsUrl) {
        this.writer.writeCode("<script type=\"text/javascript\" src=\"" + birtJsUrl + "\" >");
        this.writer.writeCode("</script>");
    }

    private void outputBirtJs() {
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        this.writer.writeCode("(function(a,w){function f(a){p[p.length]=a}function m(a){q.className=q.className.replace(RegExp(\"\\\\\\\\b\"+a+\"\\\\b\"),\"\")}function k(a,d){for(var b=0,c=a.length;b<c;b++)d.call(a,a[b],b)}function s(){q.className=q.className.replace(/ (w-|eq-|gt-|gte-|lt-|lte-|portrait|no-portrait|landscape|no-landscape)\\d+/g,\"\");var b=a.innerWidth||q.clientWidth,d=a.outerWidth||a.screen.width;h.screen.innerWidth=b;h.screen.outerWidth=d;f(\"w-\"+b);k(c.screens,function(a){b>a?(c.screensCss.gt&&f(\"gt-\"+a),c.screensCss.gte&&f(\"gte-\"+");
        this.writer.writeCode("a)):b<a?(c.screensCss.lt&&f(\"lt-\"+a),c.screensCss.lte&&f(\"lte-\"+a)):b===a&&(c.screensCss.lte&&f(\"lte-\"+a),c.screensCss.eq&&f(\"e-q\"+a),c.screensCss.gte&&f(\"gte-\"+a))});var d=a.innerHeight||q.clientHeight,g=a.outerHeight||a.screen.height;h.screen.innerHeight=d;h.screen.outerHeight=g;h.feature(\"portrait\",d>b);h.feature(\"landscape\",d<b)}function r(){a.clearTimeout(u);u=a.setTimeout(s,100)}var n=a.document,g=a.navigator,t=a.location,q=n.documentElement,p=[],c={screens:[240,320,480,640,768,800,1024,1280,");
        this.writer.writeCode("1440,1680,1920],screensCss:{gt:!0,gte:!1,lt:!0,lte:!1,eq:!1},browsers:[{ie:{min:6,max:10}}],browserCss:{gt:!0,gte:!1,lt:!0,lte:!1,eq:!0},section:\"-section\",page:\"-page\",head:\"head\"};if(a.head_conf)for(var b in a.head_conf)a.head_conf[b]!==w&&(c[b]=a.head_conf[b]);var h=a[c.head]=function(){h.ready.apply(null,arguments)};h.feature=function(a,b,c){if(!a)return q.className+=\" \"+p.join(\" \"),p=[],h;\"[object Function]\"===Object.prototype.toString.call(b)&&(b=b.call());f((b?\"\":\"no-\")+a);h[a]=!!b;c||(m(\"no-\"+");
        this.writer.writeCode("a),m(a),h.feature());return h};h.feature(\"js\",!0);b=g.userAgent.toLowerCase();g=/mobile|midp/.test(b);h.feature(\"mobile\",g,!0);h.feature(\"desktop\",!g,!0);b=/(chrome|firefox)[ \\/]([\\w.]+)/.exec(b)||/(iphone|ipad|ipod)(?:.*version)?[ \\/]([\\w.]+)/.exec(b)||/(android)(?:.*version)?[ \\/]([\\w.]+)/.exec(b)||/(webkit|opera)(?:.*version)?[ \\/]([\\w.]+)/.exec(b)||/(msie) ([\\w.]+)/.exec(b)||[];g=b[1];b=parseFloat(b[2]);switch(g){case \"msie\":g=\"ie\";b=n.documentMode||b;break;case \"firefox\":g=\"ff\";break;case \"ipod\":case \"ipad\":case \"iphone\":g=");
        this.writer.writeCode("\"ios\";break;case \"webkit\":g=\"safari\"}h.browser={name:g,version:b};h.browser[g]=!0;for(var v=0,x=c.browsers.length;v<x;v++)for(var i in c.browsers[v])if(g===i){f(i);for(var A=c.browsers[v][i].max,l=c.browsers[v][i].min;l<=A;l++)b>l?(c.browserCss.gt&&f(\"gt-\"+i+l),c.browserCss.gte&&f(\"gte-\"+i+l)):b<l?(c.browserCss.lt&&f(\"lt-\"+i+l),c.browserCss.lte&&f(\"lte-\"+i+l)):b===l&&(c.browserCss.lte&&f(\"lte-\"+i+l),c.browserCss.eq&&f(\"eq-\"+i+l),c.browserCss.gte&&f(\"gte-\"+i+l))}else f(\"no-\"+i);\"ie\"===g&&9>b&&k(\"abbr article aside audio canvas details figcaption figure footer header hgroup mark meter nav output progress section summary time video\".split(\" \"),");
        this.writer.writeCode("function(a){n.createElement(a)});k(t.pathname.split(\"/\"),function(a,b){if(2<this.length&&this[b+1]!==w)b&&f(this.slice(1,b+1).join(\"-\").toLowerCase()+c.section);else{var g=a||\"index\",h=g.indexOf(\".\");0<h&&(g=g.substring(0,h));q.id=g.toLowerCase()+c.page;b||f(\"root\"+c.section)}});h.screen={height:a.screen.height,width:a.screen.width};s();var u=0;a.addEventListener?a.addEventListener(\"resize\",r,!1):a.attachEvent(\"onresize\",r)})(window);");
        this.writer.writeCode("(function(a,w){function f(a){var f=a.charAt(0).toUpperCase()+a.substr(1),a=(a+\" \"+r.join(f+\" \")+f).split(\" \"),c;a:{for(c in a)if(k[a[c]]!==w){c=!0;break a}c=!1}return!!c}var m=a.document.createElement(\"i\"),k=m.style,s=\" -o- -moz- -ms- -webkit- -khtml- \".split(\" \"),r=[\"Webkit\",\"Moz\",\"O\",\"ms\",\"Khtml\"],n=a[a.head_conf&&a.head_conf.head||\"head\"],g={gradient:function(){k.cssText=(\"background-image:\"+s.join(\"gradient(linear,left top,right bottom,from(#9f9),to(#fff));background-image:\")+s.join(\"linear-gradient(left top,#eee,#fff);background-image:\")).slice(0,");
        this.writer.writeCode("-17);return!!k.backgroundImage},rgba:function(){k.cssText=\"background-color:rgba(0,0,0,0.5)\";return!!k.backgroundColor},opacity:function(){return\"\"===m.style.opacity},textshadow:function(){return\"\"===k.textShadow},multiplebgs:function(){k.cssText=\"background:url(//:),url(//:),red url(//:)\";return/(url\\s*\\(.*?){3}/.test(k.background)},boxshadow:function(){return f(\"boxShadow\")},borderimage:function(){return f(\"borderImage\")},borderradius:function(){return f(\"borderRadius\")},cssreflections:function(){return f(\"boxReflect\")},");
        this.writer.writeCode("csstransforms:function(){return f(\"transform\")},csstransitions:function(){return f(\"transition\")},touch:function(){return\"ontouchstart\"in a},retina:function(){return 1<a.devicePixelRatio},fontface:function(){var a=n.browser.version;switch(n.browser.name){case \"ie\":return 9<=a;case \"chrome\":return 13<=a;case \"ff\":return 6<=a;case \"ios\":return 5<=a;case \"android\":return!1;case \"webkit\":return 5.1<=a;case \"opera\":return 10<=a;default:return!1}}},t;for(t in g)g[t]&&n.feature(t,g[t].call(),!0);n.feature()})(window);");
        this.writer.writeCode("(function(a,w){function f(){}function m(j,a){if(j){\"object\"===typeof j&&(j=[].slice.call(j));for(var b=0,c=j.length;b<c;b++)a.call(j,j[b],b)}}function k(a,b){var e=Object.prototype.toString.call(b).slice(8,-1);return b!==w&&null!==b&&e===a}function s(a){return k(\"Function\",a)}function r(a){a=a||f;a._done||(a(),a._done=1)}function n(a){var b={};if(\"object\"===typeof a)for(var e in a)a[e]&&(b={name:e,url:a[e]});else b=a.split(\"/\"),b=b[b.length-1],e=b.indexOf(\"?\"),b={name:-1!==e?b.substring(0,e):b,url:a};");
        this.writer.writeCode("return(a=i[b.name])&&a.url===b.url?a:i[b.name]=b}function g(a){var a=a||i,b;for(b in a)if(a.hasOwnProperty(b)&&a[b].state!==y)return!1;return!0}function t(a,b){b=b||f;a.state===y?b():a.state===D?d.ready(a.name,b):a.state===C?a.onpreload.push(function(){t(a,b)}):(a.state=D,q(a,function(){a.state=y;b();m(x[a.name],function(a){r(a)});u&&g()&&m(x.ALL,function(a){r(a)})}))}function q(j,c){var c=c||f,e;/\\.css[^\\.]*$/.test(j.url)?(e=b.createElement(\"link\"),e.type=\"text/\"+(j.type||\"css\"),e.rel=\"stylesheet\",");
        this.writer.writeCode("e.href=j.url):(e=b.createElement(\"script\"),e.type=\"text/\"+(j.type||\"javascript\"),e.src=j.url);e.onload=e.onreadystatechange=function(j){j=j||a.event;if(\"load\"===j.type||/loaded|complete/.test(e.readyState)&&(!b.documentMode||9>b.documentMode))e.onload=e.onreadystatechange=e.onerror=null,c()};e.onerror=function(){e.onload=e.onreadystatechange=e.onerror=null;c()};e.async=!1;e.defer=!1;var d=b.head||b.getElementsByTagName(\"head\")[0];d.insertBefore(e,d.lastChild)}function p(){b.body?u||(u=!0,m(h,function(a){r(a)})):");
        this.writer.writeCode("(a.clearTimeout(d.readyTimeout),d.readyTimeout=a.setTimeout(p,50))}function c(){b.addEventListener?(b.removeEventListener(\"DOMContentLoaded\",c,!1),p()):\"complete\"===b.readyState&&(b.detachEvent(\"onreadystatechange\",c),p())}var b=a.document,h=[],v=[],x={},i={},A=\"async\"in b.createElement(\"script\")||\"MozAppearance\"in b.documentElement.style||a.opera,l,u,B=a.head_conf&&a.head_conf.head||\"head\",d=a[B]=a[B]||function(){d.ready.apply(null,arguments)},C=1,D=3,y=4;d.load=A?function(){var a=arguments,b=a[a.length-");
        this.writer.writeCode("1],e={};s(b)||(b=null);m(a,function(c,d){c!==b&&(c=n(c),e[c.name]=c,t(c,b&&d===a.length-2?function(){g(e)&&r(b)}:null))});return d}:function(){var a=arguments,b=[].slice.call(a,1),c=b[0];if(!l)return v.push(function(){d.load.apply(null,a)}),d;c?(m(b,function(a){if(!s(a)){var b=n(a);b.state===w&&(b.state=C,b.onpreload=[],q({url:b.url,type:\"cache\"},function(){b.state=2;m(b.onpreload,function(a){a.call()})}))}}),t(n(a[0]),s(c)?c:function(){d.load.apply(null,b)})):t(n(a[0]));return d};d.js=d.load;d.test=");
        this.writer.writeCode("function(a,b,c,g){a=\"object\"===typeof a?a:{test:a,success:b?k(\"Array\",b)?b:[b]:!1,failure:c?k(\"Array\",c)?c:[c]:!1,callback:g||f};(b=!!a.test)&&a.success?(a.success.push(a.callback),d.load.apply(null,a.success)):!b&&a.failure?(a.failure.push(a.callback),d.load.apply(null,a.failure)):g();return d};d.ready=function(a,c){if(a===b)return u?r(c):h.push(c),d;s(a)&&(c=a,a=\"ALL\");if(\"string\"!==typeof a||!s(c))return d;var e=i[a];if(e&&e.state===y||\"ALL\"===a&&g()&&u)return r(c),d;(e=x[a])?e.push(c):x[a]=[c];");
        this.writer.writeCode("return d};d.ready(b,function(){g()&&m(x.ALL,function(a){r(a)});d.feature&&d.feature(\"domloaded\",!0)});if(\"complete\"===b.readyState)p();else if(b.addEventListener)b.addEventListener(\"DOMContentLoaded\",c,!1),a.addEventListener(\"load\",p,!1);else{b.attachEvent(\"onreadystatechange\",c);a.attachEvent(\"onload\",p);var z=!1;try{z=null==a.frameElement&&b.documentElement}catch(F){}z&&z.doScroll&&function E(){if(!u){try{z.doScroll(\"left\")}catch(b){a.clearTimeout(d.readyTimeout);d.readyTimeout=a.setTimeout(E,50);");
        this.writer.writeCode("return}p()}}()}setTimeout(function(){l=!0;m(v,function(a){a()})},300)})(window);");
        this.writer.writeCode("birt={loader:head};");
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    private void doClientInitialize(String javaScriptLibraries) {
        this.writer.writeCode("<script type=\"text/javascript\">");
        this.writer.writeCode(" //<![CDATA[");
        this.writer.writeCode(javaScriptLibraries);
        this.writer.writeCode(" //]]>");
        this.writer.writeCode("</script>");
    }

    @Override
    public void start(IReportContent report) {
        String defaultStyleName;
        String viewport;
        boolean needCloseTag;
        logger.log(Level.FINEST, "[HTMLReportEmitter] Start emitter.");
        this.report = report;
        this.writer.open(this.out, "UTF-8");
        ReportDesignHandle designHandle = null;
        Report reportDesign = null;
        if (report != null) {
            Object tmp;
            reportDesign = report.getDesign();
            designHandle = reportDesign.getReportDesign();
            Map appContext = this.reportContext.getAppContext();
            if (appContext != null && (tmp = appContext.get("CHART_RESOLUTION")) != null && tmp instanceof Number) {
                this.imageDpi = ((Number)tmp).intValue();
            }
            if (this.imageDpi <= 0) {
                this.imageDpi = designHandle.getImageDPI();
            }
            if (this.imageDpi <= 0) {
                this.imageDpi = 96;
            }
        }
        this.retrieveRtLFlag();
        if (this.layoutPreference == null) {
            if (designHandle != null) {
                String reportLayoutPreference = designHandle.getLayoutPreference();
                if ("fixed layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "fixed";
                    this.fixedReport = true;
                } else if ("auto layout".equals(reportLayoutPreference)) {
                    this.layoutPreference = "auto";
                    this.fixedReport = false;
                }
            }
        } else {
            this.fixedReport = "fixed".equals(this.layoutPreference);
        }
        this.htmlEmitter = this.enableAgentStyleEngine ? new HTMLPerformanceOptimize(this, this.writer, this.fixedReport, this.enableInlineStyle, this.browserVersion) : new HTMLVisionOptimize(this, this.writer, this.fixedReport, this.enableInlineStyle, this.htmlRtLFlag, this.browserVersion);
        if (this.isEmbeddable) {
            String defaultStyleName2;
            this.outputCSSStyles(reportDesign, designHandle);
            if (this.needFixTransparentPNG) {
                this.fixTransparentPNG();
            }
            this.fixRedirect();
            this.openRootTag();
            this.writeBidiFlag();
            if (report != null && (defaultStyleName2 = report.getDesign().getRootStyleName()) != null) {
                if (this.enableInlineStyle) {
                    StringBuffer defaultStyleBuffer = new StringBuffer();
                    IStyle defaultStyle = report.findStyle(defaultStyleName2);
                    this.htmlEmitter.buildDefaultStyle(defaultStyleBuffer, defaultStyle);
                    if (defaultStyleBuffer.length() > 0) {
                        this.writer.attribute("style", defaultStyleBuffer.toString());
                    }
                } else if (this.htmlIDNamespace != null) {
                    this.writer.attribute("class", String.valueOf(this.htmlIDNamespace) + defaultStyleName2);
                } else {
                    this.writer.attribute("class", defaultStyleName2);
                }
            }
            this.outputDIVTitle(report);
            this.outputClientScript(report);
            return;
        }
        this.openRootTag();
        this.writeBidiFlag();
        this.writer.openTag("head");
        this.outputReportTitle(report);
        this.writer.openTag("meta");
        this.writer.attribute("http-equiv", "Content-Type");
        this.writer.attribute("content", this.getContentType());
        boolean bl = needCloseTag = !OUTPUT_FORMAT_HTML.equals(this.getOutputFormat());
        if (needCloseTag) {
            this.writer.closeTag("meta");
        }
        if ((viewport = new HTMLRenderOption(this.renderOption).getViewportMeta()) != null) {
            this.writer.openTag("meta");
            this.writer.attribute("name", "viewport");
            this.writer.attribute("content", viewport);
            if (needCloseTag) {
                this.writer.closeTag("meta");
            }
        }
        this.outputCSSStyles(reportDesign, designHandle);
        if (this.needFixTransparentPNG) {
            this.fixTransparentPNG();
        }
        this.fixRedirect();
        String clientInitialize = null;
        if (report != null) {
            clientInitialize = report.getDesign().getReportDesign().getClientInitialize();
        }
        if (!StringUtil.isBlank(clientInitialize)) {
            String birtJsUrl = new HTMLRenderOption(this.renderOption).getBirtJsUrl();
            if (!StringUtil.isBlank(birtJsUrl)) {
                this.loadBirtJs(birtJsUrl);
            } else {
                this.outputBirtJs();
            }
            this.doClientInitialize(clientInitialize);
        }
        this.writer.closeTag("head");
        this.writer.openTag("body");
        StringBuffer defaultStyleBuffer = new StringBuffer();
        if (report != null && (defaultStyleName = report.getDesign().getRootStyleName()) != null) {
            if (this.enableInlineStyle) {
                IStyle defaultStyle = report.findStyle(defaultStyleName);
                this.htmlEmitter.buildDefaultStyle(defaultStyleBuffer, defaultStyle);
            } else if (this.htmlIDNamespace != null) {
                this.writer.attribute("class", String.valueOf(this.htmlIDNamespace) + defaultStyleName);
            } else {
                this.writer.attribute("class", defaultStyleName);
            }
        }
        if (this.outputMasterPageContent) {
            defaultStyleBuffer.append(" margin:0px;");
        }
        if (defaultStyleBuffer.length() > 0) {
            this.writer.attribute("style", defaultStyleBuffer.toString());
        }
        this.outputClientScript(report);
    }

    protected void outputDIVTitle(IReportContent report) {
        String title = this.getReportTitle(report);
        if (title != null) {
            this.writer.attribute("title", title);
        }
    }

    protected String getContentType() {
        return "text/html; charset=utf-8";
    }

    private void outputClientScript(IReportContent report) {
        String clientScripts;
        IContent root;
        Map<String, Object> extensions;
        if (report != null && (extensions = (root = report.getRoot()).getExtensions()) != null && (clientScripts = (String)extensions.get(EXTENSION_HTML_CLIENT_SCRIPTS)) != null) {
            this.writer.openTag("div");
            this.outputBookmark(root, "div");
            this.writer.attribute("style", "display:none");
            this.writer.closeTag("div");
            this.outputClientScript(root);
        }
    }

    private void outputClientScript(IContent content) {
        String clientScripts;
        Map<String, Object> extensions = content.getExtensions();
        if (extensions != null && (clientScripts = (String)extensions.get(EXTENSION_HTML_CLIENT_SCRIPTS)) != null) {
            this.writer.openTag("script");
            this.writer.attribute("type", "text/javascript");
            this.writer.writeCode(clientScripts);
            this.writer.closeTag("script");
        }
    }

    protected void openRootTag() {
        if (this.isEmbeddable) {
            this.writer.openTag("div");
            String id = BIRT_ROOT;
            if (this.htmlIDNamespace != null) {
                id = String.valueOf(this.htmlIDNamespace) + id;
            }
            this.writer.attribute("id", id);
        } else {
            this.writer.outputDoctype();
            this.writer.openTag(OUTPUT_FORMAT_HTML);
        }
    }

    protected void outputReportTitle(IReportContent report) {
        String title = this.getReportTitle(report);
        if (title != null) {
            this.writer.openTag("title");
            this.writer.text(title);
            this.writer.closeTag("title");
        }
    }

    protected String getReportTitle(IReportContent report) {
        String title = null;
        if (report != null) {
            title = report.getTitle();
        }
        if (title == null && this.renderOption != null) {
            HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
            title = htmlOption.getHtmlTitle();
        }
        return title;
    }

    private void outputCSSStyles(Report reportDesign, ReportDesignHandle designHandle) {
        List externalCsses;
        if (this.report == null) {
            logger.log(Level.WARNING, "[HTMLReportEmitter] Report object is null.");
        } else if (!this.enableInlineStyle) {
            this.openStyleSheet();
            String styleNamePrefix = this.htmlIDNamespace != null ? "." + this.htmlIDNamespace : ".";
            String defaultStyleName = reportDesign.getRootStyleName();
            Map styles = reportDesign.getStyles();
            for (Map.Entry entry : styles.entrySet()) {
                String styleName = (String)entry.getKey();
                if (styleName == null) continue;
                IStyle style = (IStyle)entry.getValue();
                StringBuffer styleBuffer = new StringBuffer();
                if (styleName.equals(defaultStyleName)) {
                    this.htmlEmitter.buildDefaultStyle(styleBuffer, style);
                } else {
                    this.htmlEmitter.buildStyle(styleBuffer, style);
                }
                if (styleBuffer.length() <= 0) continue;
                this.writer.style(String.valueOf(styleNamePrefix) + styleName, styleBuffer.toString());
                this.outputtedStyles.add(styleName);
            }
            this.closeStyleSheet();
        }
        if (designHandle != null && (externalCsses = designHandle.getAllExternalIncludedCsses()) != null) {
            for (IncludedCssStyleSheetHandle cssStyleSheetHandle : externalCsses) {
                String href = cssStyleSheetHandle.getExternalCssURI();
                if (cssStyleSheetHandle.isUseExternalCss() || href != null) {
                    this.hasCsslinks = true;
                }
                if (href == null) continue;
                this.writer.openTag("link");
                this.writer.attribute("rel", "stylesheet");
                this.writer.attribute("type", "text/css");
                this.writer.attribute("href", href);
                this.writer.closeTag("link");
            }
        }
    }

    protected void openStyleSheet() {
        this.writer.openTag("style");
        this.writer.attribute("type", "text/css");
    }

    protected void closeStyleSheet() {
        this.writer.closeTag("style");
    }

    private void appendErrorMessage(EngineResourceHandle rc, int index, ExecutionContext.ElementExceptionInfo info) {
        this.writer.writeCode("\t\t\t<div>");
        this.writer.writeCode("\t\t\t\t<div  id=\"error_title\" style=\"text-decoration:underline\">");
        String name = info.getName();
        if (name != null) {
            this.writer.text(rc.getMessage("Error.ReportErrorMessage", new Object[]{info.getType(), name}), false);
        } else {
            this.writer.text(rc.getMessage("Error.ReportErrorMessageWithID", new Object[]{info.getType(), info.getID()}), false);
        }
        this.writer.writeCode("</div>");
        ArrayList errorList = info.getErrorList();
        ArrayList countList = info.getCountList();
        int i = 0;
        while (i < errorList.size()) {
            String errorId = "document.getElementById('error_detail" + index + "_" + i + "')";
            String errorIcon = "document.getElementById('error_icon" + index + "_" + i + "')";
            String onClick = "if (" + errorId + ".style.display == 'none') { " + errorIcon + ".innerHTML = '- '; " + errorId + ".style.display = 'block'; }" + "else { " + errorIcon + ".innerHTML = '+ '; " + errorId + ".style.display = 'none'; }";
            this.writer.writeCode("<div>");
            BirtException ex = (BirtException)errorList.get(i);
            this.writer.writeCode("<span id=\"error_icon" + index + "_" + i + "\"  style=\"cursor:pointer\" onclick=\"" + onClick + "\" > + </span>");
            this.writer.text(ex.getLocalizedMessage());
            this.writer.writeCode("\t\t\t\t<pre id=\"error_detail" + index + "_" + i + "\" style=\"display:none;\" >");
            String messageTitle = rc.getMessage("Error.ReportErrorID", new Object[]{ex.getErrorCode(), countList.get(i)});
            String detailTag = rc.getMessage("Error.ReportErrorDetail");
            String messageBody = this.getDetailMessage(ex);
            boolean indent = this.writer.isIndent();
            this.writer.setIndent(false);
            this.writer.text(messageTitle, false);
            this.writer.writeCode("\r\n");
            this.writer.text(detailTag, false);
            this.writer.text(messageBody, false);
            this.writer.setIndent(indent);
            this.writer.writeCode("\t\t\t\t</pre>");
            this.writer.writeCode("</div>");
            ++i;
        }
        this.writer.writeCode("</div>");
        this.writer.writeCode("<br>");
    }

    private String getDetailMessage(Throwable t) {
        StringWriter out = new StringWriter();
        PrintWriter print = new PrintWriter(out);
        try {
            t.printStackTrace(print);
        }
        catch (Throwable throwable) {}
        print.flush();
        return out.getBuffer().toString();
    }

    protected boolean outputErrors(List errors) {
        if (errors != null && !errors.isEmpty()) {
            this.writer.writeCode("\t<hr style=\"color:red\"/>");
            this.writer.writeCode("\t<div style=\"color:red\">");
            this.writer.writeCode("\t\t<div>");
            Locale locale = this.reportContext.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            EngineResourceHandle rc = new EngineResourceHandle(ULocale.forLocale((Locale)locale));
            this.writer.text(rc.getMessage("Error.ErrorOnReportPage"), false);
            this.writer.writeCode("</div>");
            this.writer.writeCode("<br>");
            Iterator it = errors.iterator();
            int index = 0;
            while (it.hasNext()) {
                this.appendErrorMessage(rc, index++, (ExecutionContext.ElementExceptionInfo)it.next());
            }
            this.writer.writeCode("</div>");
            return true;
        }
        return false;
    }

    @Override
    public void end(IReportContent report) {
        List errors;
        logger.log(Level.FINEST, "[HTMLReportEmitter] End body.");
        if (report != null && (errors = report.getErrors()) != null && !errors.isEmpty()) {
            this.outputErrors(errors);
        }
        if (!this.isEmbeddable) {
            this.writer.closeTag("body");
            this.writer.closeTag(OUTPUT_FORMAT_HTML);
        } else {
            this.writer.closeTag("div");
        }
        this.writer.endWriter();
        this.writer.close();
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private boolean isSameUnit(String unit1, String unit2) {
        if (unit1 == unit2) {
            return true;
        }
        return unit1 != null && unit1.equals(unit2);
    }

    private DimensionType getPageWidth(IPageContent page) {
        DimensionType pageWidth = page.getPageWidth();
        if (!this.outputMasterPageMargins) {
            DimensionType leftMargin = page.getMarginLeft();
            DimensionType rightMargin = page.getMarginRight();
            return this.removeMargin(pageWidth, leftMargin, rightMargin);
        }
        return pageWidth;
    }

    private DimensionType getPageHeight(IPageContent page) {
        DimensionType pageHeight = page.getPageHeight();
        if (!this.outputMasterPageMargins) {
            DimensionType topMargin = page.getMarginTop();
            DimensionType bottomMargin = page.getMarginBottom();
            return this.removeMargin(pageHeight, topMargin, bottomMargin);
        }
        return pageHeight;
    }

    private DimensionType removeMargin(DimensionType pageWidth, DimensionType leftMargin, DimensionType rightMargin) {
        DimensionValue converted;
        double measure = pageWidth.getMeasure();
        String unit = pageWidth.getUnits();
        if (leftMargin != null) {
            if (this.isSameUnit(unit, leftMargin.getUnits())) {
                measure -= leftMargin.getMeasure();
            } else if (DimensionUtil.isAbsoluteUnit(unit) && DimensionUtil.isAbsoluteUnit(leftMargin.getUnits())) {
                converted = DimensionUtil.convertTo(leftMargin.getMeasure(), leftMargin.getUnits(), unit);
                measure -= converted.getMeasure();
            }
        }
        if (rightMargin != null) {
            if (this.isSameUnit(unit, rightMargin.getUnits())) {
                measure -= rightMargin.getMeasure();
            } else if (DimensionUtil.isAbsoluteUnit(unit) && DimensionUtil.isAbsoluteUnit(rightMargin.getUnits())) {
                converted = DimensionUtil.convertTo(rightMargin.getMeasure(), rightMargin.getUnits(), unit);
                measure -= converted.getMeasure();
            }
        }
        if (measure > 0.0) {
            return new DimensionType(measure, unit);
        }
        return pageWidth;
    }

    private void outputColumn(DimensionType dm) {
        this.writer.openTag("col");
        StringBuffer styleBuffer = new StringBuffer();
        styleBuffer.append("width: ");
        if (dm != null) {
            styleBuffer.append(dm.toString());
        } else {
            styleBuffer.append("0pt");
        }
        styleBuffer.append(";");
        this.writer.attribute("style", styleBuffer.toString());
        this.writer.closeTag("col");
    }

    private void outputVMargin(DimensionType margin) {
        if (margin != null) {
            this.writer.openTag("tr");
            StringBuffer styleBuffer = new StringBuffer();
            styleBuffer.append("height: ");
            styleBuffer.append(margin.toString());
            styleBuffer.append(";");
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.openTag("td");
            this.writer.attribute("colspan", 3);
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
        }
    }

    private void outputHMargin(DimensionType margin) {
        this.writer.openTag("td");
        if (margin != null) {
            this.writer.openTag("div");
            StringBuffer styleBuffer = new StringBuffer();
            styleBuffer.append("width: ");
            styleBuffer.append(margin.toString());
            styleBuffer.append(";");
            this.writer.attribute("style", styleBuffer.toString());
            this.writer.closeTag("div");
        }
        this.writer.closeTag("td");
    }

    boolean showPageHeader(IPageContent page) {
        SimpleMasterPageDesign masterPage;
        boolean showHeader = true;
        Object genBy = page.getGenerateBy();
        if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowHeaderOnFirst() && page.getPageNumber() == 1L) {
            showHeader = false;
        }
        return showHeader;
    }

    boolean showPageFooter(IPageContent page) {
        SimpleMasterPageDesign masterPage;
        boolean showFooter = true;
        Object genBy = page.getGenerateBy();
        if (genBy instanceof SimpleMasterPageDesign && !(masterPage = (SimpleMasterPageDesign)genBy).isShowFooterOnLast()) {
            long totalPage = page.getPageNumber();
            IReportContent report = page.getReportContent();
            if (report != null) {
                totalPage = report.getTotalPage();
            }
            if (page.getPageNumber() == totalPage) {
                showFooter = false;
            }
        }
        return showFooter;
    }

    private void outputPageBand(IPageContent page, IContent band, DimensionType height) throws BirtException {
        boolean fixedHeight;
        this.writer.openTag("td");
        this.writeBidiFlag();
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildPageBandStyle(styleBuffer, page.getStyle());
        this.writer.attribute("style", styleBuffer.toString());
        boolean bl = fixedHeight = this.fixedReport && height != null && !band.getChildren().isEmpty();
        if (fixedHeight) {
            this.writer.openTag("div");
            styleBuffer.delete(0, styleBuffer.length());
            styleBuffer.append("overflow:hidden; height:");
            styleBuffer.append(height.toString());
            this.writer.attribute("style", styleBuffer.toString());
        }
        this.contentVisitor.visitChildren(band, null);
        if (fixedHeight) {
            this.writer.closeTag("div");
        }
        this.writer.closeTag("td");
    }

    @Override
    public void startPage(IPageContent page) throws BirtException {
        ++this.pageNo;
        if (this.pageNo > 1 && !this.outputMasterPageContent) {
            this.writer.openTag("hr");
            this.writer.closeTag("hr");
        }
        if (this.pageNo > 1) {
            this.writer.writeCode(" <div style=\"visibility: hidden; height: 0px; overflow: hidden; page-break-after: always;\">page separator</div>");
        }
        DimensionType width = null;
        DimensionType height = null;
        if (page != null && this.outputMasterPageContent) {
            width = this.getPageWidth(page);
            height = this.getPageHeight(page);
            if (width != null && height != null && this.fixedReport && !this.pageFooterFloatFlag) {
                this.startBackgroundContainer(page.getStyle(), width, height);
            }
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.writer.openTag("table");
        this.writer.attribute("cellpadding", "0");
        styleBuffer.append("empty-cells: show; border-collapse:collapse;");
        if (page != null && this.outputMasterPageContent) {
            this.htmlEmitter.buildPageStyle(page, styleBuffer, this.needOutputBackgroundSize);
            if (this.fixedReport && width != null) {
                styleBuffer.append(" width:");
                styleBuffer.append(width.toString());
                styleBuffer.append(";");
            } else if (!this.fixedReport) {
                styleBuffer.append(" width:100%;");
            }
            if (!this.pageFooterFloatFlag && height != null) {
                styleBuffer.append(" height:");
                styleBuffer.append(height.toString());
                styleBuffer.append(";");
            }
            if (this.fixedReport) {
                styleBuffer.append(" overflow: hidden;");
                styleBuffer.append(" table-layout:fixed;");
            }
        } else {
            styleBuffer.append("width:100%;");
        }
        if (styleBuffer.indexOf("border") < 0) {
            this.writer.attribute("border", "0");
        }
        this.writer.attribute("style", styleBuffer.toString());
        if (page != null && this.outputMasterPageContent) {
            if (this.outputMasterPageMargins) {
                this.outputColumn(page.getMarginLeft());
            }
            this.writer.openTag("col");
            this.writer.closeTag("col");
            if (this.outputMasterPageMargins) {
                this.outputColumn(page.getMarginLeft());
                this.outputVMargin(page.getMarginTop());
            }
            if (this.showPageHeader(page)) {
                this.writer.openTag("tr");
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginLeft());
                }
                this.outputPageBand(page, page.getPageHeader(), page.getHeaderHeight());
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginRight());
                }
                this.writer.closeTag("tr");
            }
        }
        this.writer.openTag("tr");
        if (!this.pageFooterFloatFlag) {
            this.writer.attribute("style", "height:100%;");
        }
        if (page != null && this.outputMasterPageContent && this.outputMasterPageMargins) {
            this.outputHMargin(page.getMarginLeft());
        }
        this.writer.openTag("td");
        this.writer.attribute("valign", "top");
        this.writeBidiFlag();
    }

    private void startBackgroundContainer(IStyle style, DimensionType pageWidth, DimensionType pageHeight) {
        String image;
        String backgroundHeight = this.parseBackgroundSize(style.getBackgroundHeight(), pageHeight);
        String backgroundWidth = this.parseBackgroundSize(style.getBackgroundWidth(), pageWidth);
        if (backgroundHeight == null && backgroundWidth == null) {
            return;
        }
        if (backgroundHeight == null) {
            backgroundHeight = "auto";
        }
        if (backgroundWidth == null) {
            backgroundWidth = "auto";
        }
        if ((image = style.getBackgroundImage()) == null || "none".equalsIgnoreCase(image)) {
            return;
        }
        this.needOutputBackgroundSize = true;
        this.writer.openTag("div");
        StringBuffer sb = new StringBuffer();
        sb.append("width:").append(pageWidth).append(";");
        sb.append("height:").append(pageHeight).append(";");
        AttributeBuilder.buildBackground(sb, style, this);
        sb.append("background-size:").append(backgroundWidth).append(" ").append(backgroundHeight).append(";");
        this.writer.attribute("style", sb.toString());
    }

    private String parseBackgroundSize(String backgroundHeight, DimensionType pageHeight) {
        if (backgroundHeight == null) {
            return null;
        }
        if ((backgroundHeight = backgroundHeight.trim()).endsWith("%")) {
            try {
                String percent = backgroundHeight.substring(0, backgroundHeight.length() - 1);
                int percentValue = Integer.valueOf(percent);
                return String.valueOf(pageHeight.getMeasure() * (double)percentValue / 100.0) + pageHeight.getUnits();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return backgroundHeight;
    }

    private void endBackgroundContainer() {
        this.writer.closeTag("div");
    }

    @Override
    public void endPage(IPageContent page) throws BirtException {
        logger.log(Level.FINEST, "[HTMLReportEmitter] End page.");
        this.writer.closeTag("td");
        if (page != null && this.outputMasterPageContent && this.outputMasterPageMargins) {
            this.outputHMargin(page.getMarginRight());
        }
        this.writer.closeTag("tr");
        if (page != null && this.outputMasterPageContent) {
            if (this.showPageFooter(page)) {
                this.writer.openTag("tr");
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginLeft());
                }
                this.outputPageBand(page, page.getPageFooter(), page.getFooterHeight());
                if (this.outputMasterPageMargins) {
                    this.outputHMargin(page.getMarginRight());
                }
                this.writer.closeTag("tr");
            }
            if (this.outputMasterPageMargins) {
                this.outputVMargin(page.getMarginBottom());
            }
        }
        this.writer.closeTag("table");
        if (this.needOutputBackgroundSize) {
            this.endBackgroundContainer();
            this.needOutputBackgroundSize = false;
        }
    }

    @Override
    public void startTable(ITableContent table) {
        this.cachedStartTable = table;
    }

    protected void doStartTable(ITableContent table) {
        CSSValue display;
        assert (table != null);
        boolean DIVWrap = false;
        IStyle style = table.getStyle();
        if (this.needImplementAlignTable(table)) {
            this.writer.openTag("div");
            DIVWrap = true;
            this.writer.attribute("align", style.getTextAlign());
        }
        if (!(this.browserSupportsInlineBlock || IStyle.INLINE_VALUE != (display = style.getProperty(50)) && IStyle.INLINE_BLOCK_VALUE != display)) {
            if (!DIVWrap) {
                this.writer.openTag("div");
                DIVWrap = true;
            }
            this.writer.attribute("style", " display:-moz-inline-box; display:inline-block; *+display:inline;");
        }
        this.tableDIVWrapedFlagStack.push(DIVWrap);
        logger.log(Level.FINEST, "[HTMLTableEmitter] Start table");
        if (this.enableMetadata) {
            this.metadataEmitter.startWrapTable(table);
        }
        this.writer.openTag("table");
        String styleClass = table.getStyleClass();
        this.setStyleName(styleClass, table);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTableStyle(table, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(table)), table, "table");
        }
        if (!bookmarkOutput) {
            String bookmark = table.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                table.setBookmark(bookmark);
            }
            this.outputBookmark(table, "table");
        }
        String summary = table.getSummary();
        this.writer.attribute("summary", summary);
        String caption = table.getCaption();
        if (caption != null && caption.length() > 0) {
            this.writer.openTag("caption");
            this.writer.text(caption);
            this.writer.closeTag("caption");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startTable(table);
        }
        this.writeColumns(table);
        this.tableLayout.startTable(table);
    }

    protected void writeColumns(ITableContent table) {
        int i = 0;
        while (i < table.getColumnCount()) {
            IColumn column = table.getColumn(i);
            this.writer.openTag("col");
            if (this.enableAgentStyleEngine) {
                String styleClass = column.getStyleClass();
                this.setStyleName(styleClass, table);
            }
            StringBuffer styleBuffer = new StringBuffer();
            this.htmlEmitter.buildColumnStyle(column, styleBuffer);
            this.writer.attribute("style", styleBuffer.toString());
            this.htmlEmitter.handleColumnAlign(column);
            if (this.metadataFilter != null) {
                this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(column)), column, "col");
            }
            this.writer.closeTag("col");
            ++i;
        }
    }

    @Override
    public void endTable(ITableContent table) {
        boolean DIVWrap;
        if (this.cachedStartTable != null) {
            this.cachedStartTable = null;
            return;
        }
        if (this.enableMetadata) {
            this.metadataEmitter.endTable(table);
        }
        this.writer.closeTag("table");
        if (this.enableMetadata) {
            this.metadataEmitter.endWrapTable(table);
        }
        if (DIVWrap = ((Boolean)this.tableDIVWrapedFlagStack.pop()).booleanValue()) {
            this.writer.closeTag("div");
        }
        this.tableLayout.endTable(table);
        logger.log(Level.FINEST, "[HTMLTableEmitter] End table");
    }

    protected boolean needImplementAlignTable(ITableContent table) {
        IStyle style;
        CSSValue display;
        DimensionType width;
        if (!(this.report.getRoot() != table.getParent() || (width = table.getWidth()) == null || "100%".equals(width.toString()) || (display = (style = table.getStyle()).getProperty(50)) != null && IStyle.BLOCK_VALUE != display)) {
            CSSValue align = style.getProperty(23);
            if (IStyle.CENTER_VALUE.equals(align)) {
                return true;
            }
            CSSValue direction = style.getProperty(5);
            if (IStyle.RTL_VALUE.equals(direction) ? !IStyle.RIGHT_VALUE.equals(align) : IStyle.RIGHT_VALUE == align) {
                return true;
            }
        }
        return false;
    }

    public void startTableHeader(ITableBandContent band) {
        this.writer.openTag("thead");
    }

    public void endTableHeader(ITableBandContent band) {
        this.writer.closeTag("thead");
    }

    public void startTableBody(ITableBandContent band) {
        this.writer.openTag("tbody");
    }

    public void endTableBody(ITableBandContent band) {
        this.writer.closeTag("tbody");
    }

    public void startTableFooter(ITableBandContent band) {
        this.writer.openTag("tfoot");
    }

    public void endTableFooter(ITableBandContent band) {
        this.writer.closeTag("tfoot");
    }

    @Override
    public void startRow(IRowContent row) {
        assert (row != null);
        if (this.cachedStartTable != null) {
            this.doStartTable(this.cachedStartTable);
            this.cachedStartTable = null;
        }
        this.writer.openTag("tr");
        if (this.metadataFilter != null) {
            this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(row)), row, "tr");
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startRow(row);
        }
        String styleClass = row.getStyleClass();
        this.setStyleName(styleClass, row);
        this.outputBookmark(row, null);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildRowStyle(row, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleRowAlign(row);
        if (!this.startedGroups.isEmpty()) {
            IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
            String bookmark = group.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                group.setBookmark(bookmark);
            }
            this.outputBookmark(group, null);
            this.startedGroups.remove(group);
        }
        if (this.fixedReport) {
            DimensionType rowHeight = row.getHeight();
            if (rowHeight != null && !"%".equals(rowHeight.getUnits())) {
                this.fixedRowHeightStack.push(rowHeight);
            } else {
                this.fixedRowHeightStack.push(null);
            }
        }
        this.tableLayout.startRow();
    }

    @Override
    public void endRow(IRowContent row) {
        this.tableLayout.endRow();
        if (this.enableMetadata) {
            this.metadataEmitter.endRow(row);
        }
        this.writer.closeTag("tr");
        if (this.fixedReport) {
            this.fixedRowHeightStack.pop();
        }
    }

    private boolean isCellInHead(ICellContent cell) {
        IElement row = cell.getParent();
        if (row instanceof IRowContent) {
            int type;
            IElement tableBand = row.getParent();
            if (tableBand instanceof ITableBandContent && (type = ((ITableBandContent)tableBand).getBandType()) == 1) {
                return true;
            }
            IColumn column = cell.getColumnInstance();
            if (column != null) {
                return column.isColumnHeader();
            }
        }
        return false;
    }

    @Override
    public void startCell(ICellContent cell) {
        DimensionType cellHeight;
        int rowSpan;
        logger.log(Level.FINEST, "[HTMLTableEmitter] Start cell.");
        this.tableLayout.startCell(cell);
        String tagName = null;
        boolean isHead = this.isCellInHead(cell);
        tagName = isHead ? "th" : "td";
        this.writer.openTag(tagName);
        this.writer.attribute("scope", cell.getScope());
        this.writer.attribute("id", cell.getBookmark());
        this.writer.attribute("headers", cell.getHeaders());
        String styleClass = cell.getStyleClass();
        this.setStyleName(styleClass, cell);
        int colSpan = cell.getColSpan();
        if (colSpan > 1) {
            this.writer.attribute("colspan", colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) > 1) {
            this.writer.attribute("rowspan", rowSpan);
        }
        boolean fixedCellHeight = this.useFixedCellHeight(cell);
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildCellStyle(cell, styleBuffer, isHead, fixedCellHeight);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleCellAlign(cell);
        if (fixedCellHeight) {
            this.writer.attribute("valign", "top");
        } else {
            this.htmlEmitter.handleCellVAlign(cell);
        }
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(cell)), cell, tagName);
        }
        if (!this.startedGroups.isEmpty()) {
            if (!bookmarkOutput) {
                IGroupContent group = (IGroupContent)this.startedGroups.firstElement();
                String bookmark = group.getBookmark();
                if (bookmark == null) {
                    bookmark = this.idGenerator.generateUniqueID();
                    group.setBookmark(bookmark);
                }
                this.outputBookmark(group, null);
                this.startedGroups.remove(group);
            }
            for (IGroupContent group : this.startedGroups) {
                this.outputBookmark(group);
            }
            this.startedGroups.clear();
        }
        if (fixedCellHeight) {
            this.writer.openTag("div");
            this.writer.attribute("style", "position: relative; height: 100%;");
            cellHeight = this.fixedRowHeightStack.peek();
            if (cell.hasDiagonalLine()) {
                this.outputDiagonalImage(cell, cellHeight);
            }
            this.writer.openTag("div");
            styleBuffer.setLength(0);
            styleBuffer.append(" height: ");
            styleBuffer.append(cellHeight.toString());
            styleBuffer.append("; width: 100%; position: absolute; left: 0px;");
            HTMLEmitterUtil.buildOverflowStyle(styleBuffer, cell.getStyle(), true);
            this.writer.attribute("style", styleBuffer.toString());
        } else if (cell.hasDiagonalLine() && (cellHeight = this.getCellHeight(cell)) != null && !"%".equals(cellHeight.getUnits())) {
            this.writer.openTag("div");
            this.writer.attribute("style", "position: relative; height: 100%;");
            this.outputDiagonalImage(cell, cellHeight);
        }
        if (this.enableMetadata) {
            this.metadataEmitter.startCell(cell);
        }
    }

    private boolean useFixedCellHeight(ICellContent cell) {
        DimensionType cellHeight;
        String overflow;
        IStyle style;
        if (cell.getRowSpan() > 1) {
            return false;
        }
        return this.fixedReport && (style = cell.getStyle()) != null && (overflow = style.getOverflow()) != null && "scroll".equals(overflow) && (cellHeight = this.fixedRowHeightStack.peek()) != null;
    }

    protected void outputDiagonalImage(ICellContent cell, DimensionType cellHeight) {
        String imgUri = this.diagonalCellImageMap.get(cell.getInstanceID().getComponentID());
        if (imgUri == null) {
            DiagonalLineImage imageCreater = new DiagonalLineImage();
            imageCreater.setDiagonalLine(cell.getDiagonalNumber(), cell.getDiagonalStyle(), cell.getDiagonalWidth(), cell.getDiagonalColor());
            imageCreater.setAntidiagonalLine(cell.getAntidiagonalNumber(), cell.getAntidiagonalStyle(), cell.getAntidiagonalWidth(), cell.getAntidiagonalColor());
            imageCreater.setImageDpi(this.imageDpi);
            imageCreater.setImageSize(this.getCellWidth(cell), cellHeight);
            IStyle cellComputedStyle = cell.getComputedStyle();
            String strColor = cellComputedStyle.getColor();
            imageCreater.setColor(PropertyUtil.getColor(strColor));
            byte[] imageByteArray = null;
            try {
                imageByteArray = imageCreater.drawImage();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            if (imageByteArray != null) {
                Image image = new Image(imageByteArray, cell.getInstanceID().toUniqueString(), ".png");
                image.setReportRunnable(this.runnable);
                image.setRenderOption(this.renderOption);
                imgUri = this.imageHandler.onCustomImage((IImage)image, this.reportContext);
                if (imgUri != null) {
                    this.diagonalCellImageMap.put(cell.getInstanceID().getComponentID(), imgUri);
                }
            }
        }
        if (imgUri != null) {
            this.writer.openTag("img");
            this.writer.attributeAllowEmpty("alt", "");
            this.writer.attribute("src", imgUri);
            StringBuffer styleBuffer = new StringBuffer();
            styleBuffer.append(" min-height: ");
            styleBuffer.append(cellHeight.toString());
            styleBuffer.append("; height: 100%; width: 100%; position: absolute; z-index: auto; left: 0px;");
            this.writer.attribute("style", styleBuffer.toString());
            if (this.needFixTransparentPNG) {
                if (this.htmlIDNamespace == null) {
                    this.writer.attribute("onload", "fixPNG(this)");
                } else {
                    this.writer.attribute("onload", String.valueOf(this.htmlIDNamespace) + "fixPNG(this)");
                }
            }
            this.writer.closeTag("img");
        }
    }

    protected DimensionType getCellWidth(ICellContent cell) {
        IColumn column = cell.getColumnInstance();
        if (column != null) {
            return column.getWidth();
        }
        return null;
    }

    protected DimensionType getCellHeight(ICellContent cell) {
        IElement row = cell.getParent();
        if (row instanceof IRowContent) {
            return ((IRowContent)row).getHeight();
        }
        return null;
    }

    @Override
    public void endCell(ICellContent cell) {
        DimensionType cellHeight;
        logger.log(Level.FINEST, "[HTMLReportEmitter] End cell.");
        if (this.enableMetadata) {
            this.metadataEmitter.endCell(cell);
        }
        if (this.useFixedCellHeight(cell)) {
            this.writer.closeTag("div");
            this.writer.closeTag("div");
        } else if (cell.hasDiagonalLine() && (cellHeight = this.getCellHeight(cell)) != null && !"%".equals(cellHeight.getUnits())) {
            this.writer.closeTag("div");
        }
        if (this.isCellInHead(cell)) {
            this.writer.closeTag("th");
        } else {
            this.writer.closeTag("td");
        }
        this.tableLayout.endCell(cell);
    }

    @Override
    public void startContainer(IContainerContent container) {
        logger.log(Level.FINEST, "[HTMLReportEmitter] Start container");
        this.htmlEmitter.openContainerTag(container);
        String styleClass = container.getStyleClass();
        this.setStyleName(styleClass, container);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(container)), container, "div");
        }
        if (!bookmarkOutput) {
            String bookmark = container.getBookmark();
            if (bookmark == null) {
                bookmark = this.idGenerator.generateUniqueID();
                container.setBookmark(bookmark);
            }
            this.outputBookmark(container, "div");
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildContainerStyle(container, styleBuffer);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleContainerAlign(container);
    }

    @Override
    public void endContainer(IContainerContent container) {
        this.htmlEmitter.closeContainerTag();
        logger.log(Level.FINEST, "[HTMLContainerEmitter] End container");
    }

    @Override
    public void startText(ITextContent text) {
        int display;
        IStyle mergedStyle = text.getStyle();
        logger.log(Level.FINEST, "[HTMLReportEmitter] Start text");
        DimensionType x = text.getX();
        DimensionType y = text.getY();
        DimensionType width = text.getWidth();
        DimensionType height = text.getHeight();
        String textValue = text.getText();
        boolean isBlank = false;
        if (textValue == null || "".equals(textValue)) {
            textValue = " ";
            isBlank = true;
        }
        if ((display = this.htmlEmitter.getTextElementType(x, y, width, height, mergedStyle)) == 2 && (text.isDirectionRTL() || Bidi.requiresBidi((char[])textValue.toCharArray(), (int)0, (int)textValue.length()))) {
            display |= 4;
        }
        String tagName = this.openTagByType(display, 65535);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(text)), text, tagName);
        }
        String styleClass = text.getStyleClass();
        this.setStyleName(styleClass, text);
        if (!bookmarkOutput) {
            this.outputBookmark(text, tagName);
        }
        this.writer.attribute("title", text.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildTextStyle(text, styleBuffer, display);
        this.writer.attribute("style", styleBuffer.toString());
        this.htmlEmitter.handleVerticalAlignBegin(text);
        String url = this.validate(text.getHyperlinkAction());
        if (url != null && !isBlank) {
            this.outputAction(text.getHyperlinkAction(), url);
            String strColor = mergedStyle.getColor();
            if (strColor != null) {
                styleBuffer.setLength(0);
                styleBuffer.append(" color: ");
                styleBuffer.append(strColor);
                styleBuffer.append(";");
                this.writer.attribute("style", styleBuffer.toString());
            }
            this.writer.text(textValue);
            this.writer.closeTag("a");
        } else if (isBlank) {
            this.writer.openTag("div");
            this.writer.attribute("style", "visibility:hidden");
            this.writer.text(textValue);
            this.writer.closeTag("div");
        } else {
            this.writer.text(textValue);
        }
        this.htmlEmitter.handleVerticalAlignEnd(text);
        this.writer.closeTag(tagName);
    }

    @Override
    public void startForeign(IForeignContent foreign) {
        IStyle mergedStyle = foreign.getStyle();
        logger.log(Level.FINEST, "[HTMLReportEmitter] Start foreign");
        boolean isTemplate = false;
        boolean wrapTemplateTable = false;
        Object genBy = foreign.getGenerateBy();
        if (genBy instanceof TemplateDesign) {
            isTemplate = true;
            TemplateDesign design = (TemplateDesign)genBy;
            this.setupTemplateElement(design, foreign);
            this.writer.openTag("div");
            this.writer.attribute("align", "center");
            if (this.enableMetadata && "Table".equals(design.getAllowedType())) {
                wrapTemplateTable = true;
                this.metadataEmitter.startWrapTable(foreign);
            }
        }
        DimensionType x = foreign.getX();
        DimensionType y = foreign.getY();
        DimensionType width = foreign.getWidth();
        DimensionType height = foreign.getHeight();
        int display = this.getElementType(x, y, width, height, mergedStyle);
        String tagName = this.openTagByType(display, 65535);
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(foreign)), foreign, tagName);
        }
        String styleClass = foreign.getStyleClass();
        this.setStyleName(styleClass, foreign);
        if (!bookmarkOutput) {
            this.outputBookmark(foreign, tagName);
        }
        this.writer.attribute("title", foreign.getHelpText());
        StringBuffer styleBuffer = new StringBuffer();
        this.htmlEmitter.buildForeignStyle(foreign, styleBuffer, display);
        HTMLEmitterUtil.buildOverflowStyle(styleBuffer, mergedStyle, true);
        this.writer.attribute("style", styleBuffer.toString());
        String rawType = foreign.getRawType();
        boolean isHtml = "text/html".equalsIgnoreCase(rawType);
        if (isHtml) {
            this.htmlEmitter.handleVerticalAlignBegin(foreign);
            String url = this.validate(foreign.getHyperlinkAction());
            if (url != null) {
                this.outputAction(foreign.getHyperlinkAction(), url);
                this.outputHtmlText(foreign);
                this.writer.closeTag("a");
            } else {
                this.outputHtmlText(foreign);
            }
            this.htmlEmitter.handleVerticalAlignEnd(foreign);
        }
        this.writer.closeTag(tagName);
        if (isTemplate) {
            if (wrapTemplateTable) {
                this.metadataEmitter.endWrapTable(foreign);
            }
            this.writer.closeTag("div");
        }
    }

    private void outputHtmlText(IForeignContent foreign) {
        boolean bIndent = this.writer.isIndent();
        this.writer.setIndent(false);
        Object rawValue = foreign.getRawValue();
        String text = rawValue == null ? null : rawValue.toString();
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        if (!foreign.isJTidy()) {
            this.writer.writeCode(text);
        } else {
            NodeList bodys;
            Document doc = new TextParser().parse(text, TextParser.TEXT_TYPE_HTML);
            HTMLProcessor htmlProcessor = new HTMLProcessor(design, this.reportContext.getAppContext());
            HashMap styleMap = new HashMap();
            Element body = null;
            if (doc != null && (bodys = doc.getElementsByTagName("body")).getLength() > 0) {
                body = (Element)bodys.item(0);
            }
            if (body != null) {
                htmlProcessor.execute(body, styleMap);
                this.processNodes(body, styleMap);
            }
        }
        this.writer.setIndent(bIndent);
    }

    private void processNodes(Element ele, HashMap cssStyles) {
        Node node = ele.getFirstChild();
        while (node != null) {
            short nodeType = node.getNodeType();
            if (nodeType == 3) {
                if (this.isScriptText(node)) {
                    this.writer.cdata(node.getNodeValue());
                } else {
                    this.writer.text(node.getNodeValue(), false);
                }
            } else if (nodeType == 8) {
                this.writer.comment(node.getNodeValue());
            } else if (nodeType == 1) {
                if ("br".equalsIgnoreCase(node.getNodeName())) {
                    boolean bImplicitCloseTag = this.writer.isImplicitCloseTag();
                    this.writer.setImplicitCloseTag(true);
                    this.startNode(node, cssStyles);
                    this.processNodes((Element)node, cssStyles);
                    this.endNode(node);
                    this.writer.setImplicitCloseTag(bImplicitCloseTag);
                } else {
                    this.startNode(node, cssStyles);
                    this.processNodes((Element)node, cssStyles);
                    this.endNode(node);
                }
            }
            node = node.getNextSibling();
        }
    }

    private boolean isScriptText(Node node) {
        String tag;
        Node parent = node.getParentNode();
        return parent != null && parent.getNodeType() == 1 && "script".equalsIgnoreCase(tag = parent.getNodeName());
    }

    public void startNode(Node node, HashMap cssStyles) {
        String nodeName = node.getNodeName();
        HashMap cssStyle = (HashMap)cssStyles.get(node);
        this.writer.openTag(nodeName);
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node attribute = attributes.item(i);
                String attrName = attribute.getNodeName();
                String attrValue = attribute.getNodeValue();
                if (attrValue != null) {
                    String attrValueTrue;
                    if ("img".equalsIgnoreCase(nodeName) && "src".equalsIgnoreCase(attrName) && (attrValueTrue = this.handleStyleImage(attrValue)) != null) {
                        attrValue = attrValueTrue;
                    }
                    this.writer.attribute(attrName, attrValue);
                }
                ++i;
            }
        }
        if (cssStyle != null) {
            StringBuffer buffer = new StringBuffer();
            for (Map.Entry entry : cssStyle.entrySet()) {
                Object keyObj = entry.getKey();
                Object valueObj = entry.getValue();
                if (keyObj == null || valueObj == null) continue;
                String key = keyObj.toString();
                String value = valueObj.toString();
                buffer.append(key);
                buffer.append(":");
                if ("background-image".equalsIgnoreCase(key)) {
                    String valueTrue = this.handleStyleImage(value, true);
                    if (valueTrue != null) {
                        value = valueTrue;
                    }
                    buffer.append("url(");
                    buffer.append(value);
                    buffer.append(")");
                } else {
                    buffer.append(value);
                }
                buffer.append(";");
            }
            if (buffer.length() != 0) {
                this.writer.attribute("style", buffer.toString());
            }
        }
    }

    public void endNode(Node node) {
        this.writer.closeTag(node.getNodeName());
    }

    @Override
    public void startLabel(ILabelContent label) {
        String bookmark = label.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            label.setBookmark(bookmark);
        }
        this.startText(label);
    }

    @Override
    public void startData(IDataContent data) {
        this.startText(data);
    }

    @Override
    public void startImage(IImageContent image) {
        boolean useSVG;
        assert (image != null);
        IStyle mergedStyle = image.getStyle();
        logger.log(Level.FINEST, "[HTMLImageEmitter] Start image");
        StringBuffer styleBuffer = new StringBuffer();
        int display = this.checkElementType(image.getX(), image.getY(), mergedStyle, styleBuffer);
        String tag = this.openTagByType(display, 65535);
        IHyperlinkAction hyperlinkAction = image.getHyperlinkAction();
        String url = this.validate(hyperlinkAction);
        if (url != null) {
            String strWidth = "width:0;";
            DimensionType w = image.getWidth();
            if (w != null) {
                strWidth = "width:" + w.toString();
            }
            this.writer.attribute("style", strWidth);
        }
        boolean hasAction = this.handleAction(hyperlinkAction, url);
        boolean compactMode = this.writer.isEnableCompactMode();
        if (hasAction) {
            this.writer.setEnableCompactMode(true);
        }
        if (image.getBookmark() == null) {
            image.setBookmark(this.idGenerator.generateUniqueID());
        }
        boolean bl = useSVG = "image/svg+xml".equalsIgnoreCase(image.getMIMEType()) || ".svg".equalsIgnoreCase(image.getExtension()) || image.getURI() != null && image.getURI().toLowerCase().endsWith(".svg");
        if (useSVG) {
            image.setMIMEType("image/svg+xml");
        }
        boolean useSWT = "application/x-shockwave-flash".equalsIgnoreCase(image.getMIMEType());
        if (useSVG || useSWT) {
            this.outputSVGImage(image, styleBuffer, display);
        } else {
            String altText;
            boolean hasImageMap;
            Object imageMapObject = image.getImageMap();
            String imageMapId = null;
            boolean bl2 = hasImageMap = imageMapObject != null && imageMapObject instanceof String && ((String)imageMapObject).length() > 0;
            if (hasImageMap) {
                String id = this.idGenerator.generateUniqueID();
                imageMapId = this.htmlIDNamespace != null ? String.valueOf(this.htmlIDNamespace) + id : id;
                this.writer.openTag("map");
                this.writer.attribute("id", imageMapId);
                this.writer.attribute("name", imageMapId);
                this.writer.attribute("style", "display:none");
                this.writer.cdata((String)imageMapObject);
                this.writer.closeTag("map");
            }
            this.writer.openTag("img");
            this.outputImageStyleClassBookmark(image, "img");
            String ext = image.getExtension();
            String imgUri = this.getImageURI(image);
            this.writer.attribute("src", imgUri);
            if (hasImageMap) {
                if (!hasAction) {
                    this.resetImageDefaultBorders(image, styleBuffer);
                }
                this.writer.attribute("usemap", "#" + imageMapId);
            }
            if ((altText = image.getAltText()) == null) {
                this.writer.attributeAllowEmpty("alt", "");
            } else {
                this.writer.attribute("alt", altText);
            }
            String titleText = image.getHelpText();
            if (titleText == null && hasAction) {
                titleText = hyperlinkAction.getTooltip();
            }
            this.writer.attribute("title", titleText);
            this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
            this.writer.attribute("style", styleBuffer.toString());
            if (".PNG".equalsIgnoreCase(ext) && this.imageHandler != null && this.needFixTransparentPNG) {
                if (this.htmlIDNamespace == null) {
                    this.writer.attribute("onload", "fixPNG(this)");
                } else {
                    this.writer.attribute("onload", String.valueOf(this.htmlIDNamespace) + "fixPNG(this)");
                }
            }
            this.writer.closeTag("img");
        }
        if (hasAction) {
            this.writer.closeTag("a");
        }
        if (tag != null) {
            this.writer.closeTag(tag);
        }
        this.writer.setEnableCompactMode(compactMode);
    }

    protected void outputImageStyleClassBookmark(IImageContent image, String tag) {
        boolean bookmarkOutput = false;
        if (this.metadataFilter != null) {
            bookmarkOutput = this.metadataEmitter.outputMetadataProperty(this.metadataFilter.needMetaData(HTMLEmitterUtil.getElementHandle(image)), image, tag);
        }
        String styleClass = image.getStyleClass();
        this.setStyleName(styleClass, image);
        if (!bookmarkOutput) {
            this.outputBookmark(image, "img");
        }
    }

    protected void outputSVGImage(IImageContent image, StringBuffer styleBuffer, int display) {
        this.writer.openTag("embed");
        this.outputImageStyleClassBookmark(image, "embed");
        String htmlBookmark = this.htmlIDNamespace != null ? String.valueOf(this.htmlIDNamespace) + image.getBookmark() : image.getBookmark();
        this.writer.attribute("onresize", "document.getElementById('" + htmlBookmark + "').reload()");
        this.writer.attribute("type", image.getMIMEType());
        this.writer.attribute("src", this.getImageURI(image));
        String altText = image.getAltText();
        if (altText == null) {
            this.writer.attributeAllowEmpty("alt", "");
        } else {
            this.writer.attribute("alt", altText);
        }
        if (this.enableMetadata) {
            this.writer.attribute("wmode", "transparent");
        }
        this.htmlEmitter.buildImageStyle(image, styleBuffer, display);
        this.writer.attribute("style", styleBuffer.toString());
        this.writer.closeTag("embed");
    }

    protected void resetImageDefaultBorders(IImageContent image, StringBuffer styleBuffer) {
        IStyle style = image.getStyle();
        if (style.getBorderTopStyle() == null) {
            styleBuffer.append("border-top-style:none;");
        } else if (style.getBorderTopColor() == null) {
            styleBuffer.append("border-top-color:black");
        }
        if (style.getBorderBottomStyle() == null) {
            styleBuffer.append("border-bottom-style:none;");
        } else if (style.getBorderBottomColor() == null) {
            styleBuffer.append("border-bottom-color:black");
        }
        if (style.getBorderLeftStyle() == null) {
            styleBuffer.append("border-left-style:none;");
        } else if (style.getBorderLeftColor() == null) {
            styleBuffer.append("border-left-color:black");
        }
        if (style.getBorderRightStyle() == null) {
            styleBuffer.append("border-right-style:none;");
        } else if (style.getBorderRightColor() == null) {
            styleBuffer.append("border-right-color:black");
        }
    }

    protected String getImageURI(IImageContent image) {
        String imgUri = null;
        if (this.imageHandler != null) {
            if (image.getImageSource() == 3) {
                return image.getURI();
            }
            Image img = new Image(image);
            img.setRenderOption(this.renderOption);
            img.setReportRunnable(this.runnable);
            switch (img.getSource()) {
                case 0: {
                    imgUri = this.imageHandler.onDesignImage((IImage)img, this.reportContext);
                    break;
                }
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)img, this.reportContext);
                    break;
                }
                case 1: {
                    imgUri = this.imageHandler.onDocImage((IImage)img, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)img, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)img, this.reportContext);
                    break;
                }
            }
        }
        return imgUri;
    }

    protected void setStyleName(String styleName, IContent content) {
        String name;
        DesignElementHandle handle;
        Object genBy;
        String metadataStyleClass;
        StringBuffer classBuffer = new StringBuffer();
        if (this.enableMetadata && (metadataStyleClass = this.metadataEmitter.getMetadataStyleClass(content)) != null) {
            classBuffer.append(metadataStyleClass);
        }
        if (!this.enableInlineStyle && styleName != null && styleName.length() > 0 && this.outputtedStyles.contains(styleName)) {
            if (classBuffer.length() != 0) {
                classBuffer.append(" ");
            }
            if (this.htmlIDNamespace != null) {
                classBuffer.append(this.htmlIDNamespace);
            }
            classBuffer.append(styleName);
        }
        if (this.hasCsslinks && (genBy = content.getGenerateBy()) instanceof StyledElementDesign && (handle = ((StyledElementDesign)genBy).getHandle()) != null && (name = handle.getStringProperty("style")) != null) {
            if (classBuffer.length() != 0) {
                classBuffer.append(" " + name);
            } else {
                classBuffer.append(name);
            }
        }
        if (classBuffer.length() != 0) {
            this.writer.attribute("class", classBuffer.toString());
        }
    }

    protected void outputBookmark(IContent content, String tagName) {
        String bookmark = content.getBookmark();
        this.outputBookmark(this.writer, tagName, this.htmlIDNamespace, bookmark);
    }

    public void outputBookmark(HTMLWriter writer, String tagName, String htmlIDNamespace, String bookmark) {
        HTMLEmitterUtil.setBookmark(writer, tagName, htmlIDNamespace, bookmark);
    }

    protected int checkElementType(DimensionType x, DimensionType y, IStyle style, StringBuffer styleBuffer) {
        return this.checkElementType(x, y, null, null, style, styleBuffer);
    }

    protected int checkElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style, StringBuffer styleBuffer) {
        return this.getElementType(x, y, width, height, style);
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        return this.htmlEmitter.getElementType(x, y, width, height, style);
    }

    protected String openTagByType(int display, int mask) {
        String tag = HTMLEmitterUtil.getTagByType(display, mask);
        if (tag != null) {
            this.writer.openTag(tag);
        }
        return tag;
    }

    protected boolean handleAction(IHyperlinkAction action) {
        String url = this.validate(action);
        return this.handleAction(action, url);
    }

    private boolean handleAction(IHyperlinkAction action, String url) {
        if (url != null) {
            this.outputAction(action, url);
        }
        return url != null;
    }

    protected void outputAction(IHyperlinkAction action, String url) {
        this.writer.openTag("a");
        this.writer.attribute("href", url);
        this.writer.attribute("target", action.getTargetWindow());
        this.writer.attribute("title", action.getTooltip());
    }

    private String validate(IHyperlinkAction action) {
        if (action == null) {
            return null;
        }
        String systemId = this.runnable == null ? null : this.runnable.getReportName();
        Action act = new Action(systemId, action);
        if (this.actionHandler == null) {
            return null;
        }
        String link = this.actionHandler.getURL((IAction)act, this.reportContext);
        if (link != null && !link.equals("")) {
            return link;
        }
        return null;
    }

    public String handleStyleImage(String uri) {
        return this.handleStyleImage(uri, false);
    }

    public String handleStyleImage(String uri, boolean isBackground) {
        ReportDesignHandle design = (ReportDesignHandle)this.runnable.getDesignHandle();
        URL url = design.findResource(uri, 1, this.reportContext.getAppContext());
        if (url == null) {
            return uri;
        }
        uri = url.toExternalForm();
        Image image = null;
        if (isBackground) {
            try {
                byte[] buffer = EmitterUtil.getImageData(uri);
                image = new Image(buffer, uri, ".jpg");
            }
            catch (Exception exception) {
                image = new Image(uri);
            }
        } else {
            image = new Image(uri);
        }
        image.setReportRunnable(this.runnable);
        image.setRenderOption(this.renderOption);
        String imgUri = null;
        if (this.imageHandler != null) {
            switch (image.getSource()) {
                case 2: {
                    imgUri = this.imageHandler.onURLImage((IImage)image, this.reportContext);
                    break;
                }
                case 3: {
                    imgUri = this.imageHandler.onFileImage((IImage)image, this.reportContext);
                    break;
                }
                case 4: {
                    imgUri = this.imageHandler.onCustomImage((IImage)image, this.reportContext);
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        return imgUri;
    }

    private void setupTemplateElement(TemplateDesign template, IContent content) {
        String allowedType;
        String bookmark = content.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            content.setBookmark(bookmark);
        }
        if ("ExtendedItem".equals(allowedType = template.getAllowedType())) {
            IStyle style = content.getStyle();
            style.setProperty(12, IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(3.0, "in"));
            content.setHeight(new DimensionType(3.0, "in"));
        } else if ("Table".equals(allowedType)) {
            IStyle style = content.getStyle();
            style.setProperty(12, IStyle.FALSE_VALUE);
            content.setWidth(new DimensionType(5.0, "in"));
            style.setProperty(49, IStyle.DOTTED_VALUE);
            style.setProperty(22, IStyle.DOTTED_VALUE);
            style.setProperty(52, IStyle.DOTTED_VALUE);
            style.setProperty(21, IStyle.DOTTED_VALUE);
            style.setProperty(55, IStyle.SANS_SERIF_VALUE);
        }
    }

    @Override
    public void endGroup(IGroupContent group) {
    }

    @Override
    public void endListBand(IListBandContent listBand) {
    }

    @Override
    public void endListGroup(IListGroupContent group) {
    }

    @Override
    public void endTableBand(ITableBandContent band) {
    }

    @Override
    public void endTableGroup(ITableGroupContent group) {
    }

    @Override
    public void startGroup(IGroupContent group) {
    }

    @Override
    public void startListBand(IListBandContent listBand) {
    }

    @Override
    public void startListGroup(IListGroupContent group) {
        this.outputBookmark(group);
    }

    @Override
    public void startTableBand(ITableBandContent band) {
    }

    @Override
    public void startTableGroup(ITableGroupContent group) {
        this.startedGroups.push(group);
    }

    private void outputBookmark(IGroupContent group) {
        String bookmark = group.getBookmark();
        if (bookmark == null) {
            bookmark = this.idGenerator.generateUniqueID();
            group.setBookmark(bookmark);
        }
        this.writer.openTag("span");
        this.outputBookmark(group, null);
        this.writer.closeTag("span");
    }

    private void writeBidiFlag() {
        if (this.htmlRtLFlag) {
            this.writer.attribute("dir", "rtl");
        }
    }

    private void retrieveRtLFlag() {
        ReportDesignHandle handle;
        HTMLRenderOption htmlOption = new HTMLRenderOption(this.renderOption);
        Object bidiFlag = htmlOption.getOption("RTLFlag");
        if (Boolean.TRUE.equals(bidiFlag)) {
            this.htmlRtLFlag = true;
        } else if (bidiFlag == null && this.report != null && (handle = this.report.getDesign().getReportDesign()) != null) {
            this.htmlRtLFlag = handle.isDirectionRTL();
            htmlOption.setHtmlRtLFlag(this.htmlRtLFlag);
        }
    }
}

