/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.InputParameterBinding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryExecutionHints;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.IModelAdapter;
import org.eclipse.birt.report.data.adapter.api.IQueryDefinitionUtil;
import org.eclipse.birt.report.engine.adapter.ExpressionUtil;
import org.eclipse.birt.report.engine.adapter.ITotalExprBindings;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.impl.ReportEngine;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IQueryContext;
import org.eclipse.birt.report.engine.extension.IReportItemQuery;
import org.eclipse.birt.report.engine.extension.internal.ExtensionManager;
import org.eclipse.birt.report.engine.extension.internal.QueryContext;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.RuleDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.TableHandle;

public class ReportQueryBuilder {
    protected static Logger logger = Logger.getLogger(ReportQueryBuilder.class.getName());
    private ExpressionUtil expressionUtil;
    private QueryBuilderVisitor queryBuilder;
    protected HashMap<IDataQueryDefinition, String> queryIDs;
    protected HashMap<IBaseQueryDefinition, ResultMetaData> resultMetaData;
    protected Collection<IDataQueryDefinition> queries;
    protected Report report;
    protected ExecutionContext context;
    protected int maxRows = 0;
    protected IQueryContext queryContext;
    protected DataRequestSession dteSession;
    protected Map<ReportItemHandle, List<ReportItemDesign>> unresolvedQueryReferences = new HashMap<ReportItemHandle, List<ReportItemDesign>>();

    public ReportQueryBuilder(Report report, ExecutionContext context, DataRequestSession dteSession) {
        this.expressionUtil = new ExpressionUtil();
        this.queryBuilder = this.createQueryBuilderVisitor();
        this.dteSession = dteSession;
        this.report = report;
        this.context = context;
        if (this.context != null) {
            EngineConfig engineConfig;
            ReportEngine engine;
            this.maxRows = this.context.getMaxRowsPerQuery();
            if (this.maxRows == -1 && (engine = this.context.getEngine()) != null && (engineConfig = engine.getConfig()) != null) {
                this.maxRows = engineConfig.getMaxRowsPerQuery();
            }
        }
        this.queryContext = new QueryContext(context, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        Report report = this.report;
        synchronized (report) {
            if (this.report.getQueries().isEmpty()) {
                this.queries = this.report.getQueries();
                this.queries.clear();
                this.queryIDs = this.report.getQueryIDs();
                this.queryIDs.clear();
                this.resultMetaData = this.report.getResultMetaData();
                this.resultMetaData.clear();
                int i = 0;
                while (i < this.report.getPageSetup().getMasterPageCount()) {
                    MasterPageDesign masterPage = this.report.getPageSetup().getMasterPage(i);
                    if (masterPage != null) {
                        SimpleMasterPageDesign pageDesign = (SimpleMasterPageDesign)masterPage;
                        int j = 0;
                        while (j < pageDesign.getHeaderCount()) {
                            this.build(null, pageDesign.getHeader(j));
                            ++j;
                        }
                        j = 0;
                        while (j < pageDesign.getFooterCount()) {
                            this.build(null, pageDesign.getFooter(j));
                            ++j;
                        }
                    }
                    ++i;
                }
                i = 0;
                while (i < this.report.getContentCount()) {
                    this.build(null, this.report.getContent(i));
                    ++i;
                }
                this.checkQueries();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataQueryDefinition[] build(IDataQueryDefinition parentQuery, ReportItemDesign design) {
        Report report = this.report;
        synchronized (report) {
            Object result;
            block17: {
                result = design.accept(this.queryBuilder, parentQuery);
                if (result != null) break block17;
                return null;
            }
            IDataQueryDefinition[] queries = (IDataQueryDefinition[])result;
            design.setQueries(queries);
            if (!design.useCachedResult()) {
                int i = 0;
                while (i < queries.length) {
                    IDataQueryDefinition query = queries[i];
                    if (query != null) {
                        String queryId = String.valueOf(design.getID());
                        if (i > 0) {
                            queryId = String.valueOf(queryId) + "_" + String.valueOf(i);
                        }
                        if (query instanceof IQueryDefinition) {
                            query.setName(queryId);
                        }
                        this.queryIDs.put(query, queryId);
                        if (query instanceof IBaseQueryDefinition) {
                            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)query;
                            ResultMetaData metaData = new ResultMetaData(baseQuery, design.getHandle());
                            this.resultMetaData.put(baseQuery, metaData);
                        }
                        this.registerQueryAndElement(query, design);
                        if (!(query instanceof ISubqueryDefinition)) {
                            this.queries.add(query);
                        } else if (query instanceof ISubqueryDefinition) {
                            IBaseQueryDefinition pQuery;
                            Collection subQueries;
                            if (!(parentQuery instanceof IBaseQueryDefinition)) {
                                this.context.addException(design.getHandle(), (BirtException)new EngineException("Error.SubqueryCreateError", design.getID()));
                            }
                            if (!(subQueries = (pQuery = (IBaseQueryDefinition)parentQuery).getSubqueries()).contains(query)) {
                                subQueries.add(query);
                            }
                        }
                    }
                    ++i;
                }
                this.registerQueryToHandle(design, queries);
                this.resolveQueryReference(design, queries);
                return queries;
            }
            int i = 0;
            while (i < queries.length) {
                IDataQueryDefinition query = queries[i];
                if (query instanceof IBaseQueryDefinition) {
                    IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)query;
                    ResultMetaData metaData = new ResultMetaData(baseQuery, design.getHandle());
                    this.resultMetaData.put(baseQuery, metaData);
                }
                ++i;
            }
            this.registerQueryToHandle(design, queries);
            this.resolveQueryReference(design, queries);
            return null;
        }
    }

    private void registerQueryAndElement(IDataQueryDefinition query, ReportItemDesign reportItem) {
        assert (query != null && reportItem != null);
        HashMap map = this.report.getReportItemToQueryMap();
        assert (map != null);
        map.put(query, reportItem);
    }

    private void registerQueryToHandle(ReportItemDesign reportItem, IDataQueryDefinition[] queries) {
        DesignElementHandle handle = reportItem.getHandle();
        assert (handle instanceof ReportItemHandle);
        ReportItemHandle itemHandle = (ReportItemHandle)handle;
        this.report.setQueryToReportHandle(itemHandle, queries);
    }

    private void resolveQueryReference(ReportItemDesign reportItem, IDataQueryDefinition[] queries) {
        DesignElementHandle handle = reportItem.getHandle();
        assert (handle instanceof ReportItemHandle);
        ReportItemHandle itemHandle = (ReportItemHandle)handle;
        if (this.unresolvedQueryReferences.containsKey(itemHandle)) {
            List<ReportItemDesign> items = this.unresolvedQueryReferences.get(itemHandle);
            int i = 0;
            while (i < items.size()) {
                ReportItemDesign item = items.get(i);
                this.build(null, item);
                ++i;
            }
            this.unresolvedQueryReferences.remove(itemHandle);
            i = 0;
            while (i < queries.length) {
                IDataQueryDefinition referenceQuery = queries[i];
                if (referenceQuery instanceof BaseQueryDefinition) {
                    ((BaseQueryDefinition)referenceQuery).setCacheQueryResults(true);
                } else if (referenceQuery instanceof ICubeQueryDefinition) {
                    ((ICubeQueryDefinition)referenceQuery).setCacheQueryResults(true);
                } else {
                    throw new IllegalStateException("unsupported query, report item: " + reportItem.getID());
                }
                ++i;
            }
        }
    }

    private void checkQueries() {
        HashSet<Object> failedIDs = new HashSet<Object>();
        for (List<ReportItemDesign> list : this.unresolvedQueryReferences.values()) {
            for (ReportItemDesign design : list) {
                failedIDs.add(design.getName() != null ? design.getName() : Long.valueOf(design.getID()));
            }
        }
        for (Object e : failedIDs) {
            EngineException ex = new EngineException("Error.QueryNotBuiltError", new Object[]{e});
            this.context.addException(ex);
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
    }

    protected QueryBuilderVisitor createQueryBuilderVisitor() {
        return new QueryBuilderVisitor();
    }

    protected class QueryBuilderVisitor
    extends DefaultReportItemVisitorImpl {
        private Boolean isBirt2_1_x;

        protected QueryBuilderVisitor() {
        }

        @Override
        public Object visitTemplate(TemplateDesign template, Object value) {
            return null;
        }

        @Override
        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            IDataQueryDefinition query;
            if (container.useCachedResult()) {
                query = this.getRefenceQuery(container);
                if (query == null) {
                    this.registerUnresolvedQueryReference(container);
                    return null;
                }
            } else {
                query = this.createQuery(container, (IDataQueryDefinition)value);
            }
            int i = 0;
            while (i < container.getItemCount()) {
                ReportQueryBuilder.this.build(query, container.getItem(i));
                ++i;
            }
            try {
                this.transformExpressions(container, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(container.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        @Override
        public Object visitGridItem(GridItemDesign grid, Object value) {
            IDataQueryDefinition query;
            if (grid.useCachedResult()) {
                query = this.getRefenceQuery(grid);
                if (query == null) {
                    this.registerUnresolvedQueryReference(grid);
                    return null;
                }
            } else {
                query = this.createQuery(grid, (IDataQueryDefinition)value);
            }
            int i = 0;
            while (i < grid.getRowCount()) {
                ReportQueryBuilder.this.build(query, grid.getRow(i));
                ++i;
            }
            try {
                this.transformExpressions(grid, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(grid.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        @Override
        public Object visitImageItem(ImageItemDesign image, Object value) {
            IDataQueryDefinition query;
            if (image.useCachedResult()) {
                query = this.getRefenceQuery(image);
                if (query == null) {
                    this.registerUnresolvedQueryReference(image);
                    return null;
                }
            } else {
                query = this.createQuery(image, (IDataQueryDefinition)value);
            }
            if (query != value && query instanceof BaseQueryDefinition) {
                this.setUsesDetails((BaseQueryDefinition)query);
            }
            try {
                if (image.getImageSource() == 2) {
                    Expression newImageExpression = this.transformExpression(image.getImageExpression(), query);
                    Expression newImageFormat = this.transformExpression(image.getImageFormat(), query);
                    image.setImageExpression(newImageExpression, newImageFormat);
                } else if (image.getImageSource() == 0) {
                    Expression newImageUri = this.transformExpression(image.getImageUri(), query);
                    image.setImageUri(newImageUri);
                } else if (image.getImageSource() == 3) {
                    Expression newImageUri = this.transformExpression(image.getImageUri(), query);
                    image.setImageFile(newImageUri);
                }
                this.transformExpressions(image, query);
                return this.getResultQuery(query, value);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(image.getHandle(), ex);
                return null;
            }
        }

        @Override
        public Object visitLabelItem(LabelItemDesign label, Object value) {
            IDataQueryDefinition query;
            if (label.useCachedResult()) {
                query = this.getRefenceQuery(label);
                if (query == null) {
                    this.registerUnresolvedQueryReference(label);
                    return null;
                }
            } else {
                query = this.createQuery(label, (IDataQueryDefinition)value);
            }
            if (query != value && query instanceof BaseQueryDefinition) {
                this.setUsesDetails((BaseQueryDefinition)query);
            }
            try {
                this.transformExpressions(label, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(label.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        @Override
        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            ExtendedItemHandle handle = (ExtendedItemHandle)item.getHandle();
            ReportItemHandle referenceHandle = this.getDataBindingReference(handle);
            if (referenceHandle != null) {
                IDataQueryDefinition[] queries = ReportQueryBuilder.this.report.getQueryByReportHandle(referenceHandle);
                if (queries != null && queries.length > 0) {
                    int i = 0;
                    while (i < queries.length) {
                        IDataQueryDefinition referenceQuery = queries[i];
                        if (referenceQuery instanceof BaseQueryDefinition) {
                            ((BaseQueryDefinition)referenceQuery).setCacheQueryResults(true);
                        } else if (referenceQuery instanceof ICubeQueryDefinition) {
                            ((ICubeQueryDefinition)referenceQuery).setCacheQueryResults(true);
                        }
                        ++i;
                    }
                    IDataQueryDefinition query = queries[0];
                    if (query instanceof IBaseQueryDefinition) {
                        try {
                            this.transformExpressions(item, (IBaseQueryDefinition)query);
                        }
                        catch (BirtException ex) {
                            ReportQueryBuilder.this.context.addException(item.getHandle(), ex);
                        }
                    }
                    return queries;
                }
                this.registerUnresolvedQueryReference(item);
                return null;
            }
            IReportItemQuery itemQuery = ReportQueryBuilder.this.context.getExtendedItemManager().createQuery(handle);
            IDataQueryDefinition[] queries = null;
            IDataQueryDefinition parentQuery = (IDataQueryDefinition)value;
            if (itemQuery != null) {
                try {
                    itemQuery.setModelObject(handle);
                    itemQuery.setQueryContext(ReportQueryBuilder.this.queryContext);
                    queries = itemQuery.createReportQueries(parentQuery);
                }
                catch (BirtException ex) {
                    ReportQueryBuilder.this.context.addException(handle, ex);
                }
                if (queries != null) {
                    IDataQueryDefinition query;
                    if (queries.length > 0 && (query = queries[0]) instanceof IBaseQueryDefinition) {
                        try {
                            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)query;
                            baseQuery.setMaxRows(ReportQueryBuilder.this.maxRows);
                            this.transformExpressions(item, baseQuery);
                            if (query instanceof ISubqueryDefinition) {
                                ISubqueryDefinition subQuery = (ISubqueryDefinition)query;
                                String name = String.valueOf(item.getID());
                                queries[0] = this.changeSubqueryName(subQuery, name);
                            }
                        }
                        catch (BirtException ex) {
                            ReportQueryBuilder.this.context.addException(handle, ex);
                        }
                    }
                    return queries;
                }
            }
            IDataQueryDefinition query = this.createQuery(item, parentQuery);
            try {
                this.transformExpressions(item, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(item.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        private SubqueryDefinition changeSubqueryName(ISubqueryDefinition subQuery, String name) throws DataException {
            IQueryDefinitionUtil queryCopyUtil = ReportQueryBuilder.this.dteSession.getQueryDefinitionUtil();
            SubqueryDefinition subqueryDefinition = queryCopyUtil.createSubqueryDefinition(name, subQuery);
            return subqueryDefinition;
        }

        @Override
        public Object visitListItem(ListItemDesign list, Object value) {
            IDataQueryDefinition query;
            if (list.useCachedResult()) {
                query = this.getRefenceQuery(list);
                if (query == null) {
                    this.registerUnresolvedQueryReference(list);
                    return null;
                }
            } else {
                query = this.createQuery(list, (IDataQueryDefinition)value);
            }
            BaseQueryDefinition baseQuery = (BaseQueryDefinition)query;
            if (query == null) {
                this.handleListingBand(list.getHeader(), baseQuery, true, null);
                this.handleListingBand(list.getFooter(), baseQuery, true, null);
            } else {
                this.handleListingQuery(list, baseQuery);
                this.handleListingBand(list.getHeader(), baseQuery, true, null);
                SlotHandle groupsSlot = ((ListHandle)list.getHandle()).getGroups();
                int i = 0;
                while (i < list.getGroupCount()) {
                    this.handleListingGroup(list.getGroup(i), (GroupHandle)groupsSlot.get(i), query);
                    ++i;
                }
                BandDesign detail = list.getDetail();
                this.setUsesDetails(detail, baseQuery);
                this.handleListingBand(detail, baseQuery, false, null);
                this.handleListingBand(list.getFooter(), baseQuery, true, null);
            }
            try {
                this.transformExpressions(list, baseQuery);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(list.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        @Override
        public Object visitReportItem(ReportItemDesign item, Object value) {
            return null;
        }

        @Override
        public Object visitTextItem(TextItemDesign text, Object value) {
            HashMap<String, Expression> exprs;
            IDataQueryDefinition query;
            if (text.useCachedResult()) {
                query = this.getRefenceQuery(text);
                if (query == null) {
                    this.registerUnresolvedQueryReference(text);
                    return null;
                }
            } else {
                query = this.createQuery(text, (IDataQueryDefinition)value);
            }
            if ((exprs = text.getExpressions()) != null) {
                for (Map.Entry<String, Expression> entry : exprs.entrySet()) {
                    try {
                        Expression newExpr = this.transformExpression(entry.getValue(), query);
                        entry.setValue(newExpr);
                    }
                    catch (BirtException ex) {
                        ReportQueryBuilder.this.context.addException(text.getHandle(), ex);
                        entry.setValue(null);
                    }
                }
            }
            if (query != value && query instanceof BaseQueryDefinition) {
                this.setUsesDetails((BaseQueryDefinition)query);
            }
            try {
                this.transformExpressions(text, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(text.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        public void handleColumn(ColumnDesign column, IDataQueryDefinition query) {
            try {
                this.transformColumnExpressions(column, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(column, ex);
            }
        }

        @Override
        public Object visitTableItem(TableItemDesign table, Object value) {
            IDataQueryDefinition query;
            if (table.useCachedResult()) {
                query = this.getRefenceQuery(table);
                if (query == null) {
                    this.registerUnresolvedQueryReference(table);
                    return null;
                }
            } else {
                query = this.createQuery(table, (IDataQueryDefinition)value);
            }
            BaseQueryDefinition baseQuery = (BaseQueryDefinition)query;
            if (query == null) {
                this.handleListingBand(table.getHeader(), baseQuery, true, null);
                this.handleListingBand(table.getFooter(), baseQuery, true, null);
            } else {
                this.handleListingQuery(table, baseQuery);
                int i = 0;
                while (i < table.getColumnCount()) {
                    this.handleColumn(table.getColumn(i), query);
                    ++i;
                }
                this.handleListingBand(table.getHeader(), baseQuery, true, null);
                SlotHandle groupsSlot = ((TableHandle)table.getHandle()).getGroups();
                int i2 = 0;
                while (i2 < table.getGroupCount()) {
                    this.handleListingGroup(table.getGroup(i2), (GroupHandle)groupsSlot.get(i2), baseQuery);
                    ++i2;
                }
                BandDesign detail = table.getDetail();
                this.setUsesDetails(detail, baseQuery);
                this.handleListingBand(detail, baseQuery, false, null);
                this.handleListingBand(table.getFooter(), baseQuery, true, null);
            }
            try {
                this.transformExpressions(table, baseQuery);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(table.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        private void setUsesDetails(BandDesign detail, BaseQueryDefinition baseQuery) {
            if (detail == null || detail.getContentCount() == 0) {
                if (!baseQuery.cacheQueryResults()) {
                    baseQuery.setUsesDetails(false);
                }
            } else {
                baseQuery.setUsesDetails(true);
            }
        }

        private void setUsesDetails(BaseQueryDefinition baseQuery) {
            if (baseQuery instanceof QueryDefinition && !baseQuery.cacheQueryResults()) {
                ((QueryDefinition)baseQuery).setIsSummaryQuery(true);
            }
            if (baseQuery != null && !baseQuery.cacheQueryResults()) {
                baseQuery.setUsesDetails(false);
            }
        }

        private void handleListingQuery(ListingDesign design, BaseQueryDefinition query) {
            QueryExecutionHints executionHints = new QueryExecutionHints();
            ListingHandle handle = (ListingHandle)design.getHandle();
            executionHints.setSortBeforeGrouping(handle.isSortByGroups());
            executionHints.setEnablePushDown(handle.pushDown());
            query.setQueryExecutionHints(executionHints);
        }

        @Override
        public Object visitDynamicTextItem(DynamicTextItemDesign dynamicText, Object value) {
            IDataQueryDefinition query;
            if (dynamicText.useCachedResult()) {
                query = this.getRefenceQuery(dynamicText);
                if (query == null) {
                    this.registerUnresolvedQueryReference(dynamicText);
                    return null;
                }
            } else {
                query = this.createQuery(dynamicText, (IDataQueryDefinition)value);
            }
            if (query != value && query instanceof BaseQueryDefinition) {
                this.setUsesDetails((BaseQueryDefinition)query);
            }
            try {
                Expression newContent = this.transformExpression(dynamicText.getContent(), query);
                dynamicText.setContent(newContent);
                this.transformExpressions(dynamicText, query);
                return this.getResultQuery(query, value);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(dynamicText.getHandle(), ex);
                return null;
            }
        }

        @Override
        public Object visitDataItem(DataItemDesign data, Object value) {
            IDataQueryDefinition query;
            if (data.useCachedResult()) {
                query = this.getRefenceQuery(data);
                if (query == null) {
                    this.registerUnresolvedQueryReference(data);
                    return null;
                }
            } else {
                query = this.createQuery(data, (IDataQueryDefinition)value);
            }
            if (query != value && query instanceof BaseQueryDefinition) {
                this.setUsesDetails((BaseQueryDefinition)query);
            }
            try {
                this.transformExpressions(data, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(data.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        public void handleListingBand(BandDesign band, IBaseQueryDefinition query, boolean onGroup, IGroupDefinition groupDefn) {
            if (band != null) {
                ArrayList subQueries = (ArrayList)((ArrayList)query.getSubqueries()).clone();
                int i = 0;
                while (i < band.getContentCount()) {
                    ReportQueryBuilder.this.build(query, band.getContent(i));
                    ++i;
                }
                ArrayList subQueriesChanged = (ArrayList)query.getSubqueries();
                if (subQueriesChanged != null) {
                    int i2 = 0;
                    while (i2 < subQueriesChanged.size()) {
                        SubqueryDefinition subQuery = (SubqueryDefinition)subQueriesChanged.get(i2);
                        if (!subQueries.contains(subQuery) && subQuery instanceof SubqueryDefinition) {
                            subQuery.setApplyOnGroupFlag(onGroup);
                            if (groupDefn != null) {
                                subQueriesChanged.remove(subQuery);
                                groupDefn.getSubqueries().add(subQuery);
                                --i2;
                            }
                        }
                        ++i2;
                    }
                }
            }
        }

        protected void handleListingGroup(GroupDesign group, GroupHandle handle, Object value) {
            IGroupDefinition groupDefn;
            assert (value instanceof IBaseQueryDefinition);
            IBaseQueryDefinition query = (IBaseQueryDefinition)value;
            if (!query.cacheQueryResults()) {
                IModelAdapter adaptor = ReportQueryBuilder.this.dteSession.getModelAdaptor();
                groupDefn = adaptor.adaptGroup(handle);
                query.getGroups().add(groupDefn);
            } else {
                groupDefn = this.getGroupDefinition(group, query);
            }
            if (groupDefn != null) {
                try {
                    this.transformExpressions(group, query, groupDefn.getName());
                }
                catch (BirtException ex) {
                    ReportQueryBuilder.this.context.addException(group.getHandle(), ex);
                }
                this.handleListingBand(group.getHeader(), query, true, groupDefn);
                this.handleListingBand(group.getFooter(), query, true, groupDefn);
            }
        }

        protected IGroupDefinition getGroupDefinition(GroupDesign design, IBaseQueryDefinition query) {
            String name = design.getName();
            List groups = query.getGroups();
            if (groups != null && groups.size() > 0) {
                int i = 0;
                while (i < groups.size()) {
                    IGroupDefinition group = (IGroupDefinition)groups.get(i);
                    if (group.getName().equals(name)) {
                        return group;
                    }
                    ++i;
                }
            }
            EngineException ex = new EngineException("Error.InvalidGroupError", name);
            logger.log(Level.WARNING, ex.getMessage(), ex);
            ReportQueryBuilder.this.context.addException(design.getHandle(), (BirtException)ex);
            return null;
        }

        @Override
        public Object visitRow(RowDesign row, Object value) {
            IDataQueryDefinition query;
            if (row.useCachedResult()) {
                query = this.getRefenceQuery(row);
                if (query == null) {
                    this.registerUnresolvedQueryReference(row);
                    return null;
                }
            } else {
                query = this.createQuery(row, (IDataQueryDefinition)value);
            }
            int i = 0;
            while (i < row.getCellCount()) {
                CellDesign cell = row.getCell(i);
                ReportQueryBuilder.this.build(query, cell);
                ++i;
            }
            try {
                this.transformExpressions(row, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(row.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        @Override
        public Object visitCell(CellDesign cell, Object value) {
            IDataQueryDefinition query;
            if (cell.useCachedResult()) {
                query = this.getRefenceQuery(cell);
                if (query == null) {
                    this.registerUnresolvedQueryReference(cell);
                    return null;
                }
            } else {
                query = this.createQuery(cell, (IDataQueryDefinition)value);
            }
            int i = 0;
            while (i < cell.getContentCount()) {
                ReportQueryBuilder.this.build(query, cell.getContent(i));
                ++i;
            }
            try {
                this.transformExpressions(cell, query);
            }
            catch (BirtException ex) {
                ReportQueryBuilder.this.context.addException(cell.getHandle(), ex);
            }
            return this.getResultQuery(query, value);
        }

        private IDataQueryDefinition[] getResultQuery(IDataQueryDefinition query, Object parent) {
            if (query != null && query != parent) {
                return new IDataQueryDefinition[]{query};
            }
            return null;
        }

        protected void registerUnresolvedQueryReference(ReportItemDesign item) {
            ReportItemHandle itemHandle = (ReportItemHandle)item.getHandle();
            ReportItemHandle referenceHandle = this.getDataBindingReference(itemHandle);
            if (ReportQueryBuilder.this.unresolvedQueryReferences.containsKey(referenceHandle)) {
                List<ReportItemDesign> items = ReportQueryBuilder.this.unresolvedQueryReferences.get(referenceHandle);
                items.add(item);
            } else {
                ArrayList<ReportItemDesign> items = new ArrayList<ReportItemDesign>();
                items.add(item);
                ReportQueryBuilder.this.unresolvedQueryReferences.put(referenceHandle, items);
            }
        }

        private ReportItemHandle getDataBindingReference(ReportItemHandle itemHandle) {
            ReportItemHandle referenceHandle = itemHandle.getDataBindingReference();
            if (referenceHandle == null) {
                return null;
            }
            ReportItemHandle tmpHandle = (ReportItemHandle)referenceHandle.getCurrentView();
            if (tmpHandle != null) {
                return tmpHandle;
            }
            tmpHandle = (ReportItemHandle)referenceHandle.getHostViewHandle();
            if (tmpHandle != null) {
                return tmpHandle.getCurrentView() == null ? tmpHandle : (ReportItemHandle)tmpHandle.getCurrentView();
            }
            return referenceHandle;
        }

        protected IDataQueryDefinition getRefenceQuery(ReportItemDesign item) {
            ReportItemHandle itemHandle = (ReportItemHandle)item.getHandle();
            ReportItemHandle referenceHandle = this.getDataBindingReference(itemHandle);
            IDataQueryDefinition[] queries = ReportQueryBuilder.this.report.getQueryByReportHandle(referenceHandle);
            if (queries != null && queries.length > 0) {
                int i = 0;
                while (i < queries.length) {
                    IDataQueryDefinition referenceQuery = queries[i];
                    if (referenceQuery instanceof BaseQueryDefinition) {
                        ((BaseQueryDefinition)referenceQuery).setCacheQueryResults(true);
                    }
                    ++i;
                }
                if (queries[0] instanceof BaseQueryDefinition) {
                    return (BaseQueryDefinition)queries[0];
                }
                throw new IllegalStateException("Can not support reference normal query to cube query");
            }
            return null;
        }

        protected IDataQueryDefinition createQuery(ReportItemDesign item, IDataQueryDefinition parent) {
            DesignElementHandle handle = item.getHandle();
            if (!(handle instanceof ReportItemHandle)) {
                if (!this.needQuery(item, parent)) {
                    return parent;
                }
                return this.createSubQuery(item, parent);
            }
            ReportItemHandle designHandle = (ReportItemHandle)handle;
            DataSetHandle dsHandle = designHandle.getDataSet();
            if (dsHandle == null) {
                String dsName = (String)designHandle.getProperty("dataSet");
                if (dsName != null && dsName.length() > 0) {
                    ReportQueryBuilder.this.context.addException(item.getHandle(), (BirtException)new EngineException("Error.UndefinedDatasetError", dsName));
                }
                if (!this.needQuery(item, parent)) {
                    return parent;
                }
                return this.createSubQuery(item, parent);
            }
            QueryDefinition query = new QueryDefinition(parent);
            query.setDataSetName(dsHandle.getQualifiedName());
            query.setMaxRows(ReportQueryBuilder.this.maxRows);
            if (designHandle instanceof TableHandle) {
                TableHandle listing = (TableHandle)designHandle;
                query.setIsSummaryQuery(listing.isSummaryTable());
            }
            query.getQueryExecutionHints().setEnablePushDown(designHandle.pushDown());
            this.addParamBinding(item, query);
            this.addColumnBinding(item, query);
            this.addSortAndFilter(item, query);
            return query;
        }

        protected BaseQueryDefinition createSubQuery(ReportItemDesign item, IDataQueryDefinition parent) {
            BaseQueryDefinition parentQuery = null;
            if (parent instanceof BaseQueryDefinition) {
                parentQuery = (BaseQueryDefinition)parent;
            }
            BaseQueryDefinition query = null;
            if (parentQuery == null) {
                query = new QueryDefinition(null);
            } else {
                String name = String.valueOf(item.getID());
                query = new SubqueryDefinition(name, parentQuery);
                parentQuery.getSubqueries().add(query);
            }
            query.setMaxRows(ReportQueryBuilder.this.maxRows);
            this.addColumnBinding(item, query);
            this.addSortAndFilter(item, query);
            return query;
        }

        private boolean needQuery(ReportItemDesign item, IDataQueryDefinition query) {
            DesignElementHandle handle = item.getHandle();
            if (handle instanceof ReportItemHandle) {
                ReportItemHandle designHandle = (ReportItemHandle)item.getHandle();
                if (designHandle.columnBindingsIterator().hasNext()) {
                    return true;
                }
                if (designHandle instanceof ListingHandle) {
                    return true;
                }
                if (designHandle instanceof ExtendedItemHandle) {
                    ExtendedItemHandle extHandle = (ExtendedItemHandle)designHandle;
                    return ExtensionManager.getInstance().getAllRows(extHandle.getExtensionName());
                }
            }
            return this.needQueryIn2_1_x(item, query);
        }

        private boolean needQueryIn2_1_x(ReportItemDesign item, IDataQueryDefinition query) {
            if (this.isBirt2_1_x()) {
                HighlightDesign highlight = item.getHighlight();
                if (query == null && highlight != null && highlight.getRuleCount() > 0) {
                    return true;
                }
            }
            return false;
        }

        private boolean isBirt2_1_x() {
            if (this.isBirt2_1_x == null) {
                String version;
                this.isBirt2_1_x = Boolean.FALSE;
                IReportDocument document = ReportQueryBuilder.this.context.getReportDocument();
                if (document != null && ((version = document.getVersion()) == "2.1.0" || version == "2.1.3")) {
                    this.isBirt2_1_x = Boolean.TRUE;
                }
            }
            return this.isBirt2_1_x;
        }

        private void addColumnBinding(ReportItemDesign design, IBaseQueryDefinition query) {
            DesignElementHandle elementHandle = design.getHandle();
            if (elementHandle instanceof ReportItemHandle) {
                IModelAdapter adaptor = ReportQueryBuilder.this.dteSession.getModelAdaptor();
                ReportItemHandle designHandle = (ReportItemHandle)elementHandle;
                Iterator iter = designHandle.columnBindingsIterator();
                if (iter != null) {
                    while (iter.hasNext()) {
                        try {
                            ComputedColumnHandle bindingHandle = (ComputedColumnHandle)iter.next();
                            IBinding binding = adaptor.adaptBinding(bindingHandle);
                            query.addBinding(binding);
                        }
                        catch (BirtException ex) {
                            ReportQueryBuilder.this.context.addException(design, ex);
                        }
                    }
                }
            }
        }

        private void addParamBinding(ReportItemDesign item, QueryDefinition query) {
            DesignElementHandle elementHandle = item.getHandle();
            if (elementHandle instanceof ReportItemHandle) {
                ReportItemHandle itemHandle = (ReportItemHandle)elementHandle;
                this.createParamBindings(itemHandle.paramBindingsIterator(), query.getInputParamBindings());
            }
        }

        private void addSortAndFilter(ReportItemDesign item, BaseQueryDefinition query) {
            if (item instanceof ListingDesign) {
                ListingHandle listHandle = (ListingHandle)item.getHandle();
                this.createSorts(listHandle.sortsIterator(), query.getSorts());
                this.createFilters(listHandle.filtersIterator(), query.getFilters());
            } else if (item instanceof ExtendedItemDesign) {
                ExtendedItemHandle extHandle = (ExtendedItemHandle)item.getHandle();
                this.createFilters(extHandle.filtersIterator(), query.getFilters());
            }
        }

        private void createFilters(Iterator iter, List filters) {
            if (iter != null) {
                while (iter.hasNext()) {
                    FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
                    FilterDefinition filter = ReportQueryBuilder.this.dteSession.getModelAdaptor().adaptFilter(filterHandle);
                    filters.add(filter);
                }
            }
        }

        private void createSorts(Iterator iter, List sorts) {
            if (iter != null) {
                IModelAdapter adaptor = ReportQueryBuilder.this.dteSession.getModelAdaptor();
                while (iter.hasNext()) {
                    SortKeyHandle handle = (SortKeyHandle)iter.next();
                    SortDefinition sort = adaptor.adaptSort(handle);
                    sorts.add(sort);
                }
            }
        }

        private void createParamBindings(Iterator iter, Collection bindings) {
            if (iter != null) {
                IModelAdapter adaptor = ReportQueryBuilder.this.dteSession.getModelAdaptor();
                while (iter.hasNext()) {
                    ParamBindingHandle handle = (ParamBindingHandle)iter.next();
                    InputParameterBinding binding = adaptor.adaptInputParamBinding(handle);
                    if (binding == null) continue;
                    bindings.add(binding);
                }
            }
        }

        private void transformExpressions(ReportItemDesign item, IDataQueryDefinition query) throws BirtException {
            this.transformExpressions(item, query, null);
        }

        private void transformExpressions(ReportItemDesign item, IDataQueryDefinition query, String groupName) throws BirtException {
            if (query != null) {
                ITotalExprBindings totalExpressionBindings = this.getNewExpressionBindings(item, query, groupName);
                this.addNewColumnBindings(query, totalExpressionBindings);
                this.replaceOldExpressions(item, totalExpressionBindings);
            }
        }

        protected Expression transformExpression(Expression expr, IDataQueryDefinition query) throws BirtException {
            if (expr == null) {
                return null;
            }
            if (query != null) {
                ArrayList<Expression> expressions = new ArrayList<Expression>();
                expressions.add(expr);
                ITotalExprBindings totalExpressionBinding = null;
                totalExpressionBinding = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, query);
                this.addNewColumnBindings(query, totalExpressionBinding);
                List<Expression> newExpressions = totalExpressionBinding.getNewExpression();
                return newExpressions.get(0);
            }
            return expr;
        }

        private void transformColumnExpressions(ColumnDesign column, IDataQueryDefinition query) throws BirtException {
            Expression expr;
            int i;
            HighlightDesign highlights;
            if (query == null) {
                return;
            }
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            VisibilityDesign visibilities = column.getVisibility();
            if (visibilities != null) {
                int i2 = 0;
                while (i2 < visibilities.count()) {
                    expressions.add(visibilities.getRule(i2).getExpression());
                    ++i2;
                }
            }
            if ((highlights = column.getHighlight()) != null) {
                int i3 = 0;
                while (i3 < highlights.getRuleCount()) {
                    HighlightRuleDesign rule = highlights.getRule(i3);
                    this.addRuleExpression(expressions, rule);
                    ++i3;
                }
            }
            ITotalExprBindings totalExpressionBindings = null;
            totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, query);
            this.addNewColumnBindings(query, totalExpressionBindings);
            int expressionIndex = 0;
            List<Expression> newExpressions = totalExpressionBindings.getNewExpression();
            if (visibilities != null) {
                i = 0;
                while (i < visibilities.count()) {
                    expr = newExpressions.get(expressionIndex++);
                    visibilities.getRule(i).setExpression(expr);
                    ++i;
                }
            }
            if (highlights != null) {
                i = 0;
                while (i < highlights.getRuleCount()) {
                    expr = newExpressions.get(expressionIndex++);
                    highlights.getRule(i).setConditionExpr(expr);
                    ++i;
                }
            }
        }

        private void replaceOldExpressions(ReportItemDesign item, ITotalExprBindings totalExpressionBindings) {
            ActionDesign action;
            Map<String, Expression> userProperties;
            VisibilityDesign visibilities;
            MapDesign maps;
            int expressionIndex = 0;
            List<Expression> newExpressions = totalExpressionBindings.getNewExpression();
            item.setTOC(newExpressions.get(expressionIndex++));
            item.setBookmark(newExpressions.get(expressionIndex++));
            Expression onCreateScript = newExpressions.get(expressionIndex++);
            Expression onRenderScript = newExpressions.get(expressionIndex++);
            Expression onPageBreakScript = newExpressions.get(expressionIndex++);
            item.setOnCreate(onCreateScript);
            item.setOnRender(onRenderScript);
            item.setOnPageBreak(onPageBreakScript);
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                int i = 0;
                while (i < highlights.getRuleCount()) {
                    highlights.getRule(i).setConditionExpr(newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((maps = item.getMap()) != null) {
                int i = 0;
                while (i < maps.getRuleCount()) {
                    maps.getRule(i).setConditionExpr(newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                int i = 0;
                while (i < visibilities.count()) {
                    visibilities.getRule(i).setExpression(newExpressions.get(expressionIndex++));
                    ++i;
                }
            }
            if ((userProperties = item.getUserProperties()) != null) {
                for (Map.Entry<String, Expression> entry : userProperties.entrySet()) {
                    entry.setValue(newExpressions.get(expressionIndex++));
                }
            }
            if ((action = item.getAction()) != null) {
                block0 : switch (action.getActionType()) {
                    case 2: {
                        action.setBookmark(newExpressions.get(expressionIndex++));
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        drillThrough.setBookmark(newExpressions.get(expressionIndex++));
                        Map<String, List<Expression>> params = drillThrough.getParameters();
                        if (params == null) break;
                        for (Map.Entry<String, List<Expression>> entry : params.entrySet()) {
                            if (expressionIndex >= newExpressions.size()) break block0;
                            Expression expr = newExpressions.get(expressionIndex++);
                            ArrayList<Expression> exprList = new ArrayList<Expression>();
                            exprList.add(expr);
                            entry.setValue(exprList);
                        }
                        break;
                    }
                    case 1: {
                        action.setHyperlink(newExpressions.get(expressionIndex++));
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
        }

        private ITotalExprBindings getNewExpressionBindings(ReportItemDesign item, IDataQueryDefinition query, String groupName) {
            ActionDesign action;
            Map<String, Expression> userProperties;
            VisibilityDesign visibilities;
            MapDesign maps;
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            expressions.add(item.getTOC());
            expressions.add(item.getBookmark());
            if (item.getOnCreate() != null) {
                expressions.add(item.getOnCreate());
            } else {
                expressions.add(null);
            }
            if (item.getOnRender() != null) {
                expressions.add(item.getOnRender());
            } else {
                expressions.add(null);
            }
            if (item.getOnPageBreak() != null) {
                expressions.add(item.getOnPageBreak());
            } else {
                expressions.add(null);
            }
            HighlightDesign highlights = item.getHighlight();
            if (highlights != null) {
                int i = 0;
                while (i < highlights.getRuleCount()) {
                    HighlightRuleDesign rule = highlights.getRule(i);
                    this.addRuleExpression(expressions, rule);
                    ++i;
                }
            }
            if ((maps = item.getMap()) != null) {
                int i = 0;
                while (i < maps.getRuleCount()) {
                    MapRuleDesign rule = maps.getRule(i);
                    this.addRuleExpression(expressions, rule);
                    ++i;
                }
            }
            if ((visibilities = item.getVisibility()) != null) {
                int i = 0;
                while (i < visibilities.count()) {
                    expressions.add(visibilities.getRule(i).getExpression());
                    ++i;
                }
            }
            if ((userProperties = item.getUserProperties()) != null) {
                for (Map.Entry<String, Expression> entry : userProperties.entrySet()) {
                    expressions.add(entry.getValue());
                }
            }
            if ((action = item.getAction()) != null) {
                switch (action.getActionType()) {
                    case 2: {
                        expressions.add(action.getBookmark());
                        break;
                    }
                    case 3: {
                        DrillThroughActionDesign drillThrough = action.getDrillThrough();
                        if (drillThrough == null) break;
                        expressions.add(drillThrough.getBookmark());
                        Map<String, List<Expression>> params = drillThrough.getParameters();
                        if (params == null) break;
                        for (Map.Entry<String, List<Expression>> entry : params.entrySet()) {
                            List<Expression> exprs = entry.getValue();
                            for (Expression expression : exprs) {
                                expressions.add(expression);
                            }
                        }
                        break;
                    }
                    case 1: {
                        expressions.add(action.getHyperlink());
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
            }
            ITotalExprBindings totalExpressionBindings = null;
            try {
                totalExpressionBindings = ReportQueryBuilder.this.expressionUtil.prepareTotalExpressions(expressions, groupName, query);
            }
            catch (EngineException ex) {
                ReportQueryBuilder.this.context.addException(item.getHandle(), (BirtException)ex);
            }
            return totalExpressionBindings;
        }

        private void addRuleExpression(List<Expression> expressions, RuleDesign rule) {
            if (rule != null) {
                Expression.Conditional highlightExpression = null;
                if (rule.ifValueIsList()) {
                    Expression testExpression = rule.getTestExpression();
                    List<Expression> value1List = rule.getValue1List();
                    highlightExpression = Expression.newConditional(ReportQueryBuilder.this.expressionUtil.createConditionExpression(testExpression, rule.getOperator(), value1List));
                } else {
                    Expression testExpression = rule.getTestExpression();
                    Expression value1 = rule.getValue1();
                    Expression value2 = rule.getValue2();
                    highlightExpression = Expression.newConditional(ReportQueryBuilder.this.expressionUtil.createConditionalExpression(testExpression, rule.getOperator(), value1, value2));
                }
                expressions.add(highlightExpression);
            }
        }

        protected void addNewColumnBindings(IDataQueryDefinition query, ITotalExprBindings totalExpressionBindings) throws BirtException {
            if (query instanceof IBaseQueryDefinition) {
                this.addQueryColumnBindings((IBaseQueryDefinition)query, totalExpressionBindings);
                return;
            }
            if (query instanceof ICubeQueryDefinition) {
                this.addCubeColumnBindings((ICubeQueryDefinition)query, totalExpressionBindings);
                return;
            }
            throw new EngineException("Error.UnsupportedQueryDefinitionError", query);
        }

        protected void addCubeColumnBindings(ICubeQueryDefinition query, ITotalExprBindings totalExpressionBindings) throws BirtException {
            IBinding[] bindings = totalExpressionBindings.getColumnBindings();
            if (bindings != null) {
                int i = 0;
                while (i < bindings.length) {
                    query.addBinding(bindings[i]);
                    ++i;
                }
            }
        }

        private void addQueryColumnBindings(IBaseQueryDefinition query, ITotalExprBindings totalExpressionBindings) throws BirtException {
            IBinding[] bindings = totalExpressionBindings.getColumnBindings();
            if (bindings != null) {
                int i = 0;
                while (i < bindings.length) {
                    bindings[i].setExportable(false);
                    query.addBinding(bindings[i]);
                    ++i;
                }
            }
        }
    }
}

