/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class LinkedDataSetUtil {
    private static String GET_LINKED_DATA_MODEL_METHOD = "getLinkedDataModel";
    private static String GET_MEASURES_METHOD = "getMeasures";
    private static String GET_NAME_METHOD = "getName";

    public static boolean bindToLinkedDataSet(ReportItemHandle reportItemHandle) {
        Method[] methods = reportItemHandle.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getName();
            if (name.equals(GET_LINKED_DATA_MODEL_METHOD)) {
                Object result = null;
                try {
                    result = methods[i].invoke((Object)reportItemHandle, new Object[0]);
                }
                catch (Exception exception) {
                    return false;
                }
                if (result != null) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean measureHasItsOwnAggregation(ReportItemHandle reportItemHandle, MeasureHandle cubeMeasure) throws Exception {
        Method[] methods = reportItemHandle.getClass().getMethods();
        int i = 0;
        while (i < methods.length) {
            Object result;
            String name = methods[i].getName();
            if (name.equals(GET_LINKED_DATA_MODEL_METHOD) && (result = methods[i].invoke((Object)reportItemHandle, new Object[0])) != null) {
                Method[] methodArray = methods = result.getClass().getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    if (method.getName().equals(GET_MEASURES_METHOD) && (result = method.invoke(result, new Object[0])) != null && result instanceof List) {
                        List list = (List)result;
                        for (Object object : list) {
                            Method[] objectMethods;
                            Method[] methodArray2 = objectMethods = object.getClass().getMethods();
                            int n3 = objectMethods.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Method objectMethod = methodArray2[n4];
                                if (objectMethod.getName().equals(GET_NAME_METHOD) && (result = objectMethod.invoke(object, new Object[0])) != null && result instanceof String && result.toString().equals(cubeMeasure.getName())) {
                                    return true;
                                }
                                ++n4;
                            }
                        }
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAggregationBinding(ComputedColumnHandle computed, ReportItemHandle handle) {
        if (computed.getAggregateFunction() != null) {
            return true;
        }
        try {
            Iterator iter = handle.columnBindingsIterator();
            HashSet aggregationBinding = new HashSet();
            LinkedDataSetUtil.populateAggregationBindingNames(aggregationBinding, iter);
            DataSetHandle dataSet = handle.getDataSet();
            if (dataSet != null && (iter = dataSet.computedColumnsIterator()) != null) {
                LinkedDataSetUtil.populateAggregationBindingNames(aggregationBinding, iter);
            }
            ArrayList<IColumnBinding> referedColumn = new ArrayList<IColumnBinding>();
            referedColumn.addAll(ExpressionUtil.extractColumnExpressions(computed.getExpression(), "dataSetRow"));
            referedColumn.addAll(ExpressionUtil.extractColumnExpressions(computed.getExpression(), "row"));
            int i = 0;
            while (true) {
                if (i >= referedColumn.size()) {
                    return false;
                }
                if (aggregationBinding.contains(referedColumn.get(i))) {
                    return true;
                }
                ++i;
            }
        }
        catch (BirtException birtException) {
            return false;
        }
    }

    private static void populateAggregationBindingNames(Set aggregationBinding, Iterator iter) throws BirtException {
        while (iter.hasNext()) {
            ComputedColumnHandle computedHandle = (ComputedColumnHandle)iter.next();
            if (computedHandle.getAggregateFunction() == null) continue;
            String columnName = null;
            columnName = ExpressionUtil.getColumnName(computedHandle.getExpression());
            if (columnName == null) {
                columnName = ExpressionUtil.getColumnBindingName(computedHandle.getExpression());
                if (columnName == null) continue;
                aggregationBinding.add(columnName);
                continue;
            }
            aggregationBinding.add(columnName);
        }
    }
}

