/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.executor.cache.SizeOfUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;

public class AggregationResultSetSaveUtil {
    private static String PREFIX_RESULTSET = "_ar_";

    public static void save(String name, IAggregationResultSet[] resultSets, IDocArchiveWriter writer) throws IOException {
        if (writer == null || name == null) {
            return;
        }
        RAOutputStream outputStream = writer.createRandomAccessStream(name);
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        if (resultSets == null) {
            dataOutputStream.writeInt(-1);
            return;
        }
        dataOutputStream.writeInt(resultSets.length);
        dataOutputStream.close();
        resultSets = AggregationResultSetSaveUtil.sortRsBeforeSaving(resultSets);
        int i = 0;
        while (i < resultSets.length) {
            outputStream = writer.createRandomAccessStream(String.valueOf(name) + PREFIX_RESULTSET + i);
            dataOutputStream = new DataOutputStream(outputStream);
            AggregationResultSetSaveUtil.saveOneResultSet(dataOutputStream, resultSets[i]);
            dataOutputStream.close();
            ++i;
        }
    }

    private static IAggregationResultSet[] sortRsBeforeSaving(IAggregationResultSet[] rs) {
        IAggregationResultSet result;
        ArrayList<IAggregationResultSet> sortedAggregateRs = new ArrayList<IAggregationResultSet>();
        IAggregationResultSet[] iAggregationResultSetArray = rs;
        int n = rs.length;
        int n2 = 0;
        while (n2 < n) {
            result = iAggregationResultSetArray[n2];
            if (result.getAggregationDefinition().getDrilledInfo() == null) {
                sortedAggregateRs.add(result);
            }
            ++n2;
        }
        iAggregationResultSetArray = rs;
        n = rs.length;
        n2 = 0;
        while (n2 < n) {
            result = iAggregationResultSetArray[n2];
            if (result.getAggregationDefinition().getDrilledInfo() != null) {
                sortedAggregateRs.add(result);
            }
            ++n2;
        }
        return sortedAggregateRs.toArray(new IAggregationResultSet[0]);
    }

    public static IAggregationResultSet[] load(String name, IDocArchiveReader reader, int version, long memoryCacheSize) throws IOException {
        int size;
        RAInputStream inputStream;
        FilterInputStream dataInputStream;
        block10: {
            dataInputStream = null;
            inputStream = reader.getStream(name);
            dataInputStream = new DataInputStream(inputStream);
            size = ((DataInputStream)dataInputStream).readInt();
            inputStream.close();
            if (size > 0) break block10;
            return null;
        }
        try {
            IAggregationResultSet[] result = new IAggregationResultSet[size];
            int i = 0;
            while (i < size) {
                inputStream = version != 20 ? reader.getStream(String.valueOf(name) + PREFIX_RESULTSET + i) : reader.getStream(String.valueOf(name) + i);
                dataInputStream = new DataInputStream(inputStream);
                if (size < 3) {
                    result[i] = AggregationResultSetSaveUtil.loadOneResultSet((DataInputStream)dataInputStream, memoryCacheSize / (long)size);
                } else if (size >= 3 && size < 5) {
                    result[i] = AggregationResultSetSaveUtil.loadOneResultSet((DataInputStream)dataInputStream, memoryCacheSize * 2L / (long)size);
                } else if (size >= 5) {
                    result[i] = AggregationResultSetSaveUtil.loadOneResultSet((DataInputStream)dataInputStream, memoryCacheSize * 3L / (long)size);
                }
                dataInputStream.close();
                ++i;
            }
            return result;
        }
        catch (IOException ex) {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
            throw ex;
        }
    }

    private static IAggregationResultSet loadOneResultSet(DataInputStream dataInputStream, long memoryCacheSize) throws IOException {
        String[] dimNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        String[] levelNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        DimLevel[] levels = null;
        if (dimNames != null && levelNames != null) {
            levels = new DimLevel[levelNames.length];
            int i = 0;
            while (i < levels.length) {
                levels[i] = new DimLevel(dimNames[i], levelNames[i]);
                ++i;
            }
        }
        String[][] keyNames = AggregationResultSetSaveUtil.convertToMDStringArray(AggregationResultSetSaveUtil.readMDObjectArray(dataInputStream));
        int[][] keyDataTypes = AggregationResultSetSaveUtil.readMDIntArray(dataInputStream);
        String[][] attributeNames = AggregationResultSetSaveUtil.convertToMDStringArray(AggregationResultSetSaveUtil.readMDObjectArray(dataInputStream));
        int[][] attributeDataTypes = AggregationResultSetSaveUtil.readMDIntArray(dataInputStream);
        int[] sortTypes = AggregationResultSetSaveUtil.readIntArray(dataInputStream);
        String[] aggregationNames = AggregationResultSetSaveUtil.convertToStringArray(AggregationResultSetSaveUtil.readObjectArray(dataInputStream));
        int[] aggregationDataType = AggregationResultSetSaveUtil.readIntArray(dataInputStream);
        int size = IOUtil.readInt(dataInputStream);
        int keySize = 0;
        if (keyDataTypes != null) {
            int i = 0;
            while (i < keyDataTypes.length) {
                if (keyDataTypes[i] != null) {
                    keySize += SizeOfUtil.getObjectSize(keyDataTypes[i]);
                }
                ++i;
            }
        }
        int attributeSize = 0;
        if (attributeDataTypes != null) {
            int i = 0;
            while (i < attributeDataTypes.length) {
                if (attributeDataTypes[i] != null) {
                    attributeSize += SizeOfUtil.getObjectSize(attributeDataTypes[i]);
                }
                ++i;
            }
        }
        int aggregationSize = 0;
        if (aggregationDataType != null) {
            aggregationSize += SizeOfUtil.getObjectSize(aggregationDataType);
        }
        int rowSize = 16 + (4 + (keySize + attributeSize + aggregationSize) - 1) / 8 * 8;
        int bufferSize = (int)(memoryCacheSize / (long)rowSize);
        return new CachedAggregationResultSet(dataInputStream, size, levels, sortTypes, keyNames, attributeNames, keyDataTypes, attributeDataTypes, aggregationNames, aggregationDataType, bufferSize);
    }

    private static String[] convertToStringArray(Object[] objs) {
        if (objs == null) {
            return null;
        }
        String[] result = new String[objs.length];
        System.arraycopy(objs, 0, result, 0, objs.length);
        return result;
    }

    private static String[][] convertToMDStringArray(Object[][] objs) {
        if (objs == null) {
            return null;
        }
        String[][] result = new String[objs.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.convertToStringArray(objs[i]);
            ++i;
        }
        return result;
    }

    private static void saveOneResultSet(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        AggregationResultSetSaveUtil.saveMetaData(outputStream, resultSet);
        AggregationResultSetSaveUtil.saveAggregationRowSet(outputStream, resultSet);
    }

    private static void saveAggregationRowSet(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        IOUtil.writeInt(outputStream, resultSet.length());
        int i = 0;
        while (i < resultSet.length()) {
            resultSet.seek(i);
            AggregationResultSetSaveUtil.saveAggregationRow(outputStream, resultSet.getCurrentRow());
            ++i;
        }
    }

    private static void saveAggregationRow(DataOutputStream outputStream, IAggregationResultRow resultRow) throws IOException {
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultRow.getFieldValues());
    }

    public static AggregationResultRow loadAggregationRow(DataInputStream inputStream) throws IOException {
        Object[] objects = AggregationResultSetSaveUtil.readObjectArray(inputStream);
        if (objects == null || objects.length == 0) {
            return null;
        }
        return (AggregationResultRow)AggregationResultRow.getCreator().createInstance(objects);
    }

    private static void saveMetaData(DataOutputStream outputStream, IAggregationResultSet resultSet) throws IOException {
        DimLevel[] levels = resultSet.getAllLevels();
        String[] dimensionNames = null;
        String[] levelNames = null;
        if (levels != null) {
            dimensionNames = new String[levels.length];
            levelNames = new String[levels.length];
            int i = 0;
            while (i < levels.length) {
                dimensionNames[i] = levels[i].getDimensionName();
                levelNames[i] = levels[i].getLevelName();
                ++i;
            }
        }
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, dimensionNames);
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, levelNames);
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultSet.getLevelKeys());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getLevelKeyDataType());
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, resultSet.getLevelAttributes());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getLevelAttributeDataType());
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getSortType());
        Object[] aggregationNames = new String[resultSet.getAggregationCount()];
        int i = 0;
        while (i < aggregationNames.length) {
            aggregationNames[i] = resultSet.getAggregationName(i);
            ++i;
        }
        AggregationResultSetSaveUtil.writeObjectArray(outputStream, aggregationNames);
        AggregationResultSetSaveUtil.writeIntArray(outputStream, resultSet.getAggregationDataType());
    }

    private static void writeObjectArray(DataOutputStream outputStream, Object[] objects) throws IOException {
        if (objects == null) {
            IOUtil.writeInt(outputStream, -1);
            return;
        }
        IOUtil.writeInt(outputStream, objects.length);
        int i = 0;
        while (i < objects.length) {
            IOUtil.writeObject(outputStream, objects[i]);
            ++i;
        }
    }

    private static Object[] readObjectArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt(inputStream);
        if (size == -1) {
            return null;
        }
        Object[] result = new Object[size];
        int i = 0;
        while (i < result.length) {
            result[i] = IOUtil.readObject(inputStream, DataEngineSession.getCurrentClassLoader());
            ++i;
        }
        return result;
    }

    private static Object[][] readMDObjectArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt(inputStream);
        if (size == -1) {
            return null;
        }
        Object[][] result = new Object[size][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.readObjectArray(inputStream);
            ++i;
        }
        return result;
    }

    private static void writeObjectArray(DataOutputStream outputStream, Object[][] objects) throws IOException {
        if (objects == null) {
            IOUtil.writeInt(outputStream, -1);
            return;
        }
        IOUtil.writeInt(outputStream, objects.length);
        int i = 0;
        while (i < objects.length) {
            AggregationResultSetSaveUtil.writeObjectArray(outputStream, objects[i]);
            ++i;
        }
    }

    private static int[] readIntArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt(inputStream);
        if (size == -1) {
            return null;
        }
        int[] result = new int[size];
        int i = 0;
        while (i < result.length) {
            result[i] = IOUtil.readInt(inputStream);
            ++i;
        }
        return result;
    }

    private static int[][] readMDIntArray(DataInputStream inputStream) throws IOException {
        int size = IOUtil.readInt(inputStream);
        if (size == -1) {
            return null;
        }
        int[][] result = new int[size][];
        int i = 0;
        while (i < result.length) {
            result[i] = AggregationResultSetSaveUtil.readIntArray(inputStream);
            ++i;
        }
        return result;
    }

    private static void writeIntArray(DataOutputStream outputStream, int[] iA) throws IOException {
        if (iA == null) {
            IOUtil.writeInt(outputStream, -1);
            return;
        }
        IOUtil.writeInt(outputStream, iA.length);
        int i = 0;
        while (i < iA.length) {
            IOUtil.writeInt(outputStream, iA[i]);
            ++i;
        }
    }

    private static void writeIntArray(DataOutputStream outputStream, int[][] iA) throws IOException {
        if (iA == null) {
            IOUtil.writeInt(outputStream, -1);
            return;
        }
        IOUtil.writeInt(outputStream, iA.length);
        int i = 0;
        while (i < iA.length) {
            AggregationResultSetSaveUtil.writeIntArray(outputStream, iA[i]);
            ++i;
        }
    }
}

