/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.executor.CandidateQuery;
import org.eclipse.birt.data.engine.executor.ComparatorUtil;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IQueryContextVisitor;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

class DataSource
implements IDataSource {
    private String driverName;
    private Map appContext;
    private Properties connectionProps = PropertySecurity.createProperties();
    private static Map<DataEngineSession, Map<ConnectionProp, Set<CacheConnection>>> dataEngineLevelConnectionPool = PropertySecurity.createHashMap();
    private HashMap statementMap = new HashMap();
    private static String className = DataSource.class.getName();
    private static Logger logger = Logger.getLogger(className);
    private DataEngineSession session;

    public DataSource(String driverName, Map connProperties, DataEngineSession session) {
        this.driverName = driverName;
        if (connProperties != null) {
            this.connectionProps.putAll((Map<?, ?>)connProperties);
        }
        this.session = session;
        this.session.getEngine().addShutdownListener(new ShutdownListener(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseConnection(DataEngineSession session) {
        try {
            Map<DataEngineSession, Map<ConnectionProp, Set<CacheConnection>>> map = dataEngineLevelConnectionPool;
            synchronized (map) {
                Map<ConnectionProp, Set<CacheConnection>> odaConnectionsMap = dataEngineLevelConnectionPool.remove(session);
                if (odaConnectionsMap == null) {
                    return;
                }
                for (Set<CacheConnection> set : odaConnectionsMap.values()) {
                    for (CacheConnection conn : set) {
                        try {
                            conn.odaConn.close();
                        }
                        catch (DataException e) {
                            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CacheConnection> getOdaConnections(boolean populateToCache) {
        Map<DataEngineSession, Map<ConnectionProp, Set<CacheConnection>>> map = dataEngineLevelConnectionPool;
        synchronized (map) {
            ConnectionProp connProp;
            Map<ConnectionProp, Set<CacheConnection>> odaConnectionsMap;
            if (dataEngineLevelConnectionPool.get(this.session) == null) {
                if (populateToCache) {
                    dataEngineLevelConnectionPool.put(this.session, new HashMap());
                } else {
                    return new HashSet<CacheConnection>();
                }
            }
            if ((odaConnectionsMap = dataEngineLevelConnectionPool.get(this.session)).get(connProp = new ConnectionProp(this.driverName, this.connectionProps, this.appContext)) == null) {
                odaConnectionsMap.put(connProp, new HashSet());
            }
            return odaConnectionsMap.get(connProp);
        }
    }

    String getDriverName() {
        return this.driverName;
    }

    @Override
    public void addProperty(String name, String value) throws DataException {
        if (this.isOpen()) {
            throw new DataException("data.engine.DataSourceIsOpen");
        }
        this.connectionProps.put(name, value);
    }

    @Override
    public void setAppContext(Map context) throws DataException {
        this.appContext = context;
    }

    public boolean isOpen() {
        return this.getOdaConnections(false).size() > 0;
    }

    @Override
    public void open() throws DataException {
        if (this.isOpen()) {
            return;
        }
        if (this.driverName == null || this.driverName.length() == 0) {
            return;
        }
        this.newConnection();
    }

    private CacheConnection newConnection() throws DataException {
        CacheConnection conn = new CacheConnection();
        conn.odaConn = ConnectionManager.getInstance().openConnection(this.driverName, this.connectionProps, this.appContext);
        int max = conn.odaConn.getMaxQueries();
        if (max != 0) {
            conn.maxStatements = max;
        }
        this.getOdaConnections(true).add(conn);
        return conn;
    }

    public CacheConnection getAvailableConnection() throws DataException {
        for (CacheConnection c : this.getOdaConnections(true)) {
            if (!c.odaConn.isOpen() || c.currentStatements >= c.maxStatements) continue;
            return c;
        }
        return this.newConnection();
    }

    @Override
    public IDataSourceQuery newQuery(String queryType, String queryText, boolean fromCache, IQueryContextVisitor qcv) throws DataException {
        if (fromCache) {
            return new DataSourceQuery(this.session);
        }
        return new org.eclipse.birt.data.engine.executor.DataSourceQuery(this, queryType, queryText, this.session, qcv);
    }

    @Override
    public ICandidateQuery newCandidateQuery(boolean fromCache) throws DataException {
        if (fromCache) {
            return new org.eclipse.birt.data.engine.executor.dscache.CandidateQuery(this.session);
        }
        return new CandidateQuery(this.session);
    }

    synchronized PreparedStatement prepareStatement(String queryText, String dataSetType, QuerySpecification querySpec) throws DataException {
        assert (this.isOpen());
        CacheConnection conn = this.getAvailableConnection();
        assert (conn.currentStatements < conn.maxStatements);
        ++conn.currentStatements;
        PreparedStatement stmt = conn.odaConn.prepareStatement(queryText, dataSetType, querySpec);
        this.statementMap.put(stmt, conn);
        return stmt;
    }

    synchronized void closeStatement(PreparedStatement stmt) {
        assert (stmt != null);
        CacheConnection conn = (CacheConnection)this.statementMap.remove(stmt);
        if (conn == null) {
            logger.logp(Level.WARNING, className, "closeStatement", "statement not found");
        } else {
            --conn.currentStatements;
            if (conn.currentStatements < 0) {
                logger.warning(String.valueOf(DataSource.class.getName()) + ".closeStatement: negative statement count for connection.");
            }
        }
        try {
            stmt.close();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, className, "closeStatement", "Exception at PreparedStatement.close()", e);
        }
    }

    @Override
    public boolean canClose() {
        return this.statementMap.size() == 0;
    }

    @Override
    public void close() {
        this.releaseDataSource();
    }

    private void releaseDataSource() {
        try {
            Set<CacheConnection> it;
            if (this.statementMap.size() > 0) {
                for (PreparedStatement stmt : this.statementMap.keySet()) {
                    try {
                        stmt.close();
                    }
                    catch (Exception e) {
                        logger.logp(Level.FINE, className, "close", "Exception at PreparedStatement.close()", e);
                    }
                }
                this.statementMap.clear();
            }
            if ((it = this.getOdaConnections(false)).size() > 1) {
                CacheConnection conn = it.iterator().next();
                conn.currentStatements = 0;
                it.remove(conn);
                for (CacheConnection connections : it) {
                    try {
                        connections.odaConn.close();
                    }
                    catch (Exception e) {
                        logger.logp(Level.FINE, className, "close", "Exception at Connection.close()", e);
                    }
                }
                it.clear();
                it.add(conn);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    static final class CacheConnection {
        Connection odaConn;
        int maxStatements = Integer.MAX_VALUE;
        int currentStatements = 0;

        CacheConnection() {
        }

        public void close() throws DataException {
            if (this.odaConn != null) {
                this.odaConn.close();
                this.odaConn = null;
            }
        }
    }

    private static final class ConnectionProp {
        private String driverName;
        private Properties props;
        private Map appContext;

        public ConnectionProp(String driverName, Properties connectionProps, Map appContext) {
            this.driverName = driverName;
            this.props = connectionProps;
            this.appContext = appContext;
        }

        public int hashCode() {
            return this.driverName == null ? 0 : this.driverName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionProp other = (ConnectionProp)obj;
            if (this.appContext == null ? other.appContext != null : !ComparatorUtil.isEqualProps(this.appContext, other.appContext)) {
                return false;
            }
            if (this.driverName == null ? other.driverName != null : !this.driverName.equals(other.driverName)) {
                return false;
            }
            return !(this.props == null ? other.props != null : !ComparatorUtil.isEqualProps(this.props, other.props));
        }
    }

    private static class ShutdownListener
    implements IShutdownListener {
        private DataEngineSession session;

        public ShutdownListener(DataEngineSession session) {
            this.session = session;
        }

        @Override
        public void dataEngineShutdown() {
            DataSource.releaseConnection(this.session);
        }
    }
}

