/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class BigDecimalCalculator
implements ICalculator {
    @Override
    public Number add(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return (BigDecimal)b;
        }
        if (b == null) {
            return (BigDecimal)a;
        }
        return ((BigDecimal)a).add((BigDecimal)b);
    }

    @Override
    public Number divide(Object dividend, Object divisor) throws DataException {
        if (dividend == null) {
            return null;
        }
        if (divisor == null) {
            return (BigDecimal)dividend;
        }
        return ((BigDecimal)dividend).divide((BigDecimal)divisor, MathContext.DECIMAL128);
    }

    @Override
    public Number multiply(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return (BigDecimal)b;
        }
        if (b == null) {
            return (BigDecimal)a;
        }
        return ((BigDecimal)a).multiply((BigDecimal)b);
    }

    @Override
    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        try {
            return this.divide(dividend, divisor);
        }
        catch (ArithmeticException arithmeticException) {
            return ifZero;
        }
    }

    @Override
    public Number subtract(Object a, Object b) throws DataException {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return BigDecimal.ZERO.subtract((BigDecimal)b);
        }
        if (b == null) {
            return (BigDecimal)a;
        }
        return ((BigDecimal)a).subtract((BigDecimal)b);
    }

    @Override
    public Object getTypedObject(Object obj) throws DataException {
        try {
            return DataTypeUtil.toBigDecimal(obj);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

