/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;

public class ChartExpressionUtil {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine/trace");

    protected static boolean isBinding(String indicator, String expr, boolean hasOperation) {
        if (expr == null) {
            return false;
        }
        if (hasOperation) {
            Matcher m = Pattern.compile(".*\\Q" + indicator + "[\"\\E.*\\Q\"]\\E.*", 32).matcher(expr);
            return m.matches();
        }
        String regExp = "\\Q" + indicator + "[\"\\E.*\\Q\"]\\E";
        String regExp2 = "\\Q" + indicator + "[\"\\E.*\\Q" + indicator + "[\"\\E.*\\Q\"]\\E";
        return expr.matches(regExp) && !expr.matches(regExp2);
    }

    protected static String getBindingName(String indicator, String expr, boolean hasOperation) {
        if (ChartExpressionUtil.isBinding(indicator, expr, hasOperation)) {
            try {
                List<IColumnBinding> bindings = ExpressionUtil.extractColumnExpressions(expr, indicator);
                if (!bindings.isEmpty()) {
                    return bindings.get(0).getResultSetColumnName();
                }
            }
            catch (BirtException e) {
                logger.log(e);
            }
        }
        return null;
    }

    private static void fillBindingNameCollection(Collection<String> names, String indicator, String expr) {
        try {
            List<IColumnBinding> bindings = ExpressionUtil.extractColumnExpressions(expr, indicator);
            for (IColumnBinding binding : bindings) {
                names.add(binding.getResultSetColumnName());
            }
        }
        catch (BirtException e) {
            logger.log(e);
        }
    }

    protected static List<String> getBindingNameList(String indicator, String expr) {
        ArrayList<String> names = new ArrayList<String>();
        ChartExpressionUtil.fillBindingNameCollection(names, indicator, expr);
        return names;
    }

    private static String getRowBindingName(String expr, boolean hasOperation) {
        return ChartExpressionUtil.getBindingName("row", expr, hasOperation);
    }

    private static String getCubeBindingName(String expr, boolean hasOperation) {
        return ChartExpressionUtil.getBindingName("data", expr, hasOperation);
    }

    private static boolean isRowBinding(String expr, boolean hasOperation) {
        return ChartExpressionUtil.isBinding("row", expr, hasOperation);
    }

    private static boolean isCubeBinding(String expr, boolean hasOperation) {
        return ChartExpressionUtil.isBinding("data", expr, hasOperation);
    }

    private static List<String> getCubeBindingNameList(String expr) {
        return ChartExpressionUtil.getBindingNameList("data", expr);
    }

    private static Set<String> getRowBindingNameSet(String expr) {
        HashSet<String> names = new HashSet<String>();
        ChartExpressionUtil.fillBindingNameCollection(names, "row", expr);
        return names;
    }

    private static boolean isMeasureExpresion(String expression) {
        return expression != null && expression.matches("\\Qmeasure[\"\\E.*\\Q\"]\\E");
    }

    private static String getMeasureName(String expr) {
        if (ChartExpressionUtil.isMeasureExpresion(expr)) {
            try {
                return ExpressionUtil.getReferencedMeasure(expr);
            }
            catch (BirtException e) {
                logger.log(e);
            }
        }
        return null;
    }

    private static boolean isDimensionExpresion(String expression) {
        return expression != null && expression.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    private static String[] getLevelNameFromDimensionExpression(String expr) {
        if (ChartExpressionUtil.isDimensionExpresion(expr)) {
            try {
                Set<IDimLevel> levels = ExpressionUtil.getReferencedDimLevel(expr);
                if (!levels.isEmpty()) {
                    IDimLevel level = levels.iterator().next();
                    return new String[]{level.getDimensionName(), level.getLevelName(), level.getAttrName()};
                }
            }
            catch (BirtException e) {
                logger.log(e);
            }
        }
        return null;
    }

    public static boolean checkStringInExpression(String expression) {
        boolean haveString = false;
        int squareBracketPairingCount = 0;
        int i = 0;
        while (i < expression.length()) {
            if (expression.charAt(i) == '[') {
                ++squareBracketPairingCount;
            }
            if (expression.charAt(i) == ']') {
                --squareBracketPairingCount;
            }
            if (expression.charAt(i) == '\"') {
                if (squareBracketPairingCount != 0) {
                    haveString = false;
                } else {
                    if (i == 0 || i == expression.length() - 1) {
                        haveString = true;
                        break;
                    }
                    boolean isStrOperation = false;
                    int j = i - 1;
                    while (j >= 0) {
                        if (expression.charAt(j) != ' ') {
                            if (expression.charAt(j) != '+' || expression.charAt(j) != '-') {
                                isStrOperation = true;
                                break;
                            }
                            isStrOperation = false;
                            break;
                        }
                        --j;
                    }
                    if (isStrOperation) {
                        haveString = true;
                        break;
                    }
                    if (expression.charAt(i - 1) != '[' && expression.charAt(i + 1) != ']') {
                        haveString = true;
                        break;
                    }
                }
            }
            ++i;
        }
        return haveString;
    }

    public static String escapeSpecialCharacters(String expression) {
        return expression.replaceAll("\\\\\"", "").replaceAll("\"", "").replaceAll("\\n", "").replaceAll(new String(new char[]{'\uffff'}), "").replaceAll("\\r", "");
    }

    public static String createBindingExpression(String bindingName, boolean isCube) {
        StringBuilder sb = new StringBuilder();
        if (isCube) {
            sb.append("data");
        } else {
            sb.append("row");
        }
        sb.append("[\"");
        sb.append(JavascriptEvalUtil.transformToJsConstants(bindingName));
        sb.append("\"]");
        return sb.toString();
    }

    public static class ExpressionCodec {
        public static final String JAVASCRIPT = "javascript";
        public static final String CONSTANT = "constant";
        protected String sType = "javascript";
        protected String sExpr = "";

        public String encode() {
            return this.sExpr;
        }

        public void decode(String sExpr) {
            this.setExpression(sExpr);
        }

        public String getType() {
            return this.sType;
        }

        public void setType(String type) {
            this.sType = type;
        }

        public String getExpression() {
            return this.sExpr;
        }

        public void setExpression(String sExpr) {
            if (sExpr == null) {
                this.sExpr = null;
                return;
            }
            this.sExpr = sExpr.trim();
        }

        public boolean isConstant() {
            return CONSTANT.equals(this.getType());
        }

        public String convertJSExpression(boolean isRow) {
            return this.sExpr;
        }

        public ExpressionCodec copy() {
            ExpressionCodec instance = new ExpressionCodec();
            instance.setType(this.getType());
            instance.setExpression(this.getExpression());
            return instance;
        }

        public boolean isCubeBinding(boolean hasOperation) {
            return ChartExpressionUtil.isCubeBinding(this.sExpr, hasOperation);
        }

        public boolean isCubeBinding(String expr, boolean hasOperation) {
            this.decode(expr);
            return this.isCubeBinding(hasOperation);
        }

        public String getCubeBindingName(boolean hasOperation) {
            return ChartExpressionUtil.getCubeBindingName(this.sExpr, hasOperation);
        }

        public String getCubeBindingName(String expr, boolean hasOperation) {
            this.decode(expr);
            return this.getCubeBindingName(hasOperation);
        }

        public List<String> getCubeBindingNameList() {
            return ChartExpressionUtil.getCubeBindingNameList(this.sExpr);
        }

        public List<String> getCubeBindingNameList(String expr) {
            this.decode(expr);
            return this.getCubeBindingNameList();
        }

        public boolean isRowBinding(boolean hasOperation) {
            return ChartExpressionUtil.isRowBinding(this.sExpr, hasOperation);
        }

        public boolean isRowBinding(String expr, boolean hasOperation) {
            this.decode(expr);
            return this.isRowBinding(hasOperation);
        }

        public String getRowBindingName(boolean hasOperation) {
            return ChartExpressionUtil.getRowBindingName(this.sExpr, hasOperation);
        }

        public String getRowBindingName(String expr, boolean hasOperation) {
            this.decode(expr);
            return this.getRowBindingName(hasOperation);
        }

        public Set<String> getRowBindingNameSet() {
            return ChartExpressionUtil.getRowBindingNameSet(this.sExpr);
        }

        public Set<String> getRowBindingNameSet(String expr) {
            this.decode(expr);
            return this.getRowBindingNameSet();
        }

        public String getFullBindingName() {
            if (this.isRowBinding(true)) {
                if (this.isRowBinding(false)) {
                    return this.getRowBindingName(false);
                }
                return ChartExpressionUtil.escapeSpecialCharacters(this.sExpr);
            }
            if (this.isCubeBinding(true)) {
                if (this.isCubeBinding(false)) {
                    return this.getCubeBindingName(false);
                }
                return ChartExpressionUtil.escapeSpecialCharacters(this.sExpr);
            }
            return ChartExpressionUtil.escapeSpecialCharacters(this.sExpr);
        }

        public String getFullBindingName(String expr) {
            this.decode(expr);
            return this.getFullBindingName();
        }

        public void setBindingName(String bindingName, boolean isCube, String type) {
            this.sType = type;
            this.setBindingName(bindingName, isCube);
        }

        public void setBindingName(String bindingName, boolean isCube) {
            this.sExpr = ChartExpressionUtil.createBindingExpression(bindingName, isCube);
        }

        public boolean isBinding(boolean hasOperation) {
            if (this.isRowBinding(hasOperation)) {
                return true;
            }
            return this.isCubeBinding(hasOperation);
        }

        public boolean isBinding(String expr, boolean hasOperation) {
            this.decode(expr);
            return this.isBinding(hasOperation);
        }

        public Collection<String> getBindingNames() {
            HashSet<String> set = new HashSet<String>();
            set.addAll(this.getRowBindingNameSet());
            set.addAll(this.getCubeBindingNameList());
            return set;
        }

        public Collection<String> getBindingNames(String expr) {
            this.decode(expr);
            return this.getBindingNames();
        }

        public String getBindingName() {
            String name = this.getRowBindingName(false);
            if (name != null) {
                return name;
            }
            return this.getCubeBindingName(false);
        }

        public String getBindingName(String expr) {
            this.decode(expr);
            return this.getBindingName();
        }

        public boolean isDimensionExpresion() {
            return ChartExpressionUtil.isDimensionExpresion(this.sExpr);
        }

        public boolean isDimensionExpresion(String expr) {
            this.decode(expr);
            return this.isDimensionExpresion();
        }

        public boolean isMeasureExpresion() {
            return ChartExpressionUtil.isMeasureExpresion(this.sExpr);
        }

        public boolean isMeasureExpresion(String expr) {
            this.decode(expr);
            return this.isMeasureExpresion();
        }

        public String[] getLevelNames() {
            return ChartExpressionUtil.getLevelNameFromDimensionExpression(this.sExpr);
        }

        public String[] getLevelNames(String expr) {
            this.decode(expr);
            return this.getLevelNames();
        }

        public String getMeasureName() {
            return ChartExpressionUtil.getMeasureName(this.sExpr);
        }

        public String getMeasureName(String expr) {
            this.decode(expr);
            return this.getMeasureName();
        }
    }

    public static class ExpressionSet
    extends LinkedHashSet<String> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean add(String e) {
            if (e == null) {
                return false;
            }
            if ((e = e.trim()).length() == 0) {
                return false;
            }
            return super.add(e);
        }
    }
}

