/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.extension.IStyleDeclaration;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ArgumentInfo;
import org.eclipse.birt.report.model.metadata.ArgumentInfoList;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionChoice;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.OverridePropertyInfo;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class PeerExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.reportItemModel";
    private static final String ELEMENT_TAG = "reportItem";

    public PeerExtensionLoader() {
        super(EXTENSION_POINT);
    }

    @Override
    protected void doLoad() {
        super.doLoad();
        List<IElementDefn> extensions = MetaDataDictionary.getInstance().getExtensions();
        if (extensions == null || extensions.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < extensions.size()) {
            ElementDefn defn = (ElementDefn)extensions.get(i);
            try {
                defn.build();
            }
            catch (MetaDataException e) {
                this.handleError(new MetaDataParserException(e, "EXTENSION_ERROR").getMessage());
            }
            ++i;
        }
    }

    @Override
    protected void loadExtension(IExtension extension) {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        PeerExtensionElementLoader loader = new PeerExtensionElementLoader();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement currentTag = configElements[i];
            if (ELEMENT_TAG.equals(currentTag.getName())) {
                loader.loadElement(currentTag);
            }
            ++i;
        }
    }

    private ExtensionPropertyDefn addDefnTo(ExtensionElementDefn elementDefn, MethodInfo methodInfo) {
        ExtensionPropertyDefn extPropDefn = new ExtensionPropertyDefn(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
        PropertyType typeDefn = MetaDataDictionary.getInstance().getPropertyType(18);
        String name = methodInfo.getName();
        String displayNameID = methodInfo.getDisplayNameKey();
        extPropDefn.setName(name);
        extPropDefn.setDisplayNameID(displayNameID);
        extPropDefn.setType(typeDefn);
        extPropDefn.setGroupNameKey(null);
        extPropDefn.setCanInherit(true);
        extPropDefn.setIntrinsic(false);
        extPropDefn.setStyleProperty(false);
        extPropDefn.setDetails(methodInfo);
        extPropDefn.setContext(methodInfo.getContext());
        return extPropDefn;
    }

    class PeerExtensionElementLoader
    extends ExtensionLoader.ExtensionElementLoader {
        protected static final String PROPERTY_TAG = "property";
        protected static final String CHOICE_TAG = "choice";
        protected static final String PROPERTY_GROUP_TAG = "propertyGroup";
        protected static final String PROPERTY_VISIBILITY_TAG = "propertyVisibility";
        protected static final String STYLE_PROPERTY_TAG = "styleProperty";
        protected static final String METHOD_TAG = "method";
        protected static final String ARGUMENT_TAG = "argument";
        protected static final String STYLE_TAG = "style";
        protected static final String ELEMENT_TYPE_TAG = "elementType";
        protected static final String OVERRIDE_PROPERTY_TAG = "overrideProperty";
        protected static final String JAVA_DOC_TAG = "javaDoc";
        protected static final String NAME_ATTRIB = "name";
        protected static final String PROPERTY_NAME_ATTRIB = "propertyName";
        protected static final String ALLOWEDCHOICES_ATTRIB = "allowedChoices";
        protected static final String ALLOWEDUNITS_ATTRIB = "allowedUnits";
        protected static final String DISPLAY_NAME_ID_ATTRIB = "displayNameID";
        protected static final String TYPE_ATTRIB = "type";
        protected static final String CAN_INHERIT_ATTRIB = "canInherit";
        protected static final String DEFAULT_VALUE_ATTRIB = "defaultValue";
        protected static final String VALUE_ATTRIB = "value";
        protected static final String VISIBILITY_ATTRIB = "visibility";
        protected static final String DEFAULT_DISPLAY_NAME_ATTRIB = "defaultDisplayName";
        protected static final String IS_ENCRYPTABLE_ATTRIB = "isEncryptable";
        protected static final String TOOL_TIP_ID_ATTRIB = "toolTipID";
        protected static final String RETURN_TYPE_ATTRIB = "returnType";
        protected static final String TAG_ID_ATTRIB = "tagID";
        protected static final String IS_STATIC_ATTRIB = "isStatic";
        protected static final String DEFAULT_STYLE_ATTRIB = "defaultStyle";
        protected static final String HAS_STYLE = "hasStyle";
        protected static final String IS_NAME_REQUIRED_ATTRIB = "isNameRequired";
        protected static final String EXTENDS_FROM_ATTRIB = "extendsFrom";
        protected static final String DETAIL_TYPE_ATTRIB = "detailType";
        protected static final String SUB_TYPE_ATTRIB = "subType";
        protected static final String IS_LIST_ATTRIB = "isList";
        private static final String HAS_OWN_MODEL = "hasOwnModel";
        private static final String USE_OWN_SEARCH = "useOwnSearch";
        private static final String CONTEXT_ATTRIB = "context";
        private static final String ALLOW_EXPRESSION_ATTRIB = "allowExpression";
        private static final String THEME_TYPE_ATTRIB = "themeType";
        List<IPropertyType> allowedPropertyTypes;
        List<IPropertyType> allowedSubPropertyTypes;

        PeerExtensionElementLoader() {
            super(PeerExtensionLoader.this);
            this.allowedPropertyTypes = null;
            this.allowedSubPropertyTypes = null;
        }

        @Override
        void loadElement(IConfigurationElement elementTag) {
            int i;
            String extensionName = elementTag.getAttribute("extensionName");
            String className = elementTag.getAttribute("class");
            if (!this.checkRequiredAttribute("extensionName", extensionName) || !this.checkRequiredAttribute("class", className)) {
                return;
            }
            String displayNameID = elementTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String defaultStyle = elementTag.getAttribute(DEFAULT_STYLE_ATTRIB);
            boolean hasStyle = this.getBooleanAttrib(elementTag, HAS_STYLE, true);
            boolean isNameRequired = this.getBooleanAttrib(elementTag, IS_NAME_REQUIRED_ATTRIB, false);
            String extendsFrom = elementTag.getAttribute(EXTENDS_FROM_ATTRIB);
            if (StringUtil.isBlank(extendsFrom)) {
                extendsFrom = "ExtendedItem";
            }
            IReportItemFactory factory = null;
            PeerExtensionElementDefn elementDefn = null;
            try {
                factory = (IReportItemFactory)elementTag.createExecutableExtension("class");
                elementDefn = new PeerExtensionElementDefn(extensionName, factory);
                elementDefn.setAbstract(false);
                elementDefn.setAllowsUserProperties(false);
                elementDefn.setCanExtend(true);
                elementDefn.setDisplayNameKey(displayNameID);
                elementDefn.setExtends(extendsFrom);
                elementDefn.setJavaClass(null);
                elementDefn.setSelector(defaultStyle);
                elementDefn.setHasStyle(hasStyle);
                if (isNameRequired) {
                    elementDefn.setNameOption(2);
                } else {
                    elementDefn.setNameOption(1);
                }
                elementDefn.setNameSpaceID("element");
                IConfigurationElement[] elements = elementTag.getChildren();
                i = 0;
                while (i < elements.length) {
                    try {
                        ExtensionPropertyDefn extPropDefn;
                        if (PROPERTY_TAG.equalsIgnoreCase(elements[i].getName())) {
                            extPropDefn = this.loadProperty(elementTag, elements[i], elementDefn);
                            if (extPropDefn != null) {
                                elementDefn.addProperty(extPropDefn);
                            }
                        } else if (PROPERTY_VISIBILITY_TAG.equalsIgnoreCase(elements[i].getName())) {
                            this.loadPropertyVisibility(elements[i], elementDefn);
                        } else if (PROPERTY_GROUP_TAG.equalsIgnoreCase(elements[i].getName())) {
                            this.loadPropertyGroup(elementTag, elements[i], elementDefn);
                        } else if (!STYLE_PROPERTY_TAG.equalsIgnoreCase(elements[i].getName())) {
                            if (METHOD_TAG.equalsIgnoreCase(elements[i].getName())) {
                                extPropDefn = this.loadMethod(elementTag, elements[i], elementDefn);
                                if (extPropDefn != null) {
                                    elementDefn.addProperty(extPropDefn);
                                }
                            } else if (STYLE_TAG.equalsIgnoreCase(elements[i].getName())) {
                                PredefinedStyle style = this.loadStyle(elementTag, elements[i]);
                                MetaDataDictionary.getInstance().addPredefinedStyle(style);
                            } else if (OVERRIDE_PROPERTY_TAG.equalsIgnoreCase(elements[i].getName())) {
                                this.loadOverrideProperty(elements[i], elementDefn);
                            }
                        }
                    }
                    catch (ExtensionException e) {
                        PeerExtensionLoader.this.handleError(e);
                    }
                    catch (MetaDataException e) {
                        PeerExtensionLoader.this.handleError(e);
                    }
                    ++i;
                }
            }
            catch (FrameworkException frameworkException) {
                PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE"));
                return;
            }
            elementDefn.extensionPoint = PeerExtensionLoader.EXTENSION_POINT;
            try {
                MetaDataDictionary.getInstance().addExtension(elementDefn);
            }
            catch (MetaDataException e) {
                PeerExtensionLoader.this.handleError(e);
            }
            IStyleDeclaration[] styles = factory.getFactoryStyles(extensionName);
            if (styles != null) {
                i = 0;
                while (i < styles.length) {
                    if (styles[i] != null) {
                        String styleName = styles[i].getName();
                        if (StringUtil.isBlank(styleName)) {
                            PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{extensionName}, "DEFAULT_EMPTY_STYLE_NAME"));
                        } else {
                            this.addDefaultStyleToMeta(styles[i]);
                        }
                    }
                    ++i;
                }
            }
            String themeType = elementTag.getAttribute(THEME_TYPE_ATTRIB);
            MetaDataDictionary.getInstance().addThemeType(elementDefn, themeType);
        }

        private void addDefaultStyleToMeta(IStyleDeclaration defaultStyle) {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            IElementDefn styleDefn = dd.getElement("Style");
            boolean hasLocalValues = false;
            Style style = new Style();
            style.setName(defaultStyle.getName());
            List<IElementPropertyDefn> stylePropDefn = styleDefn.getLocalProperties();
            String propName = null;
            int i = 0;
            while (i < stylePropDefn.size()) {
                PropertyDefn propDefn = (PropertyDefn)((Object)stylePropDefn.get(i));
                propName = propDefn.getName();
                Object value = defaultStyle.getProperty(propName);
                if (value != null) {
                    try {
                        propDefn.validateValue(null, style, value);
                        style.setProperty(propName, value);
                        if (!hasLocalValues) {
                            hasLocalValues = true;
                        }
                    }
                    catch (PropertyValueException e) {
                        PeerExtensionLoader.this.handleError(e.getLocalizedMessage());
                    }
                }
                ++i;
            }
            if (hasLocalValues) {
                dd.addExtensionFactoryStyle(style);
            }
        }

        void loadOverrideProperty(IConfigurationElement elementTag, PeerExtensionElementDefn elementDefn) {
            String name = elementTag.getAttribute(PROPERTY_NAME_ATTRIB);
            if (!this.checkRequiredAttribute(PROPERTY_NAME_ATTRIB, name)) {
                return;
            }
            String units = elementTag.getAttribute(ALLOWEDUNITS_ATTRIB);
            String choices = elementTag.getAttribute(ALLOWEDCHOICES_ATTRIB);
            boolean useOwnSearch = this.getBooleanAttrib(elementTag, USE_OWN_SEARCH, false);
            OverridePropertyInfo propInfo = new OverridePropertyInfo();
            if (useOwnSearch) {
                propInfo.setUseOwnSearch(useOwnSearch);
            }
            propInfo.setAllowedUnits(units);
            propInfo.setAllowedChoices(choices);
            elementDefn.setOverridePropertyInfo(name, propInfo);
        }

        ExtensionPropertyDefn loadProperty(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) {
            MetaDataDictionary dd;
            PropertyType propType;
            String name = propTag.getAttribute(NAME_ATTRIB);
            String type = propTag.getAttribute(TYPE_ATTRIB);
            if (!this.checkRequiredAttribute(NAME_ATTRIB, name) || !this.checkRequiredAttribute(TYPE_ATTRIB, type)) {
                return null;
            }
            String displayNameID = propTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String canInherit = propTag.getAttribute(CAN_INHERIT_ATTRIB);
            String defaultValue = propTag.getAttribute(DEFAULT_VALUE_ATTRIB);
            String isEncrypted = propTag.getAttribute(IS_ENCRYPTABLE_ATTRIB);
            String defaultDisplayName = propTag.getAttribute(DEFAULT_DISPLAY_NAME_ATTRIB);
            String subType = propTag.getAttribute(SUB_TYPE_ATTRIB);
            if (StringUtil.isBlank(subType)) {
                subType = "string";
            }
            if ((propType = (dd = MetaDataDictionary.getInstance()).getPropertyType(type)) == null || !this.getAllowedPropertyTypes().contains(propType)) {
                PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{type}, "INVALID_PROPERTY_TYPE"));
                return null;
            }
            PropertyType subPropType = null;
            if (!(propType.getTypeCode() != 20 || (subPropType = MetaDataDictionary.getInstance().getPropertyType(subType)) != null && this.getAllowedSubPropertyTypes().contains(subPropType))) {
                PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{name, subType}, "UNSUPPORTED_SUB_TYPE"));
                return null;
            }
            ExtensionPropertyDefn extPropDefn = new ExtensionPropertyDefn(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
            boolean hasOwnModel = this.getBooleanAttrib(propTag, HAS_OWN_MODEL, true);
            boolean allowExpression = this.getBooleanAttrib(propTag, ALLOW_EXPRESSION_ATTRIB, false);
            extPropDefn.setName(name);
            extPropDefn.setDisplayNameID(displayNameID);
            extPropDefn.setType(propType);
            extPropDefn.setSubType(subPropType);
            extPropDefn.setIntrinsic(false);
            extPropDefn.setStyleProperty(false);
            extPropDefn.setDefaultDisplayName(defaultDisplayName);
            extPropDefn.setHasOwnModel(hasOwnModel);
            extPropDefn.setAllowExpression(allowExpression);
            if (!StringUtil.isBlank(canInherit)) {
                extPropDefn.setCanInherit(Boolean.valueOf(canInherit));
            }
            if (!StringUtil.isBlank(isEncrypted)) {
                extPropDefn.setIsEncryptable(Boolean.valueOf(isEncrypted));
            }
            ArrayList<ExtensionChoice> choiceList = new ArrayList<ExtensionChoice>();
            ArrayList<String> elementTypes = new ArrayList<String>();
            IConfigurationElement[] elements = propTag.getChildren();
            int k = 0;
            while (k < elements.length) {
                if (CHOICE_TAG.equalsIgnoreCase(elements[k].getName())) {
                    ExtensionChoice choiceDefn = new ExtensionChoice(((PeerExtensionElementDefn)elementDefn).getReportItemFactory().getMessages());
                    if (this.loadChoice(elements[k], choiceDefn, extPropDefn)) {
                        choiceList.add(choiceDefn);
                    }
                } else if (ELEMENT_TYPE_TAG.equalsIgnoreCase(elements[k].getName())) {
                    elementTypes.add(this.loadElementType(elements[k]));
                }
                ++k;
            }
            String detailType = propTag.getAttribute(DETAIL_TYPE_ATTRIB);
            switch (propType.getTypeCode()) {
                case 5: {
                    if (!StringUtil.isBlank(detailType) && choiceList.size() > 0 || StringUtil.isBlank(detailType) && choiceList.size() <= 0) {
                        PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{detailType}, "INVALID_CHOICE_PROPERTY"));
                        return null;
                    }
                    if (choiceList.size() > 0) {
                        IChoice[] choices = new Choice[choiceList.size()];
                        choiceList.toArray(choices);
                        ChoiceSet choiceSet = new ChoiceSet();
                        choiceSet.setChoices(choices);
                        extPropDefn.setDetails(choiceSet);
                        break;
                    }
                    if (StringUtil.isBlank(detailType)) break;
                    extPropDefn.setDetails(dd.getChoiceSet(detailType));
                    break;
                }
                case 16: {
                    boolean isList = this.getBooleanAttrib(propTag, IS_LIST_ATTRIB, false);
                    extPropDefn.setIsList(isList);
                    extPropDefn.setDetails(detailType);
                    break;
                }
                case 15: 
                case 20: {
                    extPropDefn.setDetails(detailType);
                    break;
                }
                case 23: 
                case 24: {
                    boolean isList = this.getBooleanAttrib(propTag, IS_LIST_ATTRIB, false);
                    extPropDefn.setIsList(isList);
                    extPropDefn.setDetails(elementTypes);
                }
            }
            if (!StringUtil.isBlank(defaultValue)) {
                try {
                    Object value = extPropDefn.validateXml(null, null, defaultValue);
                    extPropDefn.setDefault(value);
                }
                catch (PropertyValueException propertyValueException) {
                    PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{name, elementDefn.getName()}, "INVALID_DEFAULT_VALUE"));
                    return null;
                }
            }
            return extPropDefn;
        }

        protected boolean loadChoice(IConfigurationElement choiceTag, ExtensionChoice choice, PropertyDefn propDefn) {
            String name = choiceTag.getAttribute(NAME_ATTRIB);
            if (!this.checkRequiredAttribute(NAME_ATTRIB, name)) {
                return false;
            }
            String value = choiceTag.getAttribute(VALUE_ATTRIB);
            String displayNameID = choiceTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String defaultDisplayName = choiceTag.getAttribute(DEFAULT_DISPLAY_NAME_ATTRIB);
            choice.setName(name);
            if (propDefn.getTypeCode() != 5) {
                try {
                    Object validateValue = propDefn.validateXml(null, null, value);
                    choice.setValue(validateValue);
                }
                catch (PropertyValueException propertyValueException) {
                    PeerExtensionLoader.this.handleError(new ExtensionException(new String[]{value, propDefn.getName()}, "INVALID_CHOICE_VALUE"));
                    return false;
                }
            } else {
                choice.setValue(value);
            }
            choice.setDisplayNameKey(displayNameID);
            choice.setDefaultDisplayName(defaultDisplayName);
            return true;
        }

        void loadPropertyVisibility(IConfigurationElement propTag, ExtensionElementDefn elementDefn) throws ExtensionException {
            String name = propTag.getAttribute(NAME_ATTRIB);
            if (!this.checkRequiredAttribute(NAME_ATTRIB, name)) {
                return;
            }
            String visible = propTag.getAttribute(VISIBILITY_ATTRIB);
            elementDefn.addPropertyVisibility(name, visible);
        }

        void loadPropertyGroup(IConfigurationElement elementTag, IConfigurationElement propGroupTag, ExtensionElementDefn elementDefn) throws MetaDataException {
            String groupName = propGroupTag.getAttribute(NAME_ATTRIB);
            if (!this.checkRequiredAttribute(NAME_ATTRIB, groupName)) {
                return;
            }
            String displayNameID = propGroupTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String defaultDisplayName = propGroupTag.getAttribute(DEFAULT_DISPLAY_NAME_ATTRIB);
            IConfigurationElement[] elements = propGroupTag.getChildren();
            int i = 0;
            while (i < elements.length) {
                ExtensionPropertyDefn extPropDefn;
                if (PROPERTY_TAG.equalsIgnoreCase(elements[i].getName()) && (extPropDefn = this.loadProperty(elementTag, elements[i], elementDefn)) != null) {
                    extPropDefn.setGroupName(groupName);
                    extPropDefn.setGroupNameKey(displayNameID);
                    extPropDefn.setGroupDefauleDisplayName(defaultDisplayName);
                    elementDefn.addProperty(extPropDefn);
                }
                ++i;
            }
        }

        ExtensionPropertyDefn loadMethod(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) {
            String name = propTag.getAttribute(NAME_ATTRIB);
            String displayNameID = propTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String toolTipID = propTag.getAttribute(TOOL_TIP_ID_ATTRIB);
            String returnType = propTag.getAttribute(RETURN_TYPE_ATTRIB);
            String context = propTag.getAttribute(CONTEXT_ATTRIB);
            boolean isStatic = this.getBooleanAttrib(propTag, IS_STATIC_ATTRIB, false);
            if (name == null) {
                PeerExtensionLoader.this.handleError(new ExtensionException(new String[0], "MISSING_METHOD_NAME"));
                return null;
            }
            MethodInfo methodInfo = new MethodInfo(false);
            methodInfo.setName(name);
            methodInfo.setDisplayNameKey(displayNameID);
            methodInfo.setReturnType(returnType);
            methodInfo.setToolTipKey(toolTipID);
            methodInfo.setStatic(isStatic);
            methodInfo.setContext(context);
            methodInfo.setElementDefn(elementDefn);
            IConfigurationElement[] elements = propTag.getChildren();
            ArgumentInfoList argumentList = null;
            int i = 0;
            while (i < elements.length) {
                if (ARGUMENT_TAG.equalsIgnoreCase(elements[i].getName())) {
                    ArgumentInfo argument = this.loadArgument(elementTag, elements[i], elementDefn);
                    argument.setElementDefn(elementDefn);
                    if (argumentList == null) {
                        argumentList = new ArgumentInfoList();
                    }
                    try {
                        argumentList.addArgument(argument);
                    }
                    catch (MetaDataException metaDataException) {
                        PeerExtensionLoader.this.handleError(new ExtensionException(new String[0], "DUPLICATE_ARGUMENT_NAME"));
                        return null;
                    }
                } else if (JAVA_DOC_TAG.equalsIgnoreCase(elements[i].getName())) {
                    String javaDoc = elements[i].getValue();
                    methodInfo.setJavaDoc(javaDoc);
                }
                ++i;
            }
            methodInfo.addArgumentList(argumentList);
            return PeerExtensionLoader.this.addDefnTo(elementDefn, methodInfo);
        }

        ArgumentInfo loadArgument(IConfigurationElement elementTag, IConfigurationElement propTag, ExtensionElementDefn elementDefn) {
            String name = propTag.getAttribute(NAME_ATTRIB);
            String tagID = propTag.getAttribute(TAG_ID_ATTRIB);
            String type = propTag.getAttribute(TYPE_ATTRIB);
            if (name == null) {
                return null;
            }
            ArgumentInfo argument = new ArgumentInfo();
            argument.setName(name);
            argument.setType(type);
            argument.setDisplayNameKey(tagID);
            return argument;
        }

        PredefinedStyle loadStyle(IConfigurationElement elementTag, IConfigurationElement propTag) {
            String name = propTag.getAttribute(NAME_ATTRIB);
            String displayNameID = propTag.getAttribute(DISPLAY_NAME_ID_ATTRIB);
            String type = propTag.getAttribute(TYPE_ATTRIB);
            PredefinedStyle style = new PredefinedStyle();
            style.setName(name);
            style.setDisplayNameKey(displayNameID);
            style.setType(type);
            return style;
        }

        String loadElementType(IConfigurationElement elementTypeTag) {
            String name = elementTypeTag.getAttribute(NAME_ATTRIB);
            if (!this.checkRequiredAttribute(NAME_ATTRIB, name)) {
                return null;
            }
            return name;
        }

        boolean isValidElementType(String type) {
            return "ExtendedItem".equalsIgnoreCase(type) || "Column".equalsIgnoreCase(type) || "Row".equalsIgnoreCase(type) || "Cell".equalsIgnoreCase(type) || "ListingGroup".equalsIgnoreCase(type);
        }

        List<IPropertyType> getAllowedPropertyTypes() {
            if (this.allowedPropertyTypes != null) {
                return this.allowedPropertyTypes;
            }
            this.allowedPropertyTypes = new ArrayList<IPropertyType>();
            for (IPropertyType propType : MetaDataDictionary.getInstance().getPropertyTypes()) {
                int type = propType.getTypeCode();
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 24: {
                        this.allowedPropertyTypes.add(propType);
                        break;
                    }
                }
            }
            return this.allowedPropertyTypes;
        }

        List<IPropertyType> getAllowedSubPropertyTypes() {
            if (this.allowedSubPropertyTypes != null && !this.allowedSubPropertyTypes.isEmpty()) {
                return this.allowedSubPropertyTypes;
            }
            this.allowedSubPropertyTypes = new ArrayList<IPropertyType>();
            for (IPropertyType propType : MetaDataDictionary.getInstance().getPropertyTypes()) {
                int type = propType.getTypeCode();
                switch (type) {
                    case 0: 
                    case 2: 
                    case 6: 
                    case 7: 
                    case 11: 
                    case 14: 
                    case 15: {
                        this.allowedSubPropertyTypes.add(propType);
                    }
                }
            }
            return this.allowedSubPropertyTypes;
        }
    }
}

