/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.model.component.util;

import java.util.Map;

import org.eclipse.birt.chart.model.component.*;

import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.ChartPreferences;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.MarkerLine;
import org.eclipse.birt.chart.model.component.MarkerRange;
import org.eclipse.birt.chart.model.component.Scale;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc --> The <b>Adapter Factory </b> for the model. It provides an adapter <code>createXXX</code>
 * method for each class of the model. <!-- end-user-doc -->
 * @see org.eclipse.birt.chart.model.component.ComponentPackage
 * @generated
 */
public class ComponentAdapterFactory extends AdapterFactoryImpl
{

	/**
	 * The cached model package.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static ComponentPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ComponentAdapterFactory( )
	{
		if ( modelPackage == null )
		{
			modelPackage = ComponentPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc --> This
	 * implementation returns <code>true</code> if the object is either the model's package or is an instance object
	 * of the model. <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType( Object object )
	{
		if ( object == modelPackage )
		{
			return true;
		}
		if ( object instanceof EObject )
		{
			return ( (EObject) object ).eClass( ).getEPackage( ) == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentSwitch<Adapter> modelSwitch = new ComponentSwitch<Adapter>( ) {

		@Override
		public Adapter caseAxis( Axis object )
		{
			return createAxisAdapter( );
		}

		@Override
		public Adapter caseChartPreferences( ChartPreferences object )
		{
			return createChartPreferencesAdapter( );
		}

		@Override
		public Adapter caseCurveFitting( CurveFitting object )
		{
			return createCurveFittingAdapter( );
		}

		@Override
		public Adapter caseDial( Dial object )
		{
			return createDialAdapter( );
		}

		@Override
		public Adapter caseDialRegion( DialRegion object )
		{
			return createDialRegionAdapter( );
		}

		@Override
		public Adapter caseEStringToDataSetMapEntry(
				Map.Entry<String, DataSet> object )
		{
			return createEStringToDataSetMapEntryAdapter( );
		}

		@Override
		public Adapter caseGrid( Grid object )
		{
			return createGridAdapter( );
		}

		@Override
		public Adapter caseLabel( Label object )
		{
			return createLabelAdapter( );
		}

		@Override
		public Adapter caseMarkerLine( MarkerLine object )
		{
			return createMarkerLineAdapter( );
		}

		@Override
		public Adapter caseMarkerRange( MarkerRange object )
		{
			return createMarkerRangeAdapter( );
		}

		@Override
		public Adapter caseNeedle( Needle object )
		{
			return createNeedleAdapter( );
		}

		@Override
		public Adapter caseScale( Scale object )
		{
			return createScaleAdapter( );
		}

		@Override
		public Adapter caseSeries( Series object )
		{
			return createSeriesAdapter( );
		}

		@Override
		public Adapter defaultCase( EObject object )
		{
			return createEObjectAdapter( );
		}
	};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter( Notifier target )
	{
		return modelSwitch.doSwitch( (EObject) target );
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Axis <em>Axis</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that we can easily ignore cases; it's useful
	 * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Axis
	 * @generated
	 */
	public Adapter createAxisAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.ChartPreferences <em>Chart Preferences</em>}'.
	 * <!-- begin-user-doc
	 * --> This default implementation returns null so that we can easily ignore cases; it's useful to ignore a case
	 * when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.ChartPreferences
	 * @generated
	 */
	public Adapter createChartPreferencesAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.CurveFitting <em>Curve Fitting</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.CurveFitting
	 * @generated
	 */
	public Adapter createCurveFittingAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Dial <em>Dial</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Dial
	 * @generated
	 */
	public Adapter createDialAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.DialRegion <em>Dial Region</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.DialRegion
	 * @generated
	 */
	public Adapter createDialRegionAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Grid <em>Grid</em>}'.
	 * <!-- begin-user-doc --> This default implementation returns null so that we can easily ignore cases; it's useful
	 * to ignore a case when inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Grid
	 * @generated
	 */
	public Adapter createGridAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Label <em>Label</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Label
	 * @generated
	 */
	public Adapter createLabelAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.MarkerLine <em>Marker Line</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.MarkerLine
	 * @generated
	 */
	public Adapter createMarkerLineAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.MarkerRange <em>Marker Range</em>}'.
	 * <!-- begin-user-doc --> This
	 * default implementation returns null so that we can easily ignore cases; it's useful to ignore a case when
	 * inheritance will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.MarkerRange
	 * @generated
	 */
	public Adapter createMarkerRangeAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Needle <em>Needle</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Needle
	 * @generated
	 */
	public Adapter createNeedleAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Scale <em>Scale</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Scale
	 * @generated
	 */
	public Adapter createScaleAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link org.eclipse.birt.chart.model.component.Series <em>Series</em>}'.
	 * <!-- begin-user-doc --> This default
	 * implementation returns null so that we can easily ignore cases; it's useful to ignore a case when inheritance
	 * will catch all the cases anyway. <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see org.eclipse.birt.chart.model.component.Series
	 * @generated
	 */
	public Adapter createSeriesAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link java.util.Map.Entry <em>EString To Data Set Map Entry</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see java.util.Map.Entry
	 * @generated
	 */
	public Adapter createEStringToDataSetMapEntryAdapter( )
	{
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc --> This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter( )
	{
		return null;
	}

} //ComponentAdapterFactory
