/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;

public final class PLSUtil {
    public static boolean isPLSEnabled(IQueryDefinition queryDefn) {
        return queryDefn.getQueryExecutionHints() != null && queryDefn.getQueryExecutionHints().getTargetGroupInstances().size() > 0;
    }

    public static boolean needUpdateDataSet(IQueryDefinition queryDefn, StreamManager manager) throws DataException {
        assert (queryDefn != null);
        assert (queryDefn.getQueryExecutionHints() != null);
        if (queryDefn.getQueryExecutionHints().getTargetGroupInstances().size() == 0) {
            return false;
        }
        PLSInfo plsInfo = PLSUtil.readPLSInfo(manager);
        int currentRequestedGroupLevel = PLSUtil.getOutmostPlsGroupLevel(queryDefn);
        return plsInfo.groupLevel == null || plsInfo.groupLevel < currentRequestedGroupLevel;
    }

    public static boolean isRowIdSaved(StreamManager manager) {
        return PLSUtil.readPLSInfo((StreamManager)manager).rowIdSaved;
    }

    private static PLSInfo readPLSInfo(StreamManager manager) {
        PLSInfo plsInfo;
        block18: {
            plsInfo = new PLSInfo(null, false);
            InputStream in = null;
            try {
                try {
                    if (manager.hasInStream(102, 0, 0)) {
                        in = manager.getInStream(102, 0, 0);
                    }
                    if (in != null) {
                        plsInfo.groupLevel = IOUtil.readInt(in);
                        try {
                            plsInfo.rowIdSaved = IOUtil.readBool(in);
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception exception) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return plsInfo;
    }

    public static int getOutmostPlsGroupLevel(IQueryDefinition queryDefn) {
        assert (queryDefn != null);
        assert (queryDefn.getQueryExecutionHints() != null);
        int currentRequestedGroupLevel = 0;
        for (IGroupInstanceInfo info : queryDefn.getQueryExecutionHints().getTargetGroupInstances()) {
            int n = currentRequestedGroupLevel = info.getGroupLevel() > currentRequestedGroupLevel ? info.getGroupLevel() : currentRequestedGroupLevel;
        }
        return currentRequestedGroupLevel;
    }

    private static List<String> getReCalGroupNames(IQueryDefinition query, List<IGroupInstanceInfo> targetGroups) {
        int groupLevel = Integer.MAX_VALUE;
        for (IGroupInstanceInfo instance : targetGroups) {
            if (groupLevel <= instance.getGroupLevel()) continue;
            groupLevel = instance.getGroupLevel();
        }
        List groups = query.getGroups();
        ArrayList<String> reCalGroups = new ArrayList<String>();
        int i = groupLevel - 1;
        while (i < groups.size()) {
            reCalGroups.add(((IGroupDefinition)groups.get(i)).getName());
            ++i;
        }
        return reCalGroups;
    }

    public static String constructNonReCalBindingDataSetName(String originalBindingName) {
        return "${RE_CAL:" + originalBindingName + "}$";
    }

    public static boolean isPLSProcessedBinding(IBinding binding) {
        try {
            String columnName;
            if (binding.getExpression() instanceof IScriptExpression && (columnName = ExpressionUtil.getColumnName(((IScriptExpression)binding.getExpression()).getText())) != null && columnName.startsWith("${RE_CAL:")) {
                return true;
            }
        }
        catch (BirtException birtException) {}
        return false;
    }

    public static IQueryDefinition populateBindings(IQueryDefinition queryDefn) throws DataException {
        try {
            List<String> reCalGroupNames = PLSUtil.getReCalGroupNames(queryDefn, queryDefn.getQueryExecutionHints().getTargetGroupInstances());
            for (IBinding binding : queryDefn.getBindings().values()) {
                String text;
                if (binding.getAggregatOns().size() != 0 && reCalGroupNames.contains(binding.getAggregatOns().get(0)) || binding.getExpression() instanceof IScriptExpression && binding.getAggrFunction() == null && (ExpressionUtil.getColumnName(text = ((IScriptExpression)binding.getExpression()).getText()) != null || ExpressionUtil.getColumnBindingName(text) == null || !PLSUtil.referToRecAggrBinding(queryDefn, reCalGroupNames, text))) continue;
                String expr = ExpressionUtil.createJSDataSetRowExpression(PLSUtil.constructNonReCalBindingDataSetName(binding.getBindingName()));
                binding.setExpression(new ScriptExpression(expr));
                binding.getAggregatOns().clear();
                binding.setAggrFunction(null);
            }
            return queryDefn;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private static boolean referToRecAggrBinding(IQueryDefinition queryDefn, List<String> reCalGroupNames, String exprText) throws BirtException {
        List columnBindings = ExpressionUtil.extractColumnExpressions(exprText, "row");
        if (columnBindings != null) {
            for (IColumnBinding cb : columnBindings) {
                String text;
                IBinding usedBinding = (IBinding)queryDefn.getBindings().get(cb.getResultSetColumnName());
                if (usedBinding.getAggrFunction() != null && usedBinding.getAggregatOns().size() > 0 && reCalGroupNames.contains(usedBinding.getAggregatOns().get(0))) {
                    return true;
                }
                if (!(usedBinding.getExpression() instanceof IScriptExpression) || !PLSUtil.referToRecAggrBinding(queryDefn, reCalGroupNames, text = ((IScriptExpression)usedBinding.getExpression()).getText())) continue;
                return true;
            }
        }
        return false;
    }

    static class PLSInfo {
        public Integer groupLevel;
        public boolean rowIdSaved;

        public PLSInfo(Integer groupLevel, boolean rowIdSaved) {
            this.groupLevel = groupLevel;
            this.rowIdSaved = rowIdSaved;
        }
    }
}

