/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.query.view;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.ICollectionConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.executor.cache.CacheUtil;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.olap.api.query.ICubeOperation;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ICubeSortDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IEdgeDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ILevelDefinition;
import org.eclipse.birt.data.engine.olap.data.api.CubeQueryExecutorHelper;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.api.IBindingValueFetcher;
import org.eclipse.birt.data.engine.olap.data.api.cube.ICube;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationResultSetSaveUtil;
import org.eclipse.birt.data.engine.olap.data.impl.CachedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.MergedAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SortedAggregationRowArray;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggrMeasureFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.filter.AggregationFilterHelper;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.driver.CubeResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.impl.query.AddingNestAggregations;
import org.eclipse.birt.data.engine.olap.impl.query.CubeOperationsExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionIOUtil;
import org.eclipse.birt.data.engine.olap.impl.query.CubeQueryExecutor;
import org.eclipse.birt.data.engine.olap.impl.query.IPreparedCubeOperation;
import org.eclipse.birt.data.engine.olap.impl.query.IncrementExecutionHint;
import org.eclipse.birt.data.engine.olap.impl.query.PreparedAddingNestAggregations;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryValidator;
import org.eclipse.birt.data.engine.olap.query.view.DrillOperationExecutor;
import org.eclipse.birt.data.engine.olap.query.view.MirrorOperationExecutor;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefn;
import org.eclipse.birt.data.engine.olap.util.CubeNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.DrillFilterHelper;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.olap.util.filter.AggrMeasureFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.BaseDimensionFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.filter.IJSFilterHelper;
import org.eclipse.birt.data.engine.olap.util.filter.JSFacttableFilterEvalHelper;
import org.eclipse.birt.data.engine.olap.util.sort.DimensionSortEvalHelper;
import org.mozilla.javascript.Scriptable;

public class QueryExecutor {
    private CubeQueryExecutorHelper cubeQueryExecutorHelper;

    public IResultSet execute(BirtCubeView view, StopSign stopSign, ICube cube, IBindingValueFetcher fetcher) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        AggregationDefinition[] cube_Aggregation = this.prepareCube(executor.getCubeQueryDefinition(), view.getAggregationRegisterTable().getCalculatedMembersFromQuery());
        if (cube_Aggregation == null || cube_Aggregation.length == 0) {
            return null;
        }
        AggregationDefinition[] drilled_aggregation = DrillFilterHelper.preparedDrillAggregation(executor.getCubeQueryDefinition(), cube_Aggregation);
        int size = cube_Aggregation.length + drilled_aggregation.length;
        AggregationDefinition[] finalAggregation = new AggregationDefinition[size];
        if (drilled_aggregation.length > 0) {
            System.arraycopy(cube_Aggregation, 0, finalAggregation, 0, cube_Aggregation.length);
            System.arraycopy(drilled_aggregation, 0, finalAggregation, cube_Aggregation.length, drilled_aggregation.length);
        } else {
            finalAggregation = cube_Aggregation;
        }
        String cubeName = executor.getCubeQueryDefinition().getName();
        if (cubeName == null || cubeName.trim().length() == 0) {
            throw new DataException("data.olap.query.noCubeBinding");
        }
        CubeQueryValidator.validateCubeQueryDefinition(view, cube);
        this.cubeQueryExecutorHelper = new CubeQueryExecutorHelper(cube, executor.getComputedMeasureHelper(), fetcher);
        this.cubeQueryExecutorHelper.setCubeQueryExecutor(executor);
        this.cubeQueryExecutorHelper.setMemoryCacheSize(CacheUtil.computeMemoryBufferSize(view.getAppContext()));
        this.cubeQueryExecutorHelper.setAppContext(view.getAppContext());
        this.cubeQueryExecutorHelper.setMaxDataObjectRows(CacheUtil.getMaxRows(view.getAppContext()));
        this.cubeQueryExecutorHelper.addJSFilter(executor.getDimensionFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addSimpleLevelFilter(executor.getdimensionSimpleFilter());
        this.cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getMeasureFilterEvalHelpers());
        this.cubeQueryExecutorHelper.addMeasureFilter(executor.getFacttableBasedFilterHelpers());
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 2);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 1);
        this.populateAggregationSort(executor, this.cubeQueryExecutorHelper, 3);
        IAggregationResultSet[] rs = null;
        this.cubeQueryExecutorHelper.setBreakHierarchy(executor.getCubeQueryDefinition().getFilterOption() == 0);
        switch (executor.getContext().getMode()) {
            case 1: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, true, fetcher);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            case 3: {
                rs = this.populateRs(view, finalAggregation, this.cubeQueryExecutorHelper, stopSign, false, fetcher);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            case 2: {
                if (executor.getCubeQueryDefinition().getQueryResultsID() != null) {
                    rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(executor.getCubeQueryDefinition().getQueryResultsID()), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    this.initLoadedAggregationResultSets(rs, finalAggregation);
                    rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                    break;
                }
                rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                rs = this.applyFilterOnOperation(view, stopSign, executor, finalAggregation, rs);
                rs = this.applyNoAggrUpdateFilters(this.getNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters()), executor, rs, cube, fetcher, false);
                MirrorOperationExecutor moe = new MirrorOperationExecutor();
                rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                this.validateLimitSetting(view, rs);
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
                break;
            }
            default: {
                String id = executor.getCubeQueryDefinition().getQueryResultsID();
                IncrementExecutionHint ieh = null;
                if (CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id)) {
                    ICubeQueryDefinition savedQuery = CubeQueryDefinitionIOUtil.load(id, executor.getContext());
                    ieh = org.eclipse.birt.data.engine.olap.impl.query.CubeQueryDefinitionUtil.getIncrementExecutionHint(savedQuery, executor.getCubeQueryDefinition());
                }
                if (!CubeQueryDefinitionIOUtil.existStream(executor.getContext().getDocReader(), id) || ieh == null || !ieh.isNoIncrement() && executor.getCubeQueryDefinition().getCubeOperations().length > 0) {
                    rs = this.cubeQueryExecutorHelper.execute(finalAggregation, stopSign);
                    rs = this.applyFilterOnOperation(view, stopSign, executor, finalAggregation, rs);
                    rs = this.applyNoAggrUpdateFilters(this.getNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters()), executor, rs, cube, fetcher, false);
                    MirrorOperationExecutor moe = new MirrorOperationExecutor();
                    rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
                    this.validateLimitSetting(view, rs);
                } else {
                    rs = AggregationResultSetSaveUtil.load(id, executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(id), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                    this.initLoadedAggregationResultSets(rs, finalAggregation);
                    this.incrementExecute(rs, ieh);
                    if (ieh.getFilters() != null && ieh.getFilters().length > 0) {
                        IFilterDefinition[] filters = ieh.getFilters();
                        ArrayList<IFilterDefinition> finalFilters = new ArrayList<IFilterDefinition>();
                        int j = 0;
                        while (j < filters.length) {
                            finalFilters.add(filters[j]);
                            ++j;
                        }
                        rs = this.applyNoAggrUpdateFilters(finalFilters, executor, rs, cube, fetcher, false);
                    }
                }
                if (executor.getContext().getDocWriter() != null) {
                    if (id == null) {
                        id = executor.getSession().getQueryResultIDUtil().nextID();
                    }
                    CubeQueryDefinitionIOUtil.save(id, executor.getContext(), executor.getCubeQueryDefinition());
                    AggregationResultSetSaveUtil.save(id, rs, executor.getContext().getDocWriter());
                    executor.setQueryResultsId(id);
                }
                rs = this.processOperationOnQuery(executor, view, stopSign, rs, cube_Aggregation, fetcher);
            }
        }
        return new CubeResultSet(rs, view, this.cubeQueryExecutorHelper);
    }

    private IAggregationResultSet[] applyFilterOnOperation(BirtCubeView view, StopSign stopSign, CubeQueryExecutor executor, AggregationDefinition[] finalAggregation, IAggregationResultSet[] rs) throws DataException, IOException, BirtException {
        if (!executor.getNestAggregationFilterEvalHelpers().isEmpty()) {
            CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
            rs = coe.execute(rs, stopSign);
            this.cubeQueryExecutorHelper.addAggrMeasureFilter(executor.getNestAggregationFilterEvalHelpers());
            this.cubeQueryExecutorHelper.applyAggrFilters(finalAggregation, rs, stopSign);
        }
        return rs;
    }

    private IAggregationResultSet[] applyNoAggrUpdateFilters(List finalFilters, CubeQueryExecutor executor, IAggregationResultSet[] rs, ICube cube, IBindingValueFetcher fetcher, boolean fromCubeOperation) throws DataException, IOException {
        if (!finalFilters.isEmpty()) {
            ArrayList<AggrMeasureFilterEvalHelper> aggrEvalList = new ArrayList<AggrMeasureFilterEvalHelper>();
            ArrayList<IJSFilterHelper> dimEvalList = new ArrayList<IJSFilterHelper>();
            ArrayList<IFilterDefinition> drillFilterList = new ArrayList<IFilterDefinition>();
            int i = 0;
            while (i < finalFilters.size()) {
                IFilterDefinition filter = (IFilterDefinition)finalFilters.get(i);
                boolean find = false;
                String bindingName = OlapExpressionCompiler.getReferencedScriptObject(filter.getExpression(), "data");
                if (executor.getCubeQueryDefinition().getCubeOperations().length > 0) {
                    ICubeOperation[] operations = executor.getCubeQueryDefinition().getCubeOperations();
                    int j = 0;
                    while (j < operations.length) {
                        if (operations[j] instanceof AddingNestAggregations) {
                            AddingNestAggregations aggr = (AddingNestAggregations)operations[j];
                            IBinding[] bindings = aggr.getNewBindings();
                            int k = 0;
                            while (k < bindings.length) {
                                if (bindings[k].getBindingName().equals(bindingName)) {
                                    find = true;
                                    break;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                if (find == fromCubeOperation) {
                    int type = executor.getFilterType(filter, executor.getDimLevelsDefinedInCubeQuery());
                    if (type == 0) {
                        dimEvalList.add(BaseDimensionFilterEvalHelper.createFilterHelper(executor.getOuterResults(), executor.getScope(), executor.getCubeQueryDefinition(), filter, executor.getSession().getEngineContext().getScriptContext()));
                    } else if (type == 1) {
                        aggrEvalList.add(new AggrMeasureFilterEvalHelper(executor.getOuterResults(), executor.getScope(), executor.getCubeQueryDefinition(), filter, executor.getSession().getEngineContext().getScriptContext()));
                    } else if (type == 2) {
                        drillFilterList.add(filter);
                    }
                }
                ++i;
            }
            ArrayList<Integer> affectedAggrResultSetIndex = new ArrayList<Integer>();
            if (aggrEvalList.size() > 0) {
                AggrMeasureFilterHelper aggrFilterHelper = new AggrMeasureFilterHelper(cube, rs);
                aggrFilterHelper.setQueryExecutor(executor);
                aggrFilterHelper.setBindingValueFetcher(fetcher);
                rs = aggrFilterHelper.removeInvalidAggrRows(aggrEvalList, affectedAggrResultSetIndex);
            }
            if (dimEvalList.size() > 0) {
                AggregationFilterHelper helper = new AggregationFilterHelper((Cube)cube, dimEvalList, fetcher);
                rs = helper.generateFilteredAggregationResultSet(rs, affectedAggrResultSetIndex);
            }
            Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap = this.populateEdgeDrillFilterMap(executor, drillFilterList);
            List<IAggregationResultSet> edgeResultSet = this.populateAndFilterEdgeResultSet(rs, edgeDrillFilterMap);
            int i2 = 0;
            while (i2 < edgeResultSet.size()) {
                int j = 0;
                while (j < affectedAggrResultSetIndex.size()) {
                    this.applyJoin(edgeResultSet.get(i2), rs[(Integer)affectedAggrResultSetIndex.get(j)]);
                    ++j;
                }
                ++i2;
            }
            if (edgeResultSet.size() > 1) {
                this.combineEdgeResultSetsInfo(edgeResultSet);
            }
        }
        return rs;
    }

    private void combineEdgeResultSetsInfo(List<IAggregationResultSet> edgeResultSet) {
        IAggregationResultSet rs;
        int index = -1;
        int i = 0;
        while (i < edgeResultSet.size()) {
            rs = edgeResultSet.get(i);
            if (rs.length() == 0) {
                index = i;
            }
            ++i;
        }
        if (index >= 0) {
            i = 0;
            while (i < edgeResultSet.size()) {
                if (i != index) {
                    rs = edgeResultSet.get(i);
                    BufferedStructureArray newRsRows = new BufferedStructureArray(AggregationResultRow.getCreator(), rs.length());
                    if (rs instanceof AggregationResultSet) {
                        ((AggregationResultSet)rs).setAggregationResultRows(newRsRows);
                    } else if (rs instanceof CachedAggregationResultSet) {
                        ((CachedAggregationResultSet)rs).setAggregationResultRows(newRsRows);
                    }
                }
                ++i;
            }
        }
    }

    private List<IAggregationResultSet> populateAndFilterEdgeResultSet(IAggregationResultSet[] rs, Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap) throws IOException, DataException {
        ArrayList<IAggregationResultSet> edgeResultSet = new ArrayList<IAggregationResultSet>();
        int i = 0;
        while (i < rs.length) {
            if (rs[i].getAggregationDefinition().getAggregationFunctions() == null) {
                edgeResultSet.add(rs[i]);
                if (edgeDrillFilterMap != null && !edgeDrillFilterMap.isEmpty()) {
                    this.filterEdgeAggrSet(edgeDrillFilterMap, rs[i]);
                }
            }
            ++i;
        }
        return edgeResultSet;
    }

    private void filterEdgeAggrSet(Map<DimLevel, IJSFacttableFilterEvalHelper> edgeDrillFilterMap, IAggregationResultSet edgeAggrSet) throws IOException, DataException {
        IJSFacttableFilterEvalHelper drillFilterHelper = null;
        DimLevel[] dimLevelArray = edgeAggrSet.getAllLevels();
        int n = dimLevelArray.length;
        int n2 = 0;
        while (n2 < n) {
            DimLevel dimLevel = dimLevelArray[n2];
            drillFilterHelper = edgeDrillFilterMap.get(dimLevel);
            if (drillFilterHelper != null) {
                AggregateRowWrapper aggrRowWrapper = new AggregateRowWrapper(edgeAggrSet);
                BufferedStructureArray newRs = new BufferedStructureArray(AggregationResultRow.getCreator(), 2000);
                int j = 0;
                while (j < edgeAggrSet.length()) {
                    edgeAggrSet.seek(j);
                    if (drillFilterHelper.evaluateFilter(aggrRowWrapper)) {
                        newRs.add(edgeAggrSet.getCurrentRow());
                    }
                    ++j;
                }
                this.reSetAggregationResultSetDiskArray(edgeAggrSet, newRs);
            }
            ++n2;
        }
    }

    private void reSetAggregationResultSetDiskArray(IAggregationResultSet edgeAggrSet, IDiskArray newRs) {
        if (edgeAggrSet instanceof AggregationResultSet) {
            ((AggregationResultSet)edgeAggrSet).setAggregationResultRows(newRs);
        } else if (edgeAggrSet instanceof CachedAggregationResultSet) {
            ((CachedAggregationResultSet)edgeAggrSet).setAggregationResultRows(newRs);
            ((CachedAggregationResultSet)edgeAggrSet).setLength(newRs.size());
        }
    }

    private Map<DimLevel, IJSFacttableFilterEvalHelper> populateEdgeDrillFilterMap(CubeQueryExecutor executor, List<IFilterDefinition> drillFilterList) throws DataException {
        HashMap<DimLevel, IJSFacttableFilterEvalHelper> result = new HashMap<DimLevel, IJSFacttableFilterEvalHelper>();
        for (IFilterDefinition filterDefn : drillFilterList) {
            assert (filterDefn instanceof ICollectionConditionalExpression);
            Collection<IScriptExpression> exprs = ((ICollectionConditionalExpression)((Object)filterDefn.getExpression())).getExpr();
            Iterator<IScriptExpression> exprsIterator = exprs.iterator();
            DimLevel containedDimLevel = null;
            while (exprsIterator.hasNext()) {
                Iterator dimLevels = OlapExpressionCompiler.getReferencedDimLevel(exprsIterator.next(), new ArrayList()).iterator();
                if (dimLevels.hasNext()) {
                    containedDimLevel = (DimLevel)dimLevels.next();
                }
                if (containedDimLevel != null) break;
            }
            if (containedDimLevel == null) continue;
            result.put(containedDimLevel, new JSFacttableFilterEvalHelper(executor.getScope(), executor.getSession().getEngineContext().getScriptContext(), filterDefn, null, null));
        }
        return result;
    }

    private int getPos(String[][] joinLevelKeys, String[][] detailLevelKeys) {
        int i = 0;
        while (i < detailLevelKeys.length) {
            if (CompareUtil.compare(joinLevelKeys[0], detailLevelKeys[i]) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void applyJoin(IAggregationResultSet joinRS, IAggregationResultSet detailRS) throws IOException {
        String[][] detailLevelKeys = detailRS.getLevelKeys();
        ArrayList<Members> detailMember = new ArrayList<Members>();
        String[][] joinLevelKeys = null;
        Member[] members = null;
        IDiskArray aggregationResultRows = null;
        joinLevelKeys = joinRS.getLevelKeys();
        if (detailLevelKeys == null) {
            return;
        }
        int pos = this.getPos(joinLevelKeys, detailLevelKeys);
        if (pos < 0) {
            int detailLevelKeyslen = detailLevelKeys.length;
            if (detailLevelKeyslen == 0 && detailRS.length() == 0) {
                BufferedStructureArray emptyRows = new BufferedStructureArray(AggregationResultRow.getCreator(), 0);
                this.reSetAggregationResultSetDiskArray(joinRS, emptyRows);
            }
            return;
        }
        int index = 0;
        while (index < detailRS.length()) {
            detailRS.seek(index);
            members = detailRS.getCurrentRow().getLevelMembers();
            if (members != null) {
                ArrayList<Member> tmpMembers = new ArrayList<Member>();
                int j = pos;
                while (j < pos + joinLevelKeys.length) {
                    if (j > members.length - 1) break;
                    if (CompareUtil.compare(joinLevelKeys[j - pos], detailLevelKeys[j]) == 0) {
                        tmpMembers.add(members[j]);
                    }
                    ++j;
                }
                detailMember.add(new Members(tmpMembers.toArray(new Member[0])));
            }
            ++index;
        }
        Collections.sort(detailMember);
        if (joinRS instanceof AggregationResultSet) {
            aggregationResultRows = ((AggregationResultSet)joinRS).getAggregationResultRows();
        } else if (joinRS instanceof CachedAggregationResultSet) {
            aggregationResultRows = ((CachedAggregationResultSet)joinRS).getAggregationResultRows();
        }
        BufferedStructureArray newRsRows = new BufferedStructureArray(AggregationResultRow.getCreator(), aggregationResultRows.size());
        int index2 = 0;
        while (index2 < joinRS.length()) {
            joinRS.seek(index2);
            int result = Collections.binarySearch(detailMember, new Members(joinRS.getCurrentRow().getLevelMembers()));
            if (result >= 0) {
                newRsRows.add(aggregationResultRows.get(index2));
            }
            ++index2;
        }
        this.reSetAggregationResultSetDiskArray(joinRS, newRsRows);
        detailMember.clear();
    }

    private List getNoAggrUpdateFilters(List filters) {
        ArrayList NoAggrUpdateFilters = new ArrayList();
        int i = 0;
        while (i < filters.size()) {
            if (!((IFilterDefinition)filters.get(i)).updateAggregation()) {
                NoAggrUpdateFilters.add(filters.get(i));
            }
            ++i;
        }
        return NoAggrUpdateFilters;
    }

    private IAggregationResultSet[] processOperationOnQuery(CubeQueryExecutor executor, BirtCubeView view, StopSign stopSign, IAggregationResultSet[] resultSet, AggregationDefinition[] aggrDefns, IBindingValueFetcher fetcher) throws DataException, IOException, BirtException {
        IAggregationResultSet[] rs = new IAggregationResultSet[aggrDefns.length];
        System.arraycopy(resultSet, 0, rs, 0, aggrDefns.length);
        IAggregationResultSet[] drillRs = new IAggregationResultSet[resultSet.length - aggrDefns.length];
        System.arraycopy(resultSet, aggrDefns.length, drillRs, 0, drillRs.length);
        CubeOperationsExecutor coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), view.getPreparedCubeOperations(), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
        int rsLenBefore = rs.length;
        rs = coe.execute(rs, stopSign);
        int rsLenAfter = rs.length;
        List noAggrUpdateFilters = this.getNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters());
        if (noAggrUpdateFilters.size() > 0) {
            int i;
            IAggregationResultSet[] result = null;
            if (rsLenBefore < rsLenAfter) {
                result = new IAggregationResultSet[rsLenAfter - rsLenBefore];
                int i2 = 0;
                while (i2 < result.length) {
                    result[i2] = rs[rsLenBefore + i2];
                    ++i2;
                }
                result = this.applyNoAggrUpdateFilters(noAggrUpdateFilters, executor, result, view.getCube(), fetcher, true);
                i2 = 0;
                while (i2 < result.length) {
                    rs[i2 + rsLenBefore] = result[i2];
                    ++i2;
                }
            } else if (rsLenBefore == rsLenAfter) {
                ArrayList<IAggregationResultSet> mergedResult = new ArrayList<IAggregationResultSet>();
                i = 0;
                while (i < rs.length) {
                    if (rs[i].getAggregationDefinition().getAggregationFunctions() != null && rs[i] instanceof MergedAggregationResultSet) {
                        IAggregationResultSet[] applyResults = this.applyNoAggrUpdateFilters(noAggrUpdateFilters, executor, new IAggregationResultSet[]{rs[i]}, view.getCube(), fetcher, true);
                        rs[i] = applyResults[0];
                        mergedResult.add(rs[i]);
                    }
                    ++i;
                }
                result = mergedResult.toArray(new IAggregationResultSet[0]);
            }
            List<IAggregationResultSet> edgeResultSet = this.populateAndFilterEdgeResultSet(rs, null);
            i = 0;
            while (i < edgeResultSet.size()) {
                int j = 0;
                while (j < result.length) {
                    this.applyJoin(edgeResultSet.get(i), result[j]);
                    ++j;
                }
                ++i;
            }
        }
        if (DrillFilterHelper.containsDrillFilter(view.getCubeQueryDefinition())) {
            IPreparedCubeOperation[] ops = view.getPreparedCubeOperations();
            ArrayList<PreparedAddingNestAggregations> operations = new ArrayList<PreparedAddingNestAggregations>();
            ArrayList<CubeNestAggrDefn> nestedAggr = new ArrayList<CubeNestAggrDefn>();
            ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
            int i = 0;
            while (i < ops.length) {
                List<AggregationDefinition> nested_aggregation = ops[i].getAggregationDefintions();
                int k = 0;
                while (k < nested_aggregation.size()) {
                    AggregationDefinition[] drilled_nested_aggregation;
                    AggregationDefinition[] aggregationDefinitionArray = drilled_nested_aggregation = DrillFilterHelper.preparedDrillForNestedAggregation(executor.getCubeQueryDefinition(), new CubeAggrDefn[]{ops[i].getNewCubeAggrDefns()[k]}, new AggregationDefinition[]{nested_aggregation.get(k)});
                    int n = drilled_nested_aggregation.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AggregationDefinition aggregation = aggregationDefinitionArray[n2];
                        CubeNestAggrDefn defn = (CubeNestAggrDefn)ops[i].getNewCubeAggrDefns()[k];
                        nestedAggr.add(new CubeNestAggrDefn(defn.getName(), defn.getBasedExpression(), Arrays.asList(ops[i].getNewCubeAggrDefns()[k]), defn.getAggrName(), defn.getArguments(), defn.getFilter()));
                        aggregations.add(aggregation);
                        ++n2;
                    }
                    ++k;
                }
                if (!nestedAggr.isEmpty()) {
                    PreparedAddingNestAggregations drill_coe = new PreparedAddingNestAggregations();
                    drill_coe.prepare(executor.getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext(), view.getAggregationRegisterTable(), nestedAggr.toArray(new CubeNestAggrDefn[0]), aggregations);
                    operations.add(drill_coe);
                }
                ++i;
            }
            if (!operations.isEmpty()) {
                coe = new CubeOperationsExecutor(view.getCubeQueryDefinition(), operations.toArray(new PreparedAddingNestAggregations[0]), view.getCubeQueryExecutor().getScope(), view.getCubeQueryExecutor().getSession().getEngineContext().getScriptContext());
                drillRs = coe.execute(drillRs, stopSign);
            }
            DrillOperationExecutor drillOp = new DrillOperationExecutor();
            rs = drillOp.execute(rs, drillRs, view.getCubeQueryDefinition());
        }
        return rs;
    }

    private void initLoadedAggregationResultSets(IAggregationResultSet[] arss, AggregationDefinition[] ads) {
        assert (ads.length <= arss.length);
        int i = 0;
        while (i < ads.length) {
            CachedAggregationResultSet cars = (CachedAggregationResultSet)arss[i];
            cars.setAggregationDefinition(ads[i]);
            ++i;
        }
    }

    private IAggregationResultSet sortAggregationResultSet(IAggregationResultSet rs) throws IOException {
        SortedAggregationRowArray sarr = new SortedAggregationRowArray(rs);
        rs.close();
        return new AggregationResultSet(rs.getAggregationDefinition(), rs.getAllLevels(), sarr.getSortedRows(), rs.getKeyNames(), rs.getAttributeNames());
    }

    private void incrementExecute(IAggregationResultSet[] baseResultSets, IncrementExecutionHint ieh) throws DataException, IOException {
        assert (baseResultSets != null && ieh != null);
        this.applyIncrementSorts(baseResultSets);
    }

    private void applyIncrementSorts(IAggregationResultSet[] baseResultSets) throws DataException, IOException {
        int i = 0;
        while (i < baseResultSets.length) {
            if (baseResultSets[i].getAggregationCount() == 0) {
                baseResultSets[i] = this.sortAggregationResultSet(baseResultSets[i]);
            }
            ++i;
        }
        this.cubeQueryExecutorHelper.applyAggrSort(baseResultSets);
    }

    private IAggregationResultSet[] populateRs(BirtCubeView view, AggregationDefinition[] aggrDefns, CubeQueryExecutorHelper cubeQueryExcutorHelper2, StopSign stopSign, boolean saveToRD, IBindingValueFetcher fetcher) throws IOException, BirtException {
        IAggregationResultSet[] rs = null;
        String id = null;
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        if (executor.getCubeQueryDefinition().getQueryResultsID() == null) {
            if (saveToRD || executor.getCubeQueryDefinition().cacheQueryResults()) {
                id = executor.getSession().getQueryResultIDUtil().nextID();
            }
            rs = this.executeQuery(view, aggrDefns, saveToRD, id, fetcher);
        } else {
            id = executor.getCubeQueryDefinition().getQueryResultsID();
            if (executor.getCubeQueryDefinition().cacheQueryResults()) {
                FileArchiveReader far = new FileArchiveReader(String.valueOf(executor.getSession().getTempDir()) + "Cache");
                rs = AggregationResultSetSaveUtil.load(id, far, VersionManager.getLatestVersion(), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                far.close();
                this.initLoadedAggregationResultSets(rs, aggrDefns);
            } else if (executor.getContext().getDocReader() != null && executor.getContext().getMode() != 1) {
                rs = AggregationResultSetSaveUtil.load(executor.getCubeQueryDefinition().getQueryResultsID(), executor.getContext().getDocReader(), new VersionManager(executor.getContext()).getVersion(id), this.cubeQueryExecutorHelper.getMemoryCacheSize());
                this.initLoadedAggregationResultSets(rs, aggrDefns);
            } else {
                rs = this.executeQuery(view, aggrDefns, saveToRD, id, fetcher);
            }
        }
        executor.setQueryResultsId(id);
        return rs;
    }

    private IAggregationResultSet[] executeQuery(BirtCubeView view, AggregationDefinition[] aggrDefns, boolean saveToRD, String queryResutID, IBindingValueFetcher fetcher) throws IOException, BirtException {
        CubeQueryExecutor executor = view.getCubeQueryExecutor();
        IAggregationResultSet[] rs = this.cubeQueryExecutorHelper.execute(aggrDefns, executor.getSession().getStopSign());
        rs = this.applyFilterOnOperation(view, executor.getSession().getStopSign(), executor, aggrDefns, rs);
        rs = this.applyNoAggrUpdateFilters(this.getNoAggrUpdateFilters(executor.getCubeQueryDefinition().getFilters()), executor, rs, view.getCube(), fetcher, false);
        MirrorOperationExecutor moe = new MirrorOperationExecutor();
        rs = moe.execute(rs, view, this.cubeQueryExecutorHelper);
        this.validateLimitSetting(view, rs);
        if (executor.getCubeQueryDefinition().cacheQueryResults()) {
            String tmpDirPath = executor.getSession().getTempDir();
            File tmpDir = new File(tmpDirPath);
            if (!FileSecurity.fileExist(tmpDir) || !FileSecurity.fileIsDirectory(tmpDir)) {
                FileSecurity.fileMakeDirs(tmpDir);
            }
            ArchiveFile aFile = new ArchiveFile(String.valueOf(tmpDirPath) + "Cache", "rw+");
            ArchiveWriter writer = new ArchiveWriter(aFile);
            AggregationResultSetSaveUtil.save(queryResutID, rs, writer);
            writer.finish();
            aFile.close();
        }
        if (saveToRD) {
            CubeQueryDefinitionIOUtil.save(queryResutID, executor.getContext(), executor.getCubeQueryDefinition());
            AggregationResultSetSaveUtil.save(queryResutID, rs, executor.getContext().getDocWriter());
        }
        return rs;
    }

    public IResultSet executeSubQuery(IResultSet parentResultSet, BirtCubeView view, int startingColumnLevelIndex, int startingRowLevelIndex) throws IOException {
        return new CubeResultSet(parentResultSet, view, this.cubeQueryExecutorHelper, startingColumnLevelIndex, startingRowLevelIndex);
    }

    private void populateAggregationSort(CubeQueryExecutor executor, CubeQueryExecutorHelper cubeQueryExcutorHelper, int type) throws DataException {
        List columnSort;
        switch (type) {
            case 2: {
                columnSort = executor.getColumnEdgeSort();
                break;
            }
            case 1: {
                columnSort = executor.getRowEdgeSort();
                break;
            }
            case 3: {
                columnSort = executor.getPageEdgeSort();
                break;
            }
            default: {
                return;
            }
        }
        int i = 0;
        while (i < columnSort.size()) {
            block23: {
                ITargetSort targetSort;
                block22: {
                    DimLevel[] aggrOnLevels;
                    String bindingName;
                    ICubeSortDefinition cubeSort;
                    block25: {
                        List aggrOns;
                        block24: {
                            IBinding referBinding;
                            String expr;
                            ICubeQueryDefinition queryDefn;
                            block21: {
                                cubeSort = (ICubeSortDefinition)columnSort.get(i);
                                queryDefn = executor.getCubeQueryDefinition();
                                expr = cubeSort.getExpression().getText();
                                targetSort = null;
                                if ((cubeSort.getAxisQualifierLevels().length != 0 || !OlapExpressionUtil.isComplexDimensionExpr(expr) && !OlapExpressionUtil.isReferenceToAttribute(cubeSort.getExpression(), queryDefn.getBindings())) && OlapExpressionUtil.isDirectRerenrence(cubeSort.getExpression(), executor.getCubeQueryDefinition().getBindings())) break block21;
                                Scriptable scope = executor.getSession().getSharedScope();
                                targetSort = new DimensionSortEvalHelper(executor.getOuterResults(), scope, queryDefn, cubeSort, executor.getSession().getEngineContext().getScriptContext());
                                break block22;
                            }
                            bindingName = OlapExpressionUtil.getBindingName(expr);
                            if (bindingName == null) break block23;
                            List bindings = queryDefn.getBindings();
                            aggrOns = null;
                            IBinding binding = null;
                            int j = 0;
                            while (j < bindings.size()) {
                                binding = (IBinding)bindings.get(j);
                                if (binding.getBindingName().equals(bindingName)) {
                                    aggrOns = binding.getAggregatOns();
                                    break;
                                }
                                ++j;
                            }
                            aggrOnLevels = null;
                            if (aggrOns != null && aggrOns.size() != 0) break block24;
                            if (binding == null) break block23;
                            String measureName = OlapExpressionCompiler.getReferencedScriptObject(binding.getExpression(), "measure");
                            if (measureName == null && (referBinding = OlapExpressionUtil.getDirectMeasureBinding(binding, bindings)) != null) {
                                measureName = OlapExpressionUtil.getMeasure(referBinding.getExpression());
                                bindingName = referBinding.getBindingName();
                                aggrOns = referBinding.getAggregatOns();
                            }
                            if (aggrOns != null && aggrOns.size() > 0) {
                                aggrOnLevels = new DimLevel[aggrOns.size()];
                                int j2 = 0;
                                while (j2 < aggrOnLevels.length) {
                                    aggrOnLevels[j2] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j2).toString());
                                    ++j2;
                                }
                            } else if (measureName != null) {
                                List measureAggrOns = CubeQueryDefinitionUtil.populateMeasureAggrOns(queryDefn);
                                aggrOnLevels = new DimLevel[measureAggrOns.size()];
                                int k = 0;
                                while (k < measureAggrOns.size()) {
                                    aggrOnLevels[k] = (DimLevel)measureAggrOns.get(k);
                                    ++k;
                                }
                            }
                            break block25;
                        }
                        aggrOnLevels = new DimLevel[aggrOns.size()];
                        int j = 0;
                        while (j < aggrOnLevels.length) {
                            aggrOnLevels[j] = OlapExpressionUtil.getTargetDimLevel(aggrOns.get(j).toString());
                            ++j;
                        }
                    }
                    DimLevel[] axisLevels = new DimLevel[cubeSort.getAxisQualifierLevels().length];
                    int k = 0;
                    while (k < axisLevels.length) {
                        axisLevels[k] = new DimLevel(cubeSort.getAxisQualifierLevels()[k]);
                        ++k;
                    }
                    targetSort = new AggrSortDefinition(aggrOnLevels, bindingName, axisLevels, cubeSort.getAxisQualifierValues(), new DimLevel(cubeSort.getTargetLevel()), cubeSort.getSortDirection());
                }
                switch (type) {
                    case 2: {
                        cubeQueryExcutorHelper.addColumnSort(targetSort);
                        break;
                    }
                    case 1: {
                        cubeQueryExcutorHelper.addRowSort(targetSort);
                        break;
                    }
                    case 3: {
                        cubeQueryExcutorHelper.addPageSort(targetSort);
                    }
                }
            }
            ++i;
        }
    }

    private AggregationDefinition[] prepareCube(ICubeQueryDefinition query, CalculatedMember[] calculatedMember) throws DataException {
        int i;
        int index;
        int[] sortType;
        DimLevel[] levelsForFilter;
        IEdgeDefinition columnEdgeDefn = query.getEdge(2);
        ILevelDefinition[] levelsOnColumn = CubeQueryDefinitionUtil.getLevelsOnEdge(columnEdgeDefn);
        IEdgeDefinition rowEdgeDefn = query.getEdge(1);
        ILevelDefinition[] levelsOnRow = CubeQueryDefinitionUtil.getLevelsOnEdge(rowEdgeDefn);
        IEdgeDefinition pageEdgeDefn = query.getEdge(3);
        ILevelDefinition[] levelsOnPage = CubeQueryDefinitionUtil.getLevelsOnEdge(pageEdgeDefn);
        ArrayList<AggregationDefinition> aggregations = new ArrayList<AggregationDefinition>();
        if (columnEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnColumn.length + levelsOnPage.length];
            sortType = new int[levelsOnColumn.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnColumn.length) {
                levelsForFilter[index] = new DimLevel(levelsOnColumn[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (rowEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnRow.length + levelsOnPage.length];
            sortType = new int[levelsOnRow.length + levelsOnPage.length];
            index = 0;
            while (index < levelsOnPage.length) {
                levelsForFilter[index] = new DimLevel(levelsOnPage[index]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[index], query);
                ++index;
            }
            i = 0;
            while (i < levelsOnRow.length) {
                levelsForFilter[index] = new DimLevel(levelsOnRow[i]);
                sortType[index] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i], query);
                ++index;
                ++i;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        if (pageEdgeDefn != null) {
            levelsForFilter = new DimLevel[levelsOnPage.length];
            sortType = new int[levelsOnPage.length];
            int i2 = 0;
            while (i2 < levelsOnPage.length) {
                levelsForFilter[i2] = new DimLevel(levelsOnPage[i2]);
                sortType[i2] = CubeQueryDefinitionUtil.getSortDirection(levelsForFilter[i2], query);
                ++i2;
            }
            aggregations.add(new AggregationDefinition(levelsForFilter, sortType, null));
        }
        AggregationDefinition[] fromCalculatedMembers = CubeQueryDefinitionUtil.createAggregationDefinitons(calculatedMember, query, null, null);
        aggregations.addAll(Arrays.asList(fromCalculatedMembers));
        return aggregations.toArray(new AggregationDefinition[0]);
    }

    private void validateLimitSetting(BirtCubeView cubeView, IAggregationResultSet[] rsArray) throws DataException {
        int limitSize;
        int count = 0;
        if (cubeView.getColumnEdgeView() != null) {
            if (cubeView.getAppContext() != null && (limitSize = this.populateFetchLimitSize(cubeView.getAppContext().get(DataEngine.CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE))) > 0 && limitSize < rsArray[count].length()) {
                throw new DataException("data.olap.ExceedColumnLimit", new Object[]{limitSize});
            }
            ++count;
        }
        if (cubeView.getRowEdgeView() != null) {
            if (cubeView.getAppContext() != null && (limitSize = this.populateFetchLimitSize(cubeView.getAppContext().get(DataEngine.CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE))) > 0 && limitSize < rsArray[count].length()) {
                throw new DataException("data.olap.ExceedRowLimit", new Object[]{limitSize});
            }
            ++count;
        }
    }

    private int populateFetchLimitSize(Object propValue) {
        String fetchLimitSize;
        int fetchLimit = -1;
        String string = fetchLimitSize = propValue == null ? "-1" : propValue.toString();
        if (fetchLimitSize != null) {
            fetchLimit = Integer.parseInt(fetchLimitSize);
        }
        return fetchLimit;
    }

    private class AggregateRowWrapper
    implements IFacttableRow {
        private IAggregationResultSet aggrResultSet;

        public AggregateRowWrapper(IAggregationResultSet aggrResultSet) {
            this.aggrResultSet = aggrResultSet;
        }

        @Override
        public Object getMeasureValue(String measureName) throws DataException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] getLevelKeyValue(String dimensionName, String levelName) throws DataException, IOException {
            return this.aggrResultSet.getLevelKeyValue(this.aggrResultSet.getLevelIndex(new DimLevel(dimensionName, levelName)));
        }

        @Override
        public Object getLevelAttributeValue(String dimensionName, String levelName, String attributeName) throws DataException, IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class Members
    implements Comparable<Members> {
        public Member[] members;

        public Members(Member[] members) {
            this.members = members;
        }

        @Override
        public int compareTo(Members other) {
            int i = 0;
            while (i < this.members.length) {
                int result = this.members[i].compareTo(other.members[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return 0;
        }
    }
}

